/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.client.dispatch;

import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.Dispatch;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.jaxws.BindingProvider;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.client.async.AsyncResponse;
import org.apache.axis2.jaxws.core.InvocationContext;
import org.apache.axis2.jaxws.core.InvocationContextFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.core.controller.AxisInvocationController;
import org.apache.axis2.jaxws.core.controller.InvocationController;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.marshaller.impl.alt.MethodMarshallerUtils;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.spi.ServiceDelegate;
import org.apache.axis2.jaxws.spi.migrator.ApplicationContextMigratorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDispatch<T>
extends BindingProvider
implements Dispatch {
    private Log log = LogFactory.getLog(BaseDispatch.class);
    protected InvocationController ic = new AxisInvocationController();
    protected ServiceClient serviceClient;
    protected Service.Mode mode;

    protected BaseDispatch(ServiceDelegate svcDelgate, EndpointDescription epDesc) {
        super(svcDelgate, epDesc);
    }

    protected abstract Message createMessageFromValue(Object var1);

    protected abstract Object getValueFromMessage(Message var1);

    protected abstract AsyncResponse createAsyncResponseListener();

    public Object invoke(Object obj) throws WebServiceException {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Entered synchronous invocation: BaseDispatch.invoke()");
            }
            InvocationContext invocationContext = InvocationContextFactory.createInvocationContext(null);
            invocationContext.setServiceClient(this.serviceClient);
            MessageContext requestMsgCtx = new MessageContext();
            requestMsgCtx.setEndpointDescription(this.getEndpointDescription());
            invocationContext.setRequestMessageContext(requestMsgCtx);
            invocationContext.setHandlers(this.getBinding().getHandlerChain());
            Message requestMsg = null;
            if (!this.isValidInvocationParam(obj)) {
                throw ExceptionFactory.makeWebServiceException("dispatchInvalidParam");
            }
            requestMsg = this.createMessageFromValue(obj);
            this.setupMessageProperties(requestMsg);
            requestMsgCtx.setMessage(requestMsg);
            ApplicationContextMigratorUtil.performMigrationToMessageContext("org.apache.axis2.jaxws.spi.ApplicationContextMigrators", this.getRequestContext(), requestMsgCtx);
            this.ic.invoke(invocationContext);
            MessageContext responseMsgCtx = invocationContext.getResponseMessageContext();
            responseMsgCtx.setEndpointDescription(requestMsgCtx.getEndpointDescription());
            ApplicationContextMigratorUtil.performMigrationFromMessageContext("org.apache.axis2.jaxws.spi.ApplicationContextMigrators", this.getResponseContext(), responseMsgCtx);
            if (this.hasFaultResponse(responseMsgCtx)) {
                WebServiceException wse = BaseDispatch.getFaultResponse(responseMsgCtx);
                throw wse;
            }
            Message responseMsg = responseMsgCtx.getMessage();
            Object returnObj = this.getValueFromMessage(responseMsg);
            this.checkMaintainSessionState(requestMsgCtx, invocationContext);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Synchronous invocation completed: BaseDispatch.invoke()");
            }
            return returnObj;
        }
        catch (WebServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    public void invokeOneWay(Object obj) throws WebServiceException {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Entered one-way invocation: BaseDispatch.invokeOneWay()");
            }
            InvocationContext invocationContext = InvocationContextFactory.createInvocationContext(null);
            invocationContext.setServiceClient(this.serviceClient);
            MessageContext requestMsgCtx = new MessageContext();
            requestMsgCtx.setEndpointDescription(this.getEndpointDescription());
            invocationContext.setRequestMessageContext(requestMsgCtx);
            Message requestMsg = null;
            if (!this.isValidInvocationParam(obj)) {
                throw ExceptionFactory.makeWebServiceException("dispatchInvalidParam");
            }
            requestMsg = this.createMessageFromValue(obj);
            this.setupMessageProperties(requestMsg);
            requestMsgCtx.setMessage(requestMsg);
            ApplicationContextMigratorUtil.performMigrationToMessageContext("org.apache.axis2.jaxws.spi.ApplicationContextMigrators", this.getRequestContext(), requestMsgCtx);
            this.ic.invokeOneWay(invocationContext);
            this.checkMaintainSessionState(requestMsgCtx, invocationContext);
            if (this.log.isDebugEnabled()) {
                this.log.debug("One-way invocation completed: BaseDispatch.invokeOneWay()");
            }
            return;
        }
        catch (WebServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    public Future<?> invokeAsync(Object obj, AsyncHandler asynchandler) throws WebServiceException {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Entered asynchronous (callback) invocation: BaseDispatch.invokeAsync()");
            }
            InvocationContext invocationContext = InvocationContextFactory.createInvocationContext(null);
            invocationContext.setServiceClient(this.serviceClient);
            MessageContext requestMsgCtx = new MessageContext();
            requestMsgCtx.setEndpointDescription(this.getEndpointDescription());
            invocationContext.setRequestMessageContext(requestMsgCtx);
            Message requestMsg = null;
            if (!this.isValidInvocationParam(obj)) {
                throw ExceptionFactory.makeWebServiceException("dispatchInvalidParam");
            }
            requestMsg = this.createMessageFromValue(obj);
            this.setupMessageProperties(requestMsg);
            requestMsgCtx.setMessage(requestMsg);
            ApplicationContextMigratorUtil.performMigrationToMessageContext("org.apache.axis2.jaxws.spi.ApplicationContextMigrators", this.getRequestContext(), requestMsgCtx);
            Executor e = this.serviceDelegate.getExecutor();
            invocationContext.setExecutor(e);
            AsyncResponse listener = this.createAsyncResponseListener();
            invocationContext.setAsyncResponseListener(listener);
            Future<?> asyncResponse = this.ic.invokeAsync(invocationContext, asynchandler);
            this.checkMaintainSessionState(requestMsgCtx, invocationContext);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Asynchronous (callback) invocation sent: BaseDispatch.invokeAsync()");
            }
            return asyncResponse;
        }
        catch (WebServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    public Response invokeAsync(Object obj) throws WebServiceException {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Entered asynchronous (polling) invocation: BaseDispatch.invokeAsync()");
            }
            InvocationContext invocationContext = InvocationContextFactory.createInvocationContext(null);
            invocationContext.setServiceClient(this.serviceClient);
            MessageContext requestMsgCtx = new MessageContext();
            requestMsgCtx.setEndpointDescription(this.getEndpointDescription());
            invocationContext.setRequestMessageContext(requestMsgCtx);
            Message requestMsg = null;
            if (!this.isValidInvocationParam(obj)) {
                throw ExceptionFactory.makeWebServiceException("dispatchInvalidParam");
            }
            requestMsg = this.createMessageFromValue(obj);
            this.setupMessageProperties(requestMsg);
            requestMsgCtx.setMessage(requestMsg);
            ApplicationContextMigratorUtil.performMigrationToMessageContext("org.apache.axis2.jaxws.spi.ApplicationContextMigrators", this.getRequestContext(), requestMsgCtx);
            Executor e = this.serviceDelegate.getExecutor();
            invocationContext.setExecutor(e);
            AsyncResponse listener = this.createAsyncResponseListener();
            invocationContext.setAsyncResponseListener(listener);
            Response asyncResponse = this.ic.invokeAsync(invocationContext);
            this.checkMaintainSessionState(requestMsgCtx, invocationContext);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Asynchronous (polling) invocation sent: BaseDispatch.invokeAsync()");
            }
            return asyncResponse;
        }
        catch (WebServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    public void setServiceClient(ServiceClient sc) {
        this.serviceClient = sc;
    }

    public Service.Mode getMode() {
        return this.mode;
    }

    public void setMode(Service.Mode m) {
        this.mode = m;
    }

    public static WebServiceException getFaultResponse(MessageContext msgCtx) {
        Message msg = msgCtx.getMessage();
        if (msg != null && msg.isFault()) {
            ProtocolException pe = MethodMarshallerUtils.createSystemException(msg.getXMLFault(), msg);
            return pe;
        }
        if (msgCtx.getLocalException() != null) {
            return ExceptionFactory.makeWebServiceException(msgCtx.getLocalException());
        }
        return null;
    }

    public boolean hasFaultResponse(MessageContext msgCtx) {
        if (msgCtx.getMessage() != null && msgCtx.getMessage().isFault()) {
            return true;
        }
        return msgCtx.getLocalException() != null;
    }

    private void setupMessageProperties(Message msg) {
        String bindingID;
        SOAPBinding soapBinding;
        Binding binding = this.getBinding();
        if (binding != null && binding instanceof SOAPBinding && (soapBinding = (SOAPBinding)binding).isMTOMEnabled()) {
            msg.setMTOMEnabled(true);
        }
        if (((bindingID = this.endpointDesc.getClientBindingID()).equalsIgnoreCase("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || bindingID.equalsIgnoreCase("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true")) && !msg.isMTOMEnabled()) {
            msg.setMTOMEnabled(true);
        }
    }

    private boolean isValidInvocationParam(Object object) {
        DOMSource ds;
        String bindingId = this.endpointDesc.getClientBindingID();
        if (bindingId == null) {
            bindingId = "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        if (!bindingId.equals("http://www.w3.org/2004/08/wsdl/http")) {
            if (this.mode.equals((Object)Service.Mode.MESSAGE) && object == null) {
                throw ExceptionFactory.makeWebServiceException("dispatchNullParamMessageMode");
            }
        } else if (object == null) {
            throw ExceptionFactory.makeWebServiceException("dispatchNullParamHttpBinding");
        }
        if (object instanceof DOMSource && (ds = (DOMSource)object).getNode() == null && ds.getSystemId() == null) {
            throw ExceptionFactory.makeWebServiceException("dispatchBadDOMSource");
        }
        return true;
    }
}

