/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.protocol.Protocols;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.websvcs.client.ClientCCPostProcessor;
import com.ibm.ws.websvcs.deployment.Axis2ServiceConfigPluginManager;
import com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder;
import com.ibm.ws.websvcs.deployment.WASAxis2PolicySetConfigurator;
import com.ibm.ws.websvcs.metadata.WASAxis2MetaDataImpl;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.websvcs.utils.WASAxis2ExecutorFactory;
import com.ibm.ws.websvcs.utils.WSResourceFinder;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import java.security.PrivilegedAction;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.utility.ExecutorFactory;
import org.apache.axis2.metadata.factory.ResourceFinderFactory;
import org.apache.axis2.metadata.registry.MetadataFactoryRegistry;

public class ClientConfigurationFactory {
    private static final TraceComponent _tc = Tr.register(ClientConfigurationFactory.class, null, null);
    private static ClientConfigurationFactory instance = new ClientConfigurationFactory();
    private Axis2ServiceConfigPluginManager configManager = null;
    private WASAxis2PolicySetConfigurator psc = null;
    private static ConfigurationContext tcConfigContext = null;

    protected ClientConfigurationFactory() {
    }

    public static ClientConfigurationFactory newInstance() {
        return instance;
    }

    public synchronized ConfigurationContext getClientConfigurationContext() {
        ConfigurationContext configurationContext = null;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Loading client configuration context.");
        }
        try {
            Object object;
            Object object2;
            this.init();
            String string = null;
            String string2 = null;
            try {
                if (!Axis2Utils.isThinClientEnv()) {
                    object2 = new WASAxis2MetaDataImpl(null);
                    if (((WASAxis2MetaDataImpl)object2).getComponentMetaData() != null) {
                        object = ((WASAxis2MetaDataImpl)object2).getComponentMetaData().getJ2EEName();
                        string = object.getApplication();
                        string2 = object.getModule();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Application name " + string + " and module name " + string2 + " set on client Axis configuration.");
                        }
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Not a server client, cannot retrieve application and module name.");
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Thin-client, not retrieving appName.");
                }
            }
            catch (Throwable throwable) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Couldn't retrieve Metadata: " + throwable.toString());
                }
                string = null;
                string2 = null;
            }
            object2 = (WASAxis2Service)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return WsServiceRegistry.getService(ClientCCPostProcessor.class, WASAxis2Service.class);
                    }
                    catch (Throwable throwable) {
                        return null;
                    }
                }
            });
            if (object2 != null && (object = object2.getClientConfigurationContexts(string, string2)) != null && !object.isEmpty()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Returning cached ConfigurationContext for module: " + string2 + " in application: " + string + ": " + ((ConfigurationContext)object.get(0)).toString());
                }
                return (ConfigurationContext)object.get(0);
            }
            if (Axis2Utils.isThinClientEnv()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Retrieving ConfigurationContext in thinclient");
                }
                if (tcConfigContext == null) {
                    tcConfigContext = this.getConfigContext(null, null);
                    ClientCCPostProcessor.processClientConfiguration(tcConfigContext);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Returning newly loaded ConfigurationContext for thinclient: " + tcConfigContext.toString());
                    }
                    return tcConfigContext;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Returning already loaded ConfigurationContext for thinclient: " + tcConfigContext.toString());
                }
                return tcConfigContext;
            }
            configurationContext = this.getConfigContext(string, string2);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Built new ConfigurationContext for managed client: " + configurationContext.toString());
            }
            ClientCCPostProcessor.processClientConfiguration(configurationContext);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Finished loading client configuration context.");
            }
        }
        catch (Exception exception) {
            configurationContext = null;
            Tr.error(_tc, "An unexpected error occurred while loading the client configuration context: " + exception.toString(), exception);
        }
        return configurationContext;
    }

    private ConfigurationContext getConfigContext(String string, String string2) throws Exception {
        AxisConfiguration axisConfiguration = null;
        WASAxis2ConfigurationBuilder wASAxis2ConfigurationBuilder = (WASAxis2ConfigurationBuilder)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new WASAxis2ConfigurationBuilder();
            }
        });
        axisConfiguration = wASAxis2ConfigurationBuilder.loadAxisClientConfiguration();
        Axis2Utils.setApplicationName(axisConfiguration, string);
        Axis2Utils.setModuleName(axisConfiguration, string2);
        ConfigurationContext configurationContext = (ConfigurationContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ConfigurationContextFactory.createEmptyConfigurationContext();
            }
        });
        configurationContext.setAxisConfiguration(axisConfiguration);
        wASAxis2ConfigurationBuilder.loadAxisClientModules(axisConfiguration, configurationContext);
        wASAxis2ConfigurationBuilder.loadAxisClientTCMPlugins(configurationContext);
        wASAxis2ConfigurationBuilder.loadAxisClientACMPlugins(configurationContext);
        return configurationContext;
    }

    public synchronized void completeAxis2Configuration(AxisService axisService) throws DeploymentException, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "completeAxis2Configuration");
        }
        if (axisService == null) {
            Tr.error(_tc, "Null Service, cannot complete configuration. Returning.");
            throw new DeploymentException("Null service.");
        }
        if (this.configManager == null) {
            this.configManager = new Axis2ServiceConfigPluginManager();
            this.configManager.discoverAxis2ServiceConfigPlugins(false);
        }
        if (this.psc == null) {
            ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ClassLoader.getSystemClassLoader();
                }
            });
            this.psc = new WASAxis2PolicySetConfigurator(classLoader, classLoader);
        }
        this.psc.associatePolicySets(axisService, this.configManager);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "completeAxis2Configuration");
        }
    }

    private void init() {
        SSLConfigManager.getInstance().initializeClientSSL();
        Protocols.init();
        ResourceFinderFactory resourceFinderFactory = new ResourceFinderFactory();
        resourceFinderFactory.setResourceFinder(new WSResourceFinder());
        MetadataFactoryRegistry.setFactory(ResourceFinderFactory.class, resourceFinderFactory);
        WASAxis2ExecutorFactory wASAxis2ExecutorFactory = WASAxis2ExecutorFactory.newInstance();
        FactoryRegistry.setFactory(ExecutorFactory.class, wASAxis2ExecutorFactory);
    }
}

