/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.handlers.addressing;

import java.util.ArrayList;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingFaultsHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.handlers.addressing.AddressingInHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressingSubmissionInHandler
extends AddressingInHandler {
    private static final Log log = LogFactory.getLog(AddressingSubmissionInHandler.class);

    public AddressingSubmissionInHandler() {
        this.addressingNamespace = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
        this.addressingVersion = "WS-Addressing Submission";
    }

    protected void extractToEprReferenceParameters(EndpointReference toEPR, SOAPHeader header, String namespace) {
    }

    protected void checkForMandatoryHeaders(ArrayList alreadyFoundAddrHeader, MessageContext messageContext) throws AxisFault {
        if (!alreadyFoundAddrHeader.contains("To")) {
            AddressingFaultsHelper.triggerMessageAddressingRequiredFault(messageContext, "To");
        }
        if (!alreadyFoundAddrHeader.contains("Action")) {
            AddressingFaultsHelper.triggerMessageAddressingRequiredFault(messageContext, "Action");
        }
        if ((alreadyFoundAddrHeader.contains("ReplyTo") || alreadyFoundAddrHeader.contains("FaultTo")) && !alreadyFoundAddrHeader.contains("MessageID")) {
            AddressingFaultsHelper.triggerMessageAddressingRequiredFault(messageContext, "MessageID");
        }
    }

    protected void setDefaults(ArrayList alreadyFoundAddrHeader, MessageContext messageContext) {
        if (!alreadyFoundAddrHeader.contains("ReplyTo")) {
            Options messageContextOptions = messageContext.getOptions();
            EndpointReference epr = messageContextOptions.getReplyTo();
            if (epr == null) {
                epr = new EndpointReference("");
                messageContextOptions.setReplyTo(epr);
            }
            if (log.isTraceEnabled()) {
                log.trace("setDefaults: Setting WS-Addressing default value for the ReplyTo property.");
            }
            epr.setAddress("http://www.w3.org/2005/08/addressing/none");
        }
    }
}

