/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.handlers.addressing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.util.AttributeHelper;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.AddressingFaultsHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.addressing.i18n.AddressingMessages;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressingOutHandler
extends AbstractHandler
implements AddressingConstants {
    private static final Log log = LogFactory.getLog(AddressingOutHandler.class);
    private boolean includeOptionalHeaders = false;

    public void init(HandlerDescription arg0) {
        super.init(arg0);
        Parameter param = arg0.getParameter("includeOptionalHeaders");
        String value = Utils.getParameterValue(param);
        this.includeOptionalHeaders = JavaUtils.isTrueExplicitly(value);
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        if (Utils.isExplicitlyTrue(msgContext, "disableAddressingForOutMessages")) {
            if (log.isTraceEnabled()) {
                log.trace(msgContext.getLogIDString() + " Addressing is disabled. Not adding WS-Addressing headers.");
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        Object addressingVersionFromCurrentMsgCtxt = msgContext.getProperty("WSAddressingVersion");
        if (log.isTraceEnabled()) {
            log.trace("Addressing version string from messageContext=" + addressingVersionFromCurrentMsgCtxt);
        }
        boolean isSubmissionNamespace = "http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(addressingVersionFromCurrentMsgCtxt);
        boolean includeOptionalHeaders = this.includeOptionalHeaders;
        Object includeHeadersPropery = msgContext.getProperty("includeOptionalHeaders");
        if (includeHeadersPropery != null) {
            includeOptionalHeaders = JavaUtils.isTrueExplicitly(includeHeadersPropery);
        }
        boolean addMustUnderstandAttribute = Utils.isExplicitlyTrue(msgContext, "addMustUnderstandToAddressingHeaders");
        boolean replaceHeaders = Utils.isExplicitlyTrue(msgContext, "ReplaceAddressingHeaders");
        WSAHeaderWriter writer = new WSAHeaderWriter(msgContext, isSubmissionNamespace, addMustUnderstandAttribute, replaceHeaders, includeOptionalHeaders);
        writer.writeHeaders();
        return Handler.InvocationResponse.CONTINUE;
    }

    private class WSAHeaderWriter {
        private MessageContext messageContext;
        private SOAPEnvelope envelope;
        private SOAPHeader header;
        private SOAPFactory factory;
        private Options messageContextOptions;
        private OMNamespace addressingNamespaceObject;
        private String addressingNamespace;
        private boolean isFinalAddressingNamespace;
        private boolean addMustUnderstandAttribute;
        private boolean replaceHeaders;
        private boolean includeOptionalHeaders;
        private ArrayList existingWSAHeaders = null;

        public WSAHeaderWriter(MessageContext mc, boolean isSubmissionNamespace, boolean addMU, boolean replace, boolean includeOptional) {
            if (log.isDebugEnabled()) {
                log.debug("WSAHeaderWriter: isFinal=" + isSubmissionNamespace + " addMU=" + addMU + " replace=" + replace + " includeOptional=" + includeOptional);
            }
            this.messageContext = mc;
            this.envelope = mc.getEnvelope();
            this.factory = (SOAPFactory)this.envelope.getOMFactory();
            this.header = this.envelope.getHeader();
            this.messageContextOptions = this.messageContext.getOptions();
            this.addressingNamespace = isSubmissionNamespace ? "http://schemas.xmlsoap.org/ws/2004/08/addressing" : "http://www.w3.org/2005/08/addressing";
            this.addressingNamespaceObject = this.factory.createOMNamespace(this.addressingNamespace, "wsa");
            if (this.header == null) {
                this.header = this.factory.createSOAPHeader(this.envelope);
            } else {
                ArrayList addressingHeaders = this.header.getHeaderBlocksWithNSURI(this.addressingNamespace);
                if (addressingHeaders != null && !addressingHeaders.isEmpty()) {
                    this.existingWSAHeaders = new ArrayList();
                    Iterator iter = addressingHeaders.iterator();
                    while (iter.hasNext()) {
                        OMElement oe = (OMElement)iter.next();
                        this.existingWSAHeaders.add(oe.getLocalName());
                    }
                }
            }
            this.isFinalAddressingNamespace = !isSubmissionNamespace;
            this.addMustUnderstandAttribute = addMU;
            this.replaceHeaders = replace;
            this.includeOptionalHeaders = includeOptional;
        }

        public void writeHeaders() throws AxisFault {
            this.envelope.declareNamespace(this.addressingNamespaceObject);
            this.processToEPR();
            this.processReplyTo();
            this.processFromEPR();
            this.processFaultToEPR();
            this.processMessageID();
            this.processWSAAction();
            this.processRelatesTo();
            this.processFaultsInfoIfPresent();
            this.processMustUnderstandProperty();
        }

        private void processMessageID() {
            String messageID = this.messageContextOptions.getMessageId();
            if (messageID != null && !this.isAddressingHeaderAlreadyAvailable("MessageID", false)) {
                OMElement oe = this.processStringInfo(messageID, "MessageID");
                ArrayList attributes = (ArrayList)this.messageContextOptions.getProperty("messageidAttributes");
                if (attributes != null && !attributes.isEmpty()) {
                    Iterator attrIterator = attributes.iterator();
                    while (attrIterator.hasNext()) {
                        AttributeHelper.importOMAttribute((OMAttribute)attrIterator.next(), oe);
                    }
                }
            }
        }

        private void processWSAAction() throws AxisFault {
            String action = this.messageContextOptions.getAction();
            if (log.isTraceEnabled()) {
                log.trace(this.messageContext.getLogIDString() + " processWSAAction: action from messageContext: " + action);
            }
            if ((action == null || action.length() == 0) && this.messageContext.getAxisOperation() != null) {
                action = this.messageContext.getAxisOperation().getOutputAction();
                if (action != null) {
                    if (log.isTraceEnabled()) {
                        log.trace(this.messageContext.getLogIDString() + " processWSAAction: Old MessageContext WSAaction is: " + this.messageContext.getWSAAction());
                        log.trace(this.messageContext.getLogIDString() + " processWSAAction: New MessageContext WSAaction is: " + action);
                    }
                    this.messageContext.setWSAAction(action);
                }
                if (log.isTraceEnabled()) {
                    log.trace(this.messageContext.getLogIDString() + " processWSAAction: Using action from AxisOperation: " + action);
                }
            }
            if ("http://www.w3.org/2005/08/addressing/fault".equals(action) || "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault".equals(action)) {
                action = this.isFinalAddressingNamespace ? "http://www.w3.org/2005/08/addressing/fault" : "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault";
                this.messageContextOptions.setAction(action);
            } else if (!this.isFinalAddressingNamespace && "http://www.w3.org/2005/08/addressing/soap/fault".equals(action)) {
                action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault";
                this.messageContextOptions.setAction(action);
            }
            if (!this.isAddressingHeaderAlreadyAvailable("Action", false)) {
                if (log.isTraceEnabled()) {
                    log.trace(this.messageContext.getLogIDString() + " processWSAAction: No existing wsa:Action header found");
                }
                if (action == null || "".equals(action)) {
                    if (log.isTraceEnabled()) {
                        log.trace(this.messageContext.getLogIDString() + " processWSAAction: No action to add to header");
                    }
                    if (!Utils.isExplicitlyTrue(this.messageContext, "disableAddressingOutboundValidation")) {
                        throw new AxisFault(AddressingMessages.getMessage("outboundNoAction"));
                    }
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace(this.messageContext.getLogIDString() + " processWSAAction: Adding action to header: " + action);
                    }
                    OMElement oe = this.processStringInfo(action, "Action");
                    ArrayList attributes = (ArrayList)this.messageContextOptions.getProperty("actionAttributes");
                    if (attributes != null && !attributes.isEmpty()) {
                        Iterator attrIterator = attributes.iterator();
                        while (attrIterator.hasNext()) {
                            AttributeHelper.importOMAttribute((OMAttribute)attrIterator.next(), oe);
                        }
                    }
                }
            }
        }

        private void processFaultsInfoIfPresent() {
            OMElement detailElement = AddressingFaultsHelper.getDetailElementForAddressingFault(this.messageContext, this.addressingNamespaceObject);
            if (detailElement != null) {
                SOAPFault fault;
                if (this.isFinalAddressingNamespace && this.messageContext.isSOAP11()) {
                    if (!this.isAddressingHeaderAlreadyAvailable("FaultDetail", false)) {
                        SOAPHeaderBlock faultDetail = this.header.addHeaderBlock("FaultDetail", this.addressingNamespaceObject);
                        faultDetail.addChild(ElementHelper.importOMElement(detailElement, this.factory));
                    }
                } else if (!this.messageContext.isSOAP11() && (fault = this.envelope.getBody().getFault()) != null && fault.getDetail() != null) {
                    fault.getDetail().addDetailEntry(ElementHelper.importOMElement(detailElement, this.factory));
                }
            }
        }

        private void processRelatesTo() {
            RelatesTo[] relatesTo;
            if (!this.isAddressingHeaderAlreadyAvailable("RelatesTo", true) && (relatesTo = this.messageContextOptions.getRelationships()) != null) {
                int length = relatesTo.length;
                for (int i = 0; i < length; ++i) {
                    OMElement relatesToHeader = this.processStringInfo(relatesTo[i].getValue(), "RelatesTo");
                    String relationshipType = relatesTo[i].getRelationshipType();
                    if (relatesToHeader == null) continue;
                    if (relatesTo[i].getExtensibilityAttributes() != null) {
                        Iterator attributes = relatesTo[i].getExtensibilityAttributes().iterator();
                        while (attributes.hasNext()) {
                            OMAttribute oma = (OMAttribute)attributes.next();
                            AttributeHelper.importOMAttribute(oma, relatesToHeader);
                        }
                    }
                    if ("http://www.w3.org/2005/08/addressing/reply".equals(relationshipType) || "wsa:Reply".equals(relationshipType)) {
                        if (!this.includeOptionalHeaders) continue;
                        relationshipType = this.isFinalAddressingNamespace ? "http://www.w3.org/2005/08/addressing/reply" : "wsa:Reply";
                        relatesTo[i].setRelationshipType(relationshipType);
                    }
                    relatesToHeader.addAttribute("RelationshipType", relationshipType, null);
                }
            }
        }

        private void processFaultToEPR() throws AxisFault {
            EndpointReference epr = this.messageContextOptions.getFaultTo();
            String headerName = "FaultTo";
            if (epr != null && !this.isAddressingHeaderAlreadyAvailable(headerName, false)) {
                this.addToSOAPHeader(epr, headerName);
            }
        }

        private void processFromEPR() throws AxisFault {
            EndpointReference epr = this.messageContextOptions.getFrom();
            String headerName = "From";
            if (epr != null && !this.isAddressingHeaderAlreadyAvailable(headerName, false)) {
                this.addToSOAPHeader(epr, headerName);
            }
        }

        private void processReplyTo() throws AxisFault {
            EndpointReference epr = this.messageContextOptions.getReplyTo();
            String headerName = "ReplyTo";
            if (!this.isAddressingHeaderAlreadyAvailable(headerName, false)) {
                this.addToSOAPHeader(epr, headerName);
            }
        }

        private void processToEPR() {
            EndpointReference epr = this.messageContextOptions.getTo();
            if (epr != null && !this.isAddressingHeaderAlreadyAvailable("To", false)) {
                Map referenceParameters = epr.getAllReferenceParameters();
                String address = epr.getAddress();
                if (!"".equals(address) && address != null) {
                    if (!this.includeOptionalHeaders && this.isFinalAddressingNamespace && ("http://www.w3.org/2005/08/addressing/anonymous".equals(address) || "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous".equals(address))) {
                        return;
                    }
                    SOAPHeaderBlock toHeaderBlock = this.header.addHeaderBlock("To", this.addressingNamespaceObject);
                    toHeaderBlock.setText(address);
                    if (epr.getAddressAttributes() != null) {
                        Iterator addressAttributes = epr.getAddressAttributes().iterator();
                        while (addressAttributes.hasNext()) {
                            OMAttribute attr = (OMAttribute)addressAttributes.next();
                            AttributeHelper.importOMAttribute(attr, toHeaderBlock);
                        }
                    }
                }
                this.processToEPRReferenceInformation(referenceParameters, this.header);
            }
        }

        private OMElement processStringInfo(String value, String headerName) {
            if (log.isTraceEnabled()) {
                log.trace("processStringInfo: value=" + value + " headerName=" + headerName);
            }
            if (!"".equals(value) && value != null) {
                SOAPHeaderBlock soapHeaderBlock = this.header.addHeaderBlock(headerName, this.addressingNamespaceObject);
                soapHeaderBlock.addChild(this.factory.createOMText(value));
                return soapHeaderBlock;
            }
            return null;
        }

        private void addToSOAPHeader(EndpointReference epr, String headerName) throws AxisFault {
            String anonymous;
            String prefix = this.addressingNamespaceObject.getPrefix();
            String string = anonymous = this.isFinalAddressingNamespace ? "http://www.w3.org/2005/08/addressing/anonymous" : "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous";
            if (log.isTraceEnabled()) {
                log.trace("addToSOAPHeader: epr=" + epr + " headerName=" + headerName);
            }
            if (epr == null) {
                if (!this.includeOptionalHeaders && this.isFinalAddressingNamespace && "ReplyTo".equals(headerName)) {
                    return;
                }
                epr = new EndpointReference(anonymous);
            } else {
                if (!this.isFinalAddressingNamespace && epr.hasNoneAddress()) {
                    return;
                }
                if ("http://www.w3.org/2005/08/addressing/anonymous".equals(epr.getAddress()) || "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous".equals(epr.getAddress())) {
                    if (!this.includeOptionalHeaders && this.isFinalAddressingNamespace && "ReplyTo".equals(headerName)) {
                        return;
                    }
                    epr.setAddress(anonymous);
                }
            }
            OMElement soapHeaderBlock = EndpointReferenceHelper.toOM(this.factory, epr, new QName(this.addressingNamespace, headerName, prefix), this.addressingNamespace);
            this.header.addChild(soapHeaderBlock);
        }

        private void processToEPRReferenceInformation(Map referenceInformation, OMElement parent) {
            if (referenceInformation != null && parent != null) {
                Iterator iterator = referenceInformation.values().iterator();
                while (iterator.hasNext()) {
                    OMElement omElement = (OMElement)iterator.next();
                    parent.addChild(ElementHelper.importOMElement(omElement, parent.getOMFactory()));
                    if (!this.isFinalAddressingNamespace) continue;
                    omElement.addAttribute("IsReferenceParameter", "true", this.addressingNamespaceObject);
                }
            }
        }

        private boolean isAddressingHeaderAlreadyAvailable(String name, boolean multipleHeaders) {
            QName qname2 = new QName(this.addressingNamespace, name, "wsa");
            boolean status = false;
            if (multipleHeaders) {
                if (this.replaceHeaders) {
                    Iterator iterator = this.header.getChildrenWithName(qname2);
                    while (iterator.hasNext()) {
                        OMElement addressingHeader = (OMElement)iterator.next();
                        addressingHeader.detach();
                    }
                }
            } else {
                boolean exists = this.didAddressingHeaderExist(name);
                if (exists && this.replaceHeaders) {
                    OMElement addressingHeader = this.header.getFirstChildWithName(qname2);
                    if (log.isTraceEnabled()) {
                        log.trace("isAddressingHeaderAlreadyAvailable: Removing existing header:" + addressingHeader.getLocalName());
                    }
                    addressingHeader.detach();
                } else {
                    status = exists;
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("isAddressingHeaderAlreadyAvailable: name=" + name + " status=" + status);
            }
            return status;
        }

        private boolean didAddressingHeaderExist(String headerName) {
            if (log.isTraceEnabled()) {
                log.trace("didAddressingHeaderExist: headerName=" + headerName);
            }
            boolean result = false;
            if (this.existingWSAHeaders != null) {
                result = this.existingWSAHeaders.contains(headerName);
                if (log.isTraceEnabled()) {
                    log.trace("didAddressingHeaderExist: existingWSAHeaders=" + this.existingWSAHeaders + " result=" + result);
                }
            }
            return result;
        }

        private void processMustUnderstandProperty() {
            if (this.addMustUnderstandAttribute) {
                ArrayList headers = this.header.getHeaderBlocksWithNSURI(this.addressingNamespace);
                int size = headers.size();
                for (int i = 0; i < size; ++i) {
                    SOAPHeaderBlock soapHeaderBlock = (SOAPHeaderBlock)headers.get(i);
                    soapHeaderBlock.setMustUnderstand(true);
                    if (!log.isTraceEnabled()) continue;
                    log.trace("processMustUnderstandProperty: Setting mustUnderstand=true on: " + soapHeaderBlock.getLocalName());
                }
            }
        }
    }
}

