/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.handlers.addressing;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.AddressingFaultsHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AddressingInHandler
extends AbstractHandler
implements AddressingConstants {
    protected String addressingNamespace = "http://www.w3.org/2005/08/addressing";
    protected String addressingVersion = null;
    public static final String DISABLE_REF_PARAMETER_EXTRACT = "disableRefParamExtract";
    private static final Log log = LogFactory.getLog(AddressingInHandler.class);
    private boolean disableRefparamExtract = false;

    public void init(HandlerDescription handlerdesc) {
        super.init(handlerdesc);
        this.disableRefparamExtract = JavaUtils.isTrueExplicitly(Utils.getParameterValue(handlerdesc.getParameter(DISABLE_REF_PARAMETER_EXTRACT)));
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug("AddressingInHandler.init disableRefparamExtract=" + this.disableRefparamExtract);
        }
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        ArrayList addressingHeaders;
        if (JavaUtils.isTrueExplicitly(msgContext.getProperty("IsAddressingProcessed"))) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug("Another handler has processed the addressing headers. Nothing to do here.");
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        String namespace = (String)msgContext.getProperty("WSAddressingVersion");
        if (namespace == null) {
            namespace = this.addressingNamespace;
        } else if (!namespace.equals(this.addressingNamespace)) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug("This addressing handler does not match the specified namespace, " + namespace);
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        SOAPHeader header = null;
        if (msgContext.isHeaderPresent()) {
            header = msgContext.getEnvelope().getHeader();
        }
        if (header == null) {
            msgContext.setProperty("disableAddressingForOutMessages", Boolean.TRUE);
            return Handler.InvocationResponse.CONTINUE;
        }
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug("Starting " + this.addressingVersion + " IN handler ...");
        }
        if ((addressingHeaders = header.getHeaderBlocksWithNSURI(namespace)) != null && addressingHeaders.size() > 0) {
            msgContext.setProperty("WSAddressingVersion", namespace);
            msgContext.setProperty("disableAddressingForOutMessages", Boolean.FALSE);
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug(this.addressingVersion + " Headers present in the SOAP message. Starting to process ...");
            }
            this.extractAddressingInformation(header, msgContext, addressingHeaders, namespace);
            msgContext.setProperty("IsAddressingProcessed", Boolean.TRUE);
        } else {
            msgContext.setProperty("disableAddressingForOutMessages", Boolean.TRUE);
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug("No Headers present corresponding to " + this.addressingVersion);
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    protected Options extractAddressingInformation(SOAPHeader header, MessageContext messageContext, ArrayList addressingHeaders, String namespace) throws AxisFault {
        Options messageContextOptions = messageContext.getOptions();
        ArrayList checkedHeaderNames = new ArrayList(7);
        ArrayList duplicateHeaderNames = new ArrayList(1);
        boolean ignoreTo = false;
        boolean ignoreFrom = false;
        boolean ignoreReplyTo = false;
        boolean ignoreFaultTo = false;
        boolean ignoreMessageID = false;
        boolean ignoreAction = false;
        Iterator addressingHeadersIt = addressingHeaders.iterator();
        while (addressingHeadersIt.hasNext()) {
            SOAPHeaderBlock soapHeaderBlock = (SOAPHeaderBlock)addressingHeadersIt.next();
            if ("http://www.w3.org/2003/05/soap-envelope/role/none".equals(soapHeaderBlock.getRole())) continue;
            String localName = soapHeaderBlock.getLocalName();
            if ("Action".equals(localName)) {
                ignoreAction = this.checkDuplicateHeaders("Action", checkedHeaderNames, duplicateHeaderNames);
                continue;
            }
            if ("To".equals(localName)) {
                ignoreTo = this.checkDuplicateHeaders("To", checkedHeaderNames, duplicateHeaderNames);
                continue;
            }
            if ("MessageID".equals(localName)) {
                ignoreMessageID = this.checkDuplicateHeaders("MessageID", checkedHeaderNames, duplicateHeaderNames);
                continue;
            }
            if ("ReplyTo".equals(localName)) {
                ignoreReplyTo = this.checkDuplicateHeaders("ReplyTo", checkedHeaderNames, duplicateHeaderNames);
                continue;
            }
            if ("FaultTo".equals(localName)) {
                ignoreFaultTo = this.checkDuplicateHeaders("FaultTo", checkedHeaderNames, duplicateHeaderNames);
                continue;
            }
            if (!"From".equals(localName)) continue;
            ignoreFrom = this.checkDuplicateHeaders("From", checkedHeaderNames, duplicateHeaderNames);
        }
        Iterator addressingHeadersIt2 = addressingHeaders.iterator();
        while (addressingHeadersIt2.hasNext()) {
            SOAPHeaderBlock soapHeaderBlock = (SOAPHeaderBlock)addressingHeadersIt2.next();
            if ("http://www.w3.org/2003/05/soap-envelope/role/none".equals(soapHeaderBlock.getRole())) continue;
            String localName = soapHeaderBlock.getLocalName();
            if ("Action".equals(localName) && !ignoreAction) {
                this.extractActionInformation(soapHeaderBlock, namespace, messageContext);
                continue;
            }
            if ("To".equals(localName) && !ignoreTo) {
                this.extractToEPRInformation(soapHeaderBlock, messageContextOptions, header, namespace);
                continue;
            }
            if ("MessageID".equals(localName) && !ignoreMessageID) {
                this.extractMessageIDInformation(soapHeaderBlock, namespace, messageContext);
                continue;
            }
            if ("RelatesTo".equals(localName)) {
                this.extractRelatesToInformation(soapHeaderBlock, namespace, messageContextOptions);
                continue;
            }
            if ("ReplyTo".equals(localName) && !ignoreReplyTo) {
                this.extractReplyToEPRInformation(soapHeaderBlock, namespace, messageContext);
                continue;
            }
            if ("FaultTo".equals(localName) && !ignoreFaultTo) {
                this.extractFaultToEPRInformation(soapHeaderBlock, namespace, messageContext);
                continue;
            }
            if (!"From".equals(localName) || ignoreFrom) continue;
            this.extractFromEPRInformation(soapHeaderBlock, namespace, messageContext);
        }
        if (!duplicateHeaderNames.isEmpty()) {
            AddressingFaultsHelper.triggerInvalidCardinalityFault(messageContext, (String)duplicateHeaderNames.get(0));
        }
        this.checkForMandatoryHeaders(checkedHeaderNames, messageContext);
        this.setDefaults(checkedHeaderNames, messageContext);
        return messageContextOptions;
    }

    protected abstract void checkForMandatoryHeaders(ArrayList var1, MessageContext var2) throws AxisFault;

    protected abstract void setDefaults(ArrayList var1, MessageContext var2) throws AxisFault;

    private boolean checkDuplicateHeaders(String addressingHeaderName, ArrayList checkedHeaderNames, ArrayList duplicateHeaderNames) {
        boolean shouldIgnore = checkedHeaderNames.contains(addressingHeaderName);
        if (shouldIgnore) {
            duplicateHeaderNames.add(addressingHeaderName);
        } else {
            checkedHeaderNames.add(addressingHeaderName);
        }
        if (log.isTraceEnabled()) {
            log.trace("checkDuplicateHeaders: addressingHeaderName=" + addressingHeaderName + " isDuplicate=" + shouldIgnore);
        }
        return shouldIgnore;
    }

    protected abstract void extractToEprReferenceParameters(EndpointReference var1, SOAPHeader var2, String var3);

    private void extractRelatesToInformation(SOAPHeaderBlock soapHeaderBlock, String addressingNamespace, Options messageContextOptions) {
        String relationshipTypeString;
        String address = soapHeaderBlock.getText();
        OMAttribute relationshipType = soapHeaderBlock.getAttribute(new QName("RelationshipType"));
        String string = relationshipTypeString = relationshipType == null ? null : relationshipType.getAttributeValue();
        if (log.isTraceEnabled()) {
            log.trace("extractRelatesToInformation: Extracted Relationship. Value=" + address + " RelationshipType=" + relationshipTypeString);
        }
        RelatesTo relatesTo = new RelatesTo(address, relationshipTypeString);
        ArrayList attributes = this.extractAttributesFromSOAPHeaderBlock(soapHeaderBlock);
        relatesTo.setExtensibilityAttributes(attributes);
        messageContextOptions.addRelatesTo(relatesTo);
        soapHeaderBlock.setProcessed();
    }

    private void extractFaultToEPRInformation(SOAPHeaderBlock soapHeaderBlock, String addressingNamespace, MessageContext messageContext) throws AxisFault {
        Options messageContextOptions = messageContext.getOptions();
        EndpointReference epr = messageContextOptions.getFaultTo();
        if (epr == null) {
            epr = new EndpointReference("");
            messageContextOptions.setFaultTo(epr);
        }
        this.extractEPRInformation(soapHeaderBlock, epr, addressingNamespace, messageContext);
        if (log.isTraceEnabled()) {
            log.trace("extractFaultToEPRInformation: Extracted FaultTo EPR: " + epr);
        }
        soapHeaderBlock.setProcessed();
    }

    private void extractReplyToEPRInformation(SOAPHeaderBlock soapHeaderBlock, String addressingNamespace, MessageContext messageContext) throws AxisFault {
        Options messageContextOptions = messageContext.getOptions();
        EndpointReference epr = messageContextOptions.getReplyTo();
        if (epr == null) {
            epr = new EndpointReference("");
            messageContextOptions.setReplyTo(epr);
        }
        this.extractEPRInformation(soapHeaderBlock, epr, addressingNamespace, messageContext);
        if (log.isTraceEnabled()) {
            log.trace("extractReplyToEPRInformation: Extracted ReplyTo EPR: " + epr);
        }
        soapHeaderBlock.setProcessed();
    }

    private void extractFromEPRInformation(SOAPHeaderBlock soapHeaderBlock, String addressingNamespace, MessageContext messageContext) throws AxisFault {
        Options messageContextOptions = messageContext.getOptions();
        EndpointReference epr = messageContextOptions.getFrom();
        if (epr == null) {
            epr = new EndpointReference("");
            messageContextOptions.setFrom(epr);
        }
        this.extractEPRInformation(soapHeaderBlock, epr, addressingNamespace, messageContext);
        if (log.isTraceEnabled()) {
            log.trace("extractFromEPRInformation: Extracted From EPR: " + epr);
        }
        soapHeaderBlock.setProcessed();
    }

    private void extractToEPRInformation(SOAPHeaderBlock soapHeaderBlock, Options messageContextOptions, SOAPHeader header, String namespace) {
        EndpointReference epr = new EndpointReference(soapHeaderBlock.getText());
        messageContextOptions.setTo(epr);
        Iterator addressAttributes = soapHeaderBlock.getAllAttributes();
        if (addressAttributes != null && addressAttributes.hasNext()) {
            ArrayList<OMAttribute> attributes = new ArrayList<OMAttribute>();
            while (addressAttributes.hasNext()) {
                OMAttribute attr = (OMAttribute)addressAttributes.next();
                attributes.add(attr);
            }
            epr.setAddressAttributes(attributes);
        }
        if (!this.disableRefparamExtract) {
            this.extractToEprReferenceParameters(epr, header, namespace);
        }
        soapHeaderBlock.setProcessed();
        if (log.isTraceEnabled()) {
            log.trace("extractToEPRInformation: Extracted To EPR: " + epr);
        }
    }

    private void extractActionInformation(SOAPHeaderBlock soapHeaderBlock, String addressingNamespace, MessageContext messageContext) throws AxisFault {
        ArrayList attributes;
        Options messageContextOptions = messageContext.getOptions();
        String soapAction = messageContextOptions.getAction();
        String wsaAction = soapHeaderBlock.getText();
        if (log.isTraceEnabled()) {
            log.trace("extractActionInformation: soapAction='" + soapAction + "' wsa:Action='" + wsaAction + "'");
        }
        if (wsaAction == null || "".equals(wsaAction.trim())) {
            AddressingFaultsHelper.triggerActionNotSupportedFault(messageContext, wsaAction);
        }
        if (soapAction != null && !"".equals(soapAction) && messageContext.isServerSide()) {
            if (!soapAction.equals(wsaAction)) {
                AddressingFaultsHelper.triggerActionMismatchFault(messageContext);
            }
        } else {
            messageContextOptions.setAction(wsaAction);
        }
        if ((attributes = this.extractAttributesFromSOAPHeaderBlock(soapHeaderBlock)) != null) {
            messageContext.setProperty("actionAttributes", attributes);
        }
        soapHeaderBlock.setProcessed();
    }

    private void extractMessageIDInformation(SOAPHeaderBlock soapHeaderBlock, String addressingNamespace, MessageContext messageContext) throws AxisFault {
        messageContext.getOptions().setMessageId(soapHeaderBlock.getText());
        ArrayList attributes = this.extractAttributesFromSOAPHeaderBlock(soapHeaderBlock);
        if (attributes != null) {
            messageContext.setProperty("messageidAttributes", attributes);
        }
        soapHeaderBlock.setProcessed();
    }

    private void extractEPRInformation(SOAPHeaderBlock headerBlock, EndpointReference epr, String addressingNamespace, MessageContext messageContext) throws AxisFault {
        try {
            EndpointReferenceHelper.fromOM(epr, headerBlock, addressingNamespace);
        }
        catch (AxisFault af) {
            if (log.isTraceEnabled()) {
                log.trace("extractEPRInformation: Exception occurred deserialising an EndpointReference.", af);
            }
            AddressingFaultsHelper.triggerMissingAddressInEPRFault(messageContext, headerBlock.getLocalName());
        }
    }

    private ArrayList extractAttributesFromSOAPHeaderBlock(SOAPHeaderBlock soapHeaderBlock) {
        Iterator actionAttributes = soapHeaderBlock.getAllAttributes();
        if (actionAttributes != null && actionAttributes.hasNext()) {
            ArrayList<OMAttribute> attributes = new ArrayList<OMAttribute>();
            while (actionAttributes.hasNext()) {
                OMAttribute attr = (OMAttribute)actionAttributes.next();
                attributes.add(attr);
            }
            return attributes;
        }
        return null;
    }
}

