/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.handlers.addressing;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.AddressingFaultsHelper;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressingInFaultHandler
extends AbstractHandler
implements AddressingConstants {
    private static final Log log = LogFactory.getLog(AddressingInFaultHandler.class);

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        String action = msgContext.getWSAAction();
        if ("http://www.w3.org/2005/08/addressing/fault".equals(action) || "http://www.w3.org/2005/08/addressing/soap/fault".equals(action) || "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault".equals(action)) {
            String newReason;
            String faultLocalName = this.getFaultLocalName(msgContext);
            String faultDetailString = this.getWSAFaultDetailString(msgContext);
            if (faultLocalName != null && (newReason = AddressingFaultsHelper.getMessageForAxisFault(faultLocalName, faultDetailString)) != null) {
                SOAPEnvelope envelope = msgContext.getEnvelope();
                SOAPFault fault = envelope.getBody().getFault();
                SOAPFactory sf = (SOAPFactory)envelope.getOMFactory();
                SOAPFaultText sft = sf.createSOAPFaultText();
                sft.setText(newReason);
                SOAPFaultReason sfr = sf.createSOAPFaultReason();
                sfr.addSOAPText(sft);
                if (fault != null) {
                    AxisFault axisFault = new AxisFault(fault.getCode(), sfr, fault.getNode(), fault.getRole(), fault.getDetail());
                    msgContext.setProperty("inboundFaultOverride", axisFault);
                }
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private String getFaultLocalName(MessageContext msgContext) {
        SOAPEnvelope envelope = msgContext.getEnvelope();
        SOAPFault fault = envelope.getBody().getFault();
        QName faultCodeQName = null;
        String result = null;
        if (fault != null) {
            faultCodeQName = fault.getCode().getValue().getTextAsQName();
            if (fault.getCode().getSubCode() != null) {
                faultCodeQName = fault.getCode().getSubCode().getValue().getTextAsQName();
                if (fault.getCode().getSubCode().getSubCode() != null) {
                    faultCodeQName = fault.getCode().getSubCode().getSubCode().getValue().getTextAsQName();
                }
            }
        }
        if (faultCodeQName != null) {
            result = faultCodeQName.getLocalPart();
        }
        return result;
    }

    private String getWSAFaultDetailString(MessageContext msgContext) {
        SOAPEnvelope envelope = msgContext.getEnvelope();
        OMElement faultDetailElement = null;
        String result = null;
        if (msgContext.isSOAP11()) {
            SOAPHeader header = envelope.getHeader();
            faultDetailElement = header.getFirstChildWithName(new QName("FaultDetail"));
            if (faultDetailElement != null) {
                result = faultDetailElement.getFirstElement().getText();
            }
        } else {
            SOAPFault fault = envelope.getBody().getFault();
            if (fault != null && fault.getDetail() != null && (faultDetailElement = fault.getDetail().getFirstChildWithName(new QName("ProblemAction"))) == null) {
                faultDetailElement = fault.getDetail().getFirstChildWithName(new QName("ProblemHeaderQName"));
            }
            if (faultDetailElement != null) {
                result = faultDetailElement.getText();
            }
        }
        return result;
    }
}

