/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SOAPMessageBodyBasedDispatcher
extends AbstractDispatcher {
    public static final String NAME = "SOAPMessageBodyBasedDispatcher";
    private static final Log log = LogFactory.getLog(SOAPMessageBodyBasedDispatcher.class);

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        QName operationName;
        AxisOperation axisOperation;
        OMElement bodyFirstChild = messageContext.getEnvelope().getBody().getFirstElement();
        if (bodyFirstChild == null) {
            return null;
        }
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug(messageContext.getLogIDString() + " Checking for Operation using SOAP message body's first child's local name : " + bodyFirstChild.getLocalName());
        }
        if ((axisOperation = service.getOperation(operationName = new QName(bodyFirstChild.getLocalName()))) == null) {
            axisOperation = service.getOperationByMessageElementQName(bodyFirstChild.getQName());
        }
        return axisOperation;
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        OMNamespace ns;
        OMElement bodyFirstChild = messageContext.getEnvelope().getBody().getFirstElement();
        if (bodyFirstChild != null && (ns = bodyFirstChild.getNamespace()) != null) {
            ConfigurationContext configurationContext;
            String[] values;
            String filePart = ns.getNamespaceURI();
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug(messageContext.getLogIDString() + " Checking for Service using SOAP message body's first child's namespace : " + filePart);
            }
            if ((values = Utils.parseRequestURLForServiceAndOperation(filePart, (configurationContext = messageContext.getConfigurationContext()).getServiceContextPath()))[0] != null) {
                String serviceName = values[0];
                AxisConfiguration registry = configurationContext.getAxisConfiguration();
                return registry.getService(serviceName);
            }
        }
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }
}

