/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTTPLocationBasedDispatcher
extends AbstractDispatcher {
    public static final String NAME = "HTTPLocationBasedDispatcher";
    private static final Log log = LogFactory.getLog(HTTPLocationBasedDispatcher.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        AxisService axisService = messageContext.getAxisService();
        if (axisService == null) return null;
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (httpServletRequest != null) {
            String httpLocation;
            String uri = httpServletRequest.getPathInfo();
            String query = httpServletRequest.getQueryString();
            if (query != null) {
                uri = uri + '?' + query;
            }
            if ((httpLocation = this.parseRequestURL(uri)) != null) {
                AxisEndpoint axisEndpoint = (AxisEndpoint)messageContext.getProperty("endpoint");
                if (axisEndpoint == null) return null;
                Map httpLocationTable = (Map)axisEndpoint.getBinding().getProperty("HTTPLocationTable");
                if (httpLocationTable == null) return null;
                return this.getOperationFromHTTPLocation(httpLocation, httpLocationTable);
            }
            log.debug("Attempt to check for Operation using HTTP Location failed");
            return null;
        }
        log.debug("HttpServletRequest in MessageContext is null");
        return null;
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    private String parseRequestURL(String path) {
        path = path.substring(1);
        int index = path.indexOf("/");
        String service = null;
        if (-1 != index) {
            service = path.substring(index);
        } else {
            int queryIndex = path.indexOf("?");
            if (queryIndex != -1) {
                service = path.substring(queryIndex);
            }
        }
        return service;
    }

    private AxisOperation getOperationFromHTTPLocation(String requestPath, Map httpLocationTable) {
        Set httpLocations = httpLocationTable.keySet();
        Iterator iter = httpLocations.iterator();
        while (iter.hasNext()) {
            String location = (String)iter.next();
            int index = requestPath.indexOf(location);
            if (index != 0) continue;
            return (AxisOperation)httpLocationTable.get(location);
        }
        return null;
    }
}

