/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ContextFactory;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DependencyManager {
    private static final Log log = LogFactory.getLog(DependencyManager.class);
    public static final String SERVICE_INIT_METHOD = "init";
    public static final String SERVICE_START_METHOD = "startUp";
    public static final String SERVICE_DESTROY_METHOD = "destroy";

    public static void initServiceClass(Object obj, ServiceContext serviceContext) {
        try {
            Class<?> classToLoad = obj.getClass();
            Method method = classToLoad.getMethod(SERVICE_INIT_METHOD, ServiceContext.class);
            if (method != null) {
                method.invoke(obj, serviceContext);
            }
        }
        catch (SecurityException e) {
            log.info("Exception trying to call init", e);
        }
        catch (IllegalArgumentException e) {
            log.info("Exception trying to call init", e);
        }
        catch (IllegalAccessException e) {
            log.info("Exception trying to call init", e);
        }
        catch (InvocationTargetException e) {
            log.info("Exception trying to call init", e);
        }
        catch (NoSuchMethodException e) {
            log.debug("Exception trying to call init", e);
        }
    }

    public static void initService(ServiceGroupContext serviceGroupContext) throws AxisFault {
        AxisServiceGroup serviceGroup = serviceGroupContext.getDescription();
        Iterator serviceItr = serviceGroup.getServices();
        while (serviceItr.hasNext()) {
            AxisService axisService = (AxisService)serviceItr.next();
            ServiceContext serviceContext = ContextFactory.createServiceContext(serviceGroupContext, axisService);
            AxisService service = serviceContext.getAxisService();
            ClassLoader classLoader = service.getClassLoader();
            Parameter implInfoParam = service.getParameter("ServiceClass");
            if (implInfoParam == null) continue;
            try {
                Class implClass = Loader.loadClass(classLoader, ((String)implInfoParam.getValue()).trim());
                Object serviceImpl = implClass.newInstance();
                serviceContext.setProperty("serviceObject", serviceImpl);
                DependencyManager.initServiceClass(serviceImpl, serviceContext);
            }
            catch (Exception e) {
                new AxisFault(e);
            }
        }
    }

    public static void destroyServiceObject(ServiceContext serviceContext) {
        block6: {
            try {
                Object obj = serviceContext.getProperty("serviceObject");
                if (obj == null) break block6;
                Class<?> classToLoad = obj.getClass();
                Method[] methods = classToLoad.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    if (!SERVICE_DESTROY_METHOD.equals(methods[i].getName()) || methods[i].getParameterTypes().length != 1 || methods[i].getParameterTypes()[0] != (class$org$apache$axis2$context$ServiceContext == null ? DependencyManager.class$("org.apache.axis2.context.ServiceContext") : class$org$apache$axis2$context$ServiceContext)) continue;
                    methods[i].invoke(obj, serviceContext);
                    break;
                }
            }
            catch (SecurityException e) {
                log.info("Exception trying to call destroy", e);
            }
            catch (IllegalArgumentException e) {
                log.info("Exception trying to call destroy", e);
            }
            catch (IllegalAccessException e) {
                log.info("Exception trying to call destroy", e);
            }
            catch (InvocationTargetException e) {
                log.info("Exception trying to call destroy", e);
            }
        }
    }
}

