/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.engine.MessageReceiverExtension;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.util.CallbackReceiver;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisEngine {
    private static final Log log = LogFactory.getLog(AxisEngine.class);
    private ConfigurationContext engineContext;
    private static boolean RESUMING_EXECUTION = true;
    private static boolean NOT_RESUMING_EXECUTION = false;
    private static boolean IS_INBOUND = true;
    private static boolean IS_OUTBOUND = false;

    public AxisEngine(ConfigurationContext engineContext) {
        this.engineContext = engineContext;
    }

    private void checkMustUnderstand(MessageContext msgContext) throws AxisFault {
        if (msgContext == null || !msgContext.isHeaderPresent()) {
            return;
        }
        SOAPEnvelope envelope = msgContext.getEnvelope();
        if (envelope.getHeader() == null) {
            return;
        }
        Iterator headerBlocks = envelope.getHeader().examineAllHeaderBlocks();
        ArrayList<QName> faultyHeaderQNames = new ArrayList<QName>();
        if (log.isDebugEnabled()) {
            log.debug("Check if MessageReceiver will handle MustUnderstand check");
        }
        boolean delegateToMR = this.delegateMustUnderstandCheckToMR(msgContext);
        while (headerBlocks.hasNext()) {
            ArrayList understoodHeaderList;
            SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)headerBlocks.next();
            QName headerQName = headerBlock.getQName();
            if (headerBlock.isProcessed() || !headerBlock.getMustUnderstand() || !this.checkThisHeader(headerBlock, msgContext)) continue;
            AxisOperation axisOperation = msgContext.getAxisOperation();
            if (axisOperation != null && (understoodHeaderList = axisOperation.getUnderstoodHeaderQNames()) != null && !understoodHeaderList.isEmpty() && understoodHeaderList.contains(headerQName)) {
                if (!LoggingControl.debugLoggingAllowed || !log.isDebugEnabled()) continue;
                log.debug("MustUnderstand header registered as understood on AxisOperation: " + headerQName);
                continue;
            }
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug("MustUnderstand header not processed or registered as understood " + headerQName);
            }
            if (delegateToMR) {
                if (log.isDebugEnabled()) {
                    log.debug("MustUnderstandCheck delegated to MessageReceiver");
                }
                if (faultyHeaderQNames.contains(headerQName)) continue;
                faultyHeaderQNames.add(headerQName);
                continue;
            }
            String prefix = envelope.getNamespace().getPrefix();
            if (!msgContext.isSOAP11()) {
                if (prefix == null || "".equals(prefix)) {
                    prefix = "soapenv";
                }
                throw new AxisFault(Messages.getMessage("mustunderstandfailed", prefix, headerQName.toString()), "MustUnderstand");
            }
            throw new AxisFault(Messages.getMessage("mustunderstandfailed", prefix, headerQName.toString()), "MustUnderstand");
        }
        AxisService axisService = msgContext.getAxisService();
        Parameter p = new Parameter("faultyHeaderQNames", faultyHeaderQNames);
        axisService.addParameter(p);
    }

    private boolean delegateMustUnderstandCheckToMR(MessageContext msgContext) throws AxisFault {
        if (msgContext.isServerSide()) {
            MessageReceiver receiver = msgContext.getAxisOperation().getMessageReceiver();
            if (receiver == null) {
                throw new AxisFault(Messages.getMessage("nomessagereciever", msgContext.getAxisOperation().getName().toString()));
            }
            if (MessageReceiverExtension.class.isAssignableFrom(receiver.getClass())) {
                MessageReceiverExtension mre = (MessageReceiverExtension)((Object)receiver);
                return mre.isMustUnderstandCheckPostponed(msgContext);
            }
            if (log.isDebugEnabled()) {
                log.debug("Receiver does not implement MessageReceiverExtension");
            }
        }
        return false;
    }

    private boolean checkThisHeader(SOAPHeaderBlock headerBlock, MessageContext msgContext) {
        boolean checkIt = true;
        AxisService axisService = msgContext.getAxisService();
        if (axisService.isClientSide()) {
            String role = headerBlock.getRole();
            boolean isSoapConnection = this.isSoapConnection(msgContext);
            if (log.isDebugEnabled()) {
                log.debug("Is this message flowing over a SOAPConnection: " + isSoapConnection);
            }
            checkIt = !isSoapConnection ? role == null || "http://www.w3.org/2003/05/soap-envelope/role/next".equals(role) || "http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver".equals(role) || "http://schemas.xmlsoap.org/soap/actor/next".equals(role) : false;
            if (log.isDebugEnabled()) {
                log.debug("Client-side MustUnderstand header checking: " + checkIt + "; for header role: " + role + "; header QName: " + headerBlock.getQName());
            }
        }
        return checkIt;
    }

    private boolean isSoapConnection(MessageContext msgContext) {
        Boolean propertyValue;
        boolean isSoapConnection = false;
        OperationContext opCtx = msgContext.getOperationContext();
        MessageContext outboundMC = null;
        try {
            outboundMC = opCtx.getMessageContext("Out");
        }
        catch (AxisFault af) {
            // empty catch block
        }
        if (outboundMC != null && (propertyValue = (Boolean)outboundMC.getProperty("com.ibm.ws.webservices.engine.xmlsoap.saaj13only.SOAPConnectionJAXWS.soapConnection")) != null) {
            isSoapConnection = propertyValue;
        }
        return isSoapConnection;
    }

    public MessageContext createFaultMessageContext(MessageContext processingContext, Throwable e) throws AxisFault {
        return MessageContextBuilder.createFaultMessageContext(processingContext, e);
    }

    public Handler.InvocationResponse receive(MessageContext msgContext) throws AxisFault {
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace(msgContext.getLogIDString() + " receive:" + msgContext.getMessageID());
        }
        ConfigurationContext confContext = msgContext.getConfigurationContext();
        ArrayList preCalculatedPhases = confContext.getAxisConfiguration().getGlobalInFlow();
        msgContext.setExecutionChain((ArrayList)preCalculatedPhases.clone());
        msgContext.setFLOW(1);
        try {
            Handler.InvocationResponse pi = this.invoke(msgContext, IS_INBOUND, NOT_RESUMING_EXECUTION);
            if (pi.equals(Handler.InvocationResponse.CONTINUE)) {
                this.checkMustUnderstand(msgContext);
                if (msgContext.isServerSide()) {
                    MessageReceiver receiver = msgContext.getAxisOperation().getMessageReceiver();
                    if (receiver == null) {
                        throw new AxisFault(Messages.getMessage("nomessagereciever", msgContext.getAxisOperation().getName().toString()));
                    }
                    receiver.receive(msgContext);
                }
            } else {
                if (pi.equals(Handler.InvocationResponse.SUSPEND)) {
                    return pi;
                }
                if (pi.equals(Handler.InvocationResponse.ABORT)) {
                    OperationContext opCtx;
                    this.flowComplete(msgContext, true);
                    String mepURI = msgContext.getAxisOperation().getMessageExchangePattern();
                    if ("http://www.w3.org/2006/01/wsdl/out-in".equals(mepURI) && (opCtx = msgContext.getOperationContext()) != null) {
                        opCtx.removeMessageContext("In");
                    }
                    return pi;
                }
                String errorMsg = "Unrecognized InvocationResponse encountered in AxisEngine.receive()";
                log.error(msgContext.getLogIDString() + " " + errorMsg);
                throw new AxisFault(errorMsg);
            }
            this.flowComplete(msgContext, true);
        }
        catch (AxisFault e) {
            this.flowComplete(msgContext, true);
            throw e;
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext, boolean inbound, boolean resuming) throws AxisFault {
        if (msgContext.getCurrentHandlerIndex() == -1) {
            msgContext.setCurrentHandlerIndex(0);
        }
        Handler.InvocationResponse pi = Handler.InvocationResponse.CONTINUE;
        while (msgContext.getCurrentHandlerIndex() < msgContext.getExecutionChain().size()) {
            Handler currentHandler = (Handler)msgContext.getExecutionChain().get(msgContext.getCurrentHandlerIndex());
            try {
                if (!resuming) {
                    if (inbound) {
                        msgContext.addInboundExecutedPhase(currentHandler);
                    } else {
                        msgContext.addOutboundExecutedPhase(currentHandler);
                    }
                } else {
                    resuming = false;
                }
                pi = currentHandler.invoke(msgContext);
            }
            catch (AxisFault e) {
                if (msgContext.getCurrentPhaseIndex() == 0) {
                    if (inbound) {
                        msgContext.removeFirstInboundExecutedPhase();
                    } else {
                        msgContext.removeFirstOutboundExecutedPhase();
                    }
                }
                throw e;
            }
            if (pi.equals(Handler.InvocationResponse.SUSPEND) || pi.equals(Handler.InvocationResponse.ABORT)) break;
            msgContext.setCurrentHandlerIndex(msgContext.getCurrentHandlerIndex() + 1);
        }
        return pi;
    }

    private void flowComplete(MessageContext msgContext, boolean inbound) {
        Iterator invokedPhaseIterator;
        Iterator iterator = invokedPhaseIterator = inbound ? msgContext.getInboundExecutedPhases() : msgContext.getOutboundExecutedPhases();
        while (invokedPhaseIterator.hasNext()) {
            Handler currentHandler = (Handler)invokedPhaseIterator.next();
            currentHandler.flowComplete(msgContext);
        }
        if (inbound) {
            msgContext.resetInboundExecutedPhases();
        } else {
            msgContext.resetOutboundExecutedPhases();
        }
    }

    public Handler.InvocationResponse resumeReceive(MessageContext msgContext) throws AxisFault {
        Handler.InvocationResponse pi;
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace(msgContext.getLogIDString() + " resumeReceive:" + msgContext.getMessageID());
        }
        if ((pi = this.invoke(msgContext, IS_INBOUND, RESUMING_EXECUTION)).equals(Handler.InvocationResponse.CONTINUE)) {
            this.checkMustUnderstand(msgContext);
            if (msgContext.isServerSide()) {
                MessageReceiver receiver = msgContext.getAxisOperation().getMessageReceiver();
                if (receiver == null) {
                    throw new AxisFault(Messages.getMessage("nomessagereciever", msgContext.getAxisOperation().getName().toString()));
                }
                receiver.receive(msgContext);
            }
            this.flowComplete(msgContext, true);
        }
        return pi;
    }

    public Handler.InvocationResponse resumeSend(MessageContext msgContext) throws AxisFault {
        Handler.InvocationResponse pi;
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace(msgContext.getLogIDString() + " resumeSend:" + msgContext.getMessageID());
        }
        if ((pi = this.invoke(msgContext, IS_OUTBOUND, RESUMING_EXECUTION)).equals(Handler.InvocationResponse.CONTINUE)) {
            TransportOutDescription transportOut = msgContext.getTransportOut();
            TransportSender sender = transportOut.getSender();
            sender.invoke(msgContext);
            this.flowComplete(msgContext, false);
        }
        return pi;
    }

    public Handler.InvocationResponse receiveFault(MessageContext msgContext) throws AxisFault {
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug(msgContext.getLogIDString() + " " + Messages.getMessage("receivederrormessage", msgContext.getMessageID()));
        }
        ConfigurationContext confContext = msgContext.getConfigurationContext();
        ArrayList preCalculatedPhases = confContext.getAxisConfiguration().getInFaultFlow();
        msgContext.setExecutionChain((ArrayList)preCalculatedPhases.clone());
        msgContext.setFLOW(3);
        try {
            Handler.InvocationResponse pi = this.invoke(msgContext, IS_INBOUND, NOT_RESUMING_EXECUTION);
            if (pi.equals(Handler.InvocationResponse.CONTINUE)) {
                this.checkMustUnderstand(msgContext);
                if (msgContext.isServerSide()) {
                    MessageReceiver receiver = msgContext.getAxisOperation().getMessageReceiver();
                    receiver.receive(msgContext);
                }
            } else {
                if (pi.equals(Handler.InvocationResponse.SUSPEND)) {
                    return pi;
                }
                if (pi.equals(Handler.InvocationResponse.ABORT)) {
                    this.flowComplete(msgContext, true);
                    AxisOperation axisOp = msgContext.getAxisOperation();
                    if (axisOp != null) {
                        OperationContext opCtx;
                        String mepURI = axisOp.getMessageExchangePattern();
                        if ("http://www.w3.org/2006/01/wsdl/out-in".equals(mepURI) && (opCtx = msgContext.getOperationContext()) != null) {
                            opCtx.removeMessageContext("In");
                        }
                    } else if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                        log.debug("failed to cleanup opCtx due to missing axisOperation " + msgContext.getOperationContext());
                    }
                    return pi;
                }
                String errorMsg = "Unrecognized InvocationResponse encountered in AxisEngine.receiveFault()";
                log.error(msgContext.getLogIDString() + " " + errorMsg);
                throw new AxisFault(errorMsg);
            }
            this.flowComplete(msgContext, true);
        }
        catch (AxisFault e) {
            this.flowComplete(msgContext, true);
            throw e;
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    public Handler.InvocationResponse resume(MessageContext msgctx) throws AxisFault {
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace(msgctx.getLogIDString() + " resume:" + msgctx.getMessageID());
        }
        msgctx.setPaused(false);
        if (msgctx.getFLOW() == 1) {
            return this.resumeReceive(msgctx);
        }
        return this.resumeSend(msgctx);
    }

    public void send(MessageContext msgContext) throws AxisFault {
        block8: {
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace(msgContext.getLogIDString() + " send:" + msgContext.getMessageID());
            }
            OperationContext operationContext = msgContext.getOperationContext();
            ArrayList executionChain = operationContext.getAxisOperation().getPhasesOutFlow();
            ArrayList outPhases = new ArrayList();
            outPhases.addAll((ArrayList)executionChain.clone());
            outPhases.addAll((ArrayList)msgContext.getConfigurationContext().getAxisConfiguration().getGlobalOutPhases().clone());
            msgContext.setExecutionChain(outPhases);
            msgContext.setFLOW(2);
            try {
                Handler.InvocationResponse pi = this.invoke(msgContext, IS_OUTBOUND, NOT_RESUMING_EXECUTION);
                if (pi.equals(Handler.InvocationResponse.CONTINUE)) {
                    TransportOutDescription transportOut = msgContext.getTransportOut();
                    if (transportOut == null) {
                        throw new AxisFault("Transport out has not been set");
                    }
                    TransportSender sender = transportOut.getSender();
                    Object isTransportNonBlocking = msgContext.getProperty("transportNonBlocking");
                    if (isTransportNonBlocking != null && ((Boolean)isTransportNonBlocking).booleanValue()) {
                        msgContext.getConfigurationContext().getThreadPool().execute(new TransportNonBlockingInvocationWorker(msgContext, sender));
                    } else {
                        sender.invoke(msgContext);
                    }
                    this.flowComplete(msgContext, false);
                    break block8;
                }
                if (pi.equals(Handler.InvocationResponse.SUSPEND)) break block8;
                if (pi.equals(Handler.InvocationResponse.ABORT)) {
                    this.flowComplete(msgContext, false);
                    break block8;
                }
                String errorMsg = "Unrecognized InvocationResponse encountered in AxisEngine.send()";
                log.error(msgContext.getLogIDString() + " " + errorMsg);
                throw new AxisFault(errorMsg);
            }
            catch (AxisFault e) {
                this.flowComplete(msgContext, false);
                throw e;
            }
        }
    }

    public void sendFault(MessageContext msgContext) throws AxisFault {
        OperationContext opContext;
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace(msgContext.getLogIDString() + " sendFault:" + msgContext.getMessageID());
        }
        if ((opContext = msgContext.getOperationContext()) != null) {
            AxisOperation axisOperation = opContext.getAxisOperation();
            ArrayList faultExecutionChain = axisOperation.getPhasesOutFaultFlow();
            ArrayList outFaultPhases = new ArrayList();
            outFaultPhases.addAll((ArrayList)faultExecutionChain.clone());
            msgContext.setExecutionChain((ArrayList)outFaultPhases.clone());
            msgContext.setFLOW(4);
            try {
                Handler.InvocationResponse pi = this.invoke(msgContext, IS_OUTBOUND, NOT_RESUMING_EXECUTION);
                if (pi.equals(Handler.InvocationResponse.SUSPEND)) {
                    log.warn(msgContext.getLogIDString() + " The resumption of this flow may function incorrectly, as the OutFaultFlow will not be used");
                    return;
                }
                if (pi.equals(Handler.InvocationResponse.ABORT)) {
                    this.flowComplete(msgContext, false);
                    return;
                }
                if (!pi.equals(Handler.InvocationResponse.CONTINUE)) {
                    String errorMsg = "Unrecognized InvocationResponse encountered in AxisEngine.sendFault()";
                    log.error(msgContext.getLogIDString() + " " + errorMsg);
                    throw new AxisFault(errorMsg);
                }
            }
            catch (AxisFault e) {
                this.flowComplete(msgContext, false);
                throw e;
            }
        }
        msgContext.setExecutionChain((ArrayList)msgContext.getConfigurationContext().getAxisConfiguration().getOutFaultFlow().clone());
        msgContext.setFLOW(4);
        Handler.InvocationResponse pi = this.invoke(msgContext, IS_OUTBOUND, NOT_RESUMING_EXECUTION);
        if (pi.equals(Handler.InvocationResponse.CONTINUE)) {
            TransportOutDescription transportOut = msgContext.getTransportOut();
            if (transportOut == null) {
                throw new AxisFault("Transport out has not been set");
            }
            TransportSender sender = transportOut.getSender();
            sender.invoke(msgContext);
            this.flowComplete(msgContext, false);
        } else if (!pi.equals(Handler.InvocationResponse.SUSPEND)) {
            if (pi.equals(Handler.InvocationResponse.ABORT)) {
                this.flowComplete(msgContext, false);
            } else {
                String errorMsg = "Unrecognized InvocationResponse encountered in AxisEngine.sendFault()";
                log.error(msgContext.getLogIDString() + " " + errorMsg);
                throw new AxisFault(errorMsg);
            }
        }
    }

    private class TransportNonBlockingInvocationWorker
    implements Runnable {
        private MessageContext msgctx;
        private TransportSender sender;

        public TransportNonBlockingInvocationWorker(MessageContext msgctx, TransportSender sender) {
            this.msgctx = msgctx;
            this.sender = sender;
        }

        public void run() {
            block2: {
                try {
                    this.sender.invoke(this.msgctx);
                }
                catch (Exception e) {
                    Callback callback;
                    MessageReceiver msgReceiver;
                    AxisOperation axisOperation;
                    log.info(this.msgctx.getLogIDString() + " " + e.getMessage());
                    if (this.msgctx.getProperty("disableTransmissionErrorCallback") != null || (axisOperation = this.msgctx.getAxisOperation()) == null || (msgReceiver = axisOperation.getMessageReceiver()) == null || !(msgReceiver instanceof CallbackReceiver) || (callback = ((CallbackReceiver)msgReceiver).lookupCallback(this.msgctx.getMessageID())) == null) break block2;
                    callback.onError(e);
                }
            }
        }
    }
}

