/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.dispatchers;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.dispatchers.AbstractOperationDispatcher;
import org.apache.axis2.util.LoggingControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionBasedOperationDispatcher
extends AbstractOperationDispatcher {
    public static final String NAME = "ActionBasedOperationDispatcher";
    private static final Log log = LogFactory.getLog(ActionBasedOperationDispatcher.class);

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        String action = messageContext.getSoapAction();
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug(messageContext.getLogIDString() + " Checking for Operation using Action : " + action);
        }
        if (action != null) {
            AxisOperation op = service.getOperationBySOAPAction(action);
            if (op == null) {
                op = service.getOperationByAction(action);
            }
            return op;
        }
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }
}

