/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDLToAxisServiceBuilder;
import org.apache.axis2.namespace.Constants;
import org.apache.axis2.transport.http.util.RESTUtil;
import org.apache.axis2.wsdl.HTTPHeaderMessage;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.axis2.wsdl.SOAPModuleMessage;
import org.apache.woden.WSDLException;
import org.apache.woden.WSDLFactory;
import org.apache.woden.WSDLReader;
import org.apache.woden.WSDLSource;
import org.apache.woden.internal.DOMWSDLFactory;
import org.apache.woden.internal.wsdl20.extensions.InterfaceOperationExtensionsImpl;
import org.apache.woden.internal.wsdl20.extensions.http.HTTPBindingExtensionsImpl;
import org.apache.woden.internal.wsdl20.extensions.http.HTTPHeaderImpl;
import org.apache.woden.internal.wsdl20.extensions.soap.SOAPBindingExtensionsImpl;
import org.apache.woden.schema.Schema;
import org.apache.woden.wsdl20.Binding;
import org.apache.woden.wsdl20.BindingFault;
import org.apache.woden.wsdl20.BindingFaultReference;
import org.apache.woden.wsdl20.BindingMessageReference;
import org.apache.woden.wsdl20.BindingOperation;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.ElementDeclaration;
import org.apache.woden.wsdl20.Endpoint;
import org.apache.woden.wsdl20.Interface;
import org.apache.woden.wsdl20.InterfaceFault;
import org.apache.woden.wsdl20.InterfaceFaultReference;
import org.apache.woden.wsdl20.InterfaceMessageReference;
import org.apache.woden.wsdl20.InterfaceOperation;
import org.apache.woden.wsdl20.Service;
import org.apache.woden.wsdl20.enumeration.MessageLabel;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingFaultExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingMessageReferenceExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingOperationExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPHeader;
import org.apache.woden.wsdl20.extensions.http.HTTPLocation;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingFaultExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingFaultReferenceExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingMessageReferenceExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingOperationExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPEndpointExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPHeaderBlock;
import org.apache.woden.wsdl20.extensions.soap.SOAPModule;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.apache.woden.wsdl20.xml.TypesElement;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.w3c.dom.Document;

public class WSDL20ToAxisServiceBuilder
extends WSDLToAxisServiceBuilder {
    protected Description description;
    private String wsdlURI;
    private static String RPC = "rpc";
    protected String interfaceName;
    private String savedTargetNamespace;
    private Map namespacemap;
    private NamespaceMap stringBasedNamespaceMap;
    private boolean setupComplete = false;
    private Service wsdlService;
    private Map processedBindings;

    public WSDL20ToAxisServiceBuilder(InputStream in, QName serviceName, String interfaceName) {
        this.in = in;
        this.serviceName = serviceName;
        this.interfaceName = interfaceName;
        this.axisService = new AxisService();
        this.setPolicyRegistryFromService(this.axisService);
    }

    public WSDL20ToAxisServiceBuilder(String wsdlUri, String name, String interfaceName) throws Exception {
        WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
        String fullPath = wsdlUri;
        if (!wsdlUri.startsWith("http://")) {
            File file = new File(wsdlUri);
            fullPath = file.getAbsolutePath();
        }
        Description description = wsdlReader.readWSDL(fullPath);
        DescriptionElement descriptionElement = description.toElement();
        this.savedTargetNamespace = descriptionElement.getTargetNamespace().toString();
        this.namespacemap = descriptionElement.getNamespaces();
        this.description = description;
        this.serviceName = null;
        if (name != null) {
            this.serviceName = new QName(descriptionElement.getTargetNamespace().toString(), name);
        }
        this.interfaceName = interfaceName;
        this.axisService = new AxisService();
        this.setPolicyRegistryFromService(this.axisService);
    }

    public WSDL20ToAxisServiceBuilder(String wsdlUri, QName serviceName) {
        super(null, serviceName);
        this.wsdlURI = wsdlUri;
    }

    public WSDL20ToAxisServiceBuilder(String wsdlUri, AxisService service) {
        super(null, service);
        this.wsdlURI = wsdlUri;
    }

    public AxisService populateService() throws AxisFault {
        try {
            this.setup();
            Parameter wsdlDescriptionParamter = new Parameter();
            wsdlDescriptionParamter.setName("WSDL20Description");
            wsdlDescriptionParamter.setValue(this.description);
            this.axisService.addParameter(wsdlDescriptionParamter);
            if (this.description == null) {
                return null;
            }
            this.axisService.setTargetNamespace(this.savedTargetNamespace);
            this.axisService.setNameSpacesMap(this.stringBasedNamespaceMap);
            TypesElement typesElement = this.description.toElement().getTypesElement();
            if (typesElement != null) {
                Schema[] schemas = typesElement.getSchemas();
                for (int i = 0; i < schemas.length; ++i) {
                    XmlSchema schemaDefinition = schemas[i].getSchemaDefinition();
                    if (schemaDefinition == null || "http://www.w3.org/2001/XMLSchema".equals(schemaDefinition.getTargetNamespace())) continue;
                    this.axisService.addSchema(schemaDefinition);
                }
            }
            this.processService();
            return this.axisService;
        }
        catch (Exception e) {
            throw new AxisFault(e);
        }
    }

    private void processEndpoints() throws AxisFault {
        Endpoint[] endpoints = this.wsdlService.getEndpoints();
        if (endpoints.length == 0) {
            throw new AxisFault("No endpoints found in the WSDL");
        }
        this.processedBindings = new HashMap();
        Endpoint endpoint = null;
        if (this.interfaceName != null) {
            for (int i = 0; i < endpoints.length; ++i) {
                if (!this.interfaceName.equals(endpoints[i].getName().toString())) continue;
                endpoint = endpoints[i];
                break;
            }
            if (endpoint == null) {
                throw new AxisFault("No endpoint found for the given name :" + this.interfaceName);
            }
            this.axisService.addEndpoint(endpoint.getName().toString(), this.processEndpoint(endpoint));
        } else {
            for (int i = 0; i < endpoints.length; ++i) {
                this.axisService.addEndpoint(endpoints[i].getName().toString(), this.processEndpoint(endpoints[i]));
            }
        }
        if (endpoint == null && endpoints.length > 0) {
            endpoint = endpoints[0];
        }
        this.axisService.setEndpointName(endpoint.getName().toString());
        this.axisService.setBindingName(endpoint.getBinding().getName().getLocalPart());
        this.axisService.setEndpointURL(endpoint.getAddress().toString());
    }

    private void processService() throws AxisFault {
        Service[] services = this.description.getServices();
        if (services.length == 0) {
            throw new AxisFault("No wsdlService found in the WSDL");
        }
        if (this.serviceName != null) {
            for (int i = 0; i < services.length; ++i) {
                if (!this.serviceName.equals(services[i].getName())) continue;
                this.wsdlService = services[i];
                break;
            }
            if (this.wsdlService == null) {
                throw new AxisFault("Service with the specified name not found in the WSDL : " + this.serviceName.getLocalPart());
            }
        }
        this.wsdlService = services[0];
        this.axisService.setName(this.wsdlService.getName().getLocalPart().toString());
        this.processInterface(this.wsdlService.getInterface());
        this.processEndpoints();
    }

    private AxisEndpoint processEndpoint(Endpoint endpoint) throws AxisFault {
        AxisEndpoint axisEndpoint = new AxisEndpoint();
        axisEndpoint.setName(endpoint.getName().toString());
        if (this.processedBindings.containsKey(endpoint.getBinding().getName())) {
            axisEndpoint.setBinding((AxisBinding)this.processedBindings.get(endpoint.getBinding().getName()));
        } else {
            axisEndpoint.setBinding(this.processBinding(endpoint.getBinding()));
        }
        SOAPEndpointExtensions soapEndpointExtensions = null;
        try {
            soapEndpointExtensions = (SOAPEndpointExtensions)endpoint.getComponentExtensionsForNamespace(new URI("http://www.w3.org/2006/01/wsdl/soap"));
        }
        catch (URISyntaxException e) {
            throw new AxisFault("HTTP Binding Extention not found");
        }
        if (soapEndpointExtensions != null) {
            axisEndpoint.setProperty("whttp:authenticationType", soapEndpointExtensions.getHttpAuthenticationScheme());
            axisEndpoint.setProperty("whttp:authenticationRealm", soapEndpointExtensions.getHttpAuthenticationRealm());
        }
        return axisEndpoint;
    }

    protected void setup() throws AxisFault {
        if (this.setupComplete) {
            return;
        }
        try {
            if (this.description == null) {
                Description description = null;
                DescriptionElement descriptionElement = null;
                if (this.wsdlURI != null && !"".equals(this.wsdlURI)) {
                    description = this.readInTheWSDLFile(this.wsdlURI);
                } else if (this.in != null) {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setNamespaceAware(true);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(this.in);
                    WSDLReader reader = DOMWSDLFactory.newInstance().newWSDLReader();
                    WSDLSource wsdlSource = reader.createWSDLSource();
                    wsdlSource.setSource((Object)document.getDocumentElement());
                    wsdlSource.setBaseURI(new URI(this.getBaseUri()));
                    description = reader.readWSDL(wsdlSource);
                    descriptionElement = description.toElement();
                } else {
                    throw new AxisFault("No resources found to read the wsdl");
                }
                this.savedTargetNamespace = descriptionElement.getTargetNamespace().toString();
                this.namespacemap = descriptionElement.getNamespaces();
                this.description = description;
            }
            this.stringBasedNamespaceMap = new NamespaceMap();
            Iterator iterator = this.namespacemap.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                this.stringBasedNamespaceMap.put(key, this.namespacemap.get(key).toString());
            }
            this.setupComplete = true;
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new AxisFault(e);
        }
    }

    private AxisBinding processBinding(Binding binding) throws AxisFault {
        AxisBinding axisBinding = new AxisBinding();
        axisBinding.setType(binding.getType().toString());
        axisBinding.setName(binding.getName());
        String bindingType = binding.getType().toString();
        if (bindingType.equals("http://www.w3.org/2006/01/wsdl/soap")) {
            this.processSOAPBindingExtention(binding, axisBinding);
        } else if (bindingType.equals("http://www.w3.org/2006/01/wsdl/http")) {
            this.processHTTPBindingExtention(binding, axisBinding);
        }
        this.processedBindings.put(binding.getName(), axisBinding);
        return axisBinding;
    }

    private void processSOAPBindingExtention(Binding binding, AxisBinding axisBinding) throws AxisFault {
        URI soapMepDefault;
        URI soapUnderlyingProtocol;
        TreeMap<String, AxisOperation> httpLocationTable = new TreeMap<String, AxisOperation>();
        SOAPBindingExtensionsImpl soapBindingExtensions = null;
        try {
            soapBindingExtensions = (SOAPBindingExtensionsImpl)binding.getComponentExtensionsForNamespace(new URI("http://www.w3.org/2006/01/wsdl/soap"));
        }
        catch (URISyntaxException e) {
            throw new AxisFault("Soap Binding Extention not found");
        }
        String soapVersion = soapBindingExtensions.getSoapVersion();
        if (soapVersion != null) {
            if (soapVersion.equals("1.1")) {
                this.axisService.setSoapNsUri("http://schemas.xmlsoap.org/soap/envelope/");
                axisBinding.setProperty("wsoap:version", "1.1");
            } else {
                this.axisService.setSoapNsUri("http://www.w3.org/2003/05/soap-envelope");
                axisBinding.setProperty("wsoap:version", "1.2");
            }
        }
        if ((soapUnderlyingProtocol = soapBindingExtensions.getSoapUnderlyingProtocol()) != null) {
            axisBinding.setProperty("wsoap:protocol", soapUnderlyingProtocol.toString());
        }
        if ((soapMepDefault = soapBindingExtensions.getSoapMepDefault()) != null) {
            axisBinding.setProperty("wsoap:mep", soapMepDefault.toString());
        }
        axisBinding.setProperty("whttp:contentEncoding", soapBindingExtensions.getHttpContentEncodingDefault());
        axisBinding.setProperty("wsoap:module", this.createSoapModules(soapBindingExtensions.getSoapModules()));
        axisBinding.setProperty("whttp:queryParameterSeparator", soapBindingExtensions.getHttpQueryParameterSeparatorDefault());
        BindingFault[] bindingFaults = binding.getBindingFaults();
        for (int i = 0; i < bindingFaults.length; ++i) {
            BindingFault bindingFault = bindingFaults[i];
            InterfaceFault interfaceFault = bindingFault.getInterfaceFault();
            AxisBindingMessage axisBindingFault = new AxisBindingMessage();
            axisBindingFault.setName(interfaceFault.getName().getLocalPart());
            axisBindingFault.setParent(axisBinding);
            SOAPBindingFaultExtensions soapBindingFaultExtensions = null;
            try {
                soapBindingFaultExtensions = (SOAPBindingFaultExtensions)bindingFault.getComponentExtensionsForNamespace(new URI("http://www.w3.org/2006/01/wsdl/soap"));
            }
            catch (URISyntaxException e) {
                throw new AxisFault("Soap Binding Extention not found");
            }
            axisBindingFault.setProperty("whttp:header", this.createHttpHeaders(soapBindingFaultExtensions.getHttpHeaders()));
            axisBindingFault.setProperty("whttp:contentEncoding", soapBindingFaultExtensions.getHttpContentEncoding());
            axisBindingFault.setProperty("wsoap:code", soapBindingFaultExtensions.getSoapFaultCode());
            axisBindingFault.setProperty("wsoap:subcodes", soapBindingFaultExtensions.getSoapFaultSubcodes());
            axisBindingFault.setProperty("wsoap:header", this.createSoapHeaders(soapBindingFaultExtensions.getSoapHeaders()));
            axisBindingFault.setProperty("wsoap:module", this.createSoapModules(soapBindingFaultExtensions.getSoapModules()));
            axisBinding.addFault(axisBindingFault);
        }
        BindingOperation[] bindingOperations = binding.getBindingOperations();
        for (int i = 0; i < bindingOperations.length; ++i) {
            BindingOperation bindingOperation = bindingOperations[i];
            AxisBindingOperation axisBindingOperation = new AxisBindingOperation();
            AxisOperation axisOperation = this.axisService.getOperation(bindingOperation.getInterfaceOperation().getName());
            axisBindingOperation.setAxisOperation(axisOperation);
            axisBindingOperation.setParent(axisBinding);
            axisBindingOperation.setName(axisOperation.getName());
            SOAPBindingOperationExtensions soapBindingOperationExtensions = null;
            try {
                soapBindingOperationExtensions = (SOAPBindingOperationExtensions)bindingOperation.getComponentExtensionsForNamespace(new URI("http://www.w3.org/2006/01/wsdl/soap"));
            }
            catch (URISyntaxException e) {
                throw new AxisFault("Soap Binding Extention not found");
            }
            URI soapAction = soapBindingOperationExtensions.getSoapAction();
            if (soapAction != null) {
                axisBindingOperation.setProperty("wsoap:action", soapAction.toString());
            }
            axisBindingOperation.setProperty("wsoap:module", this.createSoapModules(soapBindingOperationExtensions.getSoapModules()));
            URI soapMep = soapBindingOperationExtensions.getSoapMep();
            if (soapMep != null) {
                axisBindingOperation.setProperty("wsoap:mep", soapMep.toString());
            }
            HTTPLocation httpLocation = soapBindingOperationExtensions.getHttpLocation();
            String httpLocationString = "";
            if (httpLocation != null) {
                String httpLocationTemplete = httpLocation.getLocationTemplate();
                axisBindingOperation.setProperty("whttp:location", httpLocationTemplete);
                httpLocationString = RESTUtil.getConstantFromHTTPLocation(httpLocationTemplete);
            }
            httpLocationTable.put(httpLocationString, axisOperation);
            axisBindingOperation.setProperty("whttp:contentEncoding", soapBindingOperationExtensions.getHttpContentEncodingDefault());
            axisBindingOperation.setProperty("whttp:queryParameterSeparator", soapBindingOperationExtensions.getHttpQueryParameterSeparator());
            BindingMessageReference[] bindingMessageReferences = bindingOperation.getBindingMessageReferences();
            for (int j = 0; j < bindingMessageReferences.length; ++j) {
                BindingMessageReference bindingMessageReference = bindingMessageReferences[j];
                AxisBindingMessage axisBindingMessage = new AxisBindingMessage();
                axisBindingMessage.setParent(axisBindingOperation);
                AxisMessage axisMessage = axisOperation.getMessage(bindingMessageReference.getInterfaceMessageReference().getMessageLabel().toString());
                axisBindingMessage.setAxisMessage(axisMessage);
                axisBindingMessage.setName(axisMessage.getName());
                axisBindingMessage.setDirection(axisMessage.getDirection());
                SOAPBindingMessageReferenceExtensions soapBindingMessageReferenceExtensions = null;
                try {
                    soapBindingMessageReferenceExtensions = (SOAPBindingMessageReferenceExtensions)bindingMessageReference.getComponentExtensionsForNamespace(new URI("http://www.w3.org/2006/01/wsdl/soap"));
                }
                catch (URISyntaxException e) {
                    throw new AxisFault("Soap Binding Extention not found");
                }
                axisBindingMessage.setProperty("whttp:header", this.createHttpHeaders(soapBindingMessageReferenceExtensions.getHttpHeaders()));
                axisBindingMessage.setProperty("whttp:contentEncoding", soapBindingMessageReferenceExtensions.getHttpContentEncoding());
                axisBindingMessage.setProperty("wsoap:header", this.createSoapHeaders(soapBindingMessageReferenceExtensions.getSoapHeaders()));
                axisBindingMessage.setProperty("wsoap:module", this.createSoapModules(soapBindingMessageReferenceExtensions.getSoapModules()));
                axisBindingOperation.addChild(axisMessage.getDirection(), axisBindingMessage);
            }
            BindingFaultReference[] bindingFaultReferences = bindingOperation.getBindingFaultReferences();
            for (int j = 0; j < bindingFaultReferences.length; ++j) {
                BindingFaultReference bindingFaultReference = bindingFaultReferences[j];
                AxisBindingMessage axisBindingMessageFault = new AxisBindingMessage();
                axisBindingMessageFault.setParent(axisBindingOperation);
                axisBindingMessageFault.setName(bindingFaultReference.getInterfaceFaultReference().getInterfaceFault().getName().getLocalPart());
                SOAPBindingFaultReferenceExtensions soapBindingFaultReferenceExtensions = null;
                try {
                    soapBindingFaultReferenceExtensions = (SOAPBindingFaultReferenceExtensions)bindingFaultReference.getComponentExtensionsForNamespace(new URI("http://www.w3.org/2006/01/wsdl/soap"));
                }
                catch (URISyntaxException e) {
                    throw new AxisFault("Soap Binding Extention not found");
                }
                axisBindingMessageFault.setProperty("wsoap:module", this.createSoapModules(soapBindingFaultReferenceExtensions.getSoapModules()));
                axisBindingOperation.addFault(axisBindingMessageFault);
            }
            axisBinding.setProperty("HTTPLocationTable", httpLocationTable);
            axisBinding.addChild(axisBindingOperation.getName(), axisBindingOperation);
        }
    }

    private void processHTTPBindingExtention(Binding binding, AxisBinding axisBinding) throws AxisFault {
        TreeMap<String, AxisOperation> httpLocationTable = new TreeMap<String, AxisOperation>();
        HTTPBindingExtensionsImpl httpBindingExtensions = null;
        try {
            httpBindingExtensions = (HTTPBindingExtensionsImpl)binding.getComponentExtensionsForNamespace(new URI("http://www.w3.org/2006/01/wsdl/http"));
        }
        catch (URISyntaxException e) {
            throw new AxisFault("HTTP Binding Extention not found");
        }
        axisBinding.setProperty("whttp:method", httpBindingExtensions.getHttpMethodDefault());
        axisBinding.setProperty("whttp:queryParameterSeparator", httpBindingExtensions.getHttpQueryParameterSeparatorDefault());
        axisBinding.setProperty("whttp:contentEncoding", httpBindingExtensions.getHttpContentEncodingDefault());
        BindingFault[] bindingFaults = binding.getBindingFaults();
        for (int i = 0; i < bindingFaults.length; ++i) {
            BindingFault bindingFault = bindingFaults[i];
            InterfaceFault interfaceFault = bindingFault.getInterfaceFault();
            AxisBindingMessage axisBindingFault = new AxisBindingMessage();
            axisBindingFault.setName(interfaceFault.getName().getLocalPart());
            axisBindingFault.setParent(axisBinding);
            HTTPBindingFaultExtensions httpBindingFaultExtensions = null;
            try {
                httpBindingFaultExtensions = (HTTPBindingFaultExtensions)bindingFault.getComponentExtensionsForNamespace(new URI("http://www.w3.org/2006/01/wsdl/http"));
            }
            catch (URISyntaxException e) {
                throw new AxisFault("HTTP Binding Extention not found");
            }
            axisBindingFault.setProperty("whttp:code", httpBindingFaultExtensions.getHttpErrorStatusCode().getCode());
            axisBindingFault.setProperty("whttp:header", this.createHttpHeaders(httpBindingFaultExtensions.getHttpHeaders()));
            axisBindingFault.setProperty("whttp:contentEncoding", httpBindingFaultExtensions.getHttpContentEncoding());
            axisBinding.addFault(axisBindingFault);
        }
        BindingOperation[] bindingOperations = binding.getBindingOperations();
        for (int i = 0; i < bindingOperations.length; ++i) {
            BindingOperation bindingOperation = bindingOperations[i];
            AxisBindingOperation axisBindingOperation = new AxisBindingOperation();
            AxisOperation axisOperation = this.axisService.getOperation(bindingOperation.getInterfaceOperation().getName());
            axisBindingOperation.setAxisOperation(axisOperation);
            axisBindingOperation.setParent(axisBinding);
            axisBindingOperation.setName(axisOperation.getName());
            HTTPBindingOperationExtensions httpBindingOperationExtensions = null;
            try {
                httpBindingOperationExtensions = (HTTPBindingOperationExtensions)bindingOperation.getComponentExtensionsForNamespace(new URI("http://www.w3.org/2006/01/wsdl/http"));
            }
            catch (URISyntaxException e) {
                throw new AxisFault("HTTP Binding Extention not found");
            }
            axisBindingOperation.setProperty("whttp:faultSerialization", httpBindingOperationExtensions.getHttpFaultSerialization());
            axisBindingOperation.setProperty("whttp:inputSerialization", httpBindingOperationExtensions.getHttpInputSerialization());
            HTTPLocation httpLocation = httpBindingOperationExtensions.getHttpLocation();
            String httpLocationString = "";
            if (httpLocation != null) {
                String httpLocationTemplete = httpLocation.getLocationTemplate();
                axisBindingOperation.setProperty("whttp:location", httpLocationTemplete);
                httpLocationString = RESTUtil.getConstantFromHTTPLocation(httpLocationTemplete);
            }
            httpLocationTable.put(httpLocationString, axisOperation);
            axisBindingOperation.setProperty("whttp:ignoreUncited", httpBindingOperationExtensions.isHttpLocationIgnoreUncited());
            axisBindingOperation.setProperty("whttp:method", httpBindingOperationExtensions.getHttpMethod());
            axisBindingOperation.setProperty("whttp:outputSerialization", httpBindingOperationExtensions.getHttpOutputSerialization());
            axisBindingOperation.setProperty("whttp:queryParameterSeparator", httpBindingOperationExtensions.getHttpQueryParameterSeparator());
            axisBindingOperation.setProperty("whttp:contentEncoding", httpBindingOperationExtensions.getHttpContentEncodingDefault());
            BindingMessageReference[] bindingMessageReferences = bindingOperation.getBindingMessageReferences();
            for (int j = 0; j < bindingMessageReferences.length; ++j) {
                BindingMessageReference bindingMessageReference = bindingMessageReferences[j];
                AxisBindingMessage axisBindingMessage = new AxisBindingMessage();
                axisBindingMessage.setParent(axisBindingOperation);
                AxisMessage axisMessage = axisOperation.getMessage(bindingMessageReference.getInterfaceMessageReference().getMessageLabel().toString());
                axisBindingMessage.setAxisMessage(axisMessage);
                axisBindingMessage.setName(axisMessage.getName());
                axisBindingMessage.setDirection(axisMessage.getDirection());
                HTTPBindingMessageReferenceExtensions httpBindingMessageReferenceExtensions = null;
                try {
                    httpBindingMessageReferenceExtensions = (HTTPBindingMessageReferenceExtensions)bindingMessageReference.getComponentExtensionsForNamespace(new URI("http://www.w3.org/2006/01/wsdl/http"));
                }
                catch (URISyntaxException e) {
                    throw new AxisFault("HTTP Binding Extention not found");
                }
                axisBindingMessage.setProperty("whttp:header", this.createHttpHeaders(httpBindingMessageReferenceExtensions.getHttpHeaders()));
                axisBindingMessage.setProperty("whttp:contentEncoding", httpBindingMessageReferenceExtensions.getHttpContentEncoding());
                axisBindingOperation.addChild(axisMessage.getDirection(), axisBindingMessage);
            }
            BindingFaultReference[] bindingFaultReferences = bindingOperation.getBindingFaultReferences();
            for (int j = 0; j < bindingFaultReferences.length; ++j) {
                BindingFaultReference bindingFaultReference = bindingFaultReferences[j];
                AxisBindingMessage axisBindingMessageFault = axisBinding.getFault(bindingFaultReference.getInterfaceFaultReference().getInterfaceFault().getName().getLocalPart());
                axisBindingOperation.addFault(axisBindingMessageFault);
            }
            axisBinding.setProperty("HTTPLocationTable", httpLocationTable);
            axisBinding.addChild(axisBindingOperation.getName(), axisBindingOperation);
        }
    }

    private void processInterface(Interface serviceInterface) throws AxisFault {
        ArrayList<QName> operationNames = new ArrayList<QName>();
        InterfaceOperation[] interfaceOperations = serviceInterface.getInterfaceOperations();
        for (int i = 0; i < interfaceOperations.length; ++i) {
            this.axisService.addOperation(this.populateOperations(interfaceOperations[i]));
            operationNames.add(interfaceOperations[i].getName());
        }
        if (this.isCodegen) {
            this.axisService.setOperationsNameList(operationNames);
        }
        Interface[] extendedInterfaces = serviceInterface.getExtendedInterfaces();
        for (int i = 0; i < extendedInterfaces.length; ++i) {
            Interface extendedInterface = extendedInterfaces[i];
            this.processInterface(extendedInterface);
        }
    }

    private AxisOperation populateOperations(InterfaceOperation operation) throws AxisFault {
        InterfaceOperationExtensionsImpl interfaceOperationExtensions;
        QName opName = operation.getName();
        AxisOperation axisOperation = this.axisService.getOperation(opName);
        if (axisOperation == null) {
            String MEP2 = operation.getMessageExchangePattern().toString();
            axisOperation = AxisOperationFactory.getOperationDescription(MEP2);
            axisOperation.setName(opName);
        }
        axisOperation.setMessageExchangePattern(operation.getMessageExchangePattern().toString());
        try {
            interfaceOperationExtensions = (InterfaceOperationExtensionsImpl)operation.getComponentExtensionsForNamespace(new URI("http://www.w3.org/2006/01/wsdl-extensions"));
        }
        catch (URISyntaxException e) {
            throw new AxisFault("WSDL2 extensions not defined for this operation");
        }
        if (interfaceOperationExtensions != null) {
            Parameter parameter = new Parameter("wsdlx:safe", new Boolean(interfaceOperationExtensions.isSafety()));
            axisOperation.addParameter(parameter);
        }
        InterfaceMessageReference[] interfaceMessageReferences = operation.getInterfaceMessageReferences();
        for (int i = 0; i < interfaceMessageReferences.length; ++i) {
            InterfaceMessageReference messageReference = interfaceMessageReferences[i];
            if (messageReference.getMessageLabel().equals((Object)MessageLabel.IN)) {
                if (this.isServerSide) {
                    this.createAxisMessage(axisOperation, messageReference, "In");
                    continue;
                }
                this.createAxisMessage(axisOperation, messageReference, "Out");
                continue;
            }
            if (!messageReference.getMessageLabel().equals((Object)MessageLabel.OUT)) continue;
            if (this.isServerSide) {
                this.createAxisMessage(axisOperation, messageReference, "Out");
                continue;
            }
            this.createAxisMessage(axisOperation, messageReference, "In");
        }
        InterfaceFaultReference[] faults = operation.getInterfaceFaultReferences();
        for (int i = 0; i < faults.length; ++i) {
            AxisMessage faultMessage = new AxisMessage();
            InterfaceFaultReference interfaceFaultReference = faults[i];
            faultMessage.setDirection(interfaceFaultReference.getDirection().toString());
            InterfaceFault interfaceFault = interfaceFaultReference.getInterfaceFault();
            faultMessage.setElementQName(interfaceFault.getElementDeclaration().getName());
            faultMessage.setName(interfaceFault.getName().getLocalPart());
            axisOperation.setFaultMessages(faultMessage);
        }
        return axisOperation;
    }

    private void createAxisMessage(AxisOperation axisOperation, InterfaceMessageReference messageReference, String messageLabel) throws AxisFault {
        AxisMessage message = axisOperation.getMessage(messageLabel);
        String messageContentModelName = messageReference.getMessageContentModel();
        QName elementQName = null;
        if ("#element".equals(messageContentModelName)) {
            elementQName = messageReference.getElementDeclaration().getName();
        } else if ("#any".equals(messageContentModelName)) {
            elementQName = Constants.XSD_ANY;
        } else if (!"#none".equals(messageContentModelName)) {
            throw new AxisFault("Sorry we do not support " + messageContentModelName + ". We do only support #any, #none and #element as message content models.");
        }
        message.setElementQName(elementQName);
        message.setName(elementQName != null ? elementQName.getLocalPart() : null);
        axisOperation.addMessage(message, messageLabel);
        if (elementQName != null) {
            this.axisService.addMessageElementQNameToOperationMapping(elementQName, axisOperation);
        }
    }

    private Description readInTheWSDLFile(String wsdlURI) throws WSDLException {
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        return reader.readWSDL(wsdlURI);
    }

    private ArrayList createSoapHeaders(SOAPHeaderBlock[] soapHeaderBlocks) {
        if (soapHeaderBlocks.length == 0) {
            return null;
        }
        ArrayList<SOAPHeaderMessage> soapHeaderMessages = new ArrayList<SOAPHeaderMessage>();
        for (int i = 0; i < soapHeaderBlocks.length; ++i) {
            SOAPHeaderBlock soapHeaderBlock = soapHeaderBlocks[i];
            ElementDeclaration elementDeclaration = soapHeaderBlock.getElementDeclaration();
            if (elementDeclaration == null) continue;
            QName name = elementDeclaration.getName();
            SOAPHeaderMessage soapHeaderMessage = new SOAPHeaderMessage();
            soapHeaderMessage.setElement(name);
            soapHeaderMessage.setRequired(soapHeaderBlock.isRequired());
            soapHeaderMessage.setMustUnderstand(soapHeaderBlock.mustUnderstand());
            soapHeaderMessages.add(soapHeaderMessage);
        }
        return soapHeaderMessages;
    }

    private ArrayList createSoapModules(SOAPModule[] soapModules) {
        if (soapModules.length == 0) {
            return null;
        }
        ArrayList<SOAPModuleMessage> soapModuleMessages = new ArrayList<SOAPModuleMessage>();
        for (int i = 0; i < soapModules.length; ++i) {
            SOAPModule soapModule = soapModules[i];
            SOAPModuleMessage soapModuleMessage = new SOAPModuleMessage();
            soapModuleMessage.setUri(soapModule.getRef().toString());
            soapModuleMessages.add(soapModuleMessage);
        }
        return soapModuleMessages;
    }

    private ArrayList createHttpHeaders(HTTPHeader[] httpHeaders) {
        if (httpHeaders.length == 0) {
            return null;
        }
        ArrayList<HTTPHeaderMessage> httpHeaderMessages = new ArrayList<HTTPHeaderMessage>();
        for (int i = 0; i < httpHeaders.length; ++i) {
            HTTPHeaderImpl httpHeader = (HTTPHeaderImpl)httpHeaders[i];
            HTTPHeaderMessage httpHeaderMessage = new HTTPHeaderMessage();
            httpHeaderMessage.setqName(httpHeader.getTypeName());
            httpHeaderMessage.setName(httpHeader.getName());
            httpHeaderMessage.setRequired(httpHeader.isRequired());
            httpHeaderMessages.add(httpHeaderMessage);
        }
        return httpHeaderMessages;
    }
}

