/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import com.ibm.wsdl.util.xml.DOM2Writer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Header;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.wsdl.WSDL11ActionHelper;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.description.WSDLToAxisServiceBuilder;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.util.XMLUtils;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.axis2.wsdl.SoapAddress;
import org.apache.axis2.wsdl.WSDLConstants;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.axis2.wsdl.util.WSDL4JImportedWSDLHelper;
import org.apache.axis2.wsdl.util.WSDLDefinitionWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyReference;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WSDL11ToAxisServiceBuilder
extends WSDLToAxisServiceBuilder {
    protected static final Log log = LogFactory.getLog(WSDL11ToAxisServiceBuilder.class);
    private static final boolean isTraceEnabled = log.isTraceEnabled();
    protected String portName;
    private static final String BINDING = "Binding";
    private static final String SERVICE = "Service";
    private static final String PORT = "Port";
    private static final String PORT_TYPE = "PortType";
    private static final String PORT_TYPE_OPERATION = "PortType.Operation";
    private static final String PORT_TYPE_OPERATION_INPUT = "PortType.Operation.Input";
    private static final String PORT_TYPE_OPERATION_OUTPUT = "PortType.Operation.Output";
    private static final String PORT_TYPE_OPERATION_FAULT = "PortType.Operation.Fault";
    private static final String BINDING_OPERATION = "Binding.Operation";
    private static final String BINDING_OPERATION_INPUT = "Binding.Operation.Input";
    private static final String BINDING_OPERATION_OUTPUT = "Binding.Operation.Output";
    protected Definition wsdl4jDefinition = null;
    private WSDLLocator customWSDLResolver;
    public static final String RPC_STYLE = "rpc";
    public static final String DOCUMENT_STYLE = "document";
    public static final String ENCODED_USE = "encoded";
    private List wrappableOperations = new ArrayList();
    public static final String WRAPPED_OUTPUTNAME_SUFFIX = "Response";
    public static final String XML_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    public static final String NAMESPACE_DECLARATION_PREFIX = "xmlns:";
    private static int prefixCounter = 0;
    public static final String NAMESPACE_URI = "namespace";
    public static final String TRAGET_NAMESPACE = "targetNamespace";
    private boolean setupComplete = false;
    private Map schemaMap = null;
    private static final String JAVAX_WSDL_VERBOSE_MODE_KEY = "javax.wsdl.verbose";

    public WSDL11ToAxisServiceBuilder(InputStream in, QName serviceName, String portName) {
        super(in, serviceName);
        this.portName = portName;
    }

    public WSDL11ToAxisServiceBuilder(Definition def, QName serviceName, String portName) {
        super(null, serviceName);
        this.wsdl4jDefinition = def;
        this.portName = portName;
    }

    public WSDL11ToAxisServiceBuilder(InputStream in, AxisService service) {
        super(in, service);
    }

    public WSDL11ToAxisServiceBuilder(InputStream in) {
        this(in, null, null);
    }

    public void setCustomWSLD4JResolver(WSDLLocator customResolver) {
        this.setCustomWSDLResolver(customResolver);
    }

    public void setCustomWSDLResolver(WSDLLocator customResolver) {
        this.customWSDLResolver = customResolver;
        this.setDocumentBaseUri(this.customWSDLResolver.getBaseURI());
    }

    public void setDocumentBaseUri(String baseUri) {
        if (this.wsdl4jDefinition != null) {
            this.wsdl4jDefinition.setDocumentBaseURI(baseUri);
        }
    }

    public AxisService populateService() throws AxisFault {
        try {
            Element documentationElement;
            this.setup();
            if (this.wsdl4jDefinition == null) {
                return null;
            }
            this.axisService.setTargetNamespace(this.wsdl4jDefinition.getTargetNamespace());
            this.axisService.setNameSpacesMap(new NamespaceMap(this.wsdl4jDefinition.getNamespaces()));
            Service wsdl4jService = this.findService(this.wsdl4jDefinition);
            Binding binding = this.findBinding(this.wsdl4jDefinition, wsdl4jService);
            if (binding.getPortType() == null) {
                throw new AxisFault("There is no port type associated with the binding");
            }
            Element[] schemaElements = this.generateWrapperSchema(this.schemaMap, binding);
            Types wsdl4jTypes = this.wsdl4jDefinition.getTypes();
            if (null != wsdl4jTypes) {
                this.copyExtensibleElements(wsdl4jTypes.getExtensibilityElements(), this.wsdl4jDefinition, this.axisService, "Types");
            }
            if (schemaElements != null && schemaElements.length > 0) {
                for (int i = 0; i < schemaElements.length; ++i) {
                    Element schemaElement = schemaElements[i];
                    if (schemaElement == null) continue;
                    this.axisService.addSchema(this.getXMLSchema(schemaElement, null));
                }
            }
            if ((documentationElement = this.wsdl4jDefinition.getDocumentationElement()) != null && documentationElement.getFirstChild() != null) {
                Node firstChild = documentationElement.getFirstChild();
                String serviceDes = firstChild.getNodeType() == 3 ? firstChild.getNodeValue() : DOM2Writer.nodeToString(firstChild);
                this.axisService.setServiceDescription(serviceDes);
            }
            this.axisService.setName(wsdl4jService.getQName().getLocalPart());
            this.populateEndpoints(binding, wsdl4jService);
            Parameter wsdlDefinitionParameter = new Parameter();
            wsdlDefinitionParameter.setName("wsdl4jDefinition");
            if (!(this.wsdl4jDefinition instanceof WSDLDefinitionWrapper)) {
                WSDLDefinitionWrapper wrapper = new WSDLDefinitionWrapper(this.wsdl4jDefinition);
                wsdlDefinitionParameter.setValue(wrapper);
            } else {
                wsdlDefinitionParameter.setValue(this.wsdl4jDefinition);
            }
            this.axisService.addParameter(wsdlDefinitionParameter);
            this.axisService.setWsdlFound(true);
            this.axisService.setCustomWsld(true);
            return this.axisService;
        }
        catch (WSDLException e) {
            log.error(e);
            throw new AxisFault(e);
        }
        catch (Exception e) {
            log.error(e);
            throw new AxisFault(e);
        }
    }

    private void populateEndpoints(Binding binding, Service wsdl4jService) throws AxisFault {
        Map wsdl4jPorts = wsdl4jService.getPorts();
        QName bindingName = binding.getQName();
        AxisEndpoint axisEndpoint = null;
        this.populatePortType(this.wsdl4jDefinition.getPortType(binding.getPortType().getQName()));
        Iterator iterator = wsdl4jPorts.values().iterator();
        while (iterator.hasNext()) {
            Port port = (Port)iterator.next();
            Binding currentBinding = this.wsdl4jDefinition.getBinding(port.getBinding().getQName());
            if (!currentBinding.getPortType().getQName().equals(binding.getPortType().getQName())) continue;
            axisEndpoint = new AxisEndpoint();
            axisEndpoint.setName(port.getName());
            if (this.axisService.getEndpointName() == null && bindingName.equals(port.getBinding().getQName())) {
                this.populateEndpoint(axisEndpoint, port, true);
                this.axisService.setEndpointName(axisEndpoint.getName());
                this.axisService.setBindingName(axisEndpoint.getBinding().getName().getLocalPart());
                SoapAddress soapAddress = (SoapAddress)axisEndpoint.getProperty("wsoap:address");
                if (soapAddress != null) {
                    this.axisService.setEndpointURL(soapAddress.getLocation());
                }
            } else {
                this.populateEndpoint(axisEndpoint, port, false);
            }
            this.axisService.addEndpoint(port.getName(), axisEndpoint);
        }
    }

    private void populateEndpoint(AxisEndpoint axisEndpoint, Port wsdl4jPort, boolean isSetMessageQNames) throws AxisFault {
        this.copyExtensibleElements(wsdl4jPort.getExtensibilityElements(), this.wsdl4jDefinition, axisEndpoint, BINDING);
        AxisBinding axisBinding = new AxisBinding();
        Binding wsdl4jBinding = this.wsdl4jDefinition.getBinding(wsdl4jPort.getBinding().getQName());
        axisBinding.setName(wsdl4jBinding.getQName());
        axisEndpoint.setBinding(axisBinding);
        this.populateBinding(axisBinding, wsdl4jBinding, isSetMessageQNames);
    }

    private void populatePortType(PortType wsdl4jPortType) throws AxisFault {
        List wsdl4jOperations = wsdl4jPortType.getOperations();
        if (wsdl4jOperations.size() < 1) {
            throw new AxisFault("No operation found in the portType element");
        }
        ArrayList<QName> operationNames = new ArrayList<QName>();
        Iterator iterator = wsdl4jOperations.iterator();
        while (iterator.hasNext()) {
            Operation wsdl4jOperation = (Operation)iterator.next();
            AxisOperation axisOperation = this.populateOperations(wsdl4jOperation, wsdl4jPortType, this.wsdl4jDefinition);
            axisOperation.setParent(this.axisService);
            this.axisService.addChild(axisOperation);
            operationNames.add(axisOperation.getName());
        }
        if (this.isCodegen) {
            this.axisService.setOperationsNameList(operationNames);
        }
    }

    private void populateBinding(AxisBinding axisBinding, Binding wsdl4jBinding, boolean isSetMessageQNames) throws AxisFault {
        this.copyExtensibleElements(wsdl4jBinding.getExtensibilityElements(), this.wsdl4jDefinition, axisBinding, BINDING);
        List wsdl4jBidingOperations = wsdl4jBinding.getBindingOperations();
        if (wsdl4jBidingOperations.size() < 1) {
            throw new AxisFault("No operation found for the binding");
        }
        PortType portType = this.wsdl4jDefinition.getPortType(wsdl4jBinding.getPortType().getQName());
        Iterator iterator = wsdl4jBidingOperations.iterator();
        while (iterator.hasNext()) {
            BindingOutput wsdl4jBindingOutput;
            AxisBindingOperation axisBindingOperation = new AxisBindingOperation();
            BindingOperation wsdl4jBindingOperation = (BindingOperation)iterator.next();
            Operation wsdl4jOperation = this.findOperation(portType, wsdl4jBindingOperation);
            axisBindingOperation.setName(new QName("", wsdl4jBindingOperation.getName()));
            AxisOperation axisOperation = this.axisService.getOperation(new QName("", wsdl4jOperation.getName()));
            axisBindingOperation.setAxisOperation(axisOperation);
            this.copyExtensibleElements(wsdl4jBindingOperation.getExtensibilityElements(), this.wsdl4jDefinition, axisBindingOperation, BINDING_OPERATION);
            BindingInput wsdl4jBindingInput = wsdl4jBindingOperation.getBindingInput();
            if (wsdl4jBindingInput != null && WSDLUtil.isInputPresentForMEP(axisOperation.getMessageExchangePattern())) {
                AxisBindingMessage axisBindingInMessage = new AxisBindingMessage();
                this.copyExtensibleElements(wsdl4jBindingInput.getExtensibilityElements(), this.wsdl4jDefinition, axisBindingInMessage, BINDING_OPERATION_INPUT);
                AxisMessage axisInMessage = axisOperation.getMessage("In");
                if (isSetMessageQNames) {
                    this.addQNameReference(axisInMessage, wsdl4jBindingOperation.getOperation(), wsdl4jBindingInput, this.wrappableOperations.contains(wsdl4jBindingOperation));
                }
                axisBindingInMessage.setAxisMessage(axisInMessage);
                axisBindingInMessage.setDirection(axisInMessage.getDirection());
                axisBindingOperation.addChild(axisBindingInMessage.getDirection(), axisBindingInMessage);
            }
            if ((wsdl4jBindingOutput = wsdl4jBindingOperation.getBindingOutput()) != null && WSDLUtil.isOutputPresentForMEP(axisOperation.getMessageExchangePattern())) {
                AxisBindingMessage axisBindingOutMessage = new AxisBindingMessage();
                AxisMessage axisOutMessage = axisOperation.getMessage("Out");
                this.copyExtensibleElements(wsdl4jBindingOutput.getExtensibilityElements(), this.wsdl4jDefinition, axisBindingOutMessage, BINDING_OPERATION_OUTPUT);
                if (isSetMessageQNames) {
                    this.addQNameReference(axisOutMessage, wsdl4jBindingOperation.getOperation(), wsdl4jBindingOutput, this.wrappableOperations.contains(wsdl4jBindingOperation));
                }
                axisBindingOutMessage.setAxisMessage(axisOutMessage);
                axisBindingOutMessage.setDirection(axisOutMessage.getDirection());
                axisBindingOperation.addChild(axisBindingOutMessage.getDirection(), axisBindingOutMessage);
            }
            Map bindingFaultsMap = wsdl4jBindingOperation.getBindingFaults();
            Iterator bindingFaults = bindingFaultsMap.values().iterator();
            while (bindingFaults.hasNext()) {
                BindingFault bindingFault = (BindingFault)bindingFaults.next();
                Fault wsdl4jFault = wsdl4jOperation.getFault(bindingFault.getName());
                Message wsdl4jFaultMessge = wsdl4jFault.getMessage();
                AxisMessage faultMessage = this.findFaultMessage(wsdl4jFaultMessge.getQName().getLocalPart(), axisOperation.getFaultMessages());
                AxisBindingMessage axisBindingFaultMessage = new AxisBindingMessage();
                axisBindingFaultMessage.setAxisMessage(faultMessage);
                axisBindingFaultMessage.setParent(axisBindingOperation);
                axisBindingOperation.addFault(axisBindingFaultMessage);
                if (!isSetMessageQNames) continue;
                this.addQNameReference(faultMessage, wsdl4jFault.getMessage());
            }
            axisBinding.addChild(axisBindingOperation.getName(), axisBindingOperation);
        }
    }

    protected void setup() throws WSDLException {
        if (this.setupComplete) {
            return;
        }
        if (this.wsdl4jDefinition == null) {
            this.wsdl4jDefinition = this.readInTheWSDLFile(this.in);
        }
        if (this.wsdl4jDefinition == null) {
            return;
        }
        WSDL4JImportedWSDLHelper.processImports(this.wsdl4jDefinition);
        this.processPoliciesInDefintion(this.wsdl4jDefinition);
        this.schemaMap = this.getSchemaMap(this.wsdl4jDefinition.getTypes());
        this.setupComplete = true;
    }

    private Map getSchemaMap(Types wsdl4jTypes) {
        HashMap<String, Element> schemaMap = new HashMap<String, Element>();
        if (wsdl4jTypes != null) {
            Iterator iterator = wsdl4jTypes.getExtensibilityElements().iterator();
            while (iterator.hasNext()) {
                Object extensibilityElement = iterator.next();
                if (!(extensibilityElement instanceof Schema)) continue;
                Element schemaElement = ((Schema)extensibilityElement).getElement();
                schemaMap.put(schemaElement.getAttribute(TRAGET_NAMESPACE), schemaElement);
            }
        }
        return schemaMap;
    }

    private Service findService(Definition definition) throws AxisFault {
        Map services = definition.getServices();
        Service service = null;
        if (this.serviceName != null) {
            service = (Service)services.get(this.serviceName);
            if (service == null) {
                throw new AxisFault("Service " + this.serviceName + " was not found in the WSDL");
            }
        } else if (services.size() > 0) {
            Iterator iter = services.values().iterator();
            while (iter.hasNext() && (service = (Service)iter.next()).getPorts().size() <= 0) {
            }
            if (service == null || service.getPorts().size() == 0) {
                throw new AxisFault("there is no service with ports to pick");
            }
        } else {
            throw new AxisFault("No service was not found in the WSDL");
        }
        return service;
    }

    private Binding findBinding(Definition dif, Service service) throws AxisFault {
        Binding binding = null;
        Port port = null;
        this.copyExtensibleElements(service.getExtensibilityElements(), dif, this.axisService, SERVICE);
        if (this.portName != null) {
            port = service.getPort(this.portName);
            if (port == null) {
                throw new AxisFault("No port found for the given name :" + this.portName);
            }
        } else {
            Map ports = service.getPorts();
            if (ports != null && ports.size() > 0 && (port = this.findSOAPPort(ports)) == null) {
                log.info("A SOAP port was not found - picking a random port!");
                port = (Port)ports.values().toArray()[0];
            }
        }
        this.axisService.setName(service.getQName().getLocalPart());
        if (port != null) {
            this.copyExtensibleElements(port.getExtensibilityElements(), dif, this.axisService, PORT);
            binding = dif.getBinding(port.getBinding().getQName());
            if (binding == null) {
                binding = port.getBinding();
            }
        }
        return binding;
    }

    private Port findSOAPPort(Map ports) {
        Iterator portsIterator = ports.values().iterator();
        while (portsIterator.hasNext()) {
            Port port = (Port)portsIterator.next();
            List extensibilityElements = port.getExtensibilityElements();
            for (int i = 0; i < extensibilityElements.size(); ++i) {
                Object extElement = extensibilityElements.get(i);
                if (extElement instanceof SOAPAddress) {
                    return port;
                }
                if (!(extElement instanceof SOAP12Address)) continue;
                return port;
            }
        }
        return null;
    }

    private Operation findOperation(PortType portType, BindingOperation wsdl4jBindingOperation) {
        Operation op2;
        Operation op = wsdl4jBindingOperation.getOperation();
        String input = null;
        if (op != null && op.getInput() != null && ":none".equals(input = op.getInput().getName())) {
            input = null;
        }
        String output = null;
        if (op != null && op.getOutput() != null && ":none".equals(output = op.getOutput().getName())) {
            output = null;
        }
        return (op2 = portType.getOperation(op.getName(), input, output)) == null ? op : op2;
    }

    private AxisMessage findFaultMessage(String name, ArrayList faultMessages) {
        for (int i = 0; i < faultMessages.size(); ++i) {
            AxisMessage tempMessage = (AxisMessage)faultMessages.get(i);
            if (!name.equals(tempMessage.getName())) continue;
            return tempMessage;
        }
        return null;
    }

    private void addQNameReference(AxisMessage inMessage, Operation wsdl4jOperation, BindingInput bindingInput, boolean isWrapped) {
        List extensibilityElements = bindingInput.getExtensibilityElements();
        Message wsdl4jMessage = wsdl4jOperation.getInput().getMessage();
        this.addQNameReference(inMessage, wsdl4jOperation, isWrapped, extensibilityElements, wsdl4jMessage, wsdl4jOperation.getName());
    }

    private void addQNameReference(AxisMessage outMessage, Operation wsdl4jOperation, BindingOutput bindingOutput, boolean isWrapped) {
        if (bindingOutput != null) {
            List extensibilityElements = bindingOutput.getExtensibilityElements();
            if (wsdl4jOperation.getOutput() == null) {
                return;
            }
            Message wsdl4jMessage = wsdl4jOperation.getOutput().getMessage();
            this.addQNameReference(outMessage, wsdl4jOperation, isWrapped, extensibilityElements, wsdl4jMessage, wsdl4jOperation.getName() + WRAPPED_OUTPUTNAME_SUFFIX);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addQNameReference(AxisMessage message, Operation wsdl4jOperation, boolean isWrapped, List extensibilityElements, Message wsdl4jMessage, String rpcOperationName) {
        if (isWrapped) {
            message.setElementQName((QName)this.resolvedRpcWrappedElementMap.get(rpcOperationName));
            return;
        } else {
            List bindingPartsList = this.getPartsListFromSoapBody(extensibilityElements);
            if (bindingPartsList == null) {
                if (wsdl4jMessage.getParts() != null && wsdl4jMessage.getParts().size() > 0) {
                    if (wsdl4jMessage.getParts().size() != 1) throw new WSDLProcessingException("More than one part for message " + wsdl4jMessage.getQName().getLocalPart());
                    Part part = (Part)wsdl4jMessage.getParts().values().iterator().next();
                    QName elementName = part.getElementName();
                    if (elementName == null) throw new WSDLProcessingException("No element type is defined for message " + wsdl4jMessage.getQName().getLocalPart());
                    message.setElementQName(elementName);
                    ((AxisService)message.getParent().getParent()).addMessageElementQNameToOperationMapping(elementName, (AxisOperation)message.getParent());
                    return;
                } else {
                    message.setElementQName(null);
                }
                return;
            } else if (bindingPartsList.size() == 0) {
                message.setElementQName(null);
                return;
            } else {
                if (bindingPartsList.size() != 1) throw new WSDLProcessingException("More than one element part is not allwed in document literal  type binding operation " + wsdl4jOperation.getName());
                Part part = wsdl4jMessage.getPart((String)bindingPartsList.get(0));
                if (part == null) throw new WSDLProcessingException("Missing part named " + bindingPartsList.get(0) + " ");
                QName elementName = part.getElementName();
                if (elementName == null) throw new WSDLProcessingException("No element type is defined for message" + wsdl4jMessage.getQName().getLocalPart());
                message.setElementQName(elementName);
                ((AxisService)message.getParent().getParent()).addMessageElementQNameToOperationMapping(elementName, (AxisOperation)message.getParent());
            }
        }
    }

    private void addQNameReference(AxisMessage faultMessage, Message wsdl4jMessage) throws AxisFault {
        Part wsdl4jMessagePart = (Part)wsdl4jMessage.getParts().values().toArray()[0];
        if (wsdl4jMessagePart == null) {
            throw new WSDLProcessingException();
        }
        QName name = wsdl4jMessagePart.getElementName();
        if (name == null) {
            String message = "Part '" + wsdl4jMessagePart.getName() + "' of fault message '" + wsdl4jMessage.getQName() + "' must be defined with 'element=QName' and not 'type=QName'";
            log.error(message);
            throw new AxisFault(message);
        }
        faultMessage.setElementQName(name);
    }

    private String getSOAPStyle(BindingOperation bindingOp) {
        List extensibilityElements = bindingOp.getExtensibilityElements();
        for (int i = 0; i < extensibilityElements.size(); ++i) {
            Object extElement = extensibilityElements.get(i);
            if (extElement instanceof SOAPOperation) {
                return ((SOAPOperation)extElement).getStyle();
            }
            if (!(extElement instanceof SOAP12Operation)) continue;
            return ((SOAP12Operation)extElement).getStyle();
        }
        return null;
    }

    private void processPortType(PortType wsdl4jPortType, Definition dif) throws Exception {
        this.copyExtensionAttributes(wsdl4jPortType.getExtensionAttributes(), this.axisService, PORT_TYPE);
        this.axisService.setEndpointName(wsdl4jPortType.getQName().getLocalPart());
        Iterator wsdl4JOperationsIterator = wsdl4jPortType.getOperations().iterator();
        while (wsdl4JOperationsIterator.hasNext()) {
            Operation wsdl4jOperation = (Operation)wsdl4JOperationsIterator.next();
            this.axisService.addOperation(this.populateOperations(wsdl4jOperation, wsdl4jPortType, dif));
        }
    }

    private AxisOperation populateOperations(Operation wsdl4jOperation, PortType wsdl4jPortType, Definition dif) throws AxisFault {
        Message message;
        AxisMessage outMessage;
        Output wsdl4jOutputMessage;
        Message message2;
        AxisMessage inMessage;
        QName opName = new QName(wsdl4jOperation.getName());
        AxisOperation axisOperation = this.axisService.getOperation(opName);
        if (axisOperation == null) {
            String MEP2 = this.getMEP(wsdl4jOperation);
            axisOperation = AxisOperationFactory.getOperationDescription(MEP2);
            axisOperation.setName(opName);
            PolicyInclude policyInclude = new PolicyInclude(axisOperation);
            axisOperation.setPolicyInclude(policyInclude);
        }
        this.copyExtensibleElements(wsdl4jOperation.getExtensibilityElements(), dif, axisOperation, PORT_TYPE_OPERATION);
        Input wsdl4jInputMessage = wsdl4jOperation.getInput();
        if (this.isServerSide) {
            String action;
            if (null != wsdl4jInputMessage) {
                inMessage = axisOperation.getMessage("In");
                message2 = wsdl4jInputMessage.getMessage();
                if (null != message2) {
                    inMessage.setName(message2.getQName().getLocalPart());
                    this.copyExtensibleElements(message2.getExtensibilityElements(), dif, inMessage, PORT_TYPE_OPERATION_INPUT);
                }
                ArrayList<String> inputActions = axisOperation.getWsamappingList();
                action = null;
                if (inputActions == null || inputActions.size() == 0) {
                    action = WSDL11ActionHelper.getActionFromInputElement(dif, wsdl4jPortType, wsdl4jOperation, wsdl4jInputMessage);
                }
                if (action != null) {
                    if (inputActions == null) {
                        inputActions = new ArrayList<String>();
                        axisOperation.setWsamappingList(inputActions);
                    }
                    inputActions.add(action);
                    this.axisService.mapActionToOperation(action, axisOperation);
                }
            }
            if (null != (wsdl4jOutputMessage = wsdl4jOperation.getOutput())) {
                outMessage = axisOperation.getMessage("Out");
                message = wsdl4jOutputMessage.getMessage();
                if (null != message) {
                    outMessage.setName(message.getQName().getLocalPart());
                    this.copyExtensibleElements(message.getExtensibilityElements(), dif, outMessage, PORT_TYPE_OPERATION_OUTPUT);
                }
                if ((action = axisOperation.getOutputAction()) == null) {
                    action = WSDL11ActionHelper.getActionFromOutputElement(dif, wsdl4jPortType, wsdl4jOperation, wsdl4jOutputMessage);
                }
                if (action != null) {
                    axisOperation.setOutputAction(action);
                }
            }
        } else {
            if (null != wsdl4jInputMessage) {
                String action;
                inMessage = axisOperation.getMessage("Out");
                message2 = wsdl4jInputMessage.getMessage();
                if (null != message2) {
                    inMessage.setName(message2.getQName().getLocalPart());
                    this.copyExtensibleElements(message2.getExtensibilityElements(), dif, inMessage, PORT_TYPE_OPERATION_OUTPUT);
                }
                if ((action = axisOperation.getOutputAction()) == null) {
                    action = WSDL11ActionHelper.getActionFromInputElement(dif, wsdl4jPortType, wsdl4jOperation, wsdl4jInputMessage);
                }
                if (action != null) {
                    axisOperation.setOutputAction(action);
                }
            }
            if (null != (wsdl4jOutputMessage = wsdl4jOperation.getOutput())) {
                outMessage = axisOperation.getMessage("In");
                message = wsdl4jOutputMessage.getMessage();
                if (null != message) {
                    outMessage.setName(message.getQName().getLocalPart());
                    this.copyExtensibleElements(message.getExtensibilityElements(), dif, outMessage, PORT_TYPE_OPERATION_INPUT);
                }
                ArrayList<String> inputActions = axisOperation.getWsamappingList();
                String action = null;
                if (inputActions == null || inputActions.size() == 0) {
                    action = WSDL11ActionHelper.getActionFromOutputElement(dif, wsdl4jPortType, wsdl4jOperation, wsdl4jOutputMessage);
                }
                if (action != null) {
                    if (inputActions == null) {
                        inputActions = new ArrayList<String>();
                        axisOperation.setWsamappingList(inputActions);
                    }
                    inputActions.add(action);
                }
            }
        }
        Map faults = wsdl4jOperation.getFaults();
        Iterator faultKeyIterator = faults.keySet().iterator();
        while (faultKeyIterator.hasNext()) {
            String action;
            Fault fault = (Fault)faults.get(faultKeyIterator.next());
            AxisMessage axisFaultMessage = new AxisMessage();
            Message faultMessage = fault.getMessage();
            if (null != faultMessage) {
                axisFaultMessage.setName(faultMessage.getQName().getLocalPart());
                this.copyExtensibleElements(faultMessage.getExtensibilityElements(), dif, axisFaultMessage, PORT_TYPE_OPERATION_FAULT);
            }
            if ((action = axisOperation.getFaultAction(fault.getName())) == null) {
                action = WSDL11ActionHelper.getActionFromFaultElement(dif, wsdl4jPortType, wsdl4jOperation, fault);
            }
            if (action != null) {
                axisOperation.addFaultAction(fault.getName(), action);
            }
            axisOperation.setFaultMessages(axisFaultMessage);
        }
        return axisOperation;
    }

    private Element[] generateWrapperSchema(Map schemaMap, Binding wsdl4jBinding) {
        ArrayList schemaElementList = new ArrayList();
        String porttypeNamespaceURI = wsdl4jBinding.getPortType().getQName().getNamespaceURI();
        List wrappableBindingOperationsList = this.findWrappableBindingOperations(wsdl4jBinding);
        Map newSchemaMap = this.createSchemaForPorttype(porttypeNamespaceURI, wrappableBindingOperationsList, schemaMap);
        schemaElementList.addAll(newSchemaMap.values());
        return schemaElementList.toArray(new Element[schemaElementList.size()]);
    }

    private Map createSchemaForPorttype(String namespaceURI, List operationListToProcess, Map existingSchemaMap) {
        Element elementDeclaration;
        BindingOperation operation;
        HashMap<String, Element> newSchemaMap = new HashMap<String, Element>();
        if (operationListToProcess.isEmpty()) {
            return newSchemaMap;
        }
        HashMap<QName, Message> messageQnameToMessageMap = new HashMap<QName, Message>();
        HashMap<BindingOperation, Message> operationToInputMessageMap = new HashMap<BindingOperation, Message>();
        HashMap<BindingOperation, Message> operationToOutputMessageMap = new HashMap<BindingOperation, Message>();
        HashMap namespaceImportsMap = null;
        HashMap namespacePrefixMap = null;
        for (int k = 0; k < operationListToProcess.size(); ++k) {
            Output output;
            Message message;
            BindingOperation op = (BindingOperation)operationListToProcess.get(k);
            Input input = op.getOperation().getInput();
            if (input != null) {
                message = input.getMessage();
                messageQnameToMessageMap.put(message.getQName(), message);
                operationToInputMessageMap.put(op, message);
            }
            if ((output = op.getOperation().getOutput()) == null) continue;
            message = output.getMessage();
            messageQnameToMessageMap.put(message.getQName(), message);
            operationToOutputMessageMap.put(op, message);
        }
        String xsdPrefix = this.findSchemaPrefix();
        Document document = this.getDOMDocumentBuilder().newDocument();
        Iterator operationsIter = operationToInputMessageMap.keySet().iterator();
        while (operationsIter.hasNext()) {
            operation = (BindingOperation)operationsIter.next();
            elementDeclaration = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "element");
            elementDeclaration.setAttribute("name", operation.getName());
            BindingInput bindingInput = operation.getBindingInput();
            Message message = (Message)operationToInputMessageMap.get(operation);
            if (bindingInput != null) {
                String namespaceToUse;
                List parameterOrder;
                List bodyPartsList = this.getPartsListFromSoapBody(bindingInput.getExtensibilityElements());
                Iterator<Object> partsIterator = bodyPartsList != null ? message.getOrderedParts(bodyPartsList).iterator() : ((parameterOrder = operation.getOperation().getParameterOrdering()) != null ? message.getOrderedParts(parameterOrder).iterator() : message.getParts().values().iterator());
                namespaceImportsMap = new HashMap();
                namespacePrefixMap = new HashMap();
                Element newComplexType = this.getNewComplextType(document, xsdPrefix, partsIterator, namespaceImportsMap, namespacePrefixMap);
                elementDeclaration.appendChild(newComplexType);
                String bodyNamespace = this.getNamespaceFromSoapBody(bindingInput.getExtensibilityElements());
                String string = namespaceToUse = bodyNamespace != null ? bodyNamespace : namespaceURI;
                if (existingSchemaMap.containsKey(namespaceToUse)) {
                    this.addElementToAnExistingSchema((Element)existingSchemaMap.get(namespaceToUse), elementDeclaration, namespacePrefixMap, namespaceImportsMap, namespaceToUse);
                } else if (newSchemaMap.containsKey(namespaceToUse)) {
                    this.addElementToAnExistingSchema((Element)newSchemaMap.get(namespaceToUse), elementDeclaration, namespacePrefixMap, namespaceImportsMap, namespaceToUse);
                } else {
                    Element newSchema = this.createNewSchemaWithElemet(elementDeclaration, namespacePrefixMap, namespaceImportsMap, namespaceToUse, document, xsdPrefix);
                    newSchemaMap.put(namespaceToUse, newSchema);
                }
                this.resolvedRpcWrappedElementMap.put(operation.getName(), new QName(namespaceToUse, operation.getName(), "axis2wrapped"));
                continue;
            }
            throw new WSDLProcessingException("No binding input is defiend for binding operation ==> " + operation.getName());
        }
        Iterator operationsIterator = operationToOutputMessageMap.keySet().iterator();
        while (operationsIterator.hasNext()) {
            operation = (BindingOperation)operationsIterator.next();
            String baseoutputOpName = operation.getName();
            String outputOpName = baseoutputOpName + WRAPPED_OUTPUTNAME_SUFFIX;
            elementDeclaration = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "element");
            elementDeclaration.setAttribute("name", outputOpName);
            BindingOutput bindingOutput = operation.getBindingOutput();
            Message message = (Message)operationToOutputMessageMap.get(operation);
            if (bindingOutput != null) {
                String namespaceToUse;
                Iterator<Object> partsIterator;
                List bodyPartsList = this.getPartsListFromSoapBody(bindingOutput.getExtensibilityElements());
                if (bodyPartsList != null) {
                    bodyPartsList.add("result");
                    partsIterator = message.getOrderedParts(bodyPartsList).iterator();
                } else {
                    List parameterOrder = operation.getOperation().getParameterOrdering();
                    if (parameterOrder != null) {
                        parameterOrder.add("result");
                        partsIterator = message.getOrderedParts(parameterOrder).iterator();
                    } else {
                        partsIterator = message.getParts().values().iterator();
                    }
                }
                namespacePrefixMap = new HashMap();
                namespaceImportsMap = new HashMap();
                Element newComplexType = this.getNewComplextType(document, xsdPrefix, partsIterator, namespaceImportsMap, namespacePrefixMap);
                elementDeclaration.appendChild(newComplexType);
                String bodyNamespace = this.getNamespaceFromSoapBody(bindingOutput.getExtensibilityElements());
                String string = namespaceToUse = bodyNamespace != null ? bodyNamespace : namespaceURI;
                if (existingSchemaMap.containsKey(namespaceToUse)) {
                    this.addElementToAnExistingSchema((Element)existingSchemaMap.get(namespaceToUse), elementDeclaration, namespacePrefixMap, namespaceImportsMap, namespaceToUse);
                } else if (newSchemaMap.containsKey(namespaceToUse)) {
                    this.addElementToAnExistingSchema((Element)newSchemaMap.get(namespaceToUse), elementDeclaration, namespacePrefixMap, namespaceImportsMap, namespaceToUse);
                } else {
                    Element newSchema = this.createNewSchemaWithElemet(elementDeclaration, namespacePrefixMap, namespaceImportsMap, namespaceToUse, document, xsdPrefix);
                    newSchemaMap.put(namespaceToUse, newSchema);
                }
                this.resolvedRpcWrappedElementMap.put(outputOpName, new QName(namespaceToUse, outputOpName, "axis2wrapped"));
                continue;
            }
            throw new WSDLProcessingException("No binding out put is defined for binding operation ==>" + operation.getName());
        }
        return newSchemaMap;
    }

    private void addElementToAnExistingSchema(Element schemaElement, Element newElement, Map namespacePrefixMap, Map namespaceImportsMap, String targetNamespace) {
        Document ownerDocument = schemaElement.getOwnerDocument();
        String[] nameSpaceDeclarationArray = namespacePrefixMap.keySet().toArray(new String[namespacePrefixMap.size()]);
        for (int i = 0; i < nameSpaceDeclarationArray.length; ++i) {
            String s = nameSpaceDeclarationArray[i];
            this.checkAndAddNamespaceDeclarations(s, namespacePrefixMap, schemaElement);
        }
        Element[] namespaceImports = namespaceImportsMap.values().toArray(new Element[namespaceImportsMap.size()]);
        for (int i = 0; i < namespaceImports.length; ++i) {
            if (targetNamespace.equals(namespaceImports[i].getAttribute(NAMESPACE_URI))) continue;
            schemaElement.appendChild(ownerDocument.importNode(namespaceImports[i], true));
        }
        schemaElement.appendChild(ownerDocument.importNode(newElement, true));
    }

    private Element createNewSchemaWithElemet(Element newElement, Map namespacePrefixMap, Map namespaceImportsMap, String targetNamespace, Document document, String xsdPrefix) {
        Element schemaElement = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "schema");
        String[] nameSpaceDeclarationArray = namespacePrefixMap.keySet().toArray(new String[namespacePrefixMap.size()]);
        for (int i = 0; i < nameSpaceDeclarationArray.length; ++i) {
            String s = nameSpaceDeclarationArray[i];
            schemaElement.setAttributeNS(XML_NAMESPACE_URI, NAMESPACE_DECLARATION_PREFIX + namespacePrefixMap.get(s).toString(), s);
        }
        if (schemaElement.getAttributeNS(XML_NAMESPACE_URI, xsdPrefix).length() == 0) {
            schemaElement.setAttributeNS(XML_NAMESPACE_URI, NAMESPACE_DECLARATION_PREFIX + xsdPrefix, "http://www.w3.org/2001/XMLSchema");
        }
        schemaElement.setAttributeNS(XML_NAMESPACE_URI, "xmlns:axis2wrapped", targetNamespace);
        schemaElement.setAttribute(TRAGET_NAMESPACE, targetNamespace);
        schemaElement.setAttribute("elementFormDefault", "unqualified");
        Element[] namespaceImports = namespaceImportsMap.values().toArray(new Element[namespaceImportsMap.size()]);
        for (int i = 0; i < namespaceImports.length; ++i) {
            schemaElement.appendChild(namespaceImports[i]);
        }
        schemaElement.appendChild(newElement);
        return schemaElement;
    }

    private List getPartsListFromSoapBody(List extensibilityElements) {
        List partsList = null;
        Iterator iter = extensibilityElements.iterator();
        while (iter.hasNext()) {
            ExtensibilityElement soapBody;
            ExtensibilityElement extElement = (ExtensibilityElement)iter.next();
            if (extElement instanceof SOAPBody) {
                soapBody = (SOAPBody)extElement;
                if (soapBody.getUse() != null && soapBody.getUse().equals(ENCODED_USE)) {
                    throw new WSDLProcessingException("Encoded use is not supported");
                }
                partsList = soapBody.getParts();
                continue;
            }
            if (extElement instanceof SOAP12Body) {
                soapBody = (SOAP12Body)extElement;
                if (soapBody.getUse() != null && soapBody.getUse().equals(ENCODED_USE)) {
                    throw new WSDLProcessingException("Encoded use is not supported");
                }
                partsList = soapBody.getParts();
                continue;
            }
            if (!(extElement instanceof MIMEMultipartRelated)) continue;
            MIMEMultipartRelated mpr = (MIMEMultipartRelated)extElement;
            List mimeParts = mpr.getMIMEParts();
            Iterator i = mimeParts.iterator();
            while (i.hasNext()) {
                MIMEPart part = (MIMEPart)i.next();
                List mimeExtElements = part.getExtensibilityElements();
                List containedSoapBodyParts = this.getPartsListFromSoapBody(mimeExtElements);
                if (containedSoapBodyParts == null || containedSoapBodyParts.isEmpty()) continue;
                if (partsList == null) {
                    partsList = containedSoapBodyParts;
                    continue;
                }
                partsList.addAll(containedSoapBodyParts);
            }
        }
        return partsList;
    }

    private String getNamespaceFromSoapBody(List extensibilityElements) {
        String namespace = null;
        Iterator iter = extensibilityElements.iterator();
        while (iter.hasNext()) {
            ExtensibilityElement soapBody;
            ExtensibilityElement extElement = (ExtensibilityElement)iter.next();
            if (extElement instanceof SOAPBody) {
                soapBody = (SOAPBody)extElement;
                namespace = soapBody.getNamespaceURI();
                continue;
            }
            if (!(extElement instanceof SOAP12Body)) continue;
            soapBody = (SOAP12Body)extElement;
            namespace = soapBody.getNamespaceURI();
        }
        return namespace;
    }

    private Element getNewComplextType(Document document, String xsdPrefix, Iterator partsIterator, Map namespaceImportsMap, Map namespacePrefixMap) {
        Element newComplexType = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "complexType");
        Element cmplxTypeSequence = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "sequence");
        while (partsIterator.hasNext()) {
            Part part = (Part)partsIterator.next();
            String elementName = part.getName();
            QName schemaTypeName = part.getTypeName();
            if (schemaTypeName != null) {
                String prefix;
                Element child = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "element");
                child.setAttribute("form", "unqualified");
                if ("http://www.w3.org/2001/XMLSchema".equals(schemaTypeName.getNamespaceURI())) {
                    prefix = xsdPrefix;
                } else {
                    String uri = schemaTypeName.getNamespaceURI();
                    if (!namespaceImportsMap.containsKey(uri)) {
                        Element namespaceImport = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "import");
                        namespaceImport.setAttribute(NAMESPACE_URI, uri);
                        namespaceImportsMap.put(uri, namespaceImport);
                        prefix = this.getTemporaryNamespacePrefix();
                        namespacePrefixMap.put(uri, prefix);
                    } else {
                        prefix = (String)namespacePrefixMap.get(uri);
                    }
                }
                child.setAttribute("name", elementName);
                child.setAttribute("type", prefix + ":" + schemaTypeName.getLocalPart());
                cmplxTypeSequence.appendChild(child);
                continue;
            }
            throw new WSDLProcessingException("RPC-literal type message part " + part.getName() + "should have a type attribute ");
        }
        newComplexType.appendChild(cmplxTypeSequence);
        return newComplexType;
    }

    private void checkAndAddNamespaceDeclarations(String namespace, Map prefixMap, Element schemaElement) {
        String prefix = (String)prefixMap.get(namespace);
        String existingURL = schemaElement.getAttributeNS(XML_NAMESPACE_URI, NAMESPACE_DECLARATION_PREFIX + prefix);
        if (existingURL == null || existingURL.length() == 0) {
            schemaElement.setAttributeNS(XML_NAMESPACE_URI, NAMESPACE_DECLARATION_PREFIX + prefix, namespace);
        } else if (!existingURL.equals(namespace)) {
            String generatedPrefix = "ns" + prefixCounter++;
            while (prefixMap.containsKey(generatedPrefix)) {
                generatedPrefix = "ns" + prefixCounter++;
            }
            schemaElement.setAttributeNS(XML_NAMESPACE_URI, NAMESPACE_DECLARATION_PREFIX + generatedPrefix, namespace);
            prefixMap.put(namespace, generatedPrefix);
        }
    }

    private Definition readInTheWSDLFile(InputStream in) throws WSDLException {
        Definition def;
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature(JAVAX_WSDL_VERBOSE_MODE_KEY, false);
        if (this.customWSDLResolver != null) {
            def = reader.readWSDL(this.customWSDLResolver);
            def.setDocumentBaseURI(this.customWSDLResolver.getBaseURI());
        } else {
            Document doc;
            try {
                doc = XMLUtils.newDocument(in);
            }
            catch (ParserConfigurationException e) {
                throw new WSDLException("PARSER_ERROR", "Parser Configuration Error", e);
            }
            catch (SAXException e) {
                throw new WSDLException("PARSER_ERROR", "Parser SAX Error", e);
            }
            catch (IOException e) {
                throw new WSDLException("INVALID_WSDL", "IO Error", e);
            }
            def = reader.readWSDL(this.getBaseUri(), doc);
            def.setDocumentBaseURI(this.getBaseUri());
        }
        return def;
    }

    private void copyExtensibleElements(List wsdl4jExtensibleElements, Definition wsdl4jDefinition, AxisDescription description, String originOfExtensibilityElements) throws AxisFault {
        Iterator iterator = wsdl4jExtensibleElements.iterator();
        while (iterator.hasNext()) {
            AxisBinding axisBinding;
            ExtensibilityElement soapBinding;
            List<SOAPHeaderMessage> soapHeaders;
            Part msgPart;
            Boolean required;
            SOAPHeaderMessage headerMessage;
            ExtensibilityElement soapHeader;
            String style;
            AxisBindingOperation axisBindingOperation;
            ExtensibilityElement soapOperation;
            SoapAddress address;
            ExtensibilityElement soapAddress;
            ExtensibilityElement wsdl4jExtensibilityElement = (ExtensibilityElement)iterator.next();
            if (wsdl4jExtensibilityElement instanceof UnknownExtensibilityElement) {
                UnknownExtensibilityElement unknown = (UnknownExtensibilityElement)wsdl4jExtensibilityElement;
                QName type = unknown.getElementType();
                if (WSDLConstants.WSDL11Constants.POLICY.equals(type)) {
                    int attachmentScope;
                    Policy policy;
                    if (isTraceEnabled) {
                        log.trace("copyExtensibleElements:: PolicyElement found " + unknown);
                    }
                    if ((policy = (Policy)PolicyUtil.getPolicyComponent(unknown.getElement())) == null || (attachmentScope = this.getPolicyAttachmentPoint(description, originOfExtensibilityElements)) <= -1) continue;
                    description.getPolicyInclude().addPolicyElement(attachmentScope, policy);
                    continue;
                }
                if (WSDLConstants.WSDL11Constants.POLICY_REFERENCE.equals(type)) {
                    int attachmentScope;
                    PolicyReference policyReference;
                    if (isTraceEnabled) {
                        log.trace("copyExtensibleElements:: PolicyReference found " + unknown);
                    }
                    if ((policyReference = (PolicyReference)PolicyUtil.getPolicyComponent(unknown.getElement())) == null || (attachmentScope = this.getPolicyAttachmentPoint(description, originOfExtensibilityElements)) <= -1) continue;
                    description.getPolicyInclude().addPolicyRefElement(attachmentScope, policyReference);
                    continue;
                }
                if (AddressingConstants.Final.WSAW_USING_ADDRESSING.equals(type) || AddressingConstants.Submission.WSAW_USING_ADDRESSING.equals(unknown.getElementType())) {
                    if (isTraceEnabled) {
                        log.trace("copyExtensibleElements:: wsaw:UsingAddressing found " + unknown);
                    }
                    if (!originOfExtensibilityElements.equals(PORT) && !originOfExtensibilityElements.equals(BINDING)) continue;
                    if (Boolean.TRUE.equals(unknown.getRequired())) {
                        this.axisService.setWSAddressingFlag("required");
                        continue;
                    }
                    this.axisService.setWSAddressingFlag("optional");
                    continue;
                }
                if (AddressingConstants.Final.WSAW_ANONYMOUS.equals(unknown.getElementType())) {
                    if (!originOfExtensibilityElements.equals(BINDING_OPERATION)) continue;
                    AxisOperation axisOperation = (AxisOperation)description;
                    if (unknown.getElement().getFirstChild() == null || unknown.getElement().getFirstChild().getNodeType() != 3) continue;
                    String anonymousValue = unknown.getElement().getFirstChild().getNodeValue();
                    AddressingHelper.setAnonymousParameterValue(axisOperation, anonymousValue);
                    continue;
                }
                if (!isTraceEnabled) continue;
                log.trace("copyExtensibleElements:: Unknown Extensibility Element found " + unknown);
                continue;
            }
            if (wsdl4jExtensibilityElement instanceof SOAP12Address) {
                soapAddress = (SOAP12Address)wsdl4jExtensibilityElement;
                address = new SoapAddress();
                address.setLocation(soapAddress.getLocationURI());
                if (!(description instanceof AxisEndpoint)) continue;
                ((AxisEndpoint)description).setProperty("wsoap:address", address);
                continue;
            }
            if (wsdl4jExtensibilityElement instanceof SOAPAddress) {
                soapAddress = (SOAPAddress)wsdl4jExtensibilityElement;
                address = new SoapAddress();
                address.setLocation(soapAddress.getLocationURI());
                if (!(description instanceof AxisEndpoint)) continue;
                ((AxisEndpoint)description).setProperty("wsoap:address", address);
                continue;
            }
            if (wsdl4jExtensibilityElement instanceof Schema) {
                Schema schema = (Schema)wsdl4jExtensibilityElement;
                this.axisService.addSchema(this.getXMLSchema(schema.getElement(), schema.getDocumentBaseURI()));
                continue;
            }
            if (wsdl4jExtensibilityElement instanceof SOAP12Operation) {
                String soapActionURI;
                soapOperation = (SOAP12Operation)wsdl4jExtensibilityElement;
                axisBindingOperation = (AxisBindingOperation)description;
                style = soapOperation.getStyle();
                if (style != null) {
                    axisBindingOperation.setProperty("style", style);
                }
                if ((soapActionURI = soapOperation.getSoapActionURI()) == null) continue;
                axisBindingOperation.setProperty("wsoap:action", soapActionURI);
                axisBindingOperation.getAxisOperation().setSoapAction(soapActionURI);
                this.axisService.mapActionToOperation(soapActionURI, axisBindingOperation.getAxisOperation());
                continue;
            }
            if (wsdl4jExtensibilityElement instanceof SOAPOperation) {
                String soapAction;
                soapOperation = (SOAPOperation)wsdl4jExtensibilityElement;
                axisBindingOperation = (AxisBindingOperation)description;
                style = soapOperation.getStyle();
                if (style != null) {
                    axisBindingOperation.setProperty("style", style);
                }
                if ((soapAction = soapOperation.getSoapActionURI()) == null) continue;
                axisBindingOperation.setProperty("wsoap:action", soapAction);
                axisBindingOperation.getAxisOperation().setSoapAction(soapAction);
                this.axisService.mapActionToOperation(soapAction, axisBindingOperation.getAxisOperation());
                continue;
            }
            if (wsdl4jExtensibilityElement instanceof SOAP12Header) {
                soapHeader = (SOAP12Header)wsdl4jExtensibilityElement;
                headerMessage = new SOAPHeaderMessage();
                headerMessage.setNamespaceURI(soapHeader.getNamespaceURI());
                headerMessage.setUse(soapHeader.getUse());
                required = soapHeader.getRequired();
                if (required != null) {
                    headerMessage.setRequired(required);
                }
                if (wsdl4jDefinition != null) {
                    Message msg = wsdl4jDefinition.getMessage(soapHeader.getMessage());
                    if (msg == null) {
                        throw new AxisFault("message " + soapHeader.getMessage() + " not found in the WSDL ");
                    }
                    msgPart = msg.getPart(soapHeader.getPart());
                    if (msgPart == null) {
                        throw new AxisFault("message part " + soapHeader.getPart() + " not found in the WSDL ");
                    }
                    headerMessage.setElement(msgPart.getElementName());
                }
                headerMessage.setMessage(soapHeader.getMessage());
                headerMessage.setPart(soapHeader.getPart());
                if (!(description instanceof AxisBindingMessage)) continue;
                AxisBindingMessage bindingMessage = (AxisBindingMessage)description;
                soapHeaders = (ArrayList<SOAPHeaderMessage>)bindingMessage.getProperty("wsoap:header");
                if (soapHeaders == null) {
                    soapHeaders = new ArrayList<SOAPHeaderMessage>();
                    bindingMessage.setProperty("wsoap:header", soapHeaders);
                }
                soapHeaders.add(headerMessage);
                continue;
            }
            if (wsdl4jExtensibilityElement instanceof SOAPHeader) {
                soapHeader = (SOAPHeader)wsdl4jExtensibilityElement;
                headerMessage = new SOAPHeaderMessage();
                headerMessage.setNamespaceURI(soapHeader.getNamespaceURI());
                headerMessage.setUse(soapHeader.getUse());
                required = soapHeader.getRequired();
                if (null != required) {
                    headerMessage.setRequired(required);
                }
                if (null != wsdl4jDefinition) {
                    Message msg = wsdl4jDefinition.getMessage(soapHeader.getMessage());
                    if (msg == null) {
                        throw new AxisFault("message " + soapHeader.getMessage() + " not found in the WSDL ");
                    }
                    msgPart = msg.getPart(soapHeader.getPart());
                    if (msgPart == null) {
                        throw new AxisFault("message part " + soapHeader.getPart() + " not found in the WSDL ");
                    }
                    headerMessage.setElement(msgPart.getElementName());
                }
                headerMessage.setMessage(soapHeader.getMessage());
                headerMessage.setPart(soapHeader.getPart());
                if (!(description instanceof AxisBindingMessage)) continue;
                AxisBindingMessage bindingMessage = (AxisBindingMessage)description;
                soapHeaders = (List)bindingMessage.getProperty("wsoap:header");
                if (soapHeaders == null) {
                    soapHeaders = new ArrayList();
                    bindingMessage.setProperty("wsoap:header", soapHeaders);
                }
                soapHeaders.add(headerMessage);
                continue;
            }
            if (wsdl4jExtensibilityElement instanceof SOAPBinding) {
                soapBinding = (SOAPBinding)wsdl4jExtensibilityElement;
                axisBinding = (AxisBinding)description;
                axisBinding.setType(soapBinding.getTransportURI());
                String soapNamespaceURI = soapBinding.getElementType().getNamespaceURI();
                axisBinding.setProperty("wsoap:version", soapNamespaceURI);
                this.axisService.setSoapNsUri(soapNamespaceURI);
                String style2 = soapBinding.getStyle();
                if (style2 == null) continue;
                axisBinding.setProperty("style", style2);
                continue;
            }
            if (!(wsdl4jExtensibilityElement instanceof SOAP12Binding)) continue;
            soapBinding = (SOAP12Binding)wsdl4jExtensibilityElement;
            axisBinding = (AxisBinding)description;
            String soapNamesapceURI = soapBinding.getElementType().getNamespaceURI();
            axisBinding.setProperty("wsoap:version", soapNamesapceURI);
            this.axisService.setSoapNsUri(soapNamesapceURI);
            String style3 = soapBinding.getStyle();
            if (style3 != null) {
                axisBinding.setProperty("style", style3);
            }
            String transportURI = soapBinding.getTransportURI();
            axisBinding.setType(transportURI);
        }
    }

    private int getPolicyAttachmentPoint(AxisDescription description, String originOfExtensibilityElements) {
        int result = -1;
        if (description instanceof AxisService) {
            if (SERVICE.equals(originOfExtensibilityElements)) {
                result = 6;
            } else if (PORT.equals(originOfExtensibilityElements)) {
                result = 7;
            } else if (BINDING.equals(originOfExtensibilityElements)) {
                result = 9;
            }
        } else if (description instanceof AxisOperation) {
            result = PORT_TYPE_OPERATION.equals(originOfExtensibilityElements) ? 10 : 9;
        } else if (PORT_TYPE_OPERATION_INPUT.equals(originOfExtensibilityElements)) {
            result = 12;
        } else if (BINDING_OPERATION_INPUT.equals(originOfExtensibilityElements)) {
            result = 14;
        } else if (PORT_TYPE_OPERATION_OUTPUT.equals(originOfExtensibilityElements)) {
            result = 13;
        } else if (BINDING_OPERATION_OUTPUT.equals(originOfExtensibilityElements)) {
            result = 15;
        }
        if (isTraceEnabled) {
            log.trace("getPolicyAttachmentPoint:: axisDescription=" + description + " extensibilityPoint=" + originOfExtensibilityElements + " result=" + result);
        }
        return result;
    }

    private List findWrappableBindingOperations(Binding binding) {
        boolean isRPC = false;
        boolean isSOAPBinding = false;
        List extElements = binding.getExtensibilityElements();
        for (int i = 0; i < extElements.size(); ++i) {
            ExtensibilityElement soapBinding;
            if (extElements.get(i) instanceof SOAPBinding) {
                isSOAPBinding = true;
                soapBinding = (SOAPBinding)extElements.get(i);
                if (!RPC_STYLE.equals(soapBinding.getStyle())) break;
                isRPC = true;
                break;
            }
            if (!(extElements.get(i) instanceof SOAP12Binding)) continue;
            isSOAPBinding = true;
            soapBinding = (SOAP12Binding)extElements.get(i);
            if (!RPC_STYLE.equals(soapBinding.getStyle())) break;
            isRPC = true;
            break;
        }
        if (!isSOAPBinding) {
            return new ArrayList();
        }
        ArrayList<BindingOperation> returnList = new ArrayList<BindingOperation>();
        Iterator bindingOperationsIterator = binding.getBindingOperations().iterator();
        while (bindingOperationsIterator.hasNext()) {
            BindingOperation bindingOp = (BindingOperation)bindingOperationsIterator.next();
            String style = this.getSOAPStyle(bindingOp);
            if (style == null) {
                if (!isRPC) continue;
                returnList.add(bindingOp);
                continue;
            }
            if (!RPC_STYLE.equals(style)) continue;
            returnList.add(bindingOp);
        }
        this.wrappableOperations = returnList;
        return returnList;
    }

    private String getMEP(Operation operation) throws AxisFault {
        OperationType operationType = operation.getStyle();
        if (this.isServerSide) {
            if (operationType != null) {
                if (operationType.equals(OperationType.REQUEST_RESPONSE)) {
                    return "http://www.w3.org/2006/01/wsdl/in-out";
                }
                if (operationType.equals(OperationType.ONE_WAY)) {
                    if (operation.getFaults().size() > 0) {
                        return "http://www.w3.org/2006/01/wsdl/robust-in-only";
                    }
                    return "http://www.w3.org/2006/01/wsdl/in-only";
                }
                if (operationType.equals(OperationType.NOTIFICATION)) {
                    return "http://www.w3.org/2006/01/wsdl/out-only";
                }
                if (operationType.equals(OperationType.SOLICIT_RESPONSE)) {
                    return "http://www.w3.org/2006/01/wsdl/out-in";
                }
                throw new AxisFault("Cannot Determine the MEP");
            }
        } else if (operationType != null) {
            if (operationType.equals(OperationType.REQUEST_RESPONSE)) {
                return "http://www.w3.org/2006/01/wsdl/out-in";
            }
            if (operationType.equals(OperationType.ONE_WAY)) {
                return "http://www.w3.org/2006/01/wsdl/out-only";
            }
            if (operationType.equals(OperationType.NOTIFICATION)) {
                return "http://www.w3.org/2006/01/wsdl/in-only";
            }
            if (operationType.equals(OperationType.SOLICIT_RESPONSE)) {
                return "http://www.w3.org/2006/01/wsdl/in-out";
            }
            throw new AxisFault("Cannot Determine the MEP");
        }
        throw new AxisFault("Cannot Determine the MEP");
    }

    private void copyExtensionAttributes(Map extAttributes, AxisDescription description, String origin) {
        Iterator iterator = extAttributes.keySet().iterator();
        while (iterator.hasNext()) {
            QName value;
            String policyURIs;
            QName key = (QName)iterator.next();
            if (!"http://schemas.xmlsoap.org/ws/2004/09/policy".equals(key.getNamespaceURI()) || !"PolicyURIs".equals(key.getLocalPart()) || (policyURIs = (value = (QName)extAttributes.get(key)).getLocalPart()).length() == 0) continue;
            String[] uris = policyURIs.split(" ");
            for (int i = 0; i < uris.length; ++i) {
                PolicyReference ref = new PolicyReference();
                ref.setURI(uris[i]);
                if (!PORT_TYPE.equals(origin)) continue;
                PolicyInclude include = description.getPolicyInclude();
                include.addPolicyRefElement(8, ref);
            }
        }
    }

    private void processPoliciesInDefintion(Definition definition) {
        List extElements = definition.getExtensibilityElements();
        Iterator iterator = extElements.iterator();
        while (iterator.hasNext()) {
            String key;
            Policy policy;
            UnknownExtensibilityElement unknown;
            ExtensibilityElement extElement = (ExtensibilityElement)iterator.next();
            if (!(extElement instanceof UnknownExtensibilityElement) || !WSDLConstants.WSDL11Constants.POLICY.equals((unknown = (UnknownExtensibilityElement)extElement).getElementType()) || (policy = (Policy)PolicyUtil.getPolicyComponent(unknown.getElement())) == null || (key = policy.getName()) == null && (key = policy.getId()) == null) continue;
            this.registry.register(key, policy);
        }
    }

    public static class WSDLProcessingException
    extends RuntimeException {
        public WSDLProcessingException() {
        }

        public WSDLProcessingException(String message) {
            super(message);
        }

        public WSDLProcessingException(Throwable cause) {
            super(cause);
        }

        public WSDLProcessingException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

