/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSDL11ToAllAxisServicesBuilder
extends WSDL11ToAxisServiceBuilder {
    protected static final Log log = LogFactory.getLog(WSDL11ToAllAxisServicesBuilder.class);
    public static final String WSDL_SERVICE_QNAME = "WSDL_SERVICE_QNAME";
    public static final String WSDL_PORT = "WSDL_PORT";
    private ArrayList axisServices = new ArrayList();

    public WSDL11ToAllAxisServicesBuilder(InputStream in) {
        super(in);
    }

    public List populateAllServices() throws AxisFault {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Entry: populateAllServices");
            }
            this.setup();
            if (this.wsdl4jDefinition == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Exit: populateAllServices.  wsdl definition is null!");
                }
                return null;
            }
            Iterator wsdlServIter = this.wsdl4jDefinition.getServices().entrySet().iterator();
            while (wsdlServIter.hasNext()) {
                Map.Entry entry = wsdlServIter.next();
                Service service = (Service)entry.getValue();
                this.serviceName = service.getQName();
                Iterator wsdlPortIter = service.getPorts().entrySet().iterator();
                while (wsdlPortIter.hasNext()) {
                    Map.Entry portEntry = wsdlPortIter.next();
                    Port port = (Port)portEntry.getValue();
                    this.portName = port.getName();
                    this.axisService = new AxisService();
                    AxisService retAxisService = this.populateService();
                    if (retAxisService == null) continue;
                    Parameter serviceNameParameter = new Parameter();
                    serviceNameParameter.setName(WSDL_SERVICE_QNAME);
                    serviceNameParameter.setValue(this.serviceName);
                    retAxisService.addParameter(serviceNameParameter);
                    Parameter portParameter = new Parameter();
                    portParameter.setName(WSDL_PORT);
                    portParameter.setValue(port);
                    retAxisService.addParameter(portParameter);
                    retAxisService.setName(this.portName);
                    this.axisServices.add(retAxisService);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Exit: populateAllServices.");
            }
            return this.axisServices;
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("populateAllServices caught Exception.  Converting to AxisFault. " + e.toString());
            }
            throw new AxisFault(e);
        }
    }
}

