/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.externalize.SafeObjectInputStream;
import org.apache.axis2.context.externalize.SafeObjectOutputStream;
import org.apache.axis2.context.externalize.SafeSerializable;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParameterIncludeImpl
implements ParameterInclude,
Externalizable,
SafeSerializable {
    private static final Log log = LogFactory.getLog(ParameterIncludeImpl.class);
    private static final String myClassName = "ParameterIncludeImpl";
    private static final long serialVersionUID = 8153736719090126891L;
    private static final int REVISION_2 = 2;
    private static final int revisionID = 2;
    protected final ConcurrentHashMap parameters = new ConcurrentHashMap();

    public void addParameter(Parameter param) {
        if (param != null) {
            this.parameters.put(param.getName(), param);
        }
    }

    public void removeParameter(Parameter param) throws AxisFault {
        this.parameters.remove(param.getName());
    }

    public void deserializeParameters(OMElement parameters) throws AxisFault {
        Iterator iterator = parameters.getChildrenWithName(new QName("parameter"));
        while (iterator.hasNext()) {
            OMElement parameterElement = (OMElement)iterator.next();
            Parameter parameter = new Parameter();
            parameter.setParameterElement(parameterElement);
            OMAttribute paraName = parameterElement.getAttribute(new QName("name"));
            parameter.setName(paraName.getAttributeValue());
            OMElement paraValue = parameterElement.getFirstElement();
            if (paraValue != null) {
                parameter.setValue(parameterElement);
                parameter.setParameterType(Parameter.OM_PARAMETER);
            } else {
                String paratextValue = parameterElement.getText();
                parameter.setValue(paratextValue);
                parameter.setParameterType(Parameter.TEXT_PARAMETER);
            }
            OMAttribute paraLocked = parameterElement.getAttribute(new QName("locked"));
            if (paraLocked != null) {
                String lockedValue = paraLocked.getAttributeValue();
                if ("true".equals(lockedValue)) {
                    parameter.setLocked(true);
                } else {
                    parameter.setLocked(false);
                }
            }
            this.addParameter(parameter);
        }
    }

    public Parameter getParameter(String name) {
        return (Parameter)this.parameters.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getParameters() {
        Collection col = this.parameters.values();
        ArrayList<Parameter> para_list = new ArrayList<Parameter>();
        ConcurrentHashMap concurrentHashMap = this.parameters;
        synchronized (concurrentHashMap) {
            Iterator iterator = col.iterator();
            while (iterator.hasNext()) {
                Parameter parameter = (Parameter)iterator.next();
                para_list.add(parameter);
            }
        }
        return para_list;
    }

    public boolean isParameterLocked(String parameterName) {
        return false;
    }

    public void writeExternal(ObjectOutput o) throws IOException {
        SafeObjectOutputStream out = SafeObjectOutputStream.install(o);
        out.writeLong(8153736719090126891L);
        out.writeInt(2);
        out.writeMap(this.parameters);
    }

    public void readExternal(ObjectInput inObject) throws IOException, ClassNotFoundException {
        SafeObjectInputStream in = SafeObjectInputStream.install(inObject);
        if (log.isTraceEnabled()) {
            log.trace("ParameterIncludeImpl:readExternal():  BEGIN  bytes available in stream [" + in.available() + "]  ");
        }
        long suid = in.readLong();
        int revID = in.readInt();
        if (suid != 8153736719090126891L) {
            throw new ClassNotFoundException("Serialization version ID is not supported.");
        }
        if (revID != 2) {
            throw new ClassNotFoundException("Revision ID is not supported.");
        }
        in.readMap(this.parameters);
    }
}

