/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.i18n.Messages;

class OutOnlyAxisOperationClient
extends OperationClient {
    private MessageContext mc;

    OutOnlyAxisOperationClient(OutOnlyAxisOperation axisOp, ServiceContext sc, Options options) {
        super(axisOp, sc, options);
    }

    public void addMessageContext(MessageContext mc) throws AxisFault {
        if (this.mc != null) {
            throw new AxisFault(Messages.getMessage("cannotaddmsgctx"));
        }
        this.mc = mc;
        if (mc.getMessageID() == null) {
            this.setMessageID(mc);
        }
        mc.setServiceContext(this.sc);
        this.axisOp.registerOperationContext(mc, this.oc);
        this.completed = false;
    }

    public MessageContext getMessageContext(String messageLabel) throws AxisFault {
        if (messageLabel.equals("Out")) {
            return this.mc;
        }
        throw new AxisFault(Messages.getMessage("unknownMsgLabel", messageLabel));
    }

    public void setCallback(Callback callback) {
        throw new UnsupportedOperationException("This feature is not supported by this MEP");
    }

    public void execute(boolean block) throws AxisFault {
        if (this.completed) {
            throw new AxisFault(Messages.getMessage("mepiscomplted"));
        }
        ConfigurationContext cc = this.sc.getConfigurationContext();
        this.prepareMessageContext(cc, this.mc);
        OperationContext oc = ContextFactory.createOperationContext(this.axisOp, this.sc);
        oc.addMessageContext(this.mc);
        AxisEngine engine2 = new AxisEngine(cc);
        if (!block) {
            this.mc.setProperty("transportNonBlocking", Boolean.TRUE);
        }
        engine2.send(this.mc);
        this.completed = true;
    }
}

