/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.async.AsyncResult;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.ClientUtils;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.util.CallbackReceiver;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class OutInAxisOperationClient
extends OperationClient {
    private static Log log = LogFactory.getLog(OutInAxisOperationClient.class);

    OutInAxisOperationClient(OutInAxisOperation axisOp, ServiceContext sc, Options options) {
        super(axisOp, sc, options);
    }

    public void addMessageContext(MessageContext mc) throws AxisFault {
        mc.setServiceContext(this.sc);
        if (mc.getMessageID() == null) {
            this.setMessageID(mc);
        }
        this.axisOp.registerOperationContext(mc, this.oc);
    }

    public MessageContext getMessageContext(String messageLabel) throws AxisFault {
        return this.oc.getMessageContext(messageLabel);
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(boolean block) throws AxisFault {
        Boolean useAsyncOption;
        if (log.isDebugEnabled()) {
            log.debug("Entry: OutInAxisOperationClient::execute, " + block);
        }
        if (this.completed) {
            throw new AxisFault(Messages.getMessage("mepiscomplted"));
        }
        ConfigurationContext cc = this.sc.getConfigurationContext();
        MessageContext mc = this.oc.getMessageContext("Out");
        if (mc == null) {
            throw new AxisFault(Messages.getMessage("outmsgctxnull"));
        }
        this.prepareMessageContext(cc, mc);
        if (this.options.getTransportIn() == null && mc.getTransportIn() == null) {
            mc.setTransportIn(ClientUtils.inferInTransport(cc.getAxisConfiguration(), this.options, mc));
        } else if (mc.getTransportIn() == null) {
            mc.setTransportIn(this.options.getTransportIn());
        }
        boolean useAsync = false;
        if (!this.options.isUseSeparateListener() && (useAsyncOption = (Boolean)mc.getProperty("UseAsyncOperations")) != null) {
            useAsync = useAsyncOption;
        }
        if (useAsync || this.options.isUseSeparateListener()) {
            if (log.isDebugEnabled()) {
                log.debug("useAsync=" + useAsync + ", seperateListener=" + this.options.isUseSeparateListener());
            }
            CallbackReceiver callbackReceiver = null;
            AxisOperation axisOperation = this.axisOp;
            synchronized (axisOperation) {
                if (this.axisOp.getMessageReceiver() != null && this.axisOp.getMessageReceiver() instanceof CallbackReceiver) {
                    callbackReceiver = (CallbackReceiver)this.axisOp.getMessageReceiver();
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Creating new callback receiver");
                    }
                    callbackReceiver = new CallbackReceiver();
                    this.axisOp.setMessageReceiver(callbackReceiver);
                }
            }
            SyncCallBack internalCallback = null;
            if (this.callback != null) {
                callbackReceiver.addCallback(mc.getMessageID(), this.callback);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Creating internal callback");
                }
                internalCallback = new SyncCallBack(this);
                callbackReceiver.addCallback(mc.getMessageID(), internalCallback);
            }
            Boolean useCustomListener = (Boolean)this.options.getProperty("UseCustomListener");
            if (useAsync) {
                useCustomListener = Boolean.TRUE;
            }
            if (useCustomListener == null || !useCustomListener.booleanValue()) {
                EndpointReference replyToFromTransport = mc.getConfigurationContext().getListenerManager().getEPRforService(this.sc.getAxisService().getName(), this.axisOp.getName().getLocalPart(), mc.getTransportIn().getName().getLocalPart());
                if (mc.getReplyTo() == null) {
                    mc.setReplyTo(replyToFromTransport);
                } else {
                    mc.getReplyTo().setAddress(replyToFromTransport.getAddress());
                }
            }
            mc.setProperty("transportNonBlocking", Boolean.TRUE);
            AxisEngine engine2 = new AxisEngine(cc);
            mc.getConfigurationContext().registerOperationContext(mc.getMessageID(), this.oc);
            engine2.send(mc);
            if (internalCallback != null) {
                long timeout;
                long waitTime = timeout = this.options.getTimeOutInMilliSeconds();
                long startTime = System.currentTimeMillis();
                SyncCallBack syncCallBack = internalCallback;
                synchronized (syncCallBack) {
                    while (!internalCallback.isComplete() && waitTime >= 0L) {
                        try {
                            internalCallback.wait(timeout);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        waitTime = timeout - (System.currentTimeMillis() - startTime);
                    }
                }
                if (internalCallback.envelope == null) {
                    if (internalCallback.error instanceof AxisFault) {
                        throw (AxisFault)internalCallback.error;
                    }
                    if (internalCallback.error != null) {
                        throw new AxisFault(internalCallback.error);
                    }
                    if (!internalCallback.isComplete()) {
                        throw new AxisFault(Messages.getMessage("responseTimeOut"));
                    }
                    throw new AxisFault(Messages.getMessage("callBackCompletedWithError"));
                }
            }
        } else if (block) {
            this.send(mc);
            this.completed = true;
        } else {
            this.sc.getConfigurationContext().getThreadPool().execute(new NonBlockingInvocationWorker(this.callback, mc));
        }
    }

    protected MessageContext send(MessageContext msgctx) throws AxisFault {
        SOAPEnvelope resenvelope;
        AxisEngine engine2 = new AxisEngine(msgctx.getConfigurationContext());
        MessageContext responseMessageContext = ContextFactory.createMessageContext(msgctx.getConfigurationContext());
        responseMessageContext.setServerSide(false);
        responseMessageContext.setMessageID(msgctx.getMessageID());
        this.addMessageContext(responseMessageContext);
        responseMessageContext.setServiceContext(msgctx.getServiceContext());
        responseMessageContext.setAxisMessage(this.axisOp.getMessage("In"));
        engine2.send(msgctx);
        responseMessageContext = this.oc.getMessageContext("In");
        responseMessageContext.setDoingREST(msgctx.isDoingREST());
        responseMessageContext.setProperty("TRANSPORT_HEADERS", msgctx.getProperty("TRANSPORT_HEADERS"));
        responseMessageContext.setProperty(HTTPConstants.MC_HTTP_STATUS_CODE, msgctx.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE));
        responseMessageContext.setProperty("TRANSPORT_IN", msgctx.getProperty("TRANSPORT_IN"));
        responseMessageContext.setTransportIn(msgctx.getTransportIn());
        responseMessageContext.setTransportOut(msgctx.getTransportOut());
        responseMessageContext.setSoapAction("");
        if (responseMessageContext.getEnvelope() == null) {
            resenvelope = TransportUtils.createSOAPMessage(responseMessageContext);
            if (resenvelope != null) {
                responseMessageContext.setEnvelope(resenvelope);
            } else {
                throw new AxisFault(Messages.getMessage("blockingInvocationExpectsResponse"));
            }
        }
        if ((resenvelope = responseMessageContext.getEnvelope()) != null) {
            if (resenvelope.getBody().hasFault()) {
                SOAPFault soapFault = resenvelope.getBody().getFault();
                engine2 = new AxisEngine(msgctx.getConfigurationContext());
                engine2.receiveFault(responseMessageContext);
                if (this.options.isExceptionToBeThrownOnSOAPFault()) {
                    AxisFault af = Utils.getInboundFaultFromMessageContext(responseMessageContext);
                    throw af;
                }
            } else {
                engine2 = new AxisEngine(msgctx.getConfigurationContext());
                engine2.receive(responseMessageContext);
                if (responseMessageContext.getReplyTo() != null) {
                    this.sc.setTargetEPR(responseMessageContext.getReplyTo());
                }
            }
        }
        return responseMessageContext;
    }

    private class SyncCallBack
    extends Callback {
        private SOAPEnvelope envelope;
        OperationClient oc;
        private Exception error;

        public SyncCallBack(OperationClient oc) {
            this.oc = oc;
        }

        public void onComplete(AsyncResult result) {
            if (log.isDebugEnabled()) {
                log.debug("Entry: OutInAxisOperationClient$SyncCallBack::onComplete");
            }
            this.envelope = result.getResponseEnvelope();
            this.envelope.buildWithAttachments();
            if (log.isDebugEnabled()) {
                log.debug("Exit: OutInAxisOperationClient$SyncCallBack::onComplete");
            }
            this.oc.updateOperationContext(result.getResponseMessageContext().getOperationContext());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setComplete(boolean complete) {
            if (log.isDebugEnabled()) {
                log.debug("Entry: OutInAxisOperationClient$SyncCallBack::setComplete, " + complete);
            }
            super.setComplete(complete);
            SyncCallBack syncCallBack = this;
            synchronized (syncCallBack) {
                this.notify();
            }
            if (log.isDebugEnabled()) {
                log.debug("Exit: OutInAxisOperationClient$SyncCallBack::setComplete, " + complete);
            }
        }

        public void onError(Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Entry: OutInAxisOperationClient$SyncCallBack::onError, " + e);
            }
            this.error = e;
            if (log.isDebugEnabled()) {
                log.debug("Exit: OutInAxisOperationClient$SyncCallBack::onError");
            }
        }
    }

    private class NonBlockingInvocationWorker
    implements Runnable {
        private Callback callback;
        private MessageContext msgctx;

        public NonBlockingInvocationWorker(Callback callback, MessageContext msgctx) {
            this.callback = callback;
            this.msgctx = msgctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                MessageContext response = OutInAxisOperationClient.this.send(this.msgctx);
                if (response != null) {
                    SOAPEnvelope resenvelope = response.getEnvelope();
                    SOAPBody body = resenvelope.getBody();
                    if (body.hasFault()) {
                        AxisFault fault = new AxisFault(body.getFault(), response);
                        this.callback.onError(fault);
                    } else {
                        AsyncResult asyncResult = new AsyncResult(response);
                        this.callback.onComplete(asyncResult);
                    }
                }
            }
            catch (Exception e) {
                this.callback.onError(e);
            }
            finally {
                this.callback.setComplete(true);
            }
        }
    }
}

