/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.WSDL2Constants;
import org.apache.axis2.util.XMLUtils;
import org.apache.ws.commons.schema.XmlSchema;

public class AxisService2WSDL2
implements WSDL2Constants {
    private AxisService axisService;
    private String[] url;
    private OMNamespace wsoap;
    private OMNamespace tns;

    public AxisService2WSDL2(AxisService service, String[] serviceURL) {
        this.axisService = service;
        this.url = serviceURL;
    }

    public OMElement generateOM() throws Exception {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        fac.createOMNamespace("http://www.w3.org/2006/01/wsdl", "wsdl2");
        OMElement description = fac.createOMElement("description", null);
        Map nameSpaceMap = this.axisService.getNameSpacesMap();
        Iterator keys = nameSpaceMap.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if ("".equals(key)) {
                description.declareDefaultNamespace((String)nameSpaceMap.get(key));
                continue;
            }
            description.declareNamespace((String)nameSpaceMap.get(key), key);
        }
        this.wsoap = description.declareNamespace("http://www.w3.org/2006/01/wsdl/soap", "wsoap");
        description.declareNamespace("http://www.w3.org/2003/05/soap-envelope", "soap");
        String prefix = this.getPrefix(this.axisService.getTargetNamespace());
        if (prefix == null || "".equals(prefix)) {
            prefix = "axis2";
        }
        this.axisService.getNameSpacesMap().put(prefix, this.axisService.getTargetNamespace());
        this.tns = description.declareNamespace(this.axisService.getTargetNamespace(), prefix);
        description.addAttribute("targetNamespace", this.axisService.getTargetNamespace(), null);
        if (this.axisService.getServiceDescription() != null) {
            this.addDocumentation(description, fac, this.axisService.getServiceDescription());
        }
        OMElement wsdlTypes = fac.createOMElement("types", null);
        description.addChild(wsdlTypes);
        this.axisService.populateSchemaMappings();
        ArrayList schemas = this.axisService.getSchema();
        for (int i = 0; i < schemas.size(); ++i) {
            StringWriter writer = new StringWriter();
            XmlSchema schema = this.axisService.getSchema(i);
            if ("http://www.w3.org/2001/XMLSchema".equals(schema.getTargetNamespace())) continue;
            schema.write(writer);
            String schemaString = writer.toString();
            if ("".equals(schemaString)) continue;
            wsdlTypes.addChild(XMLUtils.toOM(new ByteArrayInputStream(schemaString.getBytes())));
        }
        this.generateInterface(description, fac);
        this.generateSOAPBinding(description, fac);
        this.generateServiceElement(description, fac);
        return description;
    }

    private void addDocumentation(OMElement element, OMFactory factory, String docmentString) {
        OMElement documentation = factory.createOMElement("documentation", this.wsoap);
        documentation.setText(docmentString);
        element.addChild(documentation);
    }

    private void generateInterface(OMElement description, OMFactory fac) {
        OMElement interfaceElement = fac.createOMElement("interface", null);
        interfaceElement.addAttribute("name", this.axisService.getName() + "Interface", null);
        this.generateInterfaceFaultElement(interfaceElement, fac);
        this.generateInterfaceOperations(interfaceElement, fac);
        description.addChild(interfaceElement);
    }

    private void generateInterfaceOperations(OMElement interfaceElement, OMFactory fac) {
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation()) continue;
            String operationName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", null);
            interfaceElement.addChild(operation);
            operation.addAttribute("name", operationName, null);
            String MEP2 = axisOperation.getMessageExchangePattern();
            operation.addAttribute("pattern", this.getUpdatedMEP(MEP2), null);
            if (("http://www.w3.org/2006/01/wsdl/in-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-opt-out".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/out-opt-in".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/robust-out-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/robust-in-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-out".equals(MEP2)) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                OMElement input = fac.createOMElement("input", null);
                input.addAttribute("messageLabel", "In", null);
                operation.addChild(input);
                this.addMessageElementAtt(input, inaxisMessage);
            }
            if (("http://www.w3.org/2006/01/wsdl/out-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/out-opt-in".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-opt-out".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/robust-out-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/robust-in-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-out".equals(MEP2)) && (outAxisMessage = axisOperation.getMessage("Out")) != null) {
                OMElement output = fac.createOMElement("output", null);
                operation.addChild(output);
                output.addAttribute("messageLabel", "Out", null);
                this.addMessageElementAtt(output, outAxisMessage);
            }
            this.addInterfaceOperationFault(operation, fac, axisOperation);
        }
    }

    private void addMessageElementAtt(OMElement messageElement, AxisMessage message) {
        QName elementQName = message.getElementQName();
        String attValue = elementQName.getPrefix() + ":" + elementQName.getLocalPart();
        messageElement.addAttribute("element", attValue, null);
    }

    private void addInterfaceOperationFault(OMElement operationElement, OMFactory fac, AxisOperation operation) {
        ArrayList faultMessages = operation.getFaultMessages();
        Iterator iterator = faultMessages.iterator();
        while (iterator.hasNext()) {
            AxisMessage faultMessage = (AxisMessage)iterator.next();
            if (faultMessage == null) continue;
            QName elementQName = faultMessage.getElementQName();
            String direction = faultMessage.getDirection();
            OMElement faultElement = null;
            if ("Out".equalsIgnoreCase(direction)) {
                faultElement = fac.createOMElement("outfault", null, operationElement);
            } else if ("In".equalsIgnoreCase(direction)) {
                faultElement = fac.createOMElement("infault", null, operationElement);
            } else {
                return;
            }
            faultElement.addAttribute("messageLabel", direction, null);
            faultElement.addAttribute("ref", elementQName.getPrefix() + ":" + elementQName.getLocalPart(), null);
        }
    }

    private void generateInterfaceFaultElement(OMElement interfaceElement, OMFactory fac) {
    }

    private void generateSOAPBinding(OMElement description, OMFactory fac) {
        OMElement bindingElement = fac.createOMElement("binding", null);
        description.addChild(bindingElement);
        bindingElement.addAttribute("name", this.axisService.getName() + "SOAPBinding", null);
        bindingElement.addAttribute("interface", this.tns.getPrefix() + ":" + this.axisService.getName() + "Interface", null);
        bindingElement.addAttribute("type", "http://www.w3.org/2006/01/wsdl/soap", null);
        bindingElement.addAttribute("protocol", "http://www.w3.org/2003/05/soap/bindings/HTTP", this.wsoap);
        this.addBindingFaultElement(bindingElement, fac);
        this.generateBindingOperations(bindingElement, fac);
    }

    private void addBindingFaultElement(OMElement bindingElement, OMFactory fac) {
    }

    private void generateBindingOperations(OMElement bindingElement, OMFactory fac) {
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation()) continue;
            OMElement operation = fac.createOMElement("operation", null);
            bindingElement.addChild(operation);
            String MEP2 = axisOperation.getMessageExchangePattern();
            operation.addAttribute("ref", this.tns.getPrefix() + ":" + axisOperation.getName().getLocalPart(), null);
            operation.addAttribute("mep", this.getMep(axisOperation.getMessageExchangePattern()), this.wsoap);
        }
    }

    private void generateServiceElement(OMElement description, OMFactory fac) throws Exception {
        OMElement serviceElement = fac.createOMElement("service", null);
        serviceElement.addAttribute("name", this.axisService.getName() + "Service", null);
        serviceElement.addAttribute("interface", this.tns.getPrefix() + ":" + this.axisService.getName() + "Interface", null);
        description.addChild(serviceElement);
        this.generateEndpoints(serviceElement, fac);
    }

    private void generateEndpoints(OMElement serviceElement, OMFactory fac) throws Exception {
        for (int i = 0; i < this.url.length; ++i) {
            String s = this.url[i];
            OMElement endpoint = fac.createOMElement("endpoint", null);
            URL url = new URL(s);
            endpoint.addAttribute("name", this.axisService.getName() + "Endpoint" + "_" + url.getProtocol(), null);
            endpoint.addAttribute("binding", this.tns.getPrefix() + ":" + this.axisService.getName() + "SOAPBinding", null);
            endpoint.addAttribute("address", s, null);
            serviceElement.addChild(endpoint);
        }
    }

    private String getMep(String mep) {
        return "http://www.w3.org/2003/05/soap/mep/soap-response";
    }

    public String getUpdatedMEP(String oldmepuri) {
        return oldmepuri.replaceAll("2004/08", "2006/01");
    }

    private String getPrefix(String targetNameSpace) {
        Map map = this.axisService.getNameSpacesMap();
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!map.get(key).equals(targetNameSpace)) continue;
            return key;
        }
        return null;
    }
}

