/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.ExternalPolicySerializer;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.util.XMLUtils;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.java2wsdl.Java2WSDLConstants;

public class AxisService2OM
implements Java2WSDLConstants {
    private AxisService axisService;
    private String[] serviceEndpointURLs;
    private String targetNamespace;
    private OMElement definition;
    private OMNamespace soap;
    private OMNamespace soap12;
    private OMNamespace http;
    private OMNamespace mime;
    private OMNamespace tns;
    private OMNamespace wsdl;
    private String style;
    private String use;
    private String servicePath;
    private boolean generateHttp = false;
    private HashMap policiesInDefinitions;
    private ExternalPolicySerializer serializer;
    private HashMap messagesMap;
    private String restPath;

    public AxisService2OM(AxisService service, String[] serviceEndpointURLs, String style, String use, String servicePath) {
        this.axisService = service;
        this.serviceEndpointURLs = serviceEndpointURLs;
        this.style = style == null ? "document" : style;
        this.use = use == null ? "literal" : use;
        this.servicePath = servicePath;
        this.targetNamespace = service.getTargetNamespace();
        this.serializer = new ExternalPolicySerializer();
        AxisConfiguration configuration = service.getAxisConfiguration();
        if (configuration != null) {
            this.serializer.setAssertionsToFilter(configuration.getLocalPolicyAssertions());
        }
    }

    public OMElement generateOM() throws Exception {
        Object value;
        AxisDescription axisdesc;
        Parameter parameter;
        this.initURLResolving();
        OMFactory fac = OMAbstractFactory.getOMFactory();
        this.wsdl = fac.createOMNamespace("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        OMElement ele = fac.createOMElement("definitions", this.wsdl);
        this.setDefinitionElement(ele);
        this.policiesInDefinitions = new HashMap();
        Map nameSpaceMap = this.axisService.getNameSpacesMap();
        Iterator keys = nameSpaceMap.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if ("".equals(key)) {
                ele.declareDefaultNamespace((String)nameSpaceMap.get(key));
                continue;
            }
            ele.declareNamespace((String)nameSpaceMap.get(key), key);
        }
        this.soap = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/soap/", "soap");
        this.soap12 = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/soap12/", "soap12");
        this.http = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/http/", "http");
        this.mime = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/mime/", "mime");
        String prefix = this.getPrefix(this.axisService.getTargetNamespace());
        if (prefix == null || "".equals(prefix)) {
            prefix = "axis2";
        }
        this.axisService.getNameSpacesMap().put(prefix, this.axisService.getTargetNamespace());
        this.tns = ele.declareNamespace(this.axisService.getTargetNamespace(), prefix);
        String servicedescription = this.axisService.getServiceDescription();
        if (servicedescription != null && !"".equals(servicedescription)) {
            OMElement documenentattion = fac.createOMElement("documentation", this.wsdl);
            documenentattion.setText(servicedescription);
            ele.addChild(documenentattion);
        }
        ele.addAttribute("targetNamespace", this.axisService.getTargetNamespace(), null);
        OMElement wsdlTypes = fac.createOMElement("types", this.wsdl);
        ele.addChild(wsdlTypes);
        this.axisService.populateSchemaMappings();
        ArrayList schemas = this.axisService.getSchema();
        for (int i = 0; i < schemas.size(); ++i) {
            StringWriter writer = new StringWriter();
            XmlSchema schema = this.axisService.getSchema(i);
            String targetNamespace = schema.getTargetNamespace();
            if ("http://www.w3.org/XML/1998/namespace".equals(targetNamespace)) continue;
            schema.write(writer);
            String schemaString = writer.toString();
            if ("".equals(schemaString)) continue;
            wsdlTypes.addChild(XMLUtils.toOM(new StringReader(schemaString)));
        }
        this.generateMessages(fac, ele);
        this.generatePortType(fac, ele);
        this.generateSOAP11Binding(fac, ele);
        this.generateSOAP12Binding(fac, ele);
        if (this.axisService.getParent() != null && (parameter = (axisdesc = this.axisService.getParent().getParent()).getParameter("enableHTTP")) != null && "true".equals((value = parameter.getValue()).toString())) {
            this.generateHttp = true;
            this.generatePostBinding(fac, ele);
        }
        this.generateService(fac, ele);
        this.addPoliciesToDefinitionElement(this.policiesInDefinitions.values().iterator(), this.definition);
        return ele;
    }

    private void initURLResolving() {
        Parameter restPathParam = this.axisService.getParameter("restPath");
        if (restPathParam != null) {
            this.restPath = ((String)restPathParam.getValue()).trim();
            if (this.restPath.length() <= 0) {
                this.restPath = "rest";
            }
        } else {
            this.restPath = "rest";
        }
    }

    private void generateMessages(OMFactory fac, OMElement defintions) {
        HashSet<String> faultMessageNames = new HashSet<String>();
        this.messagesMap = new HashMap();
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            ArrayList faultyMessages;
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation()) continue;
            String MEP2 = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/2006/01/wsdl/in-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-opt-out".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/out-opt-in".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/robust-out-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/robust-in-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-out".equals(MEP2)) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                this.writeMessage(inaxisMessage, fac, defintions);
                this.generateHeaderMessages(inaxisMessage, fac, defintions);
            }
            if (("http://www.w3.org/2006/01/wsdl/out-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/out-opt-in".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-opt-out".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/robust-out-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-out".equals(MEP2)) && (outAxisMessage = axisOperation.getMessage("Out")) != null) {
                this.writeMessage(outAxisMessage, fac, defintions);
                this.generateHeaderMessages(outAxisMessage, fac, defintions);
            }
            if ((faultyMessages = axisOperation.getFaultMessages()) == null) continue;
            for (int i = 0; i < faultyMessages.size(); ++i) {
                AxisMessage axisMessage = (AxisMessage)faultyMessages.get(i);
                String name = axisMessage.getName();
                if (!faultMessageNames.add(name)) continue;
                this.writeMessage(axisMessage, fac, defintions);
                this.generateHeaderMessages(axisMessage, fac, defintions);
            }
        }
    }

    private void generateHeaderMessages(AxisMessage axismessage, OMFactory fac, OMElement defintions) {
        ArrayList extList = axismessage.getSoapHeaders();
        for (int i = 0; i < extList.size(); ++i) {
            SOAPHeaderMessage header = (SOAPHeaderMessage)extList.get(i);
            OMElement messageElement = fac.createOMElement("message", this.wsdl);
            messageElement.addAttribute("name", header.getMessage().getLocalPart(), null);
            defintions.addChild(messageElement);
            OMElement messagePart = fac.createOMElement("part", this.wsdl);
            messageElement.addChild(messagePart);
            messagePart.addAttribute("name", header.part(), null);
            if (header.getElement() == null) {
                throw new RuntimeException("element is null for " + header.getMessage());
            }
            messagePart.addAttribute("element", this.getPrefix(header.getElement().getNamespaceURI()) + ":" + header.getElement().getLocalPart(), null);
        }
    }

    private void writeMessage(AxisMessage axismessage, OMFactory fac, OMElement defintions) {
        if (this.messagesMap.get(axismessage.getName()) == null) {
            this.messagesMap.put(axismessage.getName(), axismessage);
            QName schemaElementName = axismessage.getElementQName();
            OMElement messageElement = fac.createOMElement("message", this.wsdl);
            messageElement.addAttribute("name", axismessage.getName(), null);
            defintions.addChild(messageElement);
            if (schemaElementName != null) {
                OMElement messagePart = fac.createOMElement("part", this.wsdl);
                messageElement.addChild(messagePart);
                messagePart.addAttribute("name", "part1", null);
                messagePart.addAttribute("element", this.getPrefix(schemaElementName.getNamespaceURI()) + ":" + schemaElementName.getLocalPart(), null);
            }
        }
    }

    private void generatePortType(OMFactory fac, OMElement defintions) throws Exception {
        OMElement portType = fac.createOMElement("portType", this.wsdl);
        defintions.addChild(portType);
        portType.addAttribute("name", this.axisService.getName() + "PortType", null);
        this.addPolicyAsExtAttribute(8, this.axisService.getPolicyInclude(), portType, fac);
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            ArrayList faultyMessages;
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String operationName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            portType.addChild(operation);
            operation.addAttribute("name", operationName, null);
            this.addPolicyAsExtElement(10, axisOperation.getPolicyInclude(), operation, fac);
            String MEP2 = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/2006/01/wsdl/in-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-opt-out".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/out-opt-in".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/robust-out-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/robust-in-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-out".equals(MEP2)) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                OMElement input = fac.createOMElement("input", this.wsdl);
                input.addAttribute("message", this.tns.getPrefix() + ":" + inaxisMessage.getName(), null);
                this.addPolicyAsExtElement(12, inaxisMessage.getPolicyInclude(), input, fac);
                this.addWSAWActionAttribute(input, axisOperation.getInputAction());
                operation.addChild(input);
            }
            if (("http://www.w3.org/2006/01/wsdl/out-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/out-opt-in".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-opt-out".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/robust-out-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-out".equals(MEP2)) && (outAxisMessage = axisOperation.getMessage("Out")) != null) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                output.addAttribute("message", this.tns.getPrefix() + ":" + outAxisMessage.getName(), null);
                this.addPolicyAsExtElement(13, outAxisMessage.getPolicyInclude(), output, fac);
                this.addWSAWActionAttribute(output, axisOperation.getOutputAction());
                operation.addChild(output);
            }
            if ((faultyMessages = axisOperation.getFaultMessages()) == null) continue;
            for (int i = 0; i < faultyMessages.size(); ++i) {
                AxisMessage faultyMessage = (AxisMessage)faultyMessages.get(i);
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                fault.addAttribute("message", this.tns.getPrefix() + ":" + faultyMessage.getName(), null);
                fault.addAttribute("name", faultyMessage.getName(), null);
                this.addWSAWActionAttribute(fault, axisOperation.getFaultAction(faultyMessage.getName()));
                operation.addChild(fault);
            }
        }
    }

    public void generateService(OMFactory fac, OMElement defintions) throws Exception {
        OMElement service = fac.createOMElement("service", this.wsdl);
        defintions.addChild(service);
        service.addAttribute("name", this.axisService.getName(), null);
        this.generateSOAP11Ports(fac, service);
        this.generateSOAP12Ports(fac, service);
        this.addPolicyAsExtElement(6, this.axisService.getPolicyInclude(), service, fac);
        if (this.generateHttp) {
            this.generateHTTPPorts(fac, service);
        }
    }

    private void generateSOAP11Ports(OMFactory fac, OMElement service) throws Exception {
        for (int i = 0; i < this.serviceEndpointURLs.length; ++i) {
            String protocol;
            String urlString = this.serviceEndpointURLs[i];
            if (urlString != null && urlString.indexOf(this.restPath) != -1) continue;
            String string = protocol = urlString == null ? null : new URI(urlString).getScheme();
            if (urlString == null) {
                urlString = "REPLACE_WITH_ACTUAL_URL";
            }
            OMElement port = fac.createOMElement("port", this.wsdl);
            service.addChild(port);
            String name = this.axisService.getName() + "SOAP11port" + (protocol == null ? "" : "_" + protocol);
            if (i > 0) {
                name = name + i;
            }
            port.addAttribute("name", name, null);
            port.addAttribute("binding", this.tns.getPrefix() + ":" + this.axisService.getName() + "SOAP11Binding", null);
            this.addExtensionElement(fac, port, "address", "location", urlString, this.soap);
            this.addPolicyAsExtElement(7, this.axisService.getPolicyInclude(), port, fac);
        }
    }

    private void generateHTTPPorts(OMFactory fac, OMElement service) throws Exception {
        String[] exposedEPRs = this.axisService.getEPRs();
        for (int i = 0; i < exposedEPRs.length; ++i) {
            String urlString = this.serviceEndpointURLs[i];
            if (urlString == null || !urlString.startsWith("http") || urlString.indexOf(this.restPath) <= -1) continue;
            OMElement port = fac.createOMElement("port", this.wsdl);
            service.addChild(port);
            String name = this.axisService.getName() + "Httpport";
            if (i > 0) {
                name = name + i;
            }
            port.addAttribute("name", name, null);
            port.addAttribute("binding", this.tns.getPrefix() + ":" + this.axisService.getName() + "HttpBinding", null);
            OMElement extElement = fac.createOMElement("address", this.http);
            port.addChild(extElement);
            extElement.addAttribute("location", urlString, null);
        }
    }

    private void generateSOAP12Ports(OMFactory fac, OMElement service) throws Exception {
        for (int i = 0; i < this.serviceEndpointURLs.length; ++i) {
            String protocol;
            String urlString = this.serviceEndpointURLs[i];
            if (urlString != null && urlString.indexOf(this.restPath) != -1) continue;
            String string = protocol = urlString == null ? null : new URI(urlString).getScheme();
            if (urlString == null) {
                urlString = "REPLACE_WITH_ACTUAL_URL";
            }
            OMElement port = fac.createOMElement("port", this.wsdl);
            service.addChild(port);
            String name = this.axisService.getName() + "SOAP12port" + (protocol == null ? "" : "_" + protocol);
            if (i > 0) {
                name = name + i;
            }
            port.addAttribute("name", name, null);
            port.addAttribute("binding", this.tns.getPrefix() + ":" + this.axisService.getName() + "SOAP12Binding", null);
            this.addExtensionElement(fac, port, "address", "location", urlString, this.soap12);
            this.addPolicyAsExtElement(7, this.axisService.getPolicyInclude(), port, fac);
        }
    }

    private void generateSOAP11Binding(OMFactory fac, OMElement defintions) throws Exception {
        OMNamespace wsawNamespace;
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        defintions.addChild(binding);
        binding.addAttribute("name", this.axisService.getName() + "SOAP11Binding", null);
        binding.addAttribute("type", this.tns.getPrefix() + ":" + this.axisService.getName() + "PortType", null);
        this.addPolicyAsExtElement(3, this.axisService.getPolicyInclude(), binding, fac);
        this.addPolicyAsExtElement(9, this.axisService.getPolicyInclude(), binding, fac);
        this.addExtensionElement(fac, binding, "binding", "transport", "http://schemas.xmlsoap.org/soap/http", "style", this.style, this.soap);
        if (this.axisService.getWSAddressingFlag().equals("optional")) {
            wsawNamespace = fac.createOMNamespace("http://www.w3.org/2006/05/addressing/wsdl", "wsaw");
            this.addExtensionElement(fac, binding, "UsingAddressing", "wsdl:required", "true", wsawNamespace);
        } else if (this.axisService.getWSAddressingFlag().equals("required")) {
            wsawNamespace = fac.createOMNamespace("http://www.w3.org/2006/05/addressing/wsdl", "wsaw");
            this.addExtensionElement(fac, binding, "UsingAddressing", "wsdl:required", "true", wsawNamespace);
        }
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            ArrayList faultyMessages;
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String operationName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild(operation);
            String soapAction = axisOperation.getInputAction();
            if (soapAction == null) {
                soapAction = "";
            }
            this.addExtensionElement(fac, operation, "operation", "soapAction", soapAction, "style", this.style, this.soap);
            this.addPolicyAsExtElement(11, axisOperation.getPolicyInclude(), operation, fac);
            this.addPolicyAsExtElement(4, axisOperation.getPolicyInclude(), operation, fac);
            String MEP2 = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/2006/01/wsdl/in-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-opt-out".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/out-opt-in".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/robust-out-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/robust-in-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-out".equals(MEP2)) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                operation.addAttribute("name", operationName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                this.addExtensionElement(fac, input, "body", "use", this.use, null, this.targetNamespace, this.soap);
                this.addPolicyAsExtElement(14, inaxisMessage.getPolicyInclude(), input, fac);
                operation.addChild(input);
                this.writeSoapHeaders(inaxisMessage, fac, input, this.soap);
            }
            if (("http://www.w3.org/2006/01/wsdl/out-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/out-opt-in".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-opt-out".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/robust-out-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-out".equals(MEP2)) && (outAxisMessage = axisOperation.getMessage("Out")) != null) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                this.addExtensionElement(fac, output, "body", "use", this.use, null, this.targetNamespace, this.soap);
                this.addPolicyAsExtElement(15, outAxisMessage.getPolicyInclude(), output, fac);
                operation.addChild(output);
                this.writeSoapHeaders(outAxisMessage, fac, output, this.soap);
            }
            if ((faultyMessages = axisOperation.getFaultMessages()) == null) continue;
            for (int i = 0; i < faultyMessages.size(); ++i) {
                AxisMessage faultyMessage = (AxisMessage)faultyMessages.get(i);
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                this.addExtensionElement(fac, fault, "fault", "use", this.use, "name", faultyMessage.getName(), this.soap12);
                fault.addAttribute("name", faultyMessage.getName(), null);
                operation.addChild(fault);
                this.writeSoapHeaders(faultyMessage, fac, fault, this.soap);
            }
        }
    }

    private void generateSOAP12Binding(OMFactory fac, OMElement defintions) throws Exception {
        OMNamespace wsawNamespace;
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        defintions.addChild(binding);
        binding.addAttribute("name", this.axisService.getName() + "SOAP12Binding", null);
        binding.addAttribute("type", this.tns.getPrefix() + ":" + this.axisService.getName() + "PortType", null);
        this.addPolicyAsExtElement(3, this.axisService.getPolicyInclude(), binding, fac);
        this.addPolicyAsExtElement(9, this.axisService.getPolicyInclude(), binding, fac);
        this.addExtensionElement(fac, binding, "binding", "transport", "http://schemas.xmlsoap.org/soap/http", "style", this.style, this.soap12);
        if (this.axisService.getWSAddressingFlag().equals("optional")) {
            wsawNamespace = fac.createOMNamespace("http://www.w3.org/2006/05/addressing/wsdl", "wsaw");
            this.addExtensionElement(fac, binding, "UsingAddressing", "wsdl:required", "true", wsawNamespace);
        } else if (this.axisService.getWSAddressingFlag().equals("required")) {
            wsawNamespace = fac.createOMNamespace("http://www.w3.org/2006/05/addressing/wsdl", "wsaw");
            this.addExtensionElement(fac, binding, "UsingAddressing", "wsdl:required", "true", wsawNamespace);
        }
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            ArrayList faultyMessages;
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String opeartionName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild(operation);
            String soapAction = axisOperation.getInputAction();
            if (soapAction == null) {
                soapAction = "";
            }
            this.addExtensionElement(fac, operation, "operation", "soapAction", soapAction, "style", this.style, this.soap12);
            this.addPolicyAsExtElement(11, axisOperation.getPolicyInclude(), operation, fac);
            this.addPolicyAsExtElement(4, axisOperation.getPolicyInclude(), operation, fac);
            String MEP2 = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/2006/01/wsdl/in-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-opt-out".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/out-opt-in".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/robust-out-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/robust-in-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-out".equals(MEP2)) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                operation.addAttribute("name", opeartionName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                this.addExtensionElement(fac, input, "body", "use", this.use, null, this.targetNamespace, this.soap12);
                this.addPolicyAsExtElement(14, inaxisMessage.getPolicyInclude(), input, fac);
                operation.addChild(input);
                this.writeSoapHeaders(inaxisMessage, fac, input, this.soap12);
            }
            if (("http://www.w3.org/2006/01/wsdl/out-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/out-opt-in".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-opt-out".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/robust-out-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-out".equals(MEP2)) && (outAxisMessage = axisOperation.getMessage("Out")) != null) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                this.addExtensionElement(fac, output, "body", "use", this.use, null, this.targetNamespace, this.soap12);
                this.addPolicyAsExtElement(15, outAxisMessage.getPolicyInclude(), output, fac);
                operation.addChild(output);
                this.writeSoapHeaders(outAxisMessage, fac, output, this.soap12);
            }
            if ((faultyMessages = axisOperation.getFaultMessages()) == null) continue;
            for (int i = 0; i < faultyMessages.size(); ++i) {
                AxisMessage faultyMessage = (AxisMessage)faultyMessages.get(i);
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                this.addExtensionElement(fac, fault, "fault", "use", this.use, "name", faultyMessage.getName(), this.soap12);
                fault.addAttribute("name", faultyMessage.getName(), null);
                operation.addChild(fault);
                this.writeSoapHeaders(faultyMessage, fac, fault, this.soap12);
            }
        }
    }

    private void generatePostBinding(OMFactory fac, OMElement defintions) throws Exception {
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        defintions.addChild(binding);
        binding.addAttribute("name", this.axisService.getName() + "HttpBinding", null);
        binding.addAttribute("type", this.tns.getPrefix() + ":" + this.axisService.getName() + "PortType", null);
        OMElement httpBinding = fac.createOMElement("binding", this.http);
        binding.addChild(httpBinding);
        httpBinding.addAttribute("verb", "POST", null);
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String opeartionName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild(operation);
            OMElement httpOperation = fac.createOMElement("operation", this.http);
            operation.addChild(httpOperation);
            httpOperation.addAttribute("location", axisOperation.getName().getLocalPart(), null);
            String MEP2 = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/2006/01/wsdl/in-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-opt-out".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/out-opt-in".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/robust-out-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/robust-in-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-out".equals(MEP2)) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                operation.addAttribute("name", opeartionName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                OMElement inputelement = fac.createOMElement("content", this.mime);
                input.addChild(inputelement);
                inputelement.addAttribute("type", "text/xml", null);
                operation.addChild(input);
            }
            if (!"http://www.w3.org/2006/01/wsdl/out-only".equals(MEP2) && !"http://www.w3.org/2006/01/wsdl/out-opt-in".equals(MEP2) && !"http://www.w3.org/2006/01/wsdl/in-opt-out".equals(MEP2) && !"http://www.w3.org/2006/01/wsdl/robust-out-only".equals(MEP2) && !"http://www.w3.org/2006/01/wsdl/in-out".equals(MEP2) || (outAxisMessage = axisOperation.getMessage("Out")) == null) continue;
            OMElement output = fac.createOMElement("output", this.wsdl);
            OMElement outElement = fac.createOMElement("content", this.mime);
            outElement.addChild(outElement);
            outElement.addAttribute("type", "text/xml", null);
            output.addChild(outElement);
            operation.addChild(output);
        }
    }

    private void writeSoapHeaders(AxisMessage inaxisMessage, OMFactory fac, OMElement input, OMNamespace soapNameSpace) throws Exception {
        ArrayList extElementList = inaxisMessage.getSoapHeaders();
        if (extElementList != null) {
            Iterator elements = extElementList.iterator();
            while (elements.hasNext()) {
                SOAPHeaderMessage soapheader = (SOAPHeaderMessage)elements.next();
                this.addSOAPHeader(fac, input, soapheader, soapNameSpace);
            }
        }
    }

    private void addExtensionElement(OMFactory fac, OMElement element, String name, String att1Name, String att1Value, String att2Name, String att2Value, OMNamespace soapNameSpace) {
        OMElement soapbinding = fac.createOMElement(name, soapNameSpace);
        element.addChild(soapbinding);
        soapbinding.addAttribute(att1Name, att1Value, null);
        if (att2Name != null) {
            soapbinding.addAttribute(att2Name, att2Value, null);
        }
    }

    private void addExtensionElement(OMFactory fac, OMElement element, String name, String att1Name, String att1Value, OMNamespace soapNameSpace) {
        OMElement extElement = fac.createOMElement(name, soapNameSpace);
        element.addChild(extElement);
        extElement.addAttribute(att1Name, att1Value, null);
    }

    private void setDefinitionElement(OMElement defintion) {
        this.definition = defintion;
    }

    private void addSOAPHeader(OMFactory fac, OMElement element, SOAPHeaderMessage header, OMNamespace soapNameSpace) {
        OMElement extElement = fac.createOMElement("header", soapNameSpace);
        element.addChild(extElement);
        String use = header.getUse();
        if (use != null) {
            extElement.addAttribute("use", use, null);
        }
        if (header.part() != null) {
            extElement.addAttribute("part", header.part(), null);
        }
        if (header.getMessage() != null) {
            extElement.addAttribute("message", this.getPrefix(this.targetNamespace) + ":" + header.getMessage().getLocalPart(), null);
        }
    }

    private String getPrefix(String targetNameSpace) {
        Map map = this.axisService.getNameSpacesMap();
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!map.get(key).equals(targetNameSpace)) continue;
            return key;
        }
        return null;
    }

    private void addWSAWActionAttribute(OMElement element, String action) {
        if (action == null || action.length() == 0) {
            return;
        }
        OMNamespace namespace = element.declareNamespace("http://www.w3.org/2006/05/addressing/wsdl", "wsaw");
        element.addAttribute("Action", action, namespace);
    }

    private void addPolicyAsExtElement(int type, PolicyInclude policyInclude, OMElement element, OMFactory factory) throws Exception {
        ArrayList elementList = policyInclude.getPolicyElements(type);
        Iterator iterator = elementList.iterator();
        while (iterator.hasNext()) {
            Policy p;
            Object policyElement = iterator.next();
            if (policyElement instanceof Policy) {
                element.addChild(PolicyUtil.getPolicyComponentAsOMElement((PolicyComponent)policyElement, this.serializer));
                continue;
            }
            if (!(policyElement instanceof PolicyReference)) continue;
            element.addChild(PolicyUtil.getPolicyComponentAsOMElement((PolicyComponent)policyElement));
            PolicyRegistry reg = policyInclude.getPolicyRegistry();
            String key = ((PolicyReference)policyElement).getURI();
            if (key.startsWith("#")) {
                key = key.substring(key.indexOf("#") + 1);
            }
            if ((p = reg.lookup(key)) == null) {
                throw new Exception("Policy not found for uri : " + key);
            }
            this.addPolicyToDefinitionElement(key, p);
        }
    }

    private void addPolicyAsExtAttribute(int type, PolicyInclude policyInclude, OMElement element, OMFactory factory) throws Exception {
        ArrayList elementList = policyInclude.getPolicyElements(type);
        ArrayList<String> policyURIs = new ArrayList<String>();
        Iterator iterator = elementList.iterator();
        while (iterator.hasNext()) {
            String key;
            Object policyElement = iterator.next();
            if (policyElement instanceof Policy) {
                Policy p = (Policy)policyElement;
                if (p.getId() != null) {
                    key = "#" + p.getId();
                } else if (p.getName() != null) {
                    key = p.getName();
                } else {
                    throw new RuntimeException("Can't add the Policy as an extensibility attribute since it doesn't have a id or a name attribute");
                }
                policyURIs.add(key);
                this.addPolicyToDefinitionElement(key, p);
                continue;
            }
            String uri = ((PolicyReference)policyElement).getURI();
            PolicyRegistry registry = policyInclude.getPolicyRegistry();
            Policy p = registry.lookup(key = uri.startsWith("#") ? uri.substring(uri.indexOf(35) + 1) : uri);
            if (p == null) {
                throw new RuntimeException("Cannot resolve " + uri + " to a Policy");
            }
            this.addPolicyToDefinitionElement(key, p);
        }
        if (!policyURIs.isEmpty()) {
            String value = null;
            Iterator iterator2 = policyURIs.iterator();
            while (iterator2.hasNext()) {
                String uri = (String)iterator2.next();
                value = value == null ? uri : " " + uri;
            }
            OMNamespace ns = factory.createOMNamespace("http://schemas.xmlsoap.org/ws/2004/09/policy", "wsp");
            OMAttribute URIs = factory.createOMAttribute("PolicyURIs", ns, value);
            element.addAttribute(URIs);
        }
    }

    private void addPoliciesToDefinitionElement(Iterator iterator, OMElement definitionElement) throws Exception {
        while (iterator.hasNext()) {
            Policy policy = (Policy)iterator.next();
            OMElement policyElement = PolicyUtil.getPolicyComponentAsOMElement(policy, this.serializer);
            OMNode firstChild = this.definition.getFirstOMChild();
            if (firstChild != null) {
                firstChild.insertSiblingBefore(policyElement);
                continue;
            }
            definitionElement.addChild(policyElement);
        }
    }

    private void addPolicyToDefinitionElement(String key, Policy policy) {
        this.policiesInDefinitions.put(key, policy);
    }
}

