/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.RobustOutOnlyAxisOperation;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.wsdl.WSDLConstants;

public class AxisOperationFactory
implements WSDLConstants {
    public static AxisOperation getAxisOperation(int mepURI) throws AxisFault {
        AxisOperation abOpdesc;
        switch (mepURI) {
            case 10: {
                abOpdesc = new InOnlyAxisOperation();
                abOpdesc.setMessageExchangePattern("http://www.w3.org/2006/01/wsdl/in-only");
                break;
            }
            case 14: {
                abOpdesc = new OutOnlyAxisOperation();
                abOpdesc.setMessageExchangePattern("http://www.w3.org/2006/01/wsdl/out-only");
                break;
            }
            case 12: {
                abOpdesc = new InOutAxisOperation();
                abOpdesc.setMessageExchangePattern("http://www.w3.org/2006/01/wsdl/in-out");
                break;
            }
            case 13: {
                abOpdesc = new InOutAxisOperation();
                abOpdesc.setMessageExchangePattern("http://www.w3.org/2006/01/wsdl/in-opt-out");
                break;
            }
            case 11: {
                abOpdesc = new InOutAxisOperation();
                abOpdesc.setMessageExchangePattern("http://www.w3.org/2006/01/wsdl/robust-in-only");
                break;
            }
            case 16: {
                abOpdesc = new OutInAxisOperation();
                abOpdesc.setMessageExchangePattern("http://www.w3.org/2006/01/wsdl/out-in");
                break;
            }
            case 17: {
                abOpdesc = new OutInAxisOperation();
                abOpdesc.setMessageExchangePattern("http://www.w3.org/2006/01/wsdl/out-opt-in");
                break;
            }
            case 15: {
                abOpdesc = new RobustOutOnlyAxisOperation();
                abOpdesc.setMessageExchangePattern("http://www.w3.org/2006/01/wsdl/robust-out-only");
                break;
            }
            default: {
                throw new AxisFault(Messages.getMessage("unSupportedMEP", "ID is " + mepURI));
            }
        }
        return abOpdesc;
    }

    public static AxisOperation getOperationDescription(String mepURI) throws AxisFault {
        AxisOperation abOpdesc;
        if ("http://www.w3.org/2006/01/wsdl/in-only".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/in-only".equals(mepURI)) {
            abOpdesc = new InOnlyAxisOperation();
        } else if ("http://www.w3.org/2006/01/wsdl/out-only".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/out-only".equals(mepURI)) {
            abOpdesc = new OutOnlyAxisOperation();
        } else if ("http://www.w3.org/2006/01/wsdl/in-out".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/in-out".equals(mepURI)) {
            abOpdesc = new InOutAxisOperation();
        } else if ("http://www.w3.org/2006/01/wsdl/in-opt-out".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(mepURI)) {
            abOpdesc = new InOutAxisOperation();
        } else if ("http://www.w3.org/2006/01/wsdl/out-in".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/out-in".equals(mepURI)) {
            abOpdesc = new OutInAxisOperation();
        } else if ("http://www.w3.org/2006/01/wsdl/out-opt-in".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(mepURI)) {
            abOpdesc = new OutInAxisOperation();
        } else if ("http://www.w3.org/2006/01/wsdl/robust-out-only".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(mepURI)) {
            abOpdesc = new OutInAxisOperation();
        } else if ("http://www.w3.org/2006/01/wsdl/robust-in-only".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(mepURI)) {
            abOpdesc = new InOnlyAxisOperation();
        } else {
            throw new AxisFault(Messages.getMessage("unSupportedMEP", "ID is " + mepURI));
        }
        abOpdesc.setMessageExchangePattern(mepURI);
        return abOpdesc;
    }
}

