/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisError;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.modules.Module;
import org.apache.axis2.phaseresolver.PhaseResolver;
import org.apache.axis2.util.Utils;
import org.apache.axis2.wsdl.WSDLConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AxisOperation
extends AxisDescription
implements WSDLConstants {
    public static final String STYLE_RPC = "rpc";
    public static final String STYLE_MSG = "msg";
    public static final String STYLE_DOC = "doc";
    private static final Log log = LogFactory.getLog(AxisOperation.class);
    private int mep = -1;
    private ArrayList engagedModules = new ArrayList();
    private boolean controlOperation = false;
    private String style = "doc";
    private String mepURI = "http://www.w3.org/2006/01/wsdl/in-out";
    private MessageReceiver messageReceiver;
    private ArrayList understoodHeaderQNames = new ArrayList();
    private HashMap moduleConfigmap;
    private ArrayList modulerefs;
    private ArrayList faultMessages;
    private QName name;
    private ArrayList wsamappingList;
    private String outputAction;
    private HashMap faultActions = new HashMap();
    private String soapAction;

    public AxisOperation() {
        this.modulerefs = new ArrayList();
        this.moduleConfigmap = new HashMap();
        this.faultMessages = new ArrayList();
        QName tmpName = new QName(this.getClass().getName() + "_" + UUIDGenerator.getUUID());
        this.setName(tmpName);
    }

    public AxisOperation(QName name) {
        this();
        this.setName(name);
    }

    public abstract void addMessage(AxisMessage var1, String var2);

    public abstract void addMessageContext(MessageContext var1, OperationContext var2) throws AxisFault;

    public abstract void removeMessageContext(String var1, OperationContext var2) throws AxisFault;

    public abstract void addFaultMessageContext(MessageContext var1, OperationContext var2) throws AxisFault;

    public void addModule(QName moduleName) {
        this.modulerefs.add(moduleName);
    }

    public void addModuleConfig(ModuleConfiguration moduleConfiguration) {
        this.moduleConfigmap.put(moduleConfiguration.getModuleName(), moduleConfiguration);
    }

    public final void engageModule(AxisModule moduleref, AxisConfiguration axisConfig) throws AxisFault {
        ArrayList moduleOperations = this.engageModuleToOperation(moduleref, axisConfig);
        AxisService service = (AxisService)this.getParent();
        if (service != null) {
            for (int i = 0; i < moduleOperations.size(); ++i) {
                AxisOperation axisOperation = (AxisOperation)moduleOperations.get(i);
                service.addOperation(axisOperation);
            }
        }
    }

    private ArrayList engageModuleToOperation(AxisModule moduleref, AxisConfiguration axisConfig) throws AxisFault {
        if (moduleref == null) {
            return null;
        }
        Iterator module_itr = this.engagedModules.iterator();
        QName moduleName = moduleref.getName();
        while (module_itr.hasNext()) {
            AxisModule module = (AxisModule)module_itr.next();
            QName modu = module.getName();
            boolean isEngagable = Utils.checkVersion(moduleName, modu);
            if (isEngagable) continue;
            return new ArrayList();
        }
        PhaseResolver phaseResolver = new PhaseResolver(axisConfig);
        phaseResolver.engageModuleToOperation(this, moduleref);
        Module module = moduleref.getModule();
        if (module != null) {
            module.engageNotify(this);
        }
        this.engagedModules.add(moduleref);
        return this.addModuleOperations(moduleref, axisConfig, (AxisService)this.getParent());
    }

    public void disengageModule(AxisModule module) {
        if (module != null) {
            if (this.getParent() != null) {
                AxisService service = (AxisService)this.getParent();
                AxisConfiguration axiConfiguration = service.getAxisConfiguration();
                PhaseResolver phaseResolver = new PhaseResolver(axiConfiguration);
                if (service.isEngaged(module.getName())) {
                    phaseResolver.disengageModuleFromOperationChain(module, this);
                } else if (axiConfiguration != null && axiConfiguration.isEngaged(module.getName())) {
                    phaseResolver.disengageModuleFromOperationChain(module, this);
                } else {
                    if (axiConfiguration != null) {
                        phaseResolver.disengageModuleFromGlobalChains(module);
                    }
                    phaseResolver.disengageModuleFromOperationChain(module, this);
                    HashMap moduleOperations = module.getOperations();
                    if (moduleOperations != null) {
                        Iterator moduleOperations_itr = moduleOperations.values().iterator();
                        while (moduleOperations_itr.hasNext()) {
                            AxisOperation operation = (AxisOperation)moduleOperations_itr.next();
                            service.removeOperation(operation.getName());
                        }
                    }
                }
            }
            this.engagedModules.remove(module);
            log.debug("removed module from engaged modules list " + module.getName().getLocalPart());
        }
    }

    public void removeFromEngagedModuleList(AxisModule module) {
        this.engagedModules.remove(module);
        log.debug("removed module from engaged modules list " + module.getName().getLocalPart());
    }

    public ArrayList addModuleOperations(AxisModule module, AxisConfiguration axisConfig, AxisService service) throws AxisFault {
        HashMap map = module.getOperations();
        Collection col = map.values();
        PhaseResolver phaseResolver = new PhaseResolver(axisConfig);
        ArrayList<AxisOperation> ops = new ArrayList<AxisOperation>();
        Iterator iterator = col.iterator();
        while (iterator.hasNext()) {
            AxisOperation axisOperation = this.copyOperation((AxisOperation)iterator.next());
            axisOperation.setParent(service);
            ArrayList wsamappings = axisOperation.getWsamappingList();
            if (service.getOperation(axisOperation.getName()) != null) continue;
            axisOperation.setControlOperation(true);
            Module moduleclazz = module.getModule();
            if (moduleclazz != null) {
                moduleclazz.engageNotify(axisOperation);
            }
            phaseResolver.engageModuleToOperation(axisOperation, module);
            ops.add(axisOperation);
            if (wsamappings == null) continue;
            for (int j = 0; j < wsamappings.size(); ++j) {
                String mapping = (String)wsamappings.get(j);
                service.mapActionToOperation(mapping, axisOperation);
            }
        }
        return ops;
    }

    private AxisOperation copyOperation(AxisOperation axisOperation) throws AxisFault {
        AxisOperation operation = AxisOperationFactory.getOperationDescription(axisOperation.getMessageExchangePattern());
        operation.setMessageReceiver(axisOperation.getMessageReceiver());
        operation.setName(axisOperation.getName());
        Iterator parameters = axisOperation.getParameters().iterator();
        while (parameters.hasNext()) {
            Parameter parameter = (Parameter)parameters.next();
            operation.addParameter(parameter);
        }
        operation.setWsamappingList(axisOperation.getWsamappingList());
        operation.setOutputAction(axisOperation.getOutputAction());
        String[] faultActionNames = axisOperation.getFaultActionNames();
        for (int i = 0; i < faultActionNames.length; ++i) {
            operation.addFaultAction(faultActionNames[i], axisOperation.getFaultAction(faultActionNames[i]));
        }
        operation.setRemainingPhasesInFlow(axisOperation.getRemainingPhasesInFlow());
        operation.setPhasesInFaultFlow(axisOperation.getPhasesInFaultFlow());
        operation.setPhasesOutFaultFlow(axisOperation.getPhasesOutFaultFlow());
        operation.setPhasesOutFlow(axisOperation.getPhasesOutFlow());
        return operation;
    }

    public OperationContext findForExistingOperationContext(MessageContext msgContext) throws AxisFault {
        ConfigurationContext configContext;
        OperationContext operationContext = msgContext.getOperationContext();
        if (operationContext != null) {
            return operationContext;
        }
        if (null != msgContext.getRelatesTo() && null == (operationContext = (configContext = msgContext.getConfigurationContext()).getOperationContext(msgContext.getRelatesTo().getValue())) && log.isDebugEnabled()) {
            log.debug(msgContext.getLogIDString() + " Cannot correlate inbound message RelatesTo value [" + msgContext.getRelatesTo() + "] to in-progree MEP");
        }
        return operationContext;
    }

    public OperationContext findOperationContext(MessageContext msgContext, ServiceContext serviceContext) throws AxisFault {
        OperationContext operationContext;
        if (null == msgContext.getRelatesTo()) {
            operationContext = ContextFactory.createOperationContext(this, serviceContext);
        } else {
            ConfigurationContext configContext = msgContext.getConfigurationContext();
            operationContext = configContext.getOperationContext(msgContext.getRelatesTo().getValue());
            if (null == operationContext) {
                throw new AxisFault(Messages.getMessage("cannotCorrelateMsg", this.name.toString(), msgContext.getRelatesTo().getValue()));
            }
        }
        return operationContext;
    }

    public void registerOperationContext(MessageContext msgContext, OperationContext operationContext) throws AxisFault {
        msgContext.setAxisOperation(this);
        msgContext.getConfigurationContext().registerOperationContext(msgContext.getMessageID(), operationContext);
        operationContext.addMessageContext(msgContext);
        msgContext.setOperationContext(operationContext);
        if (operationContext.isComplete()) {
            operationContext.cleanup();
        }
    }

    public void registerMessageContext(MessageContext msgContext, OperationContext operationContext) throws AxisFault {
        msgContext.setAxisOperation(this);
        operationContext.addMessageContext(msgContext);
        msgContext.setOperationContext(operationContext);
        if (operationContext.isComplete()) {
            operationContext.cleanup();
        }
    }

    public int getAxisSpecifMEPConstant() {
        if (this.mep != -1) {
            return this.mep;
        }
        int temp = -1;
        if ("http://www.w3.org/2006/01/wsdl/in-out".equals(this.mepURI)) {
            temp = 12;
        } else if ("http://www.w3.org/2006/01/wsdl/in-only".equals(this.mepURI)) {
            temp = 10;
        } else if ("http://www.w3.org/2006/01/wsdl/in-opt-out".equals(this.mepURI)) {
            temp = 13;
        } else if ("http://www.w3.org/2006/01/wsdl/out-in".equals(this.mepURI)) {
            temp = 16;
        } else if ("http://www.w3.org/2006/01/wsdl/out-only".equals(this.mepURI)) {
            temp = 14;
        } else if ("http://www.w3.org/2006/01/wsdl/out-opt-in".equals(this.mepURI)) {
            temp = 17;
        } else if ("http://www.w3.org/2006/01/wsdl/robust-in-only".equals(this.mepURI)) {
            temp = 11;
        } else if ("http://www.w3.org/2006/01/wsdl/robust-out-only".equals(this.mepURI)) {
            temp = 15;
        }
        if (temp == -1) {
            throw new AxisError(Messages.getMessage("mepmappingerror"));
        }
        this.mep = temp;
        return this.mep;
    }

    public Collection getEngagedModules() {
        return this.engagedModules;
    }

    public abstract AxisMessage getMessage(String var1);

    public String getMessageExchangePattern() {
        return this.mepURI;
    }

    public MessageReceiver getMessageReceiver() {
        return this.messageReceiver;
    }

    public ModuleConfiguration getModuleConfig(QName moduleName) {
        return (ModuleConfiguration)this.moduleConfigmap.get(moduleName);
    }

    public ArrayList getModuleRefs() {
        return this.modulerefs;
    }

    public QName getName() {
        return this.name;
    }

    public abstract ArrayList getPhasesInFaultFlow();

    public abstract ArrayList getPhasesOutFaultFlow();

    public abstract ArrayList getPhasesOutFlow();

    public abstract ArrayList getRemainingPhasesInFlow();

    public String getStyle() {
        return this.style;
    }

    public ArrayList getWsamappingList() {
        return this.wsamappingList;
    }

    public boolean isControlOperation() {
        return this.controlOperation;
    }

    public boolean isParameterLocked(String parameterName) {
        boolean locked = false;
        if (this.getParent() != null) {
            locked = this.getParent().isParameterLocked(parameterName);
        }
        if (locked) {
            return true;
        }
        Parameter parameter = this.getParameter(parameterName);
        return parameter != null && parameter.isLocked();
    }

    public void setControlOperation(boolean controlOperation) {
        this.controlOperation = controlOperation;
    }

    public void setMessageExchangePattern(String mepURI) {
        this.mepURI = mepURI;
    }

    public void setMessageReceiver(MessageReceiver messageReceiver) {
        this.messageReceiver = messageReceiver;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public abstract void setPhasesInFaultFlow(ArrayList var1);

    public abstract void setPhasesOutFaultFlow(ArrayList var1);

    public abstract void setPhasesOutFlow(ArrayList var1);

    public abstract void setRemainingPhasesInFlow(ArrayList var1);

    public void setStyle(String style) {
        if (!"".equals(style)) {
            this.style = style;
        }
    }

    public void setWsamappingList(ArrayList wsamappingList) {
        this.wsamappingList = wsamappingList;
    }

    public OperationClient createClient(ServiceContext sc, Options options) {
        throw new UnsupportedOperationException(Messages.getMessage("mepnotyetimplemented", this.mepURI));
    }

    public Object getKey() {
        return this.name;
    }

    public ArrayList getFaultMessages() {
        return this.faultMessages;
    }

    public void setFaultMessages(AxisMessage faultMessage) {
        this.faultMessages.add(faultMessage);
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public String getInputAction() {
        String result = null;
        if (this.soapAction != null && !"".equals(this.soapAction)) {
            result = this.soapAction;
        } else if (this.wsamappingList != null && !this.wsamappingList.isEmpty()) {
            result = (String)this.wsamappingList.get(0);
        }
        return result;
    }

    public String getOutputAction() {
        return this.outputAction;
    }

    public void setOutputAction(String act) {
        this.outputAction = act;
    }

    public void addFaultAction(String faultName, String action) {
        this.faultActions.put(faultName, action);
    }

    public void removeFaultAction(String faultName) {
        this.faultActions.remove(faultName);
    }

    public String getFaultAction(String faultName) {
        return (String)this.faultActions.get(faultName);
    }

    public String[] getFaultActionNames() {
        Set keys = this.faultActions.keySet();
        String[] faultActionNames = new String[keys.size()];
        faultActionNames = keys.toArray(faultActionNames);
        return faultActionNames;
    }

    public String getFaultAction() {
        String result = null;
        Iterator iter = this.faultActions.values().iterator();
        if (iter.hasNext()) {
            result = (String)iter.next();
        }
        return result;
    }

    public boolean isEngaged(QName moduleName) {
        Iterator engagedModuleItr = this.engagedModules.iterator();
        while (engagedModuleItr.hasNext()) {
            AxisModule axisModule = (AxisModule)engagedModuleItr.next();
            if (!axisModule.getName().getLocalPart().equals(moduleName.getLocalPart())) continue;
            return true;
        }
        return false;
    }

    public ArrayList getUnderstoodHeaderQNames() {
        return this.understoodHeaderQNames;
    }

    public void registerUnderstoodHeaderQName(QName understoodHeader) {
        if (understoodHeader != null) {
            this.understoodHeaderQNames.add(understoodHeader);
        }
    }
}

