/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceDeployer
implements Deployer {
    private static final Log log = LogFactory.getLog(ServiceDeployer.class);
    private AxisConfiguration axisConfig;
    private ConfigurationContext configCtx;

    public void init(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
        this.axisConfig = this.configCtx.getAxisConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentFileData deploymentFileData) {
        boolean explodedDir = deploymentFileData.getFile().isDirectory();
        StringWriter errorWriter = new StringWriter();
        ArchiveReader archiveReader = new ArchiveReader();
        String serviceStatus = "";
        try {
            deploymentFileData.setClassLoader(explodedDir, this.axisConfig.getServiceClassLoader());
            HashMap wsdlservice = archiveReader.processWSDLs(deploymentFileData);
            if (wsdlservice != null && wsdlservice.size() > 0) {
                Iterator services = wsdlservice.values().iterator();
                while (services.hasNext()) {
                    AxisService service = (AxisService)services.next();
                    Iterator operations = service.getOperations();
                    while (operations.hasNext()) {
                        AxisOperation axisOperation = (AxisOperation)operations.next();
                        this.axisConfig.getPhasesInfo().setOperationPhases(axisOperation);
                    }
                }
            }
            AxisServiceGroup sericeGroup = new AxisServiceGroup(this.axisConfig);
            sericeGroup.setServiceGroupClassLoader(deploymentFileData.getClassLoader());
            ArrayList serviceList = archiveReader.processServiceGroup(deploymentFileData.getAbsolutePath(), deploymentFileData, sericeGroup, explodedDir, wsdlservice, this.configCtx);
            DeploymentEngine.addServiceGroup(sericeGroup, serviceList, deploymentFileData.getFile().toURL(), deploymentFileData, this.axisConfig);
            log.info(Messages.getMessage("deployingws", deploymentFileData.getName()));
        }
        catch (DeploymentException de) {
            de.printStackTrace();
            log.error(Messages.getMessage("invalidservice", deploymentFileData.getName(), de.getMessage()), de);
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            de.printStackTrace(error_ptintWriter);
            serviceStatus = "Error:\n" + errorWriter.toString();
        }
        catch (AxisFault axisFault) {
            log.error(Messages.getMessage("invalidservice", deploymentFileData.getName(), axisFault.getMessage()), axisFault);
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            axisFault.printStackTrace(error_ptintWriter);
            serviceStatus = "Error:\n" + errorWriter.toString();
        }
        catch (Exception e) {
            if (log.isInfoEnabled()) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                log.info(Messages.getMessage("invalidservice", deploymentFileData.getName(), sw.getBuffer().toString()));
            }
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            e.printStackTrace(error_ptintWriter);
            serviceStatus = "Error:\n" + errorWriter.toString();
        }
        catch (Throwable t) {
            if (log.isInfoEnabled()) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                log.info(Messages.getMessage("invalidservice", deploymentFileData.getName(), sw.getBuffer().toString()));
            }
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            t.printStackTrace(error_ptintWriter);
            serviceStatus = "Error:\n" + errorWriter.toString();
        }
        finally {
            if (serviceStatus.startsWith("Error:")) {
                this.axisConfig.getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), serviceStatus);
            }
        }
    }

    public void setDirectory(String directory) {
    }

    public void setExtension(String extension) {
    }

    public void unDeploy(String fileName) {
        try {
            fileName = DeploymentEngine.getAxisServiceName(fileName);
            AxisServiceGroup serviceGroup = this.axisConfig.removeServiceGroup(fileName);
            this.configCtx.removeServiceGroupContext(serviceGroup);
            log.info(Messages.getMessage("serviceremoved", fileName));
        }
        catch (AxisFault axisFault) {
            this.axisConfig.removeFaultyService(fileName);
        }
    }
}

