/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModuleDeployer
implements Deployer {
    private static final Log log = LogFactory.getLog(ModuleDeployer.class);
    private AxisConfiguration axisConfig;

    public ModuleDeployer() {
    }

    public ModuleDeployer(AxisConfiguration axisConfig) {
        this.axisConfig = axisConfig;
    }

    public void init(ConfigurationContext configCtx) {
        this.axisConfig = configCtx.getAxisConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentFileData deploymentFileData) {
        ArchiveReader archiveReader = new ArchiveReader();
        String moduleStatus = "";
        StringWriter errorWriter = new StringWriter();
        boolean explodedDir = deploymentFileData.getFile().isDirectory();
        try {
            deploymentFileData.setClassLoader(explodedDir, this.axisConfig.getModuleClassLoader());
            AxisModule metaData = new AxisModule();
            metaData.setModuleClassLoader(deploymentFileData.getClassLoader());
            metaData.setParent(this.axisConfig);
            archiveReader.readModuleArchive(deploymentFileData, metaData, explodedDir, this.axisConfig);
            metaData.setFileName(deploymentFileData.getFile().toURL());
            DeploymentEngine.addNewModule(metaData, this.axisConfig);
            log.info(Messages.getMessage("deployeingmodule", metaData.getName().getLocalPart()));
        }
        catch (DeploymentException e) {
            log.error(Messages.getMessage("invalidmodule", deploymentFileData.getName(), e.getMessage()), e);
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            e.printStackTrace(error_ptintWriter);
            moduleStatus = "Error:\n" + errorWriter.toString();
        }
        catch (AxisFault axisFault) {
            log.error(Messages.getMessage("invalidmodule", deploymentFileData.getName(), axisFault.getMessage()), axisFault);
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            axisFault.printStackTrace(error_ptintWriter);
            moduleStatus = "Error:\n" + errorWriter.toString();
        }
        catch (MalformedURLException e) {
            log.error(Messages.getMessage("invalidmodule", deploymentFileData.getName(), e.getMessage()), e);
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            e.printStackTrace(error_ptintWriter);
            moduleStatus = "Error:\n" + errorWriter.toString();
        }
        catch (Throwable t) {
            if (log.isInfoEnabled()) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                log.error(Messages.getMessage("invalidmodule", deploymentFileData.getName(), t.getMessage()), t);
            }
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            t.printStackTrace(error_ptintWriter);
            moduleStatus = "Error:\n" + errorWriter.toString();
        }
        finally {
            if (moduleStatus.startsWith("Error:")) {
                this.axisConfig.getFaultyModules().put(DeploymentEngine.getAxisServiceName(deploymentFileData.getName()), moduleStatus);
            }
        }
    }

    public void setDirectory(String directory) {
    }

    public void setExtension(String extension) {
    }

    public void unDeploy(String fileName) {
    }
}

