/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.InputStream;
import java.io.StringWriter;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.modules.Module;
import org.apache.axis2.util.Loader;

public class ModuleBuilder
extends DescriptionBuilder {
    private AxisModule module;

    public ModuleBuilder(InputStream serviceInputStream, AxisModule module, AxisConfiguration axisConfig) {
        super(serviceInputStream, axisConfig);
        this.module = module;
    }

    private void loadModuleClass(AxisModule module, String moduleClassName) throws DeploymentException {
        block4: {
            try {
                Class moduleClass;
                if (moduleClassName == null || "".equals(moduleClassName)) break block4;
                final Class fmoduleClass = moduleClass = Loader.loadClass(module.getModuleClassLoader(), moduleClassName);
                final AxisModule fmodule = module;
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IllegalAccessException, InstantiationException {
                            Module new_module = (Module)fmoduleClass.newInstance();
                            fmodule.setModule(new_module);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
            catch (Exception e) {
                throw new DeploymentException(e.getMessage(), e);
            }
        }
    }

    public void populateModule() throws DeploymentException {
        try {
            OMElement localPolicyAssertionElement;
            OMElement supportedPolicyNamespaces;
            OMElement outFaultFlow;
            OMElement inFaultFlow;
            OMElement outFlow;
            Iterator policyRefElements;
            OMElement descriptionElement;
            String moduleClass;
            OMElement moduleElement = this.buildOM();
            OMAttribute moduleClassAtt = moduleElement.getAttribute(new QName("class"));
            if (moduleClassAtt != null && (moduleClass = moduleClassAtt.getAttributeValue()) != null && !"".equals(moduleClass)) {
                this.loadModuleClass(this.module, moduleClass);
            }
            if ((descriptionElement = moduleElement.getFirstChildWithName(new QName("description"))) != null) {
                OMElement descriptionValue = descriptionElement.getFirstElement();
                if (descriptionValue != null) {
                    StringWriter writer = new StringWriter();
                    descriptionValue.build();
                    descriptionValue.serialize(writer);
                    writer.flush();
                    this.module.setModuleDescription(writer.toString());
                } else {
                    this.module.setModuleDescription(descriptionElement.getText());
                }
            } else {
                this.module.setModuleDescription("module description not found");
            }
            Iterator policyElements = moduleElement.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy"));
            if (policyElements != null && policyElements.hasNext()) {
                this.processPolicyElements(2, policyElements, this.module.getPolicyInclude());
            }
            if ((policyRefElements = moduleElement.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference"))) != null && policyElements.hasNext()) {
                this.processPolicyRefElements(2, policyRefElements, this.module.getPolicyInclude());
            }
            Iterator itr = moduleElement.getChildrenWithName(new QName("parameter"));
            this.processParameters(itr, this.module, this.module.getParent());
            OMElement inFlow = moduleElement.getFirstChildWithName(new QName("InFlow"));
            if (inFlow != null) {
                this.module.setInFlow(this.processFlow(inFlow, this.module));
            }
            if ((outFlow = moduleElement.getFirstChildWithName(new QName("OutFlow"))) != null) {
                this.module.setOutFlow(this.processFlow(outFlow, this.module));
            }
            if ((inFaultFlow = moduleElement.getFirstChildWithName(new QName("InFaultFlow"))) != null) {
                this.module.setFaultInFlow(this.processFlow(inFaultFlow, this.module));
            }
            if ((outFaultFlow = moduleElement.getFirstChildWithName(new QName("OutFaultFlow"))) != null) {
                this.module.setFaultOutFlow(this.processFlow(outFaultFlow, this.module));
            }
            if ((supportedPolicyNamespaces = moduleElement.getFirstChildWithName(new QName("supported-policy-namespaces"))) != null) {
                this.module.setSupportedPolicyNamespaces(this.processSupportedPolicyNamespaces(supportedPolicyNamespaces));
            }
            if ((localPolicyAssertionElement = moduleElement.getFirstChildWithName(new QName("local-policy-assertions"))) != null) {
                this.module.setLocalPolicyAssertions(this.getLocalPolicyAssertionNames(localPolicyAssertionElement));
            }
            Iterator op_itr = moduleElement.getChildrenWithName(new QName("operation"));
            ArrayList operations = this.processOperations(op_itr);
            for (int i = 0; i < operations.size(); ++i) {
                AxisOperation operation = (AxisOperation)operations.get(i);
                this.module.addOperation(operation);
            }
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
    }

    private ArrayList processOperations(Iterator operationsIterator) throws DeploymentException {
        ArrayList<AxisOperation> operations = new ArrayList<AxisOperation>();
        while (operationsIterator.hasNext()) {
            AxisOperation op_descrip;
            OMElement operation = (OMElement)operationsIterator.next();
            OMAttribute op_name_att = operation.getAttribute(new QName("name"));
            if (op_name_att == null) {
                throw new DeploymentException(Messages.getMessage(Messages.getMessage("invalid_op", "operation name missing")));
            }
            OMAttribute op_mep_att = operation.getAttribute(new QName("mep"));
            String mepURL = null;
            if (op_mep_att != null) {
                mepURL = op_mep_att.getAttributeValue();
            }
            if (mepURL == null) {
                op_descrip = new InOnlyAxisOperation();
            } else {
                try {
                    op_descrip = AxisOperationFactory.getOperationDescription(mepURL);
                }
                catch (AxisFault axisFault) {
                    throw new DeploymentException(Messages.getMessage(Messages.getMessage("op_error", axisFault.getMessage())));
                }
            }
            String opname = op_name_att.getAttributeValue();
            op_descrip.setName(new QName(opname));
            Iterator parameters = operation.getChildrenWithName(new QName("parameter"));
            this.processParameters(parameters, op_descrip, this.module);
            this.processActionMappings(operation, op_descrip);
            OMElement receiverElement = operation.getFirstChildWithName(new QName("messageReceiver"));
            if (receiverElement != null) {
                MessageReceiver messageReceiver = this.loadMessageReceiver(this.module.getModuleClassLoader(), receiverElement);
                op_descrip.setMessageReceiver(messageReceiver);
            } else {
                MessageReceiver msgReceiver = this.loadDefaultMessageReceiver(mepURL, null);
                op_descrip.setMessageReceiver(msgReceiver);
            }
            Iterator modules = operation.getChildrenWithName(new QName("module"));
            this.processOperationModuleRefs(modules, op_descrip);
            PhasesInfo info = this.axisConfig.getPhasesInfo();
            try {
                info.setOperationPhases(op_descrip);
            }
            catch (AxisFault axisFault) {
                throw new DeploymentException(axisFault);
            }
            operations.add(op_descrip);
        }
        return operations;
    }
}

