/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AxisConfigBuilder;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentClassLoader;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.ModuleBuilder;
import org.apache.axis2.deployment.ModuleDeployer;
import org.apache.axis2.deployment.RepositoryListener;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.deployment.ServiceDeployer;
import org.apache.axis2.deployment.ServiceGroupBuilder;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.repository.util.WSInfo;
import org.apache.axis2.deployment.scheduler.DeploymentIterator;
import org.apache.axis2.deployment.scheduler.Scheduler;
import org.apache.axis2.deployment.scheduler.SchedulerTask;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeploymentEngine
implements DeploymentConstants {
    private static final Log log = LogFactory.getLog(DeploymentEngine.class);
    protected boolean hotUpdate = true;
    protected boolean hotDeployment = true;
    protected boolean antiJARLocking = false;
    protected List wsToDeploy = new ArrayList();
    protected List wsToUnDeploy = new ArrayList();
    protected static String webLocationString = null;
    protected AxisConfiguration axisConfig;
    protected ConfigurationContext configContext;
    protected RepositoryListener repoListener;
    protected String servicesPath = null;
    protected File servicesDir = null;
    protected String modulesPath = null;
    protected File modulesDir = null;
    private File repositoryDir = null;
    protected ServiceDeployer serviceDeployer;
    protected ModuleDeployer moduleDeployer;
    private HashMap directoryToExtensionMappingMap = new HashMap();
    private HashMap extensioToDeployerMappingMap = new HashMap();

    public void loadServices() {
        this.repoListener.checkServices();
        if (this.hotDeployment) {
            this.startSearch(this.repoListener);
        }
    }

    public void loadRepository(String repoDir) throws DeploymentException {
        File axisRepo = new File(repoDir);
        if (!axisRepo.exists()) {
            throw new DeploymentException(Messages.getMessage("cannotfindrepo", repoDir));
        }
        this.setDeploymentFeatures();
        this.prepareRepository(repoDir);
        this.setClassLoaders(repoDir);
        this.repoListener = new RepositoryListener(this, false);
        org.apache.axis2.util.Utils.calculateDefaultModuleVersion(this.axisConfig.getModules(), this.axisConfig);
        try {
            try {
                this.axisConfig.setRepository(axisRepo.toURL());
            }
            catch (MalformedURLException e) {
                log.info(e.getMessage());
            }
            this.axisConfig.validateSystemPredefinedPhases();
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault);
        }
    }

    public void loadFromClassPath() throws DeploymentException {
        new RepositoryListener(this, true);
        org.apache.axis2.util.Utils.calculateDefaultModuleVersion(this.axisConfig.getModules(), this.axisConfig);
        this.axisConfig.validateSystemPredefinedPhases();
        try {
            this.engageModules();
        }
        catch (AxisFault axisFault) {
            log.info(Messages.getMessage("modulevalfailed", axisFault.getMessage()));
            throw new DeploymentException(axisFault);
        }
    }

    public void loadServicesFromUrl(URL repoURL) {
        try {
            String path;
            String string = path = this.servicesPath == null ? "services" : this.servicesPath;
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            URL servicesDir = new URL(repoURL, path);
            URL filelisturl = new URL(servicesDir, "services.list");
            ArrayList files = this.getFileList(filelisturl);
            Iterator fileIterator = files.iterator();
            while (fileIterator.hasNext()) {
                String fileUrl = (String)fileIterator.next();
                if (!fileUrl.endsWith(".aar")) continue;
                AxisServiceGroup serviceGroup = new AxisServiceGroup();
                URL servicesURL = new URL(servicesDir, fileUrl);
                ArrayList servicelist = this.populateService(serviceGroup, servicesURL, fileUrl.substring(0, fileUrl.indexOf(".aar")));
                DeploymentEngine.addServiceGroup(serviceGroup, servicelist, servicesURL, null, this.axisConfig);
            }
        }
        catch (MalformedURLException e) {
            log.info(e.getMessage());
        }
        catch (IOException e) {
            log.info(e.getMessage());
        }
    }

    public void loadRepositoryFromURL(URL repoURL) throws DeploymentException {
        try {
            String path;
            String string = path = this.modulesPath == null ? "modules" : this.modulesPath;
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            URL moduleDir = new URL(repoURL, path);
            URL filelisturl = new URL(moduleDir, "modules.list");
            ArrayList files = this.getFileList(filelisturl);
            Iterator fileIterator = files.iterator();
            while (fileIterator.hasNext()) {
                String fileUrl = (String)fileIterator.next();
                if (!fileUrl.endsWith(".mar")) continue;
                URL moduleurl = new URL(moduleDir, fileUrl);
                DeploymentClassLoader deploymentClassLoader = new DeploymentClassLoader(new URL[]{moduleurl}, this.axisConfig.getModuleClassLoader(), this.antiJARLocking);
                AxisModule module = new AxisModule();
                module.setModuleClassLoader(deploymentClassLoader);
                module.setParent(this.axisConfig);
                String moduleName = fileUrl.substring(0, fileUrl.indexOf(".mar"));
                module.setName(new QName(moduleName));
                this.populateModule(module, moduleurl);
                module.setFileName(moduleurl);
                DeploymentEngine.addNewModule(module, this.axisConfig);
            }
            org.apache.axis2.util.Utils.calculateDefaultModuleVersion(this.axisConfig.getModules(), this.axisConfig);
            this.axisConfig.validateSystemPredefinedPhases();
        }
        catch (MalformedURLException e) {
            throw new DeploymentException(e);
        }
        catch (IOException e) {
            throw new DeploymentException(e);
        }
    }

    private void populateModule(AxisModule module, URL moduleUrl) throws DeploymentException {
        try {
            ClassLoader classLoadere = module.getModuleClassLoader();
            InputStream moduleStream = classLoadere.getResourceAsStream("META-INF/module.xml");
            if (moduleStream == null) {
                moduleStream = classLoadere.getResourceAsStream("meta-inf/module.xml");
            }
            if (moduleStream == null) {
                throw new DeploymentException(Messages.getMessage("modulexmlnotfound", moduleUrl.toString()));
            }
            ModuleBuilder moduleBuilder = new ModuleBuilder(moduleStream, module, this.axisConfig);
            moduleBuilder.populateModule();
        }
        catch (IOException e) {
            throw new DeploymentException(e);
        }
    }

    protected ArrayList populateService(AxisServiceGroup serviceGroup, URL servicesURL, String serviceName) throws DeploymentException {
        try {
            InputStream servicexmlStream;
            serviceGroup.setServiceGroupName(serviceName);
            DeploymentClassLoader serviceClassLoader = new DeploymentClassLoader(new URL[]{servicesURL}, this.axisConfig.getServiceClassLoader(), this.antiJARLocking);
            String metainf = "meta-inf";
            serviceGroup.setServiceGroupClassLoader(serviceClassLoader);
            InputStream wsdlfilesStream = serviceClassLoader.getResourceAsStream("meta-inf/wsdl.list");
            if (wsdlfilesStream == null && (wsdlfilesStream = serviceClassLoader.getResourceAsStream("META-INF/wsdl.list")) != null) {
                metainf = "META-INF";
            }
            HashMap<String, AxisService> servicesMap = new HashMap<String, AxisService>();
            if (wsdlfilesStream != null) {
                String line;
                ArchiveReader reader = new ArchiveReader();
                BufferedReader input = new BufferedReader(new InputStreamReader(wsdlfilesStream));
                while ((line = input.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    line = metainf + "/" + line;
                    try {
                        AxisService service = reader.getAxisServiceFromWsdl(serviceClassLoader.getResourceAsStream(line), serviceClassLoader, line);
                        servicesMap.put(service.getName(), service);
                    }
                    catch (Exception e) {
                        throw new DeploymentException(e);
                    }
                }
            }
            if ((servicexmlStream = serviceClassLoader.getResourceAsStream("META-INF/services.xml")) == null) {
                servicexmlStream = serviceClassLoader.getResourceAsStream("meta-inf/services.xml");
            } else {
                metainf = "META-INF";
            }
            if (servicexmlStream == null) {
                throw new DeploymentException(Messages.getMessage("servicexmlnotfound", servicesURL.toString()));
            }
            DescriptionBuilder builder = new DescriptionBuilder(servicexmlStream, this.configContext);
            OMElement rootElement = builder.buildOM();
            String elementName = rootElement.getLocalName();
            if ("service".equals(elementName)) {
                AxisDescription axisService = null;
                InputStream wsdlStream = serviceClassLoader.getResourceAsStream(metainf + "/service.wsdl");
                URL wsdlURL = serviceClassLoader.getResource(metainf + "/service.wsdl");
                if (wsdlStream == null) {
                    wsdlStream = serviceClassLoader.getResourceAsStream(metainf + "/" + serviceName + ".wsdl");
                    wsdlURL = serviceClassLoader.getResource(metainf + "/" + serviceName + ".wsdl");
                }
                if (wsdlStream != null) {
                    WSDL11ToAxisServiceBuilder wsdl2AxisServiceBuilder = new WSDL11ToAxisServiceBuilder(wsdlStream, null, null);
                    if (wsdlURL != null) {
                        wsdl2AxisServiceBuilder.setDocumentBaseUri(wsdlURL.toString());
                    }
                    axisService = wsdl2AxisServiceBuilder.populateService();
                    ((AxisService)axisService).setWsdlFound(true);
                    ((AxisService)axisService).setCustomWsld(true);
                    ((AxisService)axisService).setName(serviceName);
                }
                if (axisService == null) {
                    axisService = new AxisService(serviceName);
                }
                axisService.setParent(serviceGroup);
                ((AxisService)axisService).setClassLoader(serviceClassLoader);
                ServiceBuilder serviceBuilder = new ServiceBuilder(this.configContext, (AxisService)axisService);
                AxisService service = serviceBuilder.populateService(rootElement);
                ArrayList<AxisService> serviceList = new ArrayList<AxisService>();
                serviceList.add(service);
                return serviceList;
            }
            if ("serviceGroup".equals(elementName)) {
                ServiceGroupBuilder groupBuilder = new ServiceGroupBuilder(rootElement, servicesMap, this.configContext);
                ArrayList servicList = groupBuilder.populateServiceGroup(serviceGroup);
                Iterator serviceIterator = servicList.iterator();
                while (serviceIterator.hasNext()) {
                    AxisService axisService = (AxisService)serviceIterator.next();
                    InputStream wsdlStream = serviceClassLoader.getResourceAsStream(metainf + "/service.wsdl");
                    URL wsdlURL = serviceClassLoader.getResource(metainf + "/service.wsdl");
                    if (wsdlStream != null) continue;
                    wsdlStream = serviceClassLoader.getResourceAsStream(metainf + "/" + serviceName + ".wsdl");
                    wsdlURL = serviceClassLoader.getResource(metainf + "/" + serviceName + ".wsdl");
                    if (wsdlStream == null) continue;
                    WSDL11ToAxisServiceBuilder wsdl2AxisServiceBuilder = new WSDL11ToAxisServiceBuilder(wsdlStream, axisService);
                    if (wsdlURL != null) {
                        wsdl2AxisServiceBuilder.setDocumentBaseUri(wsdlURL.toString());
                    }
                    axisService = wsdl2AxisServiceBuilder.populateService();
                    axisService.setWsdlFound(true);
                    axisService.setCustomWsld(true);
                    Iterator operations = axisService.getOperations();
                    while (operations.hasNext()) {
                        AxisOperation operation = (AxisOperation)operations.next();
                        if (operation.getMessageReceiver() != null) continue;
                        operation.setMessageReceiver(this.loadDefaultMessageReceiver(operation.getMessageExchangePattern(), axisService));
                    }
                }
                return servicList;
            }
        }
        catch (IOException e) {
            throw new DeploymentException(e);
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
        return null;
    }

    protected MessageReceiver loadDefaultMessageReceiver(String mepURL, AxisService service) {
        MessageReceiver messageReceiver;
        if (mepURL == null) {
            mepURL = "http://www.w3.org/2006/01/wsdl/in-out";
        }
        if (service != null && (messageReceiver = service.getMessageReceiver(mepURL)) != null) {
            return messageReceiver;
        }
        return this.axisConfig.getMessageReceiver(mepURL);
    }

    public static void addNewModule(AxisModule modulemetadata, AxisConfiguration axisConfiguration) throws AxisFault {
        Flow faultOutFlow;
        Flow faultInFlow;
        Flow outFlow;
        Flow inflow = modulemetadata.getInFlow();
        ClassLoader moduleClassLoader = modulemetadata.getModuleClassLoader();
        if (inflow != null) {
            Utils.addFlowHandlers(inflow, moduleClassLoader);
        }
        if ((outFlow = modulemetadata.getOutFlow()) != null) {
            Utils.addFlowHandlers(outFlow, moduleClassLoader);
        }
        if ((faultInFlow = modulemetadata.getFaultInFlow()) != null) {
            Utils.addFlowHandlers(faultInFlow, moduleClassLoader);
        }
        if ((faultOutFlow = modulemetadata.getFaultOutFlow()) != null) {
            Utils.addFlowHandlers(faultOutFlow, moduleClassLoader);
        }
        axisConfiguration.addModule(modulemetadata);
        log.debug(Messages.getMessage("addingnewmodule"));
    }

    public static void addServiceGroup(AxisServiceGroup serviceGroup, ArrayList serviceList, URL serviceLocation, DeploymentFileData currentDeploymentFile, AxisConfiguration axisConfiguration) throws AxisFault {
        DeploymentEngine.fillServiceGroup(serviceGroup, serviceList, serviceLocation, axisConfiguration);
        axisConfiguration.addServiceGroup(serviceGroup);
        if (currentDeploymentFile != null) {
            DeploymentEngine.addAsWebResources(currentDeploymentFile.getFile(), serviceGroup.getServiceGroupName(), serviceGroup);
        }
    }

    protected static void fillServiceGroup(AxisServiceGroup serviceGroup, ArrayList serviceList, URL serviceLocation, AxisConfiguration axisConfig) throws AxisFault {
        serviceGroup.setParent(axisConfig);
        ArrayList groupModules = serviceGroup.getModuleRefs();
        for (int i = 0; i < groupModules.size(); ++i) {
            QName moduleName = (QName)groupModules.get(i);
            AxisModule module = axisConfig.getModule(moduleName);
            if (module == null) {
                throw new DeploymentException(Messages.getMessage("badModuleFromService", serviceGroup.getServiceGroupName(), moduleName.getLocalPart()));
            }
            serviceGroup.engageModule(axisConfig.getModule(moduleName), axisConfig);
        }
        Iterator services = serviceList.iterator();
        while (services.hasNext()) {
            AxisService axisService = (AxisService)services.next();
            axisService.setUseDefaultChains(false);
            axisService.setFileName(serviceLocation);
            serviceGroup.addService(axisService);
            ArrayList list = axisService.getModules();
            for (int i = 0; i < list.size(); ++i) {
                AxisModule module = axisConfig.getModule((QName)list.get(i));
                if (module == null) {
                    throw new DeploymentException(Messages.getMessage("badModuleFromService", axisService.getName(), ((QName)list.get(i)).getLocalPart()));
                }
                axisService.engageModule(module, axisConfig);
            }
            Iterator iterator = axisService.getOperations();
            while (iterator.hasNext()) {
                AxisOperation opDesc = (AxisOperation)iterator.next();
                ArrayList modules = opDesc.getModuleRefs();
                for (int i = 0; i < modules.size(); ++i) {
                    QName moduleName = (QName)modules.get(i);
                    AxisModule module = axisConfig.getModule(moduleName);
                    if (module == null) {
                        throw new DeploymentException(Messages.getMessage("badModuleFromOperation", opDesc.getName().getLocalPart(), moduleName.getLocalPart()));
                    }
                    opDesc.engageModule(module, axisConfig);
                }
            }
        }
    }

    private static void addAsWebResources(File in, String serviceFileName, AxisServiceGroup serviceGroup) {
        try {
            ZipEntry entry;
            if (webLocationString == null) {
                return;
            }
            if (in.isDirectory()) {
                return;
            }
            File webLocation = new File(webLocationString);
            File out = new File(webLocation, serviceFileName);
            int BUFFER = 1024;
            byte[] data = new byte[BUFFER];
            FileInputStream fin = new FileInputStream(in);
            ZipInputStream zin = new ZipInputStream(fin);
            while ((entry = zin.getNextEntry()) != null) {
                ZipEntry zip = new ZipEntry(entry);
                if (!zip.getName().toUpperCase().startsWith("WWW")) continue;
                String fileName = zip.getName();
                fileName = fileName.substring("WWW/".length(), fileName.length());
                if (zip.isDirectory()) {
                    new File(out, fileName).mkdirs();
                } else {
                    int count;
                    FileOutputStream tempOut = new FileOutputStream(new File(out, fileName));
                    while ((count = zin.read(data, 0, BUFFER)) != -1) {
                        tempOut.write(data, 0, count);
                    }
                    tempOut.close();
                    tempOut.flush();
                }
                serviceGroup.setFoundWebResources(true);
            }
            zin.close();
            fin.close();
        }
        catch (IOException e) {
            log.info(e.getMessage());
        }
    }

    public void addWSToDeploy(DeploymentFileData file) {
        this.wsToDeploy.add(file);
    }

    public void addWSToUndeploy(WSInfo file) {
        this.wsToUnDeploy.add(file);
    }

    public void doDeploy() {
        if (this.wsToDeploy.size() > 0) {
            for (int i = 0; i < this.wsToDeploy.size(); ++i) {
                DeploymentFileData currentDeploymentFile = (DeploymentFileData)this.wsToDeploy.get(i);
                String type = currentDeploymentFile.getType();
                if ("service".equals(type)) {
                    this.serviceDeployer.deploy(currentDeploymentFile);
                    continue;
                }
                if ("module".equals(type)) {
                    this.moduleDeployer.deploy(currentDeploymentFile);
                    continue;
                }
                Deployer deployer = (Deployer)this.extensioToDeployerMappingMap.get(type);
                if (deployer == null) continue;
                deployer.deploy(currentDeploymentFile);
            }
        }
        this.wsToDeploy.clear();
    }

    public void engageModules() throws AxisFault {
        Iterator iterator = this.axisConfig.getGlobalModules().iterator();
        while (iterator.hasNext()) {
            QName name = (QName)iterator.next();
            this.axisConfig.engageModule(name);
        }
    }

    public AxisConfiguration populateAxisConfiguration(InputStream in) throws DeploymentException {
        this.axisConfig = new AxisConfiguration();
        AxisConfigBuilder builder = new AxisConfigBuilder(in, this.axisConfig, this);
        builder.populateConfig();
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            log.info("error in closing input stream");
        }
        this.moduleDeployer = new ModuleDeployer(this.axisConfig);
        return this.axisConfig;
    }

    protected void startSearch(RepositoryListener listener) {
        Scheduler scheduler = new Scheduler();
        scheduler.schedule(new SchedulerTask(listener), new DeploymentIterator());
    }

    public void unDeploy() {
        try {
            if (this.wsToUnDeploy.size() > 0) {
                for (int i = 0; i < this.wsToUnDeploy.size(); ++i) {
                    Deployer deployer;
                    WSInfo wsInfo = (WSInfo)this.wsToUnDeploy.get(i);
                    String fileType = wsInfo.getType();
                    if ("service".equals(fileType)) {
                        if (this.isHotUpdate()) {
                            this.serviceDeployer.unDeploy(wsInfo.getFileName());
                            continue;
                        }
                        this.axisConfig.removeFaultyService(wsInfo.getFileName());
                        continue;
                    }
                    if (!this.isHotUpdate() || (deployer = (Deployer)this.extensioToDeployerMappingMap.get(fileType)) == null) continue;
                    deployer.unDeploy(wsInfo.getFileName());
                }
            }
        }
        catch (Exception e) {
            log.info(e);
        }
        this.wsToUnDeploy.clear();
    }

    public AxisConfiguration getAxisConfig() {
        return this.axisConfig;
    }

    public static String getAxisServiceName(String fileName) {
        int seperator = 46;
        int index = fileName.indexOf(seperator);
        if (index > 0) {
            String value = fileName.substring(0, index);
            return value;
        }
        return fileName;
    }

    public AxisModule getModule(QName moduleName) throws AxisFault {
        return this.axisConfig.getModule(moduleName);
    }

    public boolean isHotUpdate() {
        return this.hotUpdate;
    }

    public boolean isAntiJARLocking() {
        return this.antiJARLocking;
    }

    protected void setClassLoaders(String axis2repoURI) throws DeploymentException {
        ClassLoader sysClassLoader = Utils.getClassLoader(Thread.currentThread().getContextClassLoader(), axis2repoURI);
        this.axisConfig.setSystemClassLoader(sysClassLoader);
        if (this.servicesDir.exists()) {
            this.axisConfig.setServiceClassLoader(Utils.getClassLoader(this.axisConfig.getSystemClassLoader(), this.servicesDir));
        } else {
            this.axisConfig.setServiceClassLoader(this.axisConfig.getSystemClassLoader());
        }
        if (this.modulesDir.exists()) {
            this.axisConfig.setModuleClassLoader(Utils.getClassLoader(this.axisConfig.getSystemClassLoader(), this.modulesDir));
        } else {
            this.axisConfig.setModuleClassLoader(this.axisConfig.getSystemClassLoader());
        }
    }

    protected void setDeploymentFeatures() {
        String moduleDirPara;
        String serviceDirPara;
        String value;
        Parameter parahotdeployment = this.axisConfig.getParameter("hotdeployment");
        Parameter parahotupdate = this.axisConfig.getParameter("hotupdate");
        if (parahotdeployment != null && "false".equalsIgnoreCase(value = (String)parahotdeployment.getValue())) {
            this.hotDeployment = false;
        }
        if (parahotupdate != null && "false".equalsIgnoreCase(value = (String)parahotupdate.getValue())) {
            this.hotUpdate = false;
        }
        if (parahotupdate != null && "true".equalsIgnoreCase(value = (String)parahotupdate.getValue())) {
            this.antiJARLocking = true;
        }
        if ((serviceDirPara = (String)this.axisConfig.getParameterValue("ServicesDirectory")) != null) {
            this.servicesPath = serviceDirPara;
        }
        if ((moduleDirPara = (String)this.axisConfig.getParameterValue("ModulesDirectory")) != null) {
            this.modulesPath = moduleDirPara;
        }
    }

    protected void prepareRepository(String repositoryName) {
        this.repositoryDir = new File(repositoryName);
        if (this.servicesPath != null) {
            this.servicesDir = new File(this.servicesPath);
            if (!this.servicesDir.exists()) {
                this.servicesDir = new File(this.repositoryDir, this.servicesPath);
            }
        } else {
            this.servicesDir = new File(this.repositoryDir, "services");
        }
        if (!this.servicesDir.exists()) {
            log.info(Messages.getMessage("noservicedirfound", this.getRepositoryPath(this.repositoryDir)));
        }
        if (this.modulesPath != null) {
            this.modulesDir = new File(this.modulesPath);
            if (!this.modulesDir.exists()) {
                this.modulesDir = new File(this.repositoryDir, this.modulesPath);
            }
        } else {
            this.modulesDir = new File(this.repositoryDir, "modules");
        }
        if (!this.modulesDir.exists()) {
            log.info(Messages.getMessage("nomoduledirfound", this.getRepositoryPath(this.repositoryDir)));
        }
    }

    protected String getRepositoryPath(File repository) {
        try {
            return repository.getCanonicalPath();
        }
        catch (IOException e) {
            return repository.getAbsolutePath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getFileList(URL fileListUrl) {
        InputStream in;
        ArrayList<String> fileList = new ArrayList<String>();
        try {
            in = fileListUrl.openStream();
        }
        catch (IOException e) {
            return fileList;
        }
        BufferedReader input = null;
        try {
            String line;
            input = new BufferedReader(new InputStreamReader(in));
            while ((line = input.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                fileList.add(line);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return fileList;
    }

    public String getWebLocationString() {
        return webLocationString;
    }

    public void setWebLocationString(String webLocationString) {
        DeploymentEngine.webLocationString = webLocationString;
    }

    public void setConfigContext(ConfigurationContext configContext) {
        this.configContext = configContext;
        this.initializeDeployers(this.configContext);
    }

    private void initializeDeployers(ConfigurationContext configContext) {
        this.serviceDeployer = new ServiceDeployer();
        this.serviceDeployer.init(configContext);
        Iterator deployers = this.extensioToDeployerMappingMap.values().iterator();
        while (deployers.hasNext()) {
            Deployer deployer = (Deployer)deployers.next();
            deployer.init(configContext);
        }
    }

    public static AxisModule buildModule(File modulearchive, AxisConfiguration config2) throws DeploymentException {
        AxisModule axismodule;
        try {
            Flow faultOutFlow;
            Flow faultInFlow;
            Flow outFlow;
            DeploymentFileData currentDeploymentFile = new DeploymentFileData(modulearchive, "module", false);
            axismodule = new AxisModule();
            ArchiveReader archiveReader = new ArchiveReader();
            currentDeploymentFile.setClassLoader(false, config2.getModuleClassLoader());
            axismodule.setModuleClassLoader(currentDeploymentFile.getClassLoader());
            archiveReader.readModuleArchive(currentDeploymentFile, axismodule, false, config2);
            ClassLoader moduleClassLoader = axismodule.getModuleClassLoader();
            Flow inflow = axismodule.getInFlow();
            if (inflow != null) {
                Utils.addFlowHandlers(inflow, moduleClassLoader);
            }
            if ((outFlow = axismodule.getOutFlow()) != null) {
                Utils.addFlowHandlers(outFlow, moduleClassLoader);
            }
            if ((faultInFlow = axismodule.getFaultInFlow()) != null) {
                Utils.addFlowHandlers(faultInFlow, moduleClassLoader);
            }
            if ((faultOutFlow = axismodule.getFaultOutFlow()) != null) {
                Utils.addFlowHandlers(faultOutFlow, moduleClassLoader);
            }
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault);
        }
        return axismodule;
    }

    public static AxisService buildService(InputStream serviceInputStream, ClassLoader classLoader, ConfigurationContext configCtx) throws DeploymentException {
        AxisService axisService = new AxisService();
        try {
            String value;
            AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
            Parameter parahotupdate = axisConfig.getParameter("hotupdate");
            boolean antiJARLocking = true;
            if (parahotupdate != null && "false".equalsIgnoreCase(value = (String)parahotupdate.getValue())) {
                antiJARLocking = false;
            }
            DeploymentFileData currentDeploymentFile = new DeploymentFileData("service", "", antiJARLocking);
            currentDeploymentFile.setClassLoader(classLoader);
            ServiceBuilder builder = new ServiceBuilder(serviceInputStream, configCtx, axisService);
            builder.populateService(builder.buildOM());
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault);
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
        return axisService;
    }

    public static AxisServiceGroup buildServiceGroup(InputStream servicesxml, ClassLoader classLoader, String serviceGroupName, ConfigurationContext configCtx, ArchiveReader archiveReader, HashMap wsdlServices) throws AxisFault {
        DeploymentFileData currentDeploymentFile = new DeploymentFileData("service", "", false);
        currentDeploymentFile.setClassLoader(classLoader);
        AxisServiceGroup serviceGroup = new AxisServiceGroup();
        serviceGroup.setServiceGroupClassLoader(classLoader);
        serviceGroup.setServiceGroupName(serviceGroupName);
        AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
        try {
            ArrayList serviceList = archiveReader.buildServiceGroup(servicesxml, currentDeploymentFile, serviceGroup, wsdlServices, configCtx);
            DeploymentEngine.fillServiceGroup(serviceGroup, serviceList, null, axisConfig);
            return serviceGroup;
        }
        catch (XMLStreamException e) {
            throw new AxisFault(e);
        }
    }

    public File getServicesDir() {
        return this.servicesDir;
    }

    public File getModulesDir() {
        return this.modulesDir;
    }

    public File getRepositoryDir() {
        return this.repositoryDir;
    }

    public void setExtensioToDeployerMappingMap(HashMap extensioToDeployerMappingMap) {
        this.extensioToDeployerMappingMap = extensioToDeployerMappingMap;
    }

    public void setDirectoryToExtensionMappingMap(HashMap directoryToExtensionMappingMap) {
        this.directoryToExtensionMappingMap = directoryToExtensionMappingMap;
    }

    public HashMap getDirectoryToExtensionMappingMap() {
        return this.directoryToExtensionMappingMap;
    }
}

