/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.InputStream;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.cluster.ClusterManager;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClusterBuilder
extends DescriptionBuilder {
    private static final Log log = LogFactory.getLog(ClusterBuilder.class);
    private AxisService service;

    public ClusterBuilder(AxisConfiguration axisConfig) {
        this.axisConfig = axisConfig;
    }

    public ClusterBuilder(InputStream serviceInputStream, AxisConfiguration axisConfig) {
        super(serviceInputStream, axisConfig);
    }

    public void buildCluster(OMElement clusterElement) throws DeploymentException {
        String className = clusterElement.getAttribute(new QName("class")).getAttributeValue();
        try {
            Class<?> clazz = Class.forName(className);
            ClusterManager clusterManager = (ClusterManager)clazz.newInstance();
            this.axisConfig.setClusterManager(clusterManager);
            return;
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException(Messages.getMessage("clusterImplNotFound"));
        }
        catch (InstantiationException e) {
            throw new DeploymentException(Messages.getMessage("cannotLoadClusterImpl"));
        }
        catch (IllegalAccessException e) {
            throw new DeploymentException(e);
        }
    }
}

