/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.attachments.utils.IOUtils;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.Base64;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.databinding.ADBBean;
import org.apache.axis2.databinding.i18n.ADBMessages;
import org.apache.axis2.databinding.types.Day;
import org.apache.axis2.databinding.types.Duration;
import org.apache.axis2.databinding.types.Entities;
import org.apache.axis2.databinding.types.Entity;
import org.apache.axis2.databinding.types.HexBinary;
import org.apache.axis2.databinding.types.IDRef;
import org.apache.axis2.databinding.types.IDRefs;
import org.apache.axis2.databinding.types.Id;
import org.apache.axis2.databinding.types.Language;
import org.apache.axis2.databinding.types.Month;
import org.apache.axis2.databinding.types.MonthDay;
import org.apache.axis2.databinding.types.NCName;
import org.apache.axis2.databinding.types.NMToken;
import org.apache.axis2.databinding.types.NMTokens;
import org.apache.axis2.databinding.types.Name;
import org.apache.axis2.databinding.types.NegativeInteger;
import org.apache.axis2.databinding.types.NonNegativeInteger;
import org.apache.axis2.databinding.types.NonPositiveInteger;
import org.apache.axis2.databinding.types.NormalizedString;
import org.apache.axis2.databinding.types.Notation;
import org.apache.axis2.databinding.types.PositiveInteger;
import org.apache.axis2.databinding.types.Time;
import org.apache.axis2.databinding.types.Token;
import org.apache.axis2.databinding.types.URI;
import org.apache.axis2.databinding.types.UnsignedByte;
import org.apache.axis2.databinding.types.UnsignedInt;
import org.apache.axis2.databinding.types.UnsignedLong;
import org.apache.axis2.databinding.types.UnsignedShort;
import org.apache.axis2.databinding.types.Year;
import org.apache.axis2.databinding.types.YearMonth;

public class ConverterUtil {
    private static final String POSITIVE_INFINITY = "INF";
    private static final String NEGATIVE_INFINITY = "-INF";

    public static String convertToString(int i) {
        return Integer.toString(i);
    }

    public static String convertToString(float i) {
        return Float.toString(i);
    }

    public static String convertToString(long i) {
        return Long.toString(i);
    }

    public static String convertToString(double i) {
        return Double.toString(i);
    }

    public static String convertToString(byte i) {
        return Byte.toString(i);
    }

    public static String convertToString(char i) {
        return Character.toString(i);
    }

    public static String convertToString(short i) {
        return Short.toString(i);
    }

    public static String convertToString(boolean i) {
        return Boolean.toString(i);
    }

    public static String convertToString(Date value) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(value);
    }

    public static String convertToString(Calendar value) {
        SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
        return zulu.format(value.getTime());
    }

    public static String convertToString(Day o) {
        return o.toString();
    }

    public static String convertToString(YearMonth o) {
        return o.toString();
    }

    public static String convertToString(Year o) {
        return o.toString();
    }

    public static String convertToString(HexBinary o) {
        return o.toString();
    }

    public static String convertToString(MonthDay o) {
        return o.toString();
    }

    public static String convertToString(Time o) {
        return o.toString();
    }

    public static String convertToString(Byte o) {
        return o.toString();
    }

    public static String convertToString(BigInteger o) {
        return o.toString();
    }

    public static String convertToString(Integer o) {
        return o.toString();
    }

    public static String convertToString(Long o) {
        return o.toString();
    }

    public static String convertToString(Short o) {
        return o.toString();
    }

    public static String convertToString(UnsignedByte o) {
        return o.toString();
    }

    public static String convertToString(UnsignedInt o) {
        return o.toString();
    }

    public static String convertToString(UnsignedLong o) {
        return o.toString();
    }

    public static String convertToString(QName o) {
        if (o != null) {
            return o.getLocalPart();
        }
        return "";
    }

    public static String convertToString(Object o) {
        return o.toString();
    }

    public static String convertToString(Double o) {
        return o.toString();
    }

    public static String convertToString(Duration o) {
        return o.toString();
    }

    public static String convertToString(Float o) {
        return o.toString();
    }

    public static String convertToString(Month o) {
        return o.toString();
    }

    public static String convertToString(byte[] bytes) {
        return Base64.encode(bytes);
    }

    public static String convertToString(DataHandler handler) {
        return ConverterUtil.getStringFromDatahandler(handler);
    }

    public static int convertToInt(String s) {
        return Integer.parseInt(s);
    }

    public static BigDecimal convertToBigDecimal(String s) {
        return new BigDecimal(s);
    }

    public static double convertToDouble(String s) {
        if (POSITIVE_INFINITY.equals(s)) {
            return Double.POSITIVE_INFINITY;
        }
        if (NEGATIVE_INFINITY.equals(s)) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.parseDouble(s);
    }

    public static BigDecimal convertToDecimal(String s) {
        return new BigDecimal(s);
    }

    public static float convertToFloat(String s) {
        if (POSITIVE_INFINITY.equals(s)) {
            return Float.POSITIVE_INFINITY;
        }
        if (NEGATIVE_INFINITY.equals(s)) {
            return Float.NEGATIVE_INFINITY;
        }
        return Float.parseFloat(s);
    }

    public static String convertToString(String s) {
        return s;
    }

    public static long convertToLong(String s) {
        return Long.parseLong(s);
    }

    public static short convertToShort(String s) {
        return Short.parseShort(s);
    }

    public static boolean convertToBoolean(String s) {
        return Boolean.valueOf(s);
    }

    public static String convertToAnySimpleType(String s) {
        return s;
    }

    public static OMElement convertToAnyType(String s) {
        try {
            XMLStreamReader r = StAXUtils.createXMLStreamReader(new ByteArrayInputStream(s.getBytes()));
            StAXOMBuilder builder = new StAXOMBuilder(OMAbstractFactory.getOMFactory(), r);
            return builder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            return null;
        }
    }

    public static YearMonth convertToGYearMonth(String s) {
        return new YearMonth(s);
    }

    public static MonthDay convertToGMonthDay(String s) {
        return new MonthDay(s);
    }

    public static Year convertToGYear(String s) {
        return new Year(s);
    }

    public static Month convertToGMonth(String s) {
        return new Month(s);
    }

    public static Day convertToGDay(String s) {
        return new Day(s);
    }

    public static Duration convertToDuration(String s) {
        return new Duration(s);
    }

    public static HexBinary convertToHexBinary(String s) {
        return new HexBinary(s);
    }

    public static DataHandler convertToBase64Binary(String s) {
        ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(Base64.decode(s));
        return new DataHandler(byteArrayDataSource);
    }

    public static DataHandler convertToDataHandler(String s) {
        return ConverterUtil.convertToBase64Binary(s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Date convertToDate(String source) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = null;
        boolean bc = false;
        if (source.startsWith("-")) {
            source = source.substring(1);
            bc = true;
        }
        if (source == null) throw new RuntimeException("In valid string to parse");
        if (source.length() < 10) throw new RuntimeException("In valid string to parse");
        if (source.length() == 10) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        } else {
            String restpart = source.substring(10);
            if (restpart.startsWith("Z")) {
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'Z'");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            } else {
                if (!restpart.startsWith("+")) {
                    if (!restpart.startsWith("-")) throw new RuntimeException("In valid string sufix");
                }
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-ddz");
                source = source.substring(0, 10) + "GMT" + restpart;
            }
        }
        try {
            Date date = simpleDateFormat.parse(source);
            if (!bc) return date;
            calendar.setTime(date);
            calendar.set(0, 0);
            return calendar.getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException("In valid string to parse");
        }
    }

    public static Time convertToTime(String s) {
        return new Time(s);
    }

    public static Token convertToToken(String s) {
        return new Token(s);
    }

    public static NormalizedString convertToNormalizedString(String s) {
        return new NormalizedString(s);
    }

    public static UnsignedLong convertToUnsignedLong(String s) {
        return new UnsignedLong(s);
    }

    public static UnsignedInt convertToUnsignedInt(String s) {
        return new UnsignedInt(s);
    }

    public static UnsignedShort convertToUnsignedShort(String s) {
        return new UnsignedShort(s);
    }

    public static UnsignedByte convertToUnsignedByte(String s) {
        return new UnsignedByte(s);
    }

    public static NonNegativeInteger convertToNonNegativeInteger(String s) {
        return new NonNegativeInteger(s);
    }

    public static NegativeInteger convertToNegativeInteger(String s) {
        return new NegativeInteger(s);
    }

    public static PositiveInteger convertToPositiveInteger(String s) {
        return new PositiveInteger(s);
    }

    public static NonPositiveInteger convertToNonPositiveInteger(String s) {
        return new NonPositiveInteger(s);
    }

    public static Name convertToName(String s) {
        return new Name(s);
    }

    public static NCName convertToNCName(String s) {
        return new NCName(s);
    }

    public static Id convertToID(String s) {
        return new Id(s);
    }

    public static Id convertToId(String s) {
        return ConverterUtil.convertToID(s);
    }

    public static Language convertToLanguage(String s) {
        return new Language(s);
    }

    public static NMToken convertToNMTOKEN(String s) {
        return new NMToken(s);
    }

    public static NMTokens convertToNMTOKENS(String s) {
        return new NMTokens(s);
    }

    public static Notation convertToNOTATION(String s) {
        return null;
    }

    public static Entity convertToENTITY(String s) {
        return new Entity(s);
    }

    public static Entities convertToENTITIES(String s) {
        return new Entities(s);
    }

    public static IDRef convertToIDREF(String s) {
        return new IDRef(s);
    }

    public static IDRefs convertToIDREFS(String s) {
        return new IDRefs(s);
    }

    public static URI convertToAnyURI(String s) {
        try {
            return new URI(s);
        }
        catch (URI.MalformedURIException e) {
            throw new ObjectConversionException(ADBMessages.getMessage("converter.cannotParse", s), e);
        }
    }

    public static BigInteger convertToInteger(String s) {
        return new BigInteger(s);
    }

    public static BigInteger convertToBigInteger(String s) {
        return ConverterUtil.convertToInteger(s);
    }

    public static byte convertToByte(String s) {
        return Byte.parseByte(s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Calendar convertToDateTime(String source) {
        SimpleDateFormat simpleDateFormat = null;
        Date date = null;
        Calendar calendar = Calendar.getInstance();
        if (source.startsWith("-")) {
            source = source.substring(1);
            calendar.set(0, 0);
        }
        try {
            if (source == null || source.length() < 19) throw new NumberFormatException("date string can not be less than 19 charactors");
            if (source.length() == 19) {
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            } else {
                String rest = source.substring(19);
                if (rest.startsWith(".")) {
                    if (rest.endsWith("Z")) {
                        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                    } else if (rest.lastIndexOf("+") > 0 || rest.lastIndexOf("-") > 0) {
                        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSz");
                        if (rest.lastIndexOf("+") > 0) {
                            source = source.substring(0, source.lastIndexOf("+")) + "GMT" + rest.substring(rest.lastIndexOf("+"));
                        } else if (rest.lastIndexOf("-") > 0) {
                            source = source.substring(0, source.lastIndexOf("-")) + "GMT" + rest.substring(rest.lastIndexOf("-"));
                        }
                    } else {
                        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                    }
                } else if (rest.startsWith("Z")) {
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                } else {
                    if (!rest.startsWith("+") && !rest.startsWith("-")) throw new NumberFormatException("in valid time zone attribute");
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                    source = source.substring(0, 19) + "GMT" + rest;
                }
            }
            date = simpleDateFormat.parse(source);
            calendar.setTime(date);
            return calendar;
        }
        catch (ParseException e) {
            throw new NumberFormatException(e.getMessage());
        }
    }

    public static QName convertToQName(String source, String nameSpaceuri) {
        int colon = (source = source.trim()).lastIndexOf(":");
        String localPart = colon < 0 ? source : source.substring(colon + 1);
        String perfix = colon <= 0 ? "" : source.substring(0, colon);
        return new QName(nameSpaceuri, localPart, perfix);
    }

    public static Object convertToObject(String i) {
        return i;
    }

    public static Object convertToObject(boolean i) {
        return i;
    }

    public static Object convertToObject(double i) {
        return new Double(i);
    }

    public static Object convertToObject(byte i) {
        return new Byte(i);
    }

    public static Object convertToObject(char i) {
        return new Character(i);
    }

    public static Object convertToObject(short i) {
        return new Short(i);
    }

    public static Object convertToArray(Class baseArrayClass, String[] valueArray) {
        ArrayList<String> valuesList = new ArrayList<String>(valueArray.length);
        for (int i = 0; i < valueArray.length; ++i) {
            valuesList.add(valueArray[i]);
        }
        return ConverterUtil.convertToArray(baseArrayClass, valuesList);
    }

    public static Object convertToArray(Class baseArrayClass, List objectList) {
        int listSize = objectList.size();
        Object returnArray = Array.newInstance(baseArrayClass, listSize);
        if (Integer.TYPE.equals(baseArrayClass)) {
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                if (o == null) continue;
                Array.setInt(returnArray, i, Integer.parseInt(o.toString()));
            }
        } else if (Float.TYPE.equals(baseArrayClass)) {
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                if (o == null) continue;
                Array.setFloat(returnArray, i, Float.parseFloat(o.toString()));
            }
        } else if (Short.TYPE.equals(baseArrayClass)) {
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                if (o == null) continue;
                Array.setShort(returnArray, i, Short.parseShort(o.toString()));
            }
        } else if (Byte.TYPE.equals(baseArrayClass)) {
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                if (o == null) continue;
                Array.setByte(returnArray, i, Byte.parseByte(o.toString()));
            }
        } else if (Long.TYPE.equals(baseArrayClass)) {
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                if (o == null) continue;
                Array.setLong(returnArray, i, Long.parseLong(o.toString()));
            }
        } else if (Boolean.TYPE.equals(baseArrayClass)) {
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                if (o == null) continue;
                Array.setBoolean(returnArray, i, Boolean.getBoolean(o.toString()));
            }
        } else if (Character.TYPE.equals(baseArrayClass)) {
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                if (o == null) continue;
                Array.setChar(returnArray, i, o.toString().toCharArray()[0]);
            }
        } else if (Double.TYPE.equals(baseArrayClass)) {
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                if (o == null) continue;
                Array.setDouble(returnArray, i, Double.parseDouble(o.toString()));
            }
        } else if (Calendar.class.equals(baseArrayClass)) {
            for (int i = 0; i < listSize; ++i) {
                Object o = objectList.get(i);
                if (o == null) continue;
                Array.set(returnArray, i, ConverterUtil.convertToDateTime(o.toString()));
            }
        } else {
            ConverterUtil.ConvertToArbitraryObjectArray(returnArray, baseArrayClass, objectList);
        }
        return returnArray;
    }

    private static void ConvertToArbitraryObjectArray(Object returnArray, Class baseArrayClass, List objectList) {
        if (!ADBBean.class.isAssignableFrom(baseArrayClass)) {
            try {
                for (int i = 0; i < objectList.size(); ++i) {
                    Object o = objectList.get(i);
                    if (o == null) {
                        Array.set(returnArray, i, ConverterUtil.getObjectForClass(baseArrayClass, null));
                        continue;
                    }
                    Array.set(returnArray, i, ConverterUtil.getObjectForClass(baseArrayClass, o.toString()));
                }
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            objectList.toArray((Object[])returnArray);
        }
        catch (Exception e) {
            throw new ObjectConversionException(e);
        }
    }

    public static List toList(Object[] array) {
        if (array == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static int compare(int intValue, String value) {
        return intValue - Integer.parseInt(value);
    }

    public static double compare(double doubleValue, String value) {
        return doubleValue - Double.parseDouble(value);
    }

    public static float compare(float floatValue, String value) {
        return floatValue - Float.parseFloat(value);
    }

    public static long compare(long longValue, String value) {
        return longValue - Long.parseLong(value);
    }

    public static int compare(short shortValue, String value) {
        return shortValue - Short.parseShort(value);
    }

    public static int compare(byte byteVlaue, String value) {
        return byteVlaue - Byte.parseByte(value);
    }

    public static int compare(BigInteger binBigInteger, String value) {
        return binBigInteger.intValue() - Integer.parseInt(value);
    }

    public static double compare(BigDecimal binBigDecimal, String value) {
        return binBigDecimal.doubleValue() - Double.parseDouble(value);
    }

    public static String getStringFromDatahandler(DataHandler dataHandler) {
        try {
            if (dataHandler == null) {
                return "";
            }
            InputStream inStream = dataHandler.getDataSource().getInputStream();
            byte[] data = IOUtils.getStreamAsByteArray(inStream);
            return Base64.encode(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getObjectForClass(Class clazz, String value) {
        boolean continueFlag = false;
        try {
            Constructor stringConstructor = clazz.getConstructor(String.class);
            return stringConstructor.newInstance(value);
        }
        catch (NoSuchMethodException e) {
            continueFlag = true;
        }
        catch (Exception e) {
            throw new ObjectConversionException(ADBMessages.getMessage("converter.cannotGenerate", clazz.getName()), e);
        }
        if (!continueFlag) {
            throw new ObjectConversionException(ADBMessages.getMessage("converter.cannotConvert", clazz.getName()));
        }
        try {
            Method parseMethod = clazz.getMethod("parse", String.class);
            Object instance = clazz.newInstance();
            return parseMethod.invoke(instance, value);
        }
        catch (NoSuchMethodException e) {
            throw new ObjectConversionException(e);
        }
        catch (Exception e) {
            throw new ObjectConversionException(ADBMessages.getMessage("converter.cannotGenerate", clazz.getName()), e);
        }
    }

    public static class ObjectConversionException
    extends RuntimeException {
        public ObjectConversionException() {
        }

        public ObjectConversionException(String message) {
            super(message);
        }

        public ObjectConversionException(Throwable cause) {
            super(cause);
        }

        public ObjectConversionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

