/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding;

import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.util.StAXUtils;

public abstract class ADBHelperDataSource
implements OMDataSource {
    protected QName parentQName;
    protected Object bean;
    protected String helperClassName;

    protected ADBHelperDataSource(Object bean, QName parentQName, String helperClassName) {
        this.bean = bean;
        this.parentQName = parentQName;
        this.helperClassName = helperClassName;
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        this.serialize(StAXUtils.createXMLStreamWriter(output));
    }

    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        this.serialize(StAXUtils.createXMLStreamWriter(writer));
    }

    public abstract void serialize(XMLStreamWriter var1) throws XMLStreamException;

    public XMLStreamReader getReader() throws XMLStreamException {
        try {
            Class<?> helperClass = Class.forName(this.helperClassName);
            Method method = helperClass.getMethod("getPullParser", Object.class, QName.class);
            return (XMLStreamReader)method.invoke(null, this.bean, this.parentQName);
        }
        catch (ClassNotFoundException e) {
            throw new XMLStreamException(e);
        }
        catch (NoSuchMethodException e) {
            throw new XMLStreamException(e);
        }
        catch (IllegalAccessException e) {
            throw new XMLStreamException(e);
        }
        catch (InvocationTargetException e) {
            throw new XMLStreamException(e);
        }
    }
}

