/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context.externalize;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectStreamConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DebugObjectOutputStream
implements ObjectStreamConstants,
ObjectOutput,
Closeable,
Flushable {
    private static final Log log = LogFactory.getLog(DebugObjectOutputStream.class);
    private static final boolean isDebug = log.isDebugEnabled();
    ObjectOutput out;

    DebugObjectOutputStream(ObjectOutput out) throws IOException {
        this.trace("--START DebugOutputStream--");
        this.out = out;
    }

    public void close() throws IOException {
        this.trace("--CLOSE DebugOutputStream--");
        this.out.close();
    }

    public void flush() throws IOException {
        this.trace("start flush()");
        this.out.flush();
        this.trace("end flush()");
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.trace("start write(b, off, len) off=" + off + " len=" + len);
        if (len > 4) {
            this.trace(" first four bytes = '" + b[off] + "' '" + b[off + 1] + "' '" + b[off + 2] + "' '" + b[off + 3] + "'");
        }
        this.out.write(b, off, len);
        this.trace("end write(b, off, len)");
    }

    public void write(byte[] b) throws IOException {
        this.trace("start write(byte) byte=" + b);
        this.out.write(b);
        this.trace("end write(b)");
    }

    public void write(int b) throws IOException {
        this.trace("start write(int) int=" + b);
        this.out.write(b);
        this.trace("end write(int)");
    }

    public void writeBoolean(boolean v) throws IOException {
        this.trace("start writeBoolean(v) v=" + v);
        this.out.writeBoolean(v);
        this.trace("end writeBoolean(v)");
    }

    public void writeByte(int v) throws IOException {
        this.trace("start writeByte(v) v=" + v);
        this.out.writeByte(v);
        this.trace("end writeByte(v)");
    }

    public void writeBytes(String s) throws IOException {
        this.trace("start writeBytes(s) s=" + s);
        this.out.writeBytes(s);
        this.trace("end writeBytes(s)");
    }

    public void writeChar(int v) throws IOException {
        this.trace("start writeChar(v) v=" + v);
        this.out.writeChar(v);
        this.trace("end writeChar(v)");
    }

    public void writeChars(String s) throws IOException {
        this.trace("start writeChars(s) s=" + s);
        this.out.writeChars(s);
        this.trace("end writeChars(s)");
    }

    public void writeDouble(double v) throws IOException {
        this.trace("start writeDouble(v) v=" + v);
        this.out.writeDouble(v);
        this.trace("end writeDouble(v)");
    }

    public void writeFloat(float v) throws IOException {
        this.trace("start writeFloat(v) v=" + v);
        this.out.writeFloat(v);
        this.trace("end writeFloat(v)");
    }

    public void writeInt(int v) throws IOException {
        this.trace("start writeInt(v) v=" + v);
        this.out.writeInt(v);
        this.trace("end writeInt(v)");
    }

    public void writeLong(long v) throws IOException {
        this.trace("start writeLong(v) v=" + v);
        this.out.writeLong(v);
        this.trace("end writeLong(v)");
    }

    public void writeObject(Object obj) throws IOException {
        this.trace("start writeObject(v) v=" + this.valueName(obj));
        this.out.writeObject(obj);
        this.trace("end writeObject(v)");
    }

    public void writeShort(int v) throws IOException {
        this.trace("start writeShort(v) v=" + v);
        this.out.writeShort(v);
        this.trace("end writeShort(v)");
    }

    public void writeUTF(String str) throws IOException {
        this.trace("start writeUTF(v) v=" + str);
        this.out.writeUTF(str);
        this.trace("end writeUTF(v)");
    }

    public void trace(String str) {
        if (isDebug) {
            log.debug(str);
        }
    }

    private String valueName(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return "Object of class = " + obj.getClass().getName();
    }
}

