/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.cluster.ClusterManager;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.DependencyManager;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.threadpool.ThreadFactory;
import org.apache.axis2.util.threadpool.ThreadPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationContext
extends AbstractContext {
    private static final Log log = LogFactory.getLog(ConfigurationContext.class);
    private final Map operationContextMap = new HashMap();
    private Hashtable serviceGroupContextMap = new Hashtable();
    private Hashtable applicationSessionServiceGroupContextTable = new Hashtable();
    private AxisConfiguration axisConfiguration;
    private ThreadFactory threadPool;
    private ListenerManager listenerManager;
    private long serviceGroupContextTimoutInterval = 30000L;
    private String contextRoot;
    private String servicePath;
    private String restPath;
    private String cachedServicePath = null;

    public ConfigurationContext(AxisConfiguration axisConfiguration) {
        super(null);
        this.axisConfiguration = axisConfiguration;
        this.initConfigContextTimeout(axisConfiguration);
        if (axisConfiguration.getClusterManager() != null) {
            this.initCluster();
        }
    }

    private void initConfigContextTimeout(AxisConfiguration axisConfiguration) {
        Object value;
        Parameter parameter = axisConfiguration.getParameter("ConfigContextTimeoutInterval");
        if (parameter != null && (value = parameter.getValue()) != null && value instanceof String) {
            this.serviceGroupContextTimoutInterval = Integer.parseInt((String)value);
        }
    }

    private void initCluster() {
        ClusterManager clusterManager = this.axisConfiguration.getClusterManager();
        clusterManager.init(this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void fillServiceContextAndServiceGroupContext(MessageContext messageContext) throws AxisFault {
        ServiceContext serviceContext = messageContext.getServiceContext();
        AxisService axisService = messageContext.getAxisService();
        if (serviceContext == null) {
            String scope = axisService.getScope();
            if ("application".equals(scope)) {
                String serviceGroupName = ((AxisServiceGroup)axisService.getParent()).getServiceGroupName();
                ServiceGroupContext serviceGroupContext = (ServiceGroupContext)this.applicationSessionServiceGroupContextTable.get(serviceGroupName);
                if (serviceGroupContext == null) {
                    AxisServiceGroup axisServiceGroup = messageContext.getAxisServiceGroup();
                    if (axisServiceGroup == null) {
                        axisServiceGroup = (AxisServiceGroup)axisService.getParent();
                        messageContext.setAxisServiceGroup(axisServiceGroup);
                    }
                    serviceGroupContext = ContextFactory.createServiceGroupContext(messageContext.getConfigurationContext(), axisServiceGroup);
                    this.applicationSessionServiceGroupContextTable.put(serviceGroupName, serviceGroupContext);
                    ClusterManager clusterManager = this.getAxisConfiguration().getClusterManager();
                    if (clusterManager != null) {
                        clusterManager.addContext(serviceGroupContext);
                    }
                }
                messageContext.setServiceGroupContext(serviceGroupContext);
                messageContext.setServiceContext(ContextFactory.createServiceContext(serviceGroupContext, axisService));
            } else if ("soapsession".equals(scope)) {
                ServiceGroupContext serviceGroupContext;
                String serviceGroupContextId = messageContext.getServiceGroupContextId();
                if (serviceGroupContextId != null) {
                    serviceGroupContext = this.getServiceGroupContextFromSoapSessionTable(serviceGroupContextId, messageContext);
                    if (serviceGroupContext == null) {
                        throw new AxisFault("Unable to find corresponding context for the serviceGroupId: " + serviceGroupContextId);
                    }
                } else {
                    AxisServiceGroup axisServiceGroup = (AxisServiceGroup)axisService.getParent();
                    serviceGroupContext = ContextFactory.createServiceGroupContext(this, axisServiceGroup);
                    serviceContext = ContextFactory.createServiceContext(serviceGroupContext, axisService);
                    serviceGroupContextId = UUIDGenerator.getUUID();
                    serviceGroupContext.setId(serviceGroupContextId);
                    ClusterManager clusterManager = this.getAxisConfiguration().getClusterManager();
                    if (clusterManager != null) {
                        clusterManager.addContext(serviceGroupContext);
                    }
                    messageContext.setServiceGroupContextId(serviceGroupContextId);
                    this.registerServiceGroupContextintoSoapSessionTable(serviceGroupContext);
                }
                messageContext.setServiceGroupContext(serviceGroupContext);
                messageContext.setServiceContext(ContextFactory.createServiceContext(serviceGroupContext, axisService));
            } else if ("request".equals(scope)) {
                AxisServiceGroup axisServiceGroup = (AxisServiceGroup)axisService.getParent();
                ServiceGroupContext serviceGroupContext = ContextFactory.createServiceGroupContext(this, axisServiceGroup);
                messageContext.setServiceGroupContext(serviceGroupContext);
                serviceContext = ContextFactory.createServiceContext(serviceGroupContext, axisService);
                messageContext.setServiceContext(serviceContext);
                messageContext.getOperationContext().setParent(serviceContext);
            }
        }
        if (messageContext.getOperationContext() != null) {
            messageContext.getOperationContext().setParent(serviceContext);
        }
    }

    public boolean registerOperationContext(String messageID, OperationContext mepContext) {
        return this.registerOperationContext(messageID, mepContext, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerOperationContext(String messageID, OperationContext mepContext, boolean override) {
        boolean alreadyInMap;
        mepContext.setKey(messageID);
        Map map = this.operationContextMap;
        synchronized (map) {
            alreadyInMap = this.operationContextMap.containsKey(messageID);
            if (!alreadyInMap || override) {
                this.operationContextMap.put(messageID, mepContext);
            }
            if (log.isDebugEnabled()) {
                log.debug("registerOperationContext (" + override + "): " + mepContext + " with key: " + messageID);
                HashMap msgContextMap = mepContext.getMessageContexts();
                Iterator msgContextIterator = msgContextMap.values().iterator();
                while (msgContextIterator.hasNext()) {
                    MessageContext msgContext = (MessageContext)msgContextIterator.next();
                    log.debug("msgContext: " + msgContext + " action: " + msgContext.getWSAAction());
                }
            }
        }
        return !alreadyInMap || override;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOperationContext(String key) {
        Map map = this.operationContextMap;
        synchronized (map) {
            Object oc = this.operationContextMap.remove(key);
            log.debug("unregisterOperationContext: " + oc + " with key: " + key);
        }
    }

    public void registerServiceGroupContextintoSoapSessionTable(ServiceGroupContext serviceGroupContext) {
        String id = serviceGroupContext.getId();
        this.serviceGroupContextMap.put(id, serviceGroupContext);
        serviceGroupContext.touch();
        serviceGroupContext.setParent(this);
        this.cleanupServiceGroupContexts();
    }

    public void addServiceGroupContextintoApplicatoionScopeTable(ServiceGroupContext serviceGroupContext) {
        if (this.applicationSessionServiceGroupContextTable == null) {
            this.applicationSessionServiceGroupContextTable = new Hashtable();
        }
        this.applicationSessionServiceGroupContextTable.put(serviceGroupContext.getDescription().getServiceGroupName(), serviceGroupContext);
    }

    public AxisConfiguration getAxisConfiguration() {
        return this.axisConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationContext getOperationContext(String id) {
        OperationContext opCtx;
        Map map = this.operationContextMap;
        synchronized (map) {
            if (this.operationContextMap == null) {
                return null;
            }
            opCtx = (OperationContext)this.operationContextMap.get(id);
        }
        return opCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationContext findOperationContext(String operationName, String serviceName, String serviceGroupName) {
        if (operationName == null) {
            return null;
        }
        if (serviceName == null) {
            return null;
        }
        Map map = this.operationContextMap;
        synchronized (map) {
            Iterator it = this.operationContextMap.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                OperationContext value = (OperationContext)this.operationContextMap.get(key);
                if (value == null) continue;
                String valueOperationName = value.getOperationName();
                String valueServiceName = value.getServiceName();
                String valueServiceGroupName = value.getServiceGroupName();
                if (valueOperationName == null || !valueOperationName.equals(operationName) || valueServiceName == null || !valueServiceName.equals(serviceName)) continue;
                if (valueServiceGroupName != null && serviceGroupName != null && valueServiceGroupName.equals(serviceGroupName)) {
                    return value;
                }
                if (valueServiceGroupName != null || serviceGroupName != null) continue;
                return value;
            }
        }
        return null;
    }

    public File getRealPath(String path) {
        URL repository = this.axisConfiguration.getRepository();
        if (repository != null) {
            File repo = new File(repository.getFile());
            return new File(repo, path);
        }
        return null;
    }

    public ServiceGroupContext getServiceGroupContextFromSoapSessionTable(String serviceGroupContextId, MessageContext msgContext) {
        ServiceGroupContext serviceGroupContext = (ServiceGroupContext)this.serviceGroupContextMap.get(serviceGroupContextId);
        if (serviceGroupContext != null) {
            serviceGroupContext.touch();
        }
        return serviceGroupContext;
    }

    public ServiceGroupContext getServiceGroupContext(String Id2) {
        if (Id2 == null) {
            return null;
        }
        ServiceGroupContext serviceGroupContext = null;
        if (this.serviceGroupContextMap != null && (serviceGroupContext = (ServiceGroupContext)this.serviceGroupContextMap.get(Id2)) != null) {
            serviceGroupContext.touch();
        }
        return serviceGroupContext;
    }

    public Hashtable getServiceGroupContexts() {
        return this.serviceGroupContextMap;
    }

    public ThreadFactory getThreadPool() {
        if (this.threadPool == null) {
            this.threadPool = new ThreadPool();
        }
        return this.threadPool;
    }

    public void setAxisConfiguration(AxisConfiguration configuration) {
        this.axisConfiguration = configuration;
    }

    public void setThreadPool(ThreadFactory pool) throws AxisFault {
        if (this.threadPool != null) {
            throw new AxisFault(Messages.getMessage("threadpoolset"));
        }
        this.threadPool = pool;
    }

    private void cleanupServiceGroupContexts() {
        if (this.serviceGroupContextMap == null) {
            return;
        }
        long currentTime = new Date().getTime();
        Iterator sgCtxtMapKeyIter = this.serviceGroupContextMap.keySet().iterator();
        while (sgCtxtMapKeyIter.hasNext()) {
            String sgCtxtId = (String)sgCtxtMapKeyIter.next();
            ServiceGroupContext serviceGroupContext = (ServiceGroupContext)this.serviceGroupContextMap.get(sgCtxtId);
            if (currentTime - serviceGroupContext.getLastTouchedTime() <= this.getServiceGroupContextTimoutInterval()) continue;
            sgCtxtMapKeyIter.remove();
            this.cleanupServiceContexts(serviceGroupContext);
        }
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public void setTransportManager(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
    }

    private void cleanupServiceContexts(ServiceGroupContext serviceGroupContext) {
        if (serviceGroupContext == null) {
            return;
        }
        Iterator serviceContecxtes = serviceGroupContext.getServiceContexts();
        if (serviceContecxtes == null) {
            return;
        }
        while (serviceContecxtes.hasNext()) {
            ServiceContext serviceContext = (ServiceContext)serviceContecxtes.next();
            DependencyManager.destroyServiceObject(serviceContext);
        }
    }

    public void cleanupContexts() {
        ServiceGroupContext serviceGroupContext;
        if (this.applicationSessionServiceGroupContextTable != null && this.applicationSessionServiceGroupContextTable.size() > 0) {
            Iterator applicationScopeSgs = this.applicationSessionServiceGroupContextTable.values().iterator();
            while (applicationScopeSgs.hasNext()) {
                serviceGroupContext = (ServiceGroupContext)applicationScopeSgs.next();
                this.cleanupServiceContexts(serviceGroupContext);
            }
            this.applicationSessionServiceGroupContextTable.clear();
        }
        if (this.serviceGroupContextMap != null && this.serviceGroupContextMap.size() > 0) {
            Iterator sopaSessionSgs = this.serviceGroupContextMap.values().iterator();
            while (sopaSessionSgs.hasNext()) {
                serviceGroupContext = (ServiceGroupContext)sopaSessionSgs.next();
                this.cleanupServiceContexts(serviceGroupContext);
            }
            this.serviceGroupContextMap.clear();
        }
    }

    public void terminate() throws AxisFault {
        if (this.listenerManager != null) {
            this.listenerManager.stop();
        }
    }

    public String getServiceContextPath() {
        if (this.cachedServicePath == null) {
            this.cachedServicePath = this.internalGetServiceContextPath();
        }
        return this.cachedServicePath;
    }

    private String internalGetServiceContextPath() {
        String ctxRoot = this.getContextRoot().trim();
        String path = "/";
        if (!ctxRoot.equals("/")) {
            path = ctxRoot + "/";
        }
        if (this.servicePath == null || this.servicePath.trim().length() == 0) {
            throw new IllegalArgumentException("service path cannot be null or empty");
        }
        path = path + this.servicePath.trim();
        return path;
    }

    public String getRESTContextPath() {
        String ctxRoot = this.getContextRoot().trim();
        String path = "/";
        if (!ctxRoot.equals("/")) {
            path = ctxRoot + "/";
        }
        if (this.restPath == null || this.restPath.trim().length() == 0) {
            throw new IllegalArgumentException("service path cannot be null or empty");
        }
        path = path + this.restPath.trim();
        return path;
    }

    public String getServicePath() {
        if (this.servicePath == null || this.servicePath.trim().length() == 0) {
            throw new IllegalArgumentException("service path cannot be null or empty");
        }
        return this.servicePath.trim();
    }

    public String getRESTPath() {
        if (this.restPath == null || this.restPath.trim().length() == 0) {
            throw new IllegalArgumentException("REST path cannot be null or empty");
        }
        return this.restPath.trim();
    }

    public String getContextRoot() {
        if (this.contextRoot == null || this.contextRoot.trim().length() == 0) {
            throw new IllegalArgumentException("context root cannot be null or empty");
        }
        return this.contextRoot.trim();
    }

    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    public void setRESTPath(String restPath) {
        this.restPath = restPath;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
        this.cachedServicePath = this.internalGetServiceContextPath();
    }

    public long getServiceGroupContextTimoutInterval() {
        Integer serviceGroupContextTimoutIntervalParam = (Integer)this.getProperty("ConfigContextTimeoutInterval");
        if (serviceGroupContextTimoutIntervalParam != null) {
            this.serviceGroupContextTimoutInterval = serviceGroupContextTimoutIntervalParam.intValue();
        }
        return this.serviceGroupContextTimoutInterval;
    }

    public void removeServiceGroupContext(AxisServiceGroup serviceGroup) {
        Object obj;
        if (serviceGroup != null && (obj = this.applicationSessionServiceGroupContextTable.get(serviceGroup.getServiceGroupName())) == null) {
            ArrayList<String> toBeRemovedList = new ArrayList<String>();
            Iterator serviceGroupContexts = this.serviceGroupContextMap.values().iterator();
            while (serviceGroupContexts.hasNext()) {
                ServiceGroupContext serviceGroupContext = (ServiceGroupContext)serviceGroupContexts.next();
                if (!serviceGroupContext.getDescription().equals(serviceGroup)) continue;
                toBeRemovedList.add(serviceGroupContext.getId());
            }
            for (int i = 0; i < toBeRemovedList.size(); ++i) {
                String s = (String)toBeRemovedList.get(i);
                this.serviceGroupContextMap.remove(s);
            }
        }
    }

    public ConfigurationContext getRootContext() {
        return this;
    }
}

