/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.cluster.ClusterManager;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;

public abstract class AbstractContext {
    public static final String COPY_PROPERTIES = "CopyProperties";
    protected long lastTouchedTime;
    protected transient AbstractContext parent;
    protected transient Map properties;

    protected AbstractContext(AbstractContext parent) {
        this.parent = parent;
    }

    protected AbstractContext() {
    }

    public AbstractContext getParent() {
        return this.parent;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        return this.properties;
    }

    public Object getProperty(String key) {
        Object obj;
        Object object = obj = this.properties == null ? null : (Object)this.properties.get(key);
        if (obj == null && this.parent != null) {
            obj = this.parent.getProperty(key);
        }
        return obj;
    }

    public void setParent(AbstractContext context) {
        this.parent = context;
    }

    public void setProperties(Map properties) {
        if (properties == null) {
            this.properties = null;
        } else {
            Boolean copyProperties = (Boolean)properties.get(COPY_PROPERTIES);
            if (copyProperties != null && copyProperties.booleanValue()) {
                this.mergeProperties(properties);
            } else {
                this.properties = properties;
            }
        }
    }

    public void mergeProperties(Map props) {
        if (props != null) {
            Iterator iterator = props.keySet().iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                if (this.properties == null) {
                    this.properties = new HashMap();
                }
                this.properties.put(key, props.get(key));
            }
        }
    }

    public void setProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
    }

    protected void touch() {
        this.lastTouchedTime = System.currentTimeMillis();
        if (this.parent != null) {
            this.parent.touch();
        }
    }

    public long getLastTouchedTime() {
        return this.lastTouchedTime;
    }

    public void setLastTouchedTime(long t) {
        this.lastTouchedTime = t;
    }

    public void flush() throws AxisFault {
        ConfigurationContext configContext = this.getRootContext();
        if (configContext == null) {
            throw new AxisFault(Messages.getMessage("cannotFlushRootNull"));
        }
        AxisConfiguration axisConfiguration = configContext.getAxisConfiguration();
        ClusterManager clusterManager = axisConfiguration.getClusterManager();
        if (clusterManager != null && clusterManager.isContextClusterable(this)) {
            clusterManager.updateState(this);
        }
    }

    public abstract ConfigurationContext getRootContext();
}

