/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.addressing;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.AttributeHelper;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EndpointReferenceHelper {
    private static final Log log = LogFactory.getLog(EndpointReferenceHelper.class);
    private static final Map finalQNames = new IdentityHashMap();
    private static final Map submissionQNames = new IdentityHashMap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fromOM(EndpointReference epr, OMElement eprOMElement, String addressingNamespace) throws AxisFault {
        boolean isFinalAddressingNamespace = false;
        Map map = null;
        if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(addressingNamespace)) {
            OMElement address = eprOMElement.getFirstChildWithName((QName)submissionQNames.get("Address"));
            if (address == null) throw new AxisFault("Unable to locate an address element for the endpoint reference type.");
            map = submissionQNames;
            isFinalAddressingNamespace = false;
            if (log.isDebugEnabled()) {
                log.debug("fromOM: Found address element for namespace, http://schemas.xmlsoap.org/ws/2004/08/addressing");
            }
        } else {
            OMElement address = eprOMElement.getFirstChildWithName((QName)finalQNames.get("Address"));
            if (address == null) throw new AxisFault("Unable to locate an address element for the endpoint reference type.");
            map = finalQNames;
            isFinalAddressingNamespace = true;
            if (log.isDebugEnabled()) {
                log.debug("fromOM: Found address element for namespace, http://www.w3.org/2005/08/addressing");
            }
        }
        EndpointReferenceHelper.fromOM(epr, eprOMElement, map, isFinalAddressingNamespace);
    }

    public static EndpointReference fromOM(String eprString) throws AxisFault {
        try {
            return EndpointReferenceHelper.fromOM(new StAXOMBuilder(new ByteArrayInputStream(eprString.getBytes())).getDocumentElement());
        }
        catch (XMLStreamException e) {
            throw new AxisFault(e);
        }
    }

    public static EndpointReference fromOM(OMElement eprOMElement) throws AxisFault {
        EndpointReference epr = new EndpointReference("");
        boolean isFinalAddressingNamespace = false;
        Map map = null;
        OMElement address = eprOMElement.getFirstChildWithName((QName)finalQNames.get("Address"));
        if (address != null) {
            map = finalQNames;
            isFinalAddressingNamespace = true;
            if (log.isDebugEnabled()) {
                log.debug("fromOM: Found address element for namespace, http://www.w3.org/2005/08/addressing");
            }
        } else {
            address = eprOMElement.getFirstChildWithName((QName)submissionQNames.get("Address"));
            if (address != null) {
                map = submissionQNames;
                isFinalAddressingNamespace = false;
                if (log.isDebugEnabled()) {
                    log.debug("fromOM: Found address element for namespace, http://schemas.xmlsoap.org/ws/2004/08/addressing");
                }
            } else {
                throw new AxisFault("Unable to locate an address element for the endpoint reference type.");
            }
        }
        EndpointReferenceHelper.fromOM(epr, eprOMElement, map, isFinalAddressingNamespace);
        return epr;
    }

    public static OMElement toOM(OMFactory factory, EndpointReference epr, QName qname2, String addressingNamespace) throws AxisFault {
        OMElement eprElement = null;
        if (log.isDebugEnabled()) {
            log.debug("toOM: Factory, " + factory);
            log.debug("toOM: Endpoint reference, " + epr);
            log.debug("toOM: Element qname, " + qname2);
            log.debug("toOM: Addressing namespace, " + addressingNamespace);
        }
        if (addressingNamespace == null) {
            throw new AxisFault("Addressing namespace cannot be null.");
        }
        if (qname2.getPrefix() != null) {
            ArrayList extensibleElements;
            ArrayList attributes;
            Map referenceParameters;
            OMElement omElement;
            ArrayList metaData;
            OMNamespace wrapNs = factory.createOMNamespace(qname2.getNamespaceURI(), qname2.getPrefix());
            eprElement = factory instanceof SOAPFactory ? ((SOAPFactory)factory).createSOAPHeaderBlock(qname2.getLocalPart(), wrapNs) : factory.createOMElement(qname2.getLocalPart(), wrapNs);
            OMNamespace wsaNS = factory.createOMNamespace(addressingNamespace, "wsa");
            OMElement addressE = factory.createOMElement("Address", wsaNS, eprElement);
            String address = epr.getAddress();
            addressE.setText(address);
            ArrayList addressAttributes = epr.getAddressAttributes();
            if (addressAttributes != null) {
                Iterator attrIter = addressAttributes.iterator();
                while (attrIter.hasNext()) {
                    OMAttribute omAttributes = (OMAttribute)attrIter.next();
                    addressE.addAttribute(omAttributes);
                }
            }
            if ((metaData = epr.getMetaData()) != null && "http://www.w3.org/2005/08/addressing".equals(addressingNamespace)) {
                OMElement metadataE = factory.createOMElement("Metadata", wsaNS, eprElement);
                int size = metaData.size();
                for (int i = 0; i < size; ++i) {
                    omElement = (OMElement)metaData.get(i);
                    metadataE.addChild(ElementHelper.importOMElement(omElement, factory));
                }
                ArrayList metadataAttributes = epr.getMetadataAttributes();
                if (metadataAttributes != null) {
                    Iterator attrIter = metadataAttributes.iterator();
                    while (attrIter.hasNext()) {
                        OMAttribute omAttributes = (OMAttribute)attrIter.next();
                        metadataE.addAttribute(omAttributes);
                    }
                }
            }
            if ((referenceParameters = epr.getAllReferenceParameters()) != null) {
                OMElement refParameterElement = factory.createOMElement("ReferenceParameters", wsaNS, eprElement);
                Iterator iterator = referenceParameters.values().iterator();
                while (iterator.hasNext()) {
                    omElement = (OMElement)iterator.next();
                    refParameterElement.addChild(ElementHelper.importOMElement(omElement, factory));
                }
            }
            if ((attributes = epr.getAttributes()) != null) {
                int size = attributes.size();
                for (int i = 0; i < size; ++i) {
                    OMAttribute omAttribute = (OMAttribute)attributes.get(i);
                    AttributeHelper.importOMAttribute(omAttribute, eprElement);
                }
            }
            if ((extensibleElements = epr.getExtensibleElements()) != null) {
                int size = extensibleElements.size();
                for (int i = 0; i < size; ++i) {
                    OMElement omElement2 = (OMElement)extensibleElements.get(i);
                    eprElement.addChild(ElementHelper.importOMElement(omElement2, factory));
                }
            }
        } else {
            throw new AxisFault("prefix must be specified");
        }
        return eprElement;
    }

    private static void fromOM(EndpointReference epr, OMElement eprOMElement, Map map, boolean isFinalAddressingNamespace) {
        Iterator childElements = eprOMElement.getChildElements();
        while (childElements.hasNext()) {
            OMElement element;
            Iterator iterator;
            OMElement eprChildElement = (OMElement)childElements.next();
            QName qname2 = eprChildElement.getQName();
            if (map.get("Address").equals(qname2)) {
                epr.setAddress(eprChildElement.getText());
                Iterator allAddrAttributes = eprChildElement.getAllAttributes();
                ArrayList<OMAttribute> addressAttributes = new ArrayList<OMAttribute>();
                while (allAddrAttributes.hasNext()) {
                    OMAttribute attribute = (OMAttribute)allAddrAttributes.next();
                    addressAttributes.add(attribute);
                }
                epr.setAddressAttributes(addressAttributes);
                continue;
            }
            if (map.get("ReferenceParameters").equals(qname2)) {
                iterator = eprChildElement.getChildElements();
                while (iterator.hasNext()) {
                    element = (OMElement)iterator.next();
                    epr.addReferenceParameter(element);
                }
                continue;
            }
            if (isFinalAddressingNamespace && map.get("Metadata").equals(qname2)) {
                iterator = eprChildElement.getChildElements();
                while (iterator.hasNext()) {
                    OMNode node = (OMNode)iterator.next();
                    epr.addMetaData(node);
                }
                Iterator allMDAttributes = eprChildElement.getAllAttributes();
                ArrayList<OMAttribute> metadataAttributes = new ArrayList<OMAttribute>();
                while (allMDAttributes.hasNext()) {
                    OMAttribute attribute = (OMAttribute)allMDAttributes.next();
                    metadataAttributes.add(attribute);
                }
                epr.setMetadataAttributes(metadataAttributes);
                continue;
            }
            if (!isFinalAddressingNamespace && map.get("ReferenceProperties").equals(qname2)) {
                iterator = eprChildElement.getChildElements();
                while (iterator.hasNext()) {
                    element = (OMElement)iterator.next();
                    epr.addReferenceParameter(element);
                }
                continue;
            }
            epr.addExtensibleElement(eprChildElement);
        }
        Iterator attributes = eprOMElement.getAllAttributes();
        while (attributes.hasNext()) {
            OMAttribute attribute = (OMAttribute)attributes.next();
            epr.addAttribute(attribute);
        }
        if (log.isDebugEnabled()) {
            log.debug("fromOM: Endpoint reference, " + epr);
        }
    }

    static {
        finalQNames.put("Address", new QName("http://www.w3.org/2005/08/addressing", "Address"));
        finalQNames.put("ReferenceParameters", new QName("http://www.w3.org/2005/08/addressing", "ReferenceParameters"));
        finalQNames.put("Metadata", new QName("http://www.w3.org/2005/08/addressing", "Metadata"));
        submissionQNames.put("Address", new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Address"));
        submissionQNames.put("ReferenceParameters", new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "ReferenceParameters"));
        submissionQNames.put("ReferenceProperties", new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "ReferenceProperties"));
    }
}

