/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.addressing;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.modules.Module;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;

public class AddressingModule
implements Module {
    private static final Log log = LogFactory.getLog(AddressingModule.class);
    private static final QName ADDRESSING = new QName("addressing");

    public void init(ConfigurationContext arg0, AxisModule arg1) throws AxisFault {
        AxisConfiguration axisConfig = arg0.getAxisConfiguration();
        ModuleConfiguration moduleConfig = axisConfig.getModuleConfig(ADDRESSING);
        if (moduleConfig != null) {
            ArrayList list = moduleConfig.getParameters();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Parameter param = (Parameter)list.get(i);
                arg1.addParameter(param);
                if (!log.isTraceEnabled()) continue;
                log.trace("init: Addressing config -" + param);
            }
            this.initHandlers(arg1);
        }
    }

    public void engageNotify(AxisDescription arg0) throws AxisFault {
    }

    public boolean canSupportAssertion(Assertion arg0) {
        return false;
    }

    public void applyPolicy(Policy arg0, AxisDescription arg1) throws AxisFault {
    }

    public void shutdown(ConfigurationContext arg0) throws AxisFault {
    }

    private void initHandlers(AxisModule axisModule) {
        Handler handler;
        HandlerDescription description;
        int i;
        Flow flow = axisModule.getOutFlow();
        if (log.isTraceEnabled()) {
            log.trace("initHandlers: Initializing handlers in out flow.");
        }
        int size = flow.getHandlerCount();
        for (i = 0; i < size; ++i) {
            description = flow.getHandler(i);
            handler = description.getHandler();
            handler.init(description);
        }
        flow = axisModule.getFaultOutFlow();
        if (log.isTraceEnabled()) {
            log.trace("initHandlers: Initializing handlers in fault out flow.");
        }
        size = flow.getHandlerCount();
        for (i = 0; i < size; ++i) {
            description = flow.getHandler(i);
            handler = description.getHandler();
            handler.init(description);
        }
    }
}

