/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;

public class ElementHelper {
    private OMElement element;

    public ElementHelper(OMElement element) {
        this.element = element;
    }

    public QName resolveQName(String qname2, boolean defaultToParentNameSpace) {
        int colon = qname2.indexOf(58);
        if (colon < 0) {
            if (defaultToParentNameSpace) {
                OMNamespace namespace = this.element.getNamespace();
                return new QName(namespace.getNamespaceURI(), qname2, namespace.getPrefix());
            }
            return new QName(qname2);
        }
        String prefix = qname2.substring(0, colon);
        String local = qname2.substring(colon + 1);
        if (local.length() == 0) {
            return null;
        }
        OMNamespace namespace = this.element.findNamespaceURI(prefix);
        if (namespace == null) {
            return null;
        }
        return new QName(namespace.getNamespaceURI(), local, prefix);
    }

    public QName resolveQName(String qname2) {
        return this.resolveQName(qname2, true);
    }

    public static void setNewElement(OMElement parent, OMElement myElement, OMElement newElement) {
        if (myElement != null) {
            myElement.discard();
        }
        parent.addChild(newElement);
        myElement = newElement;
    }

    public static OMElement getChildWithName(OMElement parent, String childName) {
        Iterator childrenIter = parent.getChildren();
        while (childrenIter.hasNext()) {
            OMNode node = (OMNode)childrenIter.next();
            if (node.getType() != 1 || !childName.equals(((OMElement)node).getLocalName())) continue;
            return (OMElement)node;
        }
        return null;
    }

    public static String getContentID(XMLStreamReader parser, String charsetEncoding) {
        String contentID;
        if (parser.getAttributeCount() > 0) {
            contentID = parser.getAttributeValue(0);
            contentID = contentID.trim();
            String contentIDName = parser.getAttributeLocalName(0);
            if (contentIDName.equalsIgnoreCase("href") & contentID.substring(0, 3).equalsIgnoreCase("cid")) {
                contentID = contentID.substring(4);
                String charEnc = charsetEncoding == null || "".equals(charsetEncoding) ? "UTF-8" : charsetEncoding;
                try {
                    contentID = URLDecoder.decode(contentID, charEnc);
                }
                catch (UnsupportedEncodingException e) {
                    throw new OMException("Unsupported Character Encoding Found", e);
                }
            } else if (!(contentIDName.equalsIgnoreCase("href") & !contentID.equals(""))) {
                throw new OMException("contentID not Found in XOP:Include element");
            }
        } else {
            throw new OMException("Href attribute not found in XOP:Include element");
        }
        return contentID;
    }

    public static OMElement importOMElement(OMElement omElement, OMFactory omFactory) {
        if (omElement.getOMFactory().getClass().isInstance(omFactory)) {
            return omElement;
        }
        OMElement documentElement = new StAXOMBuilder(omFactory, omElement.getXMLStreamReader()).getDocumentElement();
        documentElement.build();
        return documentElement;
    }
}

