/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.dom.DOMMessageFormatter;
import org.apache.axiom.om.impl.dom.DOMUtil;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.NamespaceImpl;
import org.apache.axiom.om.impl.dom.NodeImpl;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.om.impl.dom.TextImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

public class AttrImpl
extends NodeImpl
implements OMAttribute,
Attr {
    private String attrName;
    private TextImpl attrValue;
    private String attrType;
    private NamespaceImpl namespace;
    private boolean used;
    protected ParentNode parent;
    protected boolean isId;

    protected AttrImpl(DocumentImpl ownerDocument, OMFactory factory) {
        super(ownerDocument, factory);
    }

    public AttrImpl(DocumentImpl ownerDocument, String localName, OMNamespace ns, String value, OMFactory factory) {
        super(ownerDocument, factory);
        this.attrName = localName;
        this.attrValue = new TextImpl(ownerDocument, value, factory);
        this.namespace = (NamespaceImpl)ns;
        this.attrType = "CDATA";
    }

    public AttrImpl(DocumentImpl ownerDocument, String name, String value, OMFactory factory) {
        super(ownerDocument, factory);
        this.attrName = name;
        this.attrValue = new TextImpl(ownerDocument, value, factory);
        this.attrType = "CDATA";
    }

    public AttrImpl(DocumentImpl ownerDocument, String name, OMFactory factory) {
        super(ownerDocument, factory);
        this.attrName = name;
        if ("xmlns".equals(name)) {
            this.namespace = new NamespaceImpl("http://www.w3.org/2000/xmlns/", "xmlns");
        }
        this.attrType = "CDATA";
    }

    public AttrImpl(DocumentImpl ownerDocument, String localName, OMNamespace namespace, OMFactory factory) {
        super(ownerDocument, factory);
        this.attrName = localName;
        this.namespace = (NamespaceImpl)namespace;
        this.attrType = "CDATA";
    }

    public String getNodeName() {
        return this.namespace != null && !"".equals(this.namespace.getPrefix()) && !"xmlns".equals(this.attrName) ? this.namespace.getPrefix() + ":" + this.attrName : this.attrName;
    }

    public short getNodeType() {
        return 2;
    }

    public String getNodeValue() throws DOMException {
        return this.attrValue == null ? "" : this.attrValue.getData();
    }

    public String getValue() {
        return this.attrValue == null ? null : this.attrValue.getText();
    }

    public String getName() {
        if (this.namespace != null) {
            if ("xmlns".equals(this.attrName)) {
                return this.attrName;
            }
            if ("http://www.w3.org/2000/xmlns/".equals(this.namespace.getNamespaceURI())) {
                return "xmlns:" + this.attrName;
            }
            if (this.namespace.getPrefix().equals("")) {
                return this.attrName;
            }
            return this.namespace.getPrefix() + ":" + this.attrName;
        }
        return this.attrName;
    }

    public Element getOwnerElement() {
        return (Element)((Object)(this.isOwned() ? this.parent : null));
    }

    public boolean getSpecified() {
        throw new UnsupportedOperationException("TODO");
    }

    public OMNode detach() throws OMException {
        throw new UnsupportedOperationException("Not supported");
    }

    public void discard() throws OMException {
        throw new UnsupportedOperationException("Not supported");
    }

    public int getType() {
        return -1;
    }

    public void internalSerialize(XMLStreamWriter writer) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported");
    }

    public void internalSerializeAndConsume(XMLStreamWriter writer) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported");
    }

    public OMNamespace getNamespace() {
        return this.namespace;
    }

    public QName getQName() {
        return this.namespace == null ? new QName(this.attrName) : new QName(this.namespace.getNamespaceURI(), this.attrName, this.namespace.getPrefix());
    }

    public String getAttributeValue() {
        return this.attrValue.getText();
    }

    public String getAttributeType() {
        return this.attrType;
    }

    public void setLocalName(String localName) {
        this.attrName = localName;
    }

    public void setOMNamespace(OMNamespace omNamespace) {
        this.namespace = (NamespaceImpl)omNamespace;
    }

    public void setAttributeValue(String value) {
        if (this.isReadonly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        this.attrValue = (TextImpl)this.getOwnerDocument().createTextNode(value);
    }

    public void setAttributeType(String attrType) {
        this.attrType = attrType;
    }

    public void setParent(OMContainer element) {
        this.parent = (ParentNode)element;
    }

    public void setType(int nodeType) throws OMException {
    }

    protected boolean isUsed() {
        return this.used;
    }

    protected void setUsed(boolean used) {
        this.used = used;
    }

    public void setValue(String value) throws DOMException {
        this.attrValue = (TextImpl)this.getOwnerDocument().createTextNode(value);
    }

    public OMContainer getParent() {
        return this.parent;
    }

    public String getLocalName() {
        return this.namespace == null ? this.attrName : DOMUtil.getLocalName(this.attrName);
    }

    public String getNamespaceURI() {
        if (this.namespace != null) {
            return this.namespace.getNamespaceURI();
        }
        return null;
    }

    public String getPrefix() {
        return this.namespace == null ? null : this.namespace.getPrefix();
    }

    public Node cloneNode(boolean deep) {
        AttrImpl clone = (AttrImpl)super.cloneNode(deep);
        if (clone.attrValue == null) {
            clone.attrValue = new TextImpl(this.attrValue.toString(), this.factory);
            if (this.attrValue.nextSibling != null) {
                throw new UnsupportedOperationException("Attribute value can contain only a text node with out any siblings");
            }
        }
        clone.isSpecified(true);
        return clone;
    }

    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean isId() {
        return this.isId;
    }

    public String toString() {
        return this.namespace == null ? this.attrName : this.namespace.getPrefix() + ":" + this.attrName;
    }
}

