/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.ds;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;

public class CharArrayDataSource
implements OMDataSourceExt {
    char[] chars = null;

    public CharArrayDataSource(char[] chars) {
        this.chars = chars;
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        try {
            output.write(this.getXMLBytes(format.getCharSetEncoding()));
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        try {
            writer.write(this.chars);
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLStreamException(e);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        OutputStream os = this.getOutputStream(xmlWriter);
        if (os != null) {
            String encoding = this.getCharacterEncoding(xmlWriter);
            OMOutputFormat format = new OMOutputFormat();
            format.setCharSetEncoding(encoding);
            this.serialize(os, format);
        } else {
            XMLStreamReader xmlReader = this.getReader();
            CharArrayDataSource.reader2writer(xmlReader, xmlWriter);
        }
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        CharArrayReader reader = new CharArrayReader(this.chars);
        return StAXUtils.createXMLStreamReader(reader);
    }

    public InputStream getXMLInputStream(String encoding) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(this.getXMLBytes(encoding));
    }

    public Object getObject() {
        return this.chars;
    }

    public boolean isDestructiveRead() {
        return false;
    }

    public boolean isDestructiveWrite() {
        return false;
    }

    public byte[] getXMLBytes(String encoding) throws UnsupportedEncodingException {
        String text = new String(this.chars);
        return text.getBytes(encoding);
    }

    public void close() {
        this.chars = null;
    }

    public OMDataSourceExt copy() {
        return new CharArrayDataSource(this.chars);
    }

    private OutputStream getOutputStream(XMLStreamWriter writer) throws XMLStreamException {
        if (writer instanceof MTOMXMLStreamWriter) {
            return ((MTOMXMLStreamWriter)writer).getOutputStream();
        }
        return null;
    }

    private String getCharacterEncoding(XMLStreamWriter writer) {
        if (writer instanceof MTOMXMLStreamWriter) {
            return ((MTOMXMLStreamWriter)writer).getCharSetEncoding();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reader2writer(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        builder.releaseParserOnClose(true);
        try {
            OMDocument omDocument = builder.getDocument();
            Iterator it = omDocument.getChildren();
            while (it.hasNext()) {
                OMNode omNode = (OMNode)it.next();
                omNode.serializeAndConsume(writer);
            }
        }
        finally {
            builder.close();
        }
    }
}

