/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.activation.DataHandler;
import javax.mail.Header;
import javax.mail.MessagingException;
import org.apache.axiom.attachments.CachedFileDataSource;
import org.apache.axiom.attachments.Part;
import org.apache.axiom.attachments.PushbackFilePartInputStream;
import org.apache.axiom.om.OMException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PartOnFile
implements Part {
    File cacheFile;
    Part bodyPart;
    String contentType;
    String contentID;
    Hashtable headers = new Hashtable();
    protected static Log log = LogFactory.getLog(class$org$apache$axiom$attachments$PartOnFile == null ? (class$org$apache$axiom$attachments$PartOnFile = PartOnFile.class$("org.apache.axiom.attachments.PartOnFile")) : class$org$apache$axiom$attachments$PartOnFile);
    static /* synthetic */ Class class$org$apache$axiom$attachments$PartOnFile;

    public PartOnFile(PushbackFilePartInputStream inStream, String repoDir) {
        if (repoDir == null) {
            repoDir = ".";
        }
        try {
            File repoDirFile = null;
            if (repoDir != null) {
                repoDirFile = new File(repoDir);
                if (!repoDirFile.exists()) {
                    repoDirFile.mkdirs();
                }
                if (!repoDirFile.isDirectory()) {
                    repoDirFile = new File(repoDirFile.getAbsolutePath());
                }
            }
            if (!repoDirFile.isDirectory()) {
                throw new IllegalArgumentException("Given Axis2 Attachment File Cache Location " + repoDir + "  should be a directory.");
            }
            this.cacheFile = File.createTempFile("Axis2", ".att", repoDirFile);
            FileOutputStream fileOutStream = new FileOutputStream(this.cacheFile);
            int value = this.parseTheHeaders(inStream);
            fileOutStream.write(value);
            do {
                int len;
                byte[] buffer = new byte[4000];
                while ((len = inStream.read(buffer)) > 0) {
                    fileOutStream.write(buffer, 0, len);
                }
            } while (inStream.available() > 0);
            fileOutStream.flush();
            fileOutStream.close();
        }
        catch (IOException e) {
            throw new OMException("Error creating temporary File.", e);
        }
    }

    private int parseTheHeaders(InputStream inStream) throws IOException {
        int value;
        boolean readingHeaders = true;
        StringBuffer header = new StringBuffer();
        while (readingHeaders & (value = inStream.read()) != -1) {
            if (value == 13) {
                value = inStream.read();
                if (value == 10) {
                    value = inStream.read();
                    if (value == 13) {
                        value = inStream.read();
                        if (value != 10) continue;
                        this.putToMap(header);
                        readingHeaders = false;
                        continue;
                    }
                    String check = header.toString().trim();
                    if (!check.endsWith(";")) {
                        this.putToMap(header);
                        header = new StringBuffer();
                    }
                    header.append((char)value);
                    continue;
                }
                header.append(13);
                header.append(value);
                continue;
            }
            header.append((char)value);
        }
        return value;
    }

    private void putToMap(StringBuffer header) {
        String headerString = header.toString();
        int delimiter = headerString.indexOf(":");
        if (log.isDebugEnabled()) {
            log.debug("header=" + headerString + ", delimiter=" + delimiter);
        }
        String name = headerString.substring(0, delimiter).trim();
        String value = headerString.substring(delimiter + 1, headerString.length()).trim();
        Header headerObj = new Header(name, value);
        this.headers.put(name, headerObj);
    }

    public String getContentID() {
        Header cID = (Header)this.headers.get("Content-ID");
        if (cID == null && (cID = (Header)this.headers.get("Content-Id")) == null && (cID = (Header)this.headers.get("Content-id")) == null) {
            cID = (Header)this.headers.get("content-id");
        }
        return cID.getValue();
    }

    public int getSize() throws MessagingException {
        return (int)this.cacheFile.length();
    }

    public int getLineCount() throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public String getDescription() throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public void setDescription(String arg0) throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public String getFileName() throws MessagingException {
        return this.cacheFile.getAbsolutePath();
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        return new FileInputStream(this.cacheFile);
    }

    public DataHandler getDataHandler() throws MessagingException {
        CachedFileDataSource dataSource = new CachedFileDataSource(this.cacheFile);
        dataSource.setContentType(this.getContentType());
        return new DataHandler(dataSource);
    }

    public Object getContent() throws IOException, MessagingException {
        return this.getDataHandler().getContent();
    }

    public void writeTo(OutputStream outStream) throws IOException, MessagingException {
        this.getDataHandler().writeTo(outStream);
    }

    public String getHeader(String arg0) throws MessagingException {
        return ((Header)this.headers.get(arg0)).getValue();
    }

    public void addHeader(String arg0, String arg1) throws MessagingException {
        Header headerObj = new Header(arg0, arg1);
        this.headers.put(arg0, headerObj);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        return this.headers.elements();
    }

    public String getContentType() throws MessagingException {
        Header cType = (Header)this.headers.get("Content-Type");
        if (cType == null && (cType = (Header)this.headers.get("Content-type")) == null) {
            cType = (Header)this.headers.get("content-type");
        }
        return cType.getValue();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

