/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.attachments.BoundaryPushbackInputStream;

public class MIMEBodyPartInputStream
extends InputStream {
    BoundaryPushbackInputStream bpis;
    PushbackInputStream inStream;
    Attachments parent = null;
    boolean done = false;
    private int one;
    private int two;

    public MIMEBodyPartInputStream(PushbackInputStream inStream, byte[] boundary) {
        this(inStream, boundary, null, boundary.length + 2);
    }

    public MIMEBodyPartInputStream(PushbackInputStream inStream, byte[] boundary, Attachments parent) {
        this(inStream, boundary, parent, boundary.length + 2);
    }

    public MIMEBodyPartInputStream(PushbackInputStream inStream, byte[] boundary, Attachments parent, int pushbacksize) {
        this.bpis = new BoundaryPushbackInputStream(inStream, boundary, pushbacksize);
        this.inStream = inStream;
        this.parent = parent;
    }

    public int read() throws IOException {
        if (this.done) {
            return -1;
        }
        int rc = this.bpis.read();
        if (this.getBoundaryStatus()) {
            this.finish();
        }
        return rc;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.done) {
            return 0;
        }
        int rc = this.bpis.read(b, off, len);
        if (this.getBoundaryStatus()) {
            this.finish();
        }
        return rc;
    }

    public int read(byte[] b) throws IOException {
        if (this.done) {
            return 0;
        }
        int rc = this.bpis.read(b);
        if (this.getBoundaryStatus()) {
            this.finish();
        }
        return rc;
    }

    private void finish() throws IOException {
        if (!this.done) {
            if (!this.read2bytes()) {
                this.done = true;
                return;
            }
            if (this.one == 45 && this.two == 45) {
                if (this.parent != null) {
                    this.parent.setEndOfStream(true);
                }
                if (!this.read2bytes()) {
                    this.done = true;
                    return;
                }
            }
            while (this.one == 13 && this.two == 10) {
                if (this.read2bytes()) continue;
                this.done = true;
                return;
            }
            this.unread2bytes();
        }
        this.done = true;
    }

    private boolean read2bytes() throws IOException {
        this.one = this.inStream.read();
        if (this.one == -1) {
            return false;
        }
        this.two = this.inStream.read();
        if (this.two == -1) {
            this.inStream.unread(this.one);
            return false;
        }
        return true;
    }

    private void unread2bytes() throws IOException {
        this.inStream.unread(this.two);
        this.inStream.unread(this.one);
    }

    public boolean getBoundaryStatus() {
        return this.bpis.getBoundaryStatus();
    }

    public int available() throws IOException {
        if (this.done) {
            return 0;
        }
        return this.bpis.available();
    }
}

