/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;

public abstract class SAAJMetaFactory {
    private static final String SYSTEM_PROPERTY = "javax.xml.soap.MetaFactory";
    private static final String DEFAULT_FACTORY = "com.ibm.ws.webservices.engine.soap.SAAJMetaFactoryImpl";

    protected SAAJMetaFactory() {
    }

    static SAAJMetaFactory getInstance() throws SOAPException {
        return SAAJMetaFactory._getInstance();
    }

    private static synchronized SAAJMetaFactory _getInstance() throws SOAPException {
        try {
            Properties props;
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            String factoryClassName = System.getProperty(SYSTEM_PROPERTY);
            if (factoryClassName == null && (props = SAAJMetaFactory.loadJAXMProperties(classloader)) != null) {
                factoryClassName = props.getProperty(SYSTEM_PROPERTY);
            }
            if (factoryClassName == null) {
                String factoryResource = "META-INF/services/javax.xml.soap.MetaFactory";
                InputStream inputstream = null;
                inputstream = classloader == null ? ClassLoader.getSystemResourceAsStream(factoryResource) : classloader.getResourceAsStream(factoryResource);
                if (inputstream != null) {
                    BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputstream, "UTF-8"));
                    factoryClassName = bufferedreader.readLine();
                    bufferedreader.close();
                }
            }
            if (factoryClassName == null) {
                factoryClassName = DEFAULT_FACTORY;
            }
            if (factoryClassName == null) {
                throw new SOAPException("Provider for javax.xml.soap.MetaFactory cannot be found", null);
            }
            Class<?> factoryClass = classloader == null ? Class.forName(factoryClassName) : classloader.loadClass(factoryClassName);
            Object factory = factoryClass.newInstance();
            return (SAAJMetaFactory)factory;
        }
        catch (Exception exception) {
            throw new SOAPException("Unable to create SOAP Factory: " + exception.getMessage());
        }
    }

    private static Properties loadJAXMProperties(ClassLoader classloader) {
        String JAVA_HOME = "java.home";
        String JAXM_PROPS = "lib\\jaxm.properties";
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            return null;
        }
        final String file = javaHome + "\\" + "lib\\jaxm.properties";
        Properties props = null;
        try {
            props = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException, IOException {
                    Properties props = new Properties();
                    FileInputStream inputstream = null;
                    inputstream = new FileInputStream(file);
                    if (inputstream == null) {
                        return null;
                    }
                    props.load(inputstream);
                    return props;
                }
            });
        }
        catch (PrivilegedActionException e) {
            return null;
        }
        return props;
    }

    protected abstract MessageFactory newMessageFactory(String var1) throws SOAPException;

    protected abstract SOAPFactory newSOAPFactory(String var1) throws SOAPException;
}

