/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server.provider;

import com.sun.xml.bind.api.JAXBRIContext;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.activation.DataSource;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.soap.SOAPBinding;

public class ProviderModel {
    private final boolean isSource;
    private final Service.Mode mode;

    public ProviderModel(Class implementorClass, Binding binding) {
        assert (implementorClass != null);
        assert (binding != null);
        this.mode = ProviderModel.getServiceMode(implementorClass);
        Class otherClass = binding instanceof SOAPBinding ? SOAPMessage.class : DataSource.class;
        this.isSource = ProviderModel.isSource(implementorClass, otherClass);
        if (this.mode == Service.Mode.PAYLOAD && !this.isSource) {
            throw new IllegalArgumentException("Illeagal combination - Mode.PAYLOAD and Provider<" + otherClass.getName() + ">");
        }
    }

    public boolean isSource() {
        return this.isSource;
    }

    public Service.Mode getServiceMode() {
        return this.mode;
    }

    private static Service.Mode getServiceMode(Class c) {
        ServiceMode mode = c.getAnnotation(ServiceMode.class);
        if (mode == null) {
            return Service.Mode.PAYLOAD;
        }
        return mode.value();
    }

    private static boolean isSource(Class c, Class otherClass) {
        Type base = JAXBRIContext.getBaseType(c, Provider.class);
        assert (base != null);
        if (base instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)base;
            Type[] types = pt.getActualTypeArguments();
            if (types[0] instanceof Class && Source.class.isAssignableFrom((Class)types[0])) {
                return true;
            }
            if (types[0] instanceof Class && otherClass.isAssignableFrom((Class)types[0])) {
                return false;
            }
        }
        throw new IllegalArgumentException("Endpoint should implement Provider<" + Source.class.getName() + "> or Provider<" + otherClass.getName() + ">");
    }
}

