/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.model;

import com.sun.xml.bind.api.Bridge;
import com.sun.xml.bind.api.BridgeContext;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.bind.api.RawAccessor;
import com.sun.xml.bind.api.TypeReference;
import com.sun.xml.ws.encoding.JAXWSAttachmentMarshaller;
import com.sun.xml.ws.encoding.JAXWSAttachmentUnmarshaller;
import com.sun.xml.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.ws.encoding.jaxb.RpcLitPayload;
import com.sun.xml.ws.model.CheckedException;
import com.sun.xml.ws.model.JavaMethod;
import com.sun.xml.ws.model.Mode;
import com.sun.xml.ws.model.Parameter;
import com.sun.xml.ws.model.ParameterBinding;
import com.sun.xml.ws.model.WrapperParameter;
import com.sun.xml.ws.model.soap.SOAPBinding;
import com.sun.xml.ws.wsdl.parser.Binding;
import com.sun.xml.ws.wsdl.parser.BindingOperation;
import com.sun.xml.ws.wsdl.parser.Part;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RuntimeModel {
    private boolean enableMtom = false;
    private ThreadLocal<BridgeContext> bridgeContext = new ThreadLocal();
    protected JAXBRIContext jaxbContext;
    private String wsdlLocation;
    private QName serviceName;
    private QName portName;
    private QName portTypeName;
    private Map<Method, JavaMethod> methodToJM = new HashMap<Method, JavaMethod>();
    private Map<QName, JavaMethod> nameToJM = new HashMap<QName, JavaMethod>();
    private List<JavaMethod> javaMethods = new ArrayList<JavaMethod>();
    private final Map<TypeReference, Bridge> bridgeMap = new HashMap<TypeReference, Bridge>();
    private final Map<QName, Object> payloadMap = new HashMap<QName, Object>();
    protected final QName emptyBodyName = new QName("");
    private String targetNamespace = "";
    private final Map<Integer, RawAccessor> rawAccessorMap = new HashMap<Integer, RawAccessor>();
    private List<String> knownNamespaceURIs = null;

    public void postProcess() {
        if (this.jaxbContext != null) {
            return;
        }
        this.populateMaps();
        this.populateAsyncExceptions();
        this.createJAXBContext();
        this.createDecoderInfo();
    }

    protected void populateMaps() {
        for (JavaMethod jm : this.getJavaMethods()) {
            this.put(jm.getMethod(), jm);
            for (Parameter p : jm.getRequestParameters()) {
                this.put(p.getName(), jm);
            }
        }
    }

    protected void populateAsyncExceptions() {
        for (JavaMethod jm : this.getJavaMethods()) {
            int mep = jm.getMEP();
            if (mep != 4 && mep != 3) continue;
            String opName = jm.getOperationName();
            Method m = jm.getMethod();
            Class<?>[] params = m.getParameterTypes();
            if (mep == 4) {
                params = new Class[params.length - 1];
                System.arraycopy(m.getParameterTypes(), 0, params, 0, m.getParameterTypes().length - 1);
            }
            try {
                Method om = m.getDeclaringClass().getMethod(opName, params);
                JavaMethod jm2 = this.getJavaMethod(om);
                for (CheckedException ce : jm2.getCheckedExceptions()) {
                    jm.addException(ce);
                }
            }
            catch (NoSuchMethodException ex) {
            }
        }
    }

    public BridgeContext getBridgeContext() {
        if (this.jaxbContext == null) {
            return null;
        }
        BridgeContext bc = this.bridgeContext.get();
        if (bc == null) {
            bc = this.jaxbContext.createBridgeContext();
            bc.setAttachmentMarshaller(new JAXWSAttachmentMarshaller(this.enableMtom));
            bc.setAttachmentUnmarshaller(new JAXWSAttachmentUnmarshaller());
            this.bridgeContext.set(bc);
        }
        return bc;
    }

    public JAXBRIContext getJAXBContext() {
        return this.jaxbContext;
    }

    public List<String> getKnownNamespaceURIs() {
        return this.knownNamespaceURIs;
    }

    public Bridge getBridge(TypeReference type) {
        return this.bridgeMap.get(type);
    }

    public Object getDecoderInfo(QName name) {
        Object obj = this.payloadMap.get(name);
        if (obj instanceof RpcLitPayload) {
            return RpcLitPayload.copy((RpcLitPayload)obj);
        }
        if (obj instanceof JAXBBridgeInfo) {
            return JAXBBridgeInfo.copy((JAXBBridgeInfo)obj);
        }
        return null;
    }

    public void addDecoderInfo(QName name, Object payload) {
        this.payloadMap.put(name, payload);
    }

    private JAXBRIContext createJAXBContext() {
        final List<TypeReference> types = this.getAllTypeReferences();
        final Class[] cls = new Class[types.size()];
        final String ns = this.targetNamespace;
        int i = 0;
        for (TypeReference type : types) {
            cls[i++] = (Class)type.type;
        }
        try {
            this.jaxbContext = (JAXBRIContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return JAXBRIContext.newInstance(cls, types, ns, false);
                }
            });
            this.createBridgeMap(types);
        }
        catch (PrivilegedActionException e) {
            throw new WebServiceException(e.getMessage(), e.getException());
        }
        this.knownNamespaceURIs = new ArrayList<String>();
        for (String namespace : this.jaxbContext.getKnownNamespaceURIs()) {
            if (namespace.length() <= 0 || namespace.equals("http://www.w3.org/2001/XMLSchema") || namespace.equals("http://www.w3.org/XML/1998/namespace")) continue;
            this.knownNamespaceURIs.add(namespace);
        }
        return this.jaxbContext;
    }

    public List<TypeReference> getAllTypeReferences() {
        ArrayList<TypeReference> types = new ArrayList<TypeReference>();
        Collection<JavaMethod> methods = this.methodToJM.values();
        for (JavaMethod m : methods) {
            this.fillTypes(m, types);
            this.fillFaultDetailTypes(m, types);
        }
        return types;
    }

    private void fillFaultDetailTypes(JavaMethod m, List<TypeReference> types) {
        for (CheckedException ce : m.getCheckedExceptions()) {
            types.add(ce.getDetailType());
        }
    }

    protected void fillTypes(JavaMethod m, List<TypeReference> types) {
        this.addTypes(m.getRequestParameters(), types);
        this.addTypes(m.getResponseParameters(), types);
    }

    private void addTypes(List<Parameter> params, List<TypeReference> types) {
        for (Parameter p : params) {
            types.add(p.getTypeReference());
        }
    }

    private void createBridgeMap(List<TypeReference> types) {
        for (TypeReference type : types) {
            Bridge bridge = this.jaxbContext.createBridge(type);
            this.bridgeMap.put(type, bridge);
        }
    }

    public Method getDispatchMethod(QName qname2) {
        JavaMethod jm;
        if (qname2 == null) {
            qname2 = this.emptyBodyName;
        }
        if ((jm = this.getJavaMethod(qname2)) != null) {
            return jm.getMethod();
        }
        return null;
    }

    public boolean isKnownFault(QName name, Method method) {
        JavaMethod m = this.getJavaMethod(method);
        for (CheckedException ce : m.getCheckedExceptions()) {
            if (!ce.getDetailType().tagName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isCheckedException(Method m, Class ex) {
        JavaMethod jm = this.getJavaMethod(m);
        for (CheckedException ce : jm.getCheckedExceptions()) {
            if (!ce.getExcpetionClass().equals(ex)) continue;
            return true;
        }
        return false;
    }

    public JavaMethod getJavaMethod(Method method) {
        return this.methodToJM.get(method);
    }

    public JavaMethod getJavaMethod(QName name) {
        return this.nameToJM.get(name);
    }

    public QName getQNameForJM(JavaMethod jm) {
        Set<QName> set = this.nameToJM.keySet();
        for (QName key : set) {
            JavaMethod jmethod = this.nameToJM.get(key);
            if (!jmethod.getOperationName().equals(jm.getOperationName())) continue;
            return key;
        }
        return null;
    }

    public Collection<JavaMethod> getJavaMethods() {
        return Collections.unmodifiableList(this.javaMethods);
    }

    public void addJavaMethod(JavaMethod jm) {
        if (jm != null) {
            this.javaMethods.add(jm);
        }
    }

    public void applyParameterBinding(Binding wsdlBinding) {
        if (wsdlBinding == null) {
            return;
        }
        wsdlBinding.finalizeBinding();
        for (JavaMethod method : this.javaMethods) {
            if (method.isAsync()) continue;
            boolean isRpclit = ((SOAPBinding)method.getBinding()).isRpcLit();
            List<Parameter> reqParams = method.getRequestParameters();
            List<Parameter> reqAttachParams = null;
            for (Parameter param : reqParams) {
                ParameterBinding paramBinding;
                if (param.isWrapperStyle()) {
                    if (!isRpclit) continue;
                    WrapperParameter reqParam = (WrapperParameter)param;
                    BindingOperation bo = (BindingOperation)wsdlBinding.get(method.getOperationName());
                    if (bo != null && bo.getRequestNamespace() != null) {
                        this.patchRpclitNamespace(bo.getRequestNamespace(), reqParam);
                    }
                    reqAttachParams = this.applyRpcLitParamBinding(method, reqParam, wsdlBinding, Mode.IN);
                    continue;
                }
                String partName = param.getPartName();
                if (partName == null || (paramBinding = wsdlBinding.getBinding(method.getOperationName(), partName, Mode.IN)) == null) continue;
                param.setInBinding(paramBinding);
            }
            List<Parameter> resAttachParams = null;
            List<Parameter> resParams = method.getResponseParameters();
            for (Parameter param : resParams) {
                ParameterBinding paramBinding;
                if (param.isWrapperStyle()) {
                    if (!isRpclit) continue;
                    WrapperParameter respParam = (WrapperParameter)param;
                    BindingOperation bo = (BindingOperation)wsdlBinding.get(method.getOperationName());
                    if (bo != null && bo.getResponseNamespace() != null) {
                        this.patchRpclitNamespace(bo.getResponseNamespace(), respParam);
                    }
                    resAttachParams = this.applyRpcLitParamBinding(method, respParam, wsdlBinding, Mode.OUT);
                    continue;
                }
                String partName = param.getPartName();
                if (partName == null || (paramBinding = wsdlBinding.getBinding(method.getOperationName(), partName, Mode.OUT)) == null) continue;
                param.setOutBinding(paramBinding);
            }
            if (reqAttachParams != null) {
                for (Parameter p : reqAttachParams) {
                    method.addRequestParameter(p);
                }
            }
            if (resAttachParams == null) continue;
            for (Parameter p : resAttachParams) {
                method.addResponseParameter(p);
            }
        }
    }

    private void patchRpclitNamespace(String namespace, WrapperParameter param) {
        TypeReference type = param.getTypeReference();
        TypeReference newType = new TypeReference(new QName(namespace, type.tagName.getLocalPart()), type.type, type.annotations);
        param.setTypeReference(newType);
    }

    private List<Parameter> applyRpcLitParamBinding(JavaMethod method, WrapperParameter wrapperParameter, Binding wsdlBinding, Mode mode) {
        JAXBBridgeInfo bi;
        String opName = method.getOperationName();
        RpcLitPayload payload = new RpcLitPayload(wrapperParameter.getName());
        BindingOperation bo = (BindingOperation)wsdlBinding.get(opName);
        HashMap<Integer, Parameter> bodyParams = new HashMap<Integer, Parameter>();
        ArrayList<Parameter> unboundParams = new ArrayList<Parameter>();
        ArrayList<Parameter> attachParams = new ArrayList<Parameter>();
        for (Parameter param : wrapperParameter.getWrapperChildren()) {
            ParameterBinding paramBinding;
            String partName = param.getPartName();
            if (partName == null || (paramBinding = wsdlBinding.getBinding(opName, partName, mode)) == null) continue;
            if (mode == Mode.IN) {
                param.setInBinding(paramBinding);
            } else if (mode == Mode.OUT) {
                param.setOutBinding(paramBinding);
            }
            if (paramBinding.isUnbound()) {
                unboundParams.add(param);
                continue;
            }
            if (paramBinding.isAttachment()) {
                attachParams.add(param);
                continue;
            }
            if (!paramBinding.isBody()) continue;
            if (bo != null) {
                Part p = bo.getPart(param.getPartName(), mode);
                if (p != null) {
                    bodyParams.put(p.getIndex(), param);
                    continue;
                }
                bodyParams.put(bodyParams.size(), param);
                continue;
            }
            bodyParams.put(bodyParams.size(), param);
        }
        wrapperParameter.clear();
        for (int i = 0; i < bodyParams.size(); ++i) {
            Parameter p = (Parameter)bodyParams.get(i);
            wrapperParameter.addWrapperChild(p);
            if ((mode != Mode.IN || !p.getInBinding().isBody()) && (mode != Mode.OUT || !p.getOutBinding().isBody())) continue;
            bi = new JAXBBridgeInfo(this.getBridge(p.getTypeReference()), null);
            payload.addParameter(bi);
        }
        for (Parameter p : attachParams) {
            bi = new JAXBBridgeInfo(this.getBridge(p.getTypeReference()), null);
            this.payloadMap.put(p.getName(), bi);
        }
        for (Parameter p : unboundParams) {
            wrapperParameter.addWrapperChild(p);
        }
        this.payloadMap.put(wrapperParameter.getName(), payload);
        return attachParams;
    }

    protected void put(QName name, JavaMethod jm) {
        this.nameToJM.put(name, jm);
    }

    protected void put(Method method, JavaMethod jm) {
        this.methodToJM.put(method, jm);
    }

    public String getWSDLLocation() {
        return this.wsdlLocation;
    }

    public void setWSDLLocation(String location) {
        this.wsdlLocation = location;
    }

    public QName getServiceQName() {
        return this.serviceName;
    }

    public QName getPortName() {
        return this.portName;
    }

    public QName getPortTypeName() {
        return this.portTypeName;
    }

    public void setServiceQName(QName name) {
        this.serviceName = name;
    }

    public void setPortName(QName name) {
        this.portName = name;
    }

    public void setPortTypeName(QName name) {
        this.portTypeName = name;
    }

    public void setTargetNamespace(String namespace) {
        this.targetNamespace = namespace;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void enableMtom(boolean enableMtom) {
        this.enableMtom = enableMtom;
    }

    public Map<Integer, RawAccessor> getRawAccessorMap() {
        return this.rawAccessorMap;
    }

    protected abstract void createDecoderInfo();
}

