/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding.soap;

import com.sun.xml.bind.api.BridgeContext;
import com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType;
import com.sun.xml.messaging.saaj.packaging.mime.internet.ParseException;
import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.ws.client.dispatch.DispatchContext;
import com.sun.xml.ws.client.dispatch.impl.encoding.DispatchUtil;
import com.sun.xml.ws.encoding.JAXWSAttachmentUnmarshaller;
import com.sun.xml.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.ws.encoding.jaxb.RpcLitPayload;
import com.sun.xml.ws.encoding.jaxb.RpcLitPayloadSerializer;
import com.sun.xml.ws.encoding.soap.SOAPConstants;
import com.sun.xml.ws.encoding.soap.internal.AttachmentBlock;
import com.sun.xml.ws.encoding.soap.internal.BodyBlock;
import com.sun.xml.ws.encoding.soap.internal.HeaderBlock;
import com.sun.xml.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.ws.handler.HandlerChainCaller;
import com.sun.xml.ws.handler.HandlerContext;
import com.sun.xml.ws.model.soap.SOAPRuntimeModel;
import com.sun.xml.ws.pept.encoding.Decoder;
import com.sun.xml.ws.pept.ept.MessageInfo;
import com.sun.xml.ws.server.RuntimeContext;
import com.sun.xml.ws.streaming.SourceReaderFactory;
import com.sun.xml.ws.streaming.XMLReaderException;
import com.sun.xml.ws.streaming.XMLStreamReaderException;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.ws.util.FastInfosetReflection;
import com.sun.xml.ws.util.MessageInfoUtil;
import com.sun.xml.ws.util.SOAPUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SOAPDecoder
implements Decoder {
    public static final String NOT_UNDERSTOOD_HEADERS = "not-understood soap headers";
    protected static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.soap.decoder");
    protected static final String MUST_UNDERSTAND_FAULT_MESSAGE_STRING = "SOAP must understand error";
    private static final String DUPLICATE_HEADER = "Duplicate Header in the message:";
    protected DispatchUtil dispatchUtil = new DispatchUtil();

    @Override
    public void decode(MessageInfo arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void receiveAndDecode(MessageInfo arg0) {
        throw new UnsupportedOperationException();
    }

    public InternalMessage toInternalMessage(SOAPMessage soapMessage, MessageInfo messageInfo) {
        return null;
    }

    public Set<String> getRequiredRoles() {
        return new HashSet<String>();
    }

    public InternalMessage toInternalMessage(SOAPMessage soapMessage, InternalMessage internalMessage, MessageInfo messageInfo) {
        return null;
    }

    public SOAPMessage toSOAPMessage(MessageInfo messageInfo) {
        return null;
    }

    public void toMessageInfo(InternalMessage internalMessage, MessageInfo messageInfo) {
    }

    protected QName getEnvelopeTag() {
        return SOAPConstants.QNAME_SOAP_ENVELOPE;
    }

    protected QName getBodyTag() {
        return SOAPConstants.QNAME_SOAP_BODY;
    }

    protected QName getHeaderTag() {
        return SOAPConstants.QNAME_SOAP_HEADER;
    }

    protected QName getMUAttrQName() {
        return SOAPConstants.QNAME_MUSTUNDERSTAND;
    }

    protected QName getRoleAttrQName() {
        return SOAPConstants.QNAME_ROLE;
    }

    protected QName getFaultTag() {
        return SOAPConstants.QNAME_SOAP_FAULT;
    }

    protected QName getFaultDetailTag() {
        return SOAPConstants.QNAME_SOAP_FAULT_DETAIL;
    }

    protected void skipBody(XMLStreamReader reader) {
        XMLStreamReaderUtil.verifyReaderState(reader, 1);
        XMLStreamReaderUtil.verifyTag(reader, this.getBodyTag());
        XMLStreamReaderUtil.skipElement(reader);
        XMLStreamReaderUtil.nextElementContent(reader);
    }

    protected void skipHeader(XMLStreamReader reader, MessageInfo messageInfo) {
        XMLStreamReaderUtil.verifyReaderState(reader, 1);
        if (!this.isDispatch(messageInfo)) {
            return;
        }
        if (!"Header".equals(reader.getLocalName())) {
            return;
        }
        this.dispatchUtil.collectPrefixes(reader);
        XMLStreamReaderUtil.skipElement(reader);
        try {
            reader.next();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected boolean skipHeader(MessageInfo messageInfo) {
        return messageInfo.getMetaData("com.sun.xml.ws.rt.client.dispatch.mode") == Service.Mode.PAYLOAD;
    }

    protected void decodeEnvelope(XMLStreamReader reader, InternalMessage request, boolean skipBody, MessageInfo messageInfo) {
        XMLStreamReaderUtil.verifyReaderState(reader, 1);
        XMLStreamReaderUtil.verifyTag(reader, this.getEnvelopeTag());
        XMLStreamReaderUtil.nextElementContent(reader);
        if (this.skipHeader(messageInfo)) {
            this.skipHeader(reader, messageInfo);
        } else {
            this.decodeHeader(reader, messageInfo, request);
        }
        if (skipBody) {
            this.skipBody(reader);
        } else {
            this.decodeBody(reader, request, messageInfo);
        }
        XMLStreamReaderUtil.verifyReaderState(reader, 2);
        XMLStreamReaderUtil.verifyTag(reader, this.getEnvelopeTag());
        XMLStreamReaderUtil.nextElementContent(reader);
        XMLStreamReaderUtil.verifyReaderState(reader, 8);
    }

    protected void decodeHeader(XMLStreamReader reader, MessageInfo messageInfo, InternalMessage request) {
        XMLStreamReaderUtil.verifyReaderState(reader, 1);
        if (!"Header".equals(reader.getLocalName())) {
            return;
        }
        XMLStreamReaderUtil.verifyTag(reader, this.getHeaderTag());
        if (this.isDispatch(messageInfo)) {
            this.dispatchUtil.collectPrefixes(reader);
        }
        XMLStreamReaderUtil.nextElementContent(reader);
        while (reader.getEventType() == 1) {
            this.decodeHeaderElement(reader, messageInfo, request);
        }
        XMLStreamReaderUtil.verifyReaderState(reader, 2);
        XMLStreamReaderUtil.verifyTag(reader, this.getHeaderTag());
        XMLStreamReaderUtil.nextElementContent(reader);
    }

    protected void decodeHeaderElement(XMLStreamReader reader, MessageInfo messageInfo, InternalMessage msg) {
        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo);
        if (rtCtxt == null) {
            XMLStreamReaderUtil.skipElement(reader);
            XMLStreamReaderUtil.nextElementContent(reader);
            return;
        }
        BridgeContext bridgeContext = rtCtxt.getBridgeContext();
        Set<QName> knownHeaders = ((SOAPRuntimeModel)rtCtxt.getModel()).getKnownHeaders();
        QName name = reader.getName();
        if (knownHeaders != null && knownHeaders.contains(name)) {
            Object decoderInfo;
            QName headerName = reader.getName();
            if (msg.isHeaderPresent(name)) {
                this.raiseFault(this.getSenderFaultCode(), DUPLICATE_HEADER + headerName);
            }
            if ((decoderInfo = rtCtxt.getDecoderInfo(name)) != null && decoderInfo instanceof JAXBBridgeInfo) {
                JAXBBridgeInfo bridgeInfo = (JAXBBridgeInfo)decoderInfo;
                bridgeInfo.deserialize(reader, bridgeContext);
                HeaderBlock headerBlock = new HeaderBlock(bridgeInfo);
                msg.addHeader(headerBlock);
            }
        } else {
            XMLStreamReaderUtil.skipElement(reader);
            XMLStreamReaderUtil.nextElementContent(reader);
        }
    }

    protected void decodeBody(XMLStreamReader reader, InternalMessage response, MessageInfo messageInfo) {
        XMLStreamReaderUtil.verifyReaderState(reader, 1);
        XMLStreamReaderUtil.verifyTag(reader, this.getBodyTag());
        int state = XMLStreamReaderUtil.nextElementContent(reader);
        this.decodeBodyContent(reader, response, messageInfo);
        XMLStreamReaderUtil.verifyReaderState(reader, 2);
        XMLStreamReaderUtil.verifyTag(reader, this.getBodyTag());
        XMLStreamReaderUtil.nextElementContent(reader);
    }

    protected void decodeBodyContent(XMLStreamReader reader, InternalMessage response, MessageInfo messageInfo) {
        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo);
        BridgeContext bridgeContext = rtCtxt.getBridgeContext();
        this.decodeDispatchMethod(reader, response, messageInfo);
        if (reader.getEventType() == 1) {
            QName name = reader.getName();
            if (name.getNamespaceURI().equals(this.getEnvelopeTag().getNamespaceURI()) && name.getLocalPart().equals("Fault")) {
                SOAPFaultInfo soapFaultInfo = this.decodeFault(reader, response, messageInfo);
                BodyBlock responseBody = new BodyBlock(soapFaultInfo);
                response.setBody(responseBody);
            } else {
                Object decoderInfo = rtCtxt.getDecoderInfo(name);
                if (decoderInfo != null && decoderInfo instanceof JAXBBridgeInfo) {
                    JAXBBridgeInfo bridgeInfo = (JAXBBridgeInfo)decoderInfo;
                    bridgeInfo.deserialize(reader, bridgeContext);
                    BodyBlock responseBody = new BodyBlock(bridgeInfo);
                    response.setBody(responseBody);
                } else if (decoderInfo != null && decoderInfo instanceof RpcLitPayload) {
                    RpcLitPayload rpcLitPayload = (RpcLitPayload)decoderInfo;
                    RpcLitPayloadSerializer.deserialize(reader, rpcLitPayload, bridgeContext);
                    BodyBlock responseBody = new BodyBlock(rpcLitPayload);
                    response.setBody(responseBody);
                }
            }
        }
    }

    public void decodeDispatchMethod(XMLStreamReader reader, InternalMessage request, MessageInfo messageInfo) {
    }

    protected SOAPFaultInfo decodeFault(XMLStreamReader reader, InternalMessage internalMessage, MessageInfo messageInfo) {
        return null;
    }

    protected void convertBodyBlock(InternalMessage request, MessageInfo messageInfo) {
        Object value;
        BodyBlock bodyBlock = request.getBody();
        if (bodyBlock != null && !((value = bodyBlock.getValue()) instanceof JAXBBridgeInfo) && !(value instanceof RpcLitPayload)) {
            if (value instanceof Source) {
                Source source = (Source)value;
                XMLStreamReader reader = SourceReaderFactory.createSourceReader(source, true);
                XMLStreamReaderUtil.nextElementContent(reader);
                this.decodeBodyContent(reader, request, messageInfo);
            } else {
                throw new WebServiceException("Shouldn't happen. Unknown type in BodyBlock =" + value.getClass());
            }
        }
    }

    protected void processAttachments(MessageInfo mi, InternalMessage im, SOAPMessage message) throws SOAPException, ParseException, IOException {
        Iterator iter = message.getAttachments();
        if (iter.hasNext()) {
            JAXWSAttachmentUnmarshaller au = null;
            if (MessageInfoUtil.getRuntimeContext(mi) != null) {
                au = (JAXWSAttachmentUnmarshaller)MessageInfoUtil.getRuntimeContext(mi).getBridgeContext().getAttachmentUnmarshaller();
            } else {
                Unmarshaller m = (Unmarshaller)mi.getMetaData("com.sun.xml.ws.client.dispatch.unmarshaller");
                if (m != null) {
                    au = (JAXWSAttachmentUnmarshaller)m.getAttachmentUnmarshaller();
                }
            }
            if (au != null) {
                au.setXOPPackage(this.isXOPPackage(message));
                au.setAttachments(im.getAttachments());
            }
        }
        while (iter.hasNext()) {
            AttachmentPart ap = (AttachmentPart)iter.next();
            im.addAttachment(AttachmentBlock.fromSAAJ(ap));
        }
    }

    private boolean isXOPPackage(SOAPMessage sm) throws ParseException {
        String type;
        String ct = this.getContentType(sm.getSOAPPart());
        ContentType contentType = new ContentType(ct);
        String primary = contentType.getPrimaryType();
        String sub = contentType.getSubType();
        return primary.equalsIgnoreCase("application") && sub.equalsIgnoreCase("xop+xml") && ((type = contentType.getParameter("type")).toLowerCase().startsWith("text/xml") || type.toLowerCase().startsWith("application/soap+xml"));
    }

    private String getContentType(SOAPPart part) {
        String[] values = part.getMimeHeader("Content-Type");
        if (values == null) {
            return null;
        }
        return values[0];
    }

    public boolean doMustUnderstandProcessing(SOAPMessage soapMessage, MessageInfo mi, HandlerContext handlerContext, boolean getMEP) throws SOAPException, IOException {
        try {
            boolean oneway = false;
            Source source = soapMessage.getSOAPPart().getContent();
            ByteInputStream bis = null;
            if (source instanceof StreamSource) {
                StreamSource streamSource = (StreamSource)source;
                InputStream is = streamSource.getInputStream();
                if (is != null && is instanceof ByteInputStream) {
                    bis = (ByteInputStream)is;
                } else {
                    logger.fine("SAAJ StreamSource doesn't have ByteInputStream " + is);
                }
            } else if (FastInfosetReflection.isFastInfosetSource(source)) {
                try {
                    bis = (ByteInputStream)FastInfosetReflection.FastInfosetSource_getInputStream(source);
                }
                catch (Exception e) {
                    throw new XMLReaderException("fastinfoset.noImplementation", new Object[0]);
                }
            } else {
                logger.fine("Inefficient Use - SOAPMessage is already parsed");
            }
            XMLStreamReader reader = SourceReaderFactory.createSourceReader(source, true);
            XMLStreamReaderUtil.nextElementContent(reader);
            this.checkMustUnderstandHeaders(reader, mi, handlerContext);
            if (getMEP) {
                oneway = this.isOneway(reader, mi);
            }
            XMLStreamReaderUtil.close(reader);
            if (bis != null) {
                bis.close();
            }
            return oneway;
        }
        catch (XMLStreamReaderException xe) {
            this.raiseBadXMLFault(handlerContext);
            throw xe;
        }
    }

    private boolean isOneway(XMLStreamReader reader, MessageInfo mi) {
        XMLStreamReaderUtil.verifyReaderState(reader, 1);
        XMLStreamReaderUtil.verifyTag(reader, this.getBodyTag());
        int state = XMLStreamReaderUtil.nextElementContent(reader);
        QName operationName = null;
        if (state == 1) {
            operationName = reader.getName();
        }
        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(mi);
        rtCtxt.setMethodAndMEP(operationName, mi);
        return mi.getMEP() == 2;
    }

    private void checkMustUnderstandHeaders(XMLStreamReader reader, MessageInfo mi, HandlerContext context) {
        SOAPRuntimeModel model;
        XMLStreamReaderUtil.verifyReaderState(reader, 1);
        QName got = reader.getName();
        QName exp = this.getEnvelopeTag();
        if (got.getLocalPart().equals(exp.getLocalPart()) && !got.getNamespaceURI().equals(exp.getNamespaceURI())) {
            this.raiseFault(this.getVersionMismatchFaultCode(), "Invalid SOAP envelope version");
        }
        XMLStreamReaderUtil.verifyTag(reader, this.getEnvelopeTag());
        XMLStreamReaderUtil.nextElementContent(reader);
        XMLStreamReaderUtil.verifyReaderState(reader, 1);
        if (!"Header".equals(reader.getLocalName())) {
            return;
        }
        XMLStreamReaderUtil.verifyTag(reader, this.getHeaderTag());
        XMLStreamReaderUtil.nextElementContent(reader);
        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(mi);
        HashSet<String> roles = new HashSet<String>();
        roles.addAll(this.getRequiredRoles());
        HandlerChainCaller hcCaller = MessageInfoUtil.getHandlerChainCaller(mi);
        if (hcCaller != null) {
            roles.addAll(hcCaller.getRoles());
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("roles:");
            for (String r : roles) {
                logger.finest("\t\"" + r + "\"");
            }
        }
        Set<QName> understoodHeaders = null;
        if (rtCtxt != null && (model = (SOAPRuntimeModel)rtCtxt.getModel()) != null && model.getKnownHeaders() != null) {
            understoodHeaders = new HashSet<QName>(((SOAPRuntimeModel)rtCtxt.getModel()).getKnownHeaders());
        }
        if (understoodHeaders == null) {
            if (hcCaller != null) {
                understoodHeaders = hcCaller.getUnderstoodHeaders();
            }
        } else if (hcCaller != null) {
            understoodHeaders.addAll(hcCaller.getUnderstoodHeaders());
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("understood headers:");
            if (understoodHeaders == null || understoodHeaders.isEmpty()) {
                logger.finest("\tnone");
            } else {
                for (QName nameX : understoodHeaders) {
                    logger.finest("\t" + nameX.toString());
                }
            }
        }
        this.checkHeadersAgainstKnown(reader, roles, understoodHeaders, mi);
        XMLStreamReaderUtil.verifyReaderState(reader, 2);
        XMLStreamReaderUtil.verifyTag(reader, this.getHeaderTag());
        XMLStreamReaderUtil.nextElementContent(reader);
    }

    protected void checkHeadersAgainstKnown(XMLStreamReader reader, Set<String> roles, Set<QName> understoodHeaders, MessageInfo mi) {
        while (reader.getEventType() == 1) {
            String role;
            QName qName = reader.getName();
            String mu = reader.getAttributeValue(this.getMUAttrQName().getNamespaceURI(), this.getMUAttrQName().getLocalPart());
            if (mu != null && (mu.equals("1") || mu.equalsIgnoreCase("true")) && (role = reader.getAttributeValue(this.getRoleAttrQName().getNamespaceURI(), this.getRoleAttrQName().getLocalPart())) != null && roles.contains(role)) {
                logger.finest("Element=" + qName + " targeted at=" + role);
                if (understoodHeaders == null || !understoodHeaders.contains(qName)) {
                    logger.finest("Element not understood=" + qName);
                    SOAPFault sf = SOAPUtil.createSOAPFault(MUST_UNDERSTAND_FAULT_MESSAGE_STRING, SOAPConstants.FAULT_CODE_MUST_UNDERSTAND, role, null, "http://schemas.xmlsoap.org/wsdl/soap/http");
                    throw new SOAPFaultException(sf);
                }
            }
            XMLStreamReaderUtil.skipElement(reader);
            XMLStreamReaderUtil.nextElementContent(reader);
        }
    }

    protected boolean isDispatch(MessageInfo messageInfo) {
        DispatchContext context = (DispatchContext)messageInfo.getMetaData("com.sun.xml.ws.client.dispatch.context");
        return context != null;
    }

    protected String getSOAPMessageCharsetEncoding(SOAPMessage sm) throws SOAPException {
        String charset = (String)sm.getProperty("javax.xml.soap.character-set-encoding");
        return charset != null ? charset : "UTF-8";
    }

    protected final void raiseFault(QName faultCode, String faultString) {
        throw new SOAPFaultException(SOAPUtil.createSOAPFault(faultString, faultCode, null, null, this.getBindingId()));
    }

    protected void raiseBadXMLFault(HandlerContext ctxt) {
    }

    protected abstract QName getSenderFaultCode();

    protected abstract QName getReceiverFaultCode();

    protected abstract QName getVersionMismatchFaultCode();

    public abstract String getBindingId();

    public DispatchUtil getDispatchUtil() {
        return this.dispatchUtil;
    }
}

