/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.util;

import java.util.AbstractList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollisionCheckStack<E>
extends AbstractList<E> {
    private Object[] data;
    private int[] next;
    private int size = 0;
    private final int[] initialHash = new int[17];

    public CollisionCheckStack() {
        this.data = new Object[16];
        this.next = new int[16];
    }

    public boolean push(E o) {
        if (this.data.length == this.size) {
            this.expandCapacity();
        }
        this.data[this.size] = o;
        int hash = this.hash(o);
        boolean r = this.findDuplicate(o, hash);
        this.next[this.size] = this.initialHash[hash];
        this.initialHash[hash] = this.size + 1;
        ++this.size;
        return r;
    }

    public void pushNocheck(E o) {
        if (this.data.length == this.size) {
            this.expandCapacity();
        }
        this.data[this.size] = o;
        this.next[this.size] = -1;
        ++this.size;
    }

    @Override
    public E get(int index) {
        return (E)this.data[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    private int hash(Object o) {
        return (System.identityHashCode(o) & Integer.MAX_VALUE) % this.initialHash.length;
    }

    public E pop() {
        --this.size;
        Object o = this.data[this.size];
        this.data[this.size] = null;
        int n = this.next[this.size];
        if (n >= 0) {
            int hash = this.hash(o);
            assert (this.initialHash[hash] == this.size + 1);
            this.initialHash[hash] = n;
        }
        return (E)o;
    }

    public E peek() {
        return (E)this.data[this.size - 1];
    }

    private boolean findDuplicate(E o, int hash) {
        int p = this.initialHash[hash];
        while (p != 0) {
            Object existing;
            if ((existing = this.data[--p]) == o) {
                return true;
            }
            p = this.next[p];
        }
        return false;
    }

    private void expandCapacity() {
        int oldSize = this.data.length;
        int newSize = oldSize * 2;
        Object[] d = new Object[newSize];
        int[] n = new int[newSize];
        System.arraycopy(this.data, 0, d, 0, oldSize);
        System.arraycopy(this.next, 0, n, 0, oldSize);
        this.data = d;
        this.next = n;
    }

    public void reset() {
        if (this.size > 0) {
            this.size = 0;
            Arrays.fill(this.initialHash, 0);
        }
    }
}

