/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.dtd.bindinfo;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.istack.SAXParseException2;
import com.sun.tools.xjc.AbortException;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.SchemaCache;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.reader.dtd.bindinfo.BIConversion;
import com.sun.tools.xjc.reader.dtd.bindinfo.BIElement;
import com.sun.tools.xjc.reader.dtd.bindinfo.BIEnumeration;
import com.sun.tools.xjc.reader.dtd.bindinfo.BIInterface;
import com.sun.tools.xjc.reader.dtd.bindinfo.BIUserConversion;
import com.sun.tools.xjc.reader.dtd.bindinfo.DOMBuilder;
import com.sun.tools.xjc.reader.dtd.bindinfo.DOMUtil;
import com.sun.tools.xjc.util.CodeModelClassFactory;
import com.sun.tools.xjc.util.ErrorReceiverFilter;
import com.sun.tools.xjc.util.ForkContentHandler;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.ValidatorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindInfo {
    protected final ErrorReceiver errorReceiver;
    final Model model;
    private final String defaultPackage;
    final JCodeModel codeModel;
    final CodeModelClassFactory classFactory;
    private final Element dom;
    private final Map<String, BIConversion> conversions = new HashMap<String, BIConversion>();
    private final Map<String, BIElement> elements = new HashMap<String, BIElement>();
    private final Map<String, BIInterface> interfaces = new HashMap<String, BIInterface>();
    private static final String XJC_NS = "http://java.sun.com/xml/ns/jaxb/xjc";
    private static SchemaCache bindingFileSchema = new SchemaCache(BindInfo.class.getResource("bindingfile.xsd"));

    public BindInfo(Model model, InputSource source, ErrorReceiver _errorReceiver) throws AbortException {
        this(model, BindInfo.parse(source, _errorReceiver), _errorReceiver);
    }

    public BindInfo(Model model, Document _dom, ErrorReceiver _errorReceiver) {
        Object c;
        this.model = model;
        this.dom = _dom.getDocumentElement();
        this.codeModel = model.codeModel;
        this.errorReceiver = _errorReceiver;
        this.classFactory = new CodeModelClassFactory(_errorReceiver);
        this.defaultPackage = model.options.defaultPackage;
        for (Element ele : DOMUtil.getChildElements(this.dom, "element")) {
            BIElement e = new BIElement(this, ele);
            this.elements.put(e.name(), e);
        }
        BIUserConversion.addBuiltinConversions(this, this.conversions);
        for (Element cnv : DOMUtil.getChildElements(this.dom, "conversion")) {
            c = new BIUserConversion(this, cnv);
            this.conversions.put(c.name(), (BIConversion)c);
        }
        for (Element en : DOMUtil.getChildElements(this.dom, "enumeration")) {
            c = BIEnumeration.create(en, this);
            this.conversions.put(c.name(), (BIConversion)c);
        }
        for (Element itf : DOMUtil.getChildElements(this.dom, "interface")) {
            c = new BIInterface(itf);
            this.interfaces.put(((BIInterface)c).name(), (BIInterface)c);
        }
    }

    public Long getSerialVersionUID() {
        Element serial = DOMUtil.getElement(this.dom, XJC_NS, "serializable");
        if (serial == null) {
            return null;
        }
        String v = DOMUtil.getAttribute(serial, "uid");
        if (v == null) {
            v = "1";
        }
        return new Long(v);
    }

    public JClass getSuperClass() {
        JDefinedClass c;
        Element sc = DOMUtil.getElement(this.dom, XJC_NS, "superClass");
        if (sc == null) {
            return null;
        }
        try {
            String v = DOMUtil.getAttribute(sc, "name");
            if (v == null) {
                return null;
            }
            c = this.codeModel._class(v);
            c.hide();
        }
        catch (JClassAlreadyExistsException e) {
            c = e.getExistingClass();
        }
        return c;
    }

    public JClass getSuperInterface() {
        JDefinedClass c;
        Element sc = DOMUtil.getElement(this.dom, XJC_NS, "superInterface");
        if (sc == null) {
            return null;
        }
        String name = DOMUtil.getAttribute(sc, "name");
        if (name == null) {
            return null;
        }
        try {
            c = this.codeModel._class(name, ClassType.INTERFACE);
            c.hide();
        }
        catch (JClassAlreadyExistsException e) {
            c = e.getExistingClass();
        }
        return c;
    }

    public JPackage getTargetPackage() {
        String p = this.defaultPackage != null ? this.defaultPackage : this.getOption("package", "");
        return this.codeModel._package(p);
    }

    public BIConversion conversion(String name) {
        BIConversion r = this.conversions.get(name);
        if (r == null) {
            throw new AssertionError((Object)"undefined conversion name: this should be checked by the validator before we read it");
        }
        return r;
    }

    public BIElement element(String name) {
        return this.elements.get(name);
    }

    public Collection<BIElement> elements() {
        return this.elements.values();
    }

    public Collection<BIInterface> interfaces() {
        return this.interfaces.values();
    }

    private String getOption(String attName, String defaultValue) {
        String s;
        Element opt = DOMUtil.getElement(this.dom, "options");
        if (opt != null && (s = DOMUtil.getAttribute(opt, attName)) != null) {
            return s;
        }
        return defaultValue;
    }

    private static Document parse(InputSource is, ErrorReceiver receiver) throws AbortException {
        try {
            ValidatorHandler validator = bindingFileSchema.newValidator();
            SAXParserFactory pf = SAXParserFactory.newInstance();
            pf.setNamespaceAware(true);
            DOMBuilder builder = new DOMBuilder();
            ErrorReceiverFilter controller = new ErrorReceiverFilter(receiver);
            validator.setErrorHandler(controller);
            XMLReader reader = pf.newSAXParser().getXMLReader();
            reader.setErrorHandler(controller);
            reader.setContentHandler(new ForkContentHandler(validator, builder));
            reader.parse(is);
            if (controller.hadError()) {
                throw new AbortException();
            }
            return (Document)builder.getDOM();
        }
        catch (IOException e) {
            receiver.error(new SAXParseException2(e.getMessage(), null, e));
        }
        catch (SAXException e) {
            receiver.error(new SAXParseException2(e.getMessage(), null, e));
        }
        catch (ParserConfigurationException e) {
            receiver.error(new SAXParseException2(e.getMessage(), null, e));
        }
        throw new AbortException();
    }
}

