/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.generator.bean;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JJavaName;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.codemodel.fmt.JStaticJavaFile;
import com.sun.tools.xjc.AbortException;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.generator.annotation.spec.XmlAnyAttributeWriter;
import com.sun.tools.xjc.generator.annotation.spec.XmlEnumValueWriter;
import com.sun.tools.xjc.generator.annotation.spec.XmlEnumWriter;
import com.sun.tools.xjc.generator.annotation.spec.XmlJavaTypeAdapterWriter;
import com.sun.tools.xjc.generator.annotation.spec.XmlMimeTypeWriter;
import com.sun.tools.xjc.generator.annotation.spec.XmlRootElementWriter;
import com.sun.tools.xjc.generator.annotation.spec.XmlTypeWriter;
import com.sun.tools.xjc.generator.bean.ClassOutlineImpl;
import com.sun.tools.xjc.generator.bean.ElementOutlineImpl;
import com.sun.tools.xjc.generator.bean.ImplStructureStrategy;
import com.sun.tools.xjc.generator.bean.Messages;
import com.sun.tools.xjc.generator.bean.MethodWriter;
import com.sun.tools.xjc.generator.bean.PackageOutlineImpl;
import com.sun.tools.xjc.generator.bean.field.FieldRenderer;
import com.sun.tools.xjc.model.CAdapter;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CClassInfoParent;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CEnumConstant;
import com.sun.tools.xjc.model.CEnumLeafInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CTypeRef;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.model.nav.NClass;
import com.sun.tools.xjc.model.nav.NType;
import com.sun.tools.xjc.outline.Aspect;
import com.sun.tools.xjc.outline.EnumConstantOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.outline.PackageOutline;
import com.sun.tools.xjc.util.CodeModelClassFactory;
import com.sun.xml.bind.v2.runtime.SwaRefAdapter;
import com.sun.xml.xsom.XmlString;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanGenerator
implements Outline {
    private final CodeModelClassFactory codeModelClassFactory;
    private final ErrorReceiver errorReceiver;
    private final Map<JPackage, PackageOutlineImpl> packageContexts = new HashMap<JPackage, PackageOutlineImpl>();
    private final Map<CClassInfo, ClassOutlineImpl> classes = new HashMap<CClassInfo, ClassOutlineImpl>();
    private final Map<CEnumLeafInfo, EnumOutline> enums = new HashMap<CEnumLeafInfo, EnumOutline>();
    private final Map<Class, JClass> generatedRuntime = new HashMap<Class, JClass>();
    private final Model model;
    private final JCodeModel codeModel;
    private final Map<CPropertyInfo, FieldOutline> fields = new HashMap<CPropertyInfo, FieldOutline>();
    final Map<CElementInfo, ElementOutlineImpl> elements = new HashMap<CElementInfo, ElementOutlineImpl>();
    private final CClassInfoParent.Visitor<JClassContainer> exposedContainerBuilder = new CClassInfoParent.Visitor<JClassContainer>(){

        @Override
        public JClassContainer onBean(CClassInfo bean) {
            return BeanGenerator.this.getClazz((CClassInfo)bean).ref;
        }

        @Override
        public JClassContainer onElement(CElementInfo element) {
            return BeanGenerator.this.getElement((CElementInfo)element).implClass;
        }

        @Override
        public JClassContainer onPackage(JPackage pkg) {
            return ((BeanGenerator)BeanGenerator.this).model.strategy.getPackage(pkg, Aspect.EXPOSED);
        }
    };
    private final CClassInfoParent.Visitor<JClassContainer> implContainerBuilder = new CClassInfoParent.Visitor<JClassContainer>(){

        @Override
        public JClassContainer onBean(CClassInfo bean) {
            return BeanGenerator.this.getClazz((CClassInfo)bean).implClass;
        }

        @Override
        public JClassContainer onElement(CElementInfo element) {
            return BeanGenerator.this.getElement((CElementInfo)element).implClass;
        }

        @Override
        public JClassContainer onPackage(JPackage pkg) {
            return ((BeanGenerator)BeanGenerator.this).model.strategy.getPackage(pkg, Aspect.IMPLEMENTATION);
        }
    };

    public static Outline generate(Model model, ErrorReceiver _errorReceiver) {
        try {
            return new BeanGenerator(model, _errorReceiver);
        }
        catch (AbortException e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private BeanGenerator(Model _model, ErrorReceiver _errorReceiver) {
        void var6_10;
        JPackage[] packages;
        this.model = _model;
        this.codeModel = this.model.codeModel;
        this.errorReceiver = _errorReceiver;
        this.codeModelClassFactory = new CodeModelClassFactory(this.errorReceiver);
        for (CEnumLeafInfo p : this.model.enums().values()) {
            this.enums.put(p, this.generateEnum(p));
        }
        JPackage[] arr$ = packages = this.getUsedPackages(Aspect.EXPOSED);
        int len$ = arr$.length;
        boolean bl = false;
        while (var6_10 < len$) {
            JPackage pkg = arr$[var6_10];
            this.getPackageContext(pkg);
            ++var6_10;
        }
        for (CClassInfo bean : this.model.beans().values()) {
            this.getClazz(bean);
        }
        for (PackageOutlineImpl p : this.packageContexts.values()) {
            p.calcDefaultValues();
        }
        JClass OBJECT = this.codeModel.ref(Object.class);
        for (ClassOutlineImpl classOutlineImpl : this.getClasses()) {
            CClassInfo superClass = classOutlineImpl.target.getBaseClass();
            if (superClass != null) {
                this.model.strategy._extends(classOutlineImpl, this.getClazz(superClass));
                continue;
            }
            if (this.model.rootClass != null && classOutlineImpl.implClass._extends().equals(OBJECT)) {
                classOutlineImpl.implClass._extends(this.model.rootClass);
            }
            if (this.model.rootInterface == null) continue;
            classOutlineImpl.ref._implements(this.model.rootInterface);
        }
        for (ClassOutlineImpl classOutlineImpl : this.getClasses()) {
            this.generateClassBody(classOutlineImpl);
        }
        for (CElementInfo cElementInfo : this.model.getAllElements()) {
            this.getPackageContext(cElementInfo._package()).objectFactoryGenerator().populate(cElementInfo);
        }
        if (this.model.options.debugMode) {
            this.generateClassList();
        }
    }

    private void generateClassList() {
        try {
            JDefinedClass jc = this.codeModel.rootPackage()._class("JAXBDebug");
            JMethod m = jc.method(17, JAXBContext.class, "createContext");
            JVar $classLoader = m.param(ClassLoader.class, "classLoader");
            m._throws(JAXBException.class);
            JInvocation inv = this.codeModel.ref(JAXBContext.class).staticInvoke("newInstance");
            m.body()._return(inv);
            switch (this.model.strategy) {
                case INTF_AND_IMPL: {
                    StringBuilder buf = new StringBuilder();
                    for (PackageOutlineImpl po : this.packageContexts.values()) {
                        if (buf.length() > 0) {
                            buf.append(':');
                        }
                        buf.append(po._package().name());
                    }
                    inv.arg(buf.toString()).arg($classLoader);
                    break;
                }
                case BEAN_ONLY: {
                    for (ClassOutlineImpl cc : this.getClasses()) {
                        inv.arg(cc.implRef.dotclass());
                    }
                    for (PackageOutlineImpl po : this.packageContexts.values()) {
                        inv.arg(po.objectFactory().dotclass());
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (JClassAlreadyExistsException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public JCodeModel getCodeModel() {
        return this.codeModel;
    }

    @Override
    public JClassContainer getContainer(CClassInfoParent parent, Aspect aspect) {
        CClassInfoParent.Visitor<JClassContainer> v;
        switch (aspect) {
            case EXPOSED: {
                v = this.exposedContainerBuilder;
                break;
            }
            case IMPLEMENTATION: {
                v = this.implContainerBuilder;
                break;
            }
            default: {
                assert (false);
                throw new IllegalStateException();
            }
        }
        return parent.accept(v);
    }

    @Override
    public final JType resolve(CTypeRef ref, Aspect a) {
        return ((NType)ref.getTarget().getType()).toType(this, a);
    }

    public final JPackage[] getUsedPackages(Aspect aspect) {
        TreeSet<JPackage> s = new TreeSet<JPackage>();
        for (CClassInfo bean : this.model.beans().values()) {
            JClassContainer cont = this.getContainer(bean.parent(), aspect);
            if (!cont.isPackage()) continue;
            s.add((JPackage)cont);
        }
        for (CElementInfo e : this.model.getElementMappings(null).values()) {
            s.add(e._package());
        }
        return s.toArray(new JPackage[s.size()]);
    }

    @Override
    public ErrorReceiver getErrorReceiver() {
        return this.errorReceiver;
    }

    @Override
    public CodeModelClassFactory getClassFactory() {
        return this.codeModelClassFactory;
    }

    @Override
    public PackageOutlineImpl getPackageContext(JPackage p) {
        PackageOutlineImpl r = this.packageContexts.get(p);
        if (r == null) {
            r = new PackageOutlineImpl(this, this.model, p);
            this.packageContexts.put(p, r);
        }
        return r;
    }

    private ClassOutlineImpl generateClassDef(CClassInfo bean) {
        JDefinedClass implRef;
        ImplStructureStrategy.Result r = this.model.strategy.createClasses(this, bean);
        if (bean.getUserSpecifiedImplClass() != null) {
            JDefinedClass usr;
            try {
                usr = this.codeModel._class(bean.getUserSpecifiedImplClass());
                usr.hide();
            }
            catch (JClassAlreadyExistsException e) {
                usr = e.getExistingClass();
            }
            usr._extends(r.implementation);
            implRef = usr;
        } else {
            implRef = r.implementation;
        }
        return new ClassOutlineImpl(this, bean, r.exposed, r.implementation, implRef);
    }

    public Collection<ClassOutlineImpl> getClasses() {
        assert (this.model.beans().size() == this.classes.size());
        return this.classes.values();
    }

    @Override
    public ClassOutlineImpl getClazz(CClassInfo bean) {
        ClassOutlineImpl r = this.classes.get(bean);
        if (r == null) {
            r = this.generateClassDef(bean);
            this.classes.put(bean, r);
        }
        return r;
    }

    @Override
    public ElementOutlineImpl getElement(CElementInfo ei) {
        ElementOutlineImpl def = this.elements.get(ei);
        if (def == null && ei.hasClass()) {
            def = new ElementOutlineImpl(this, ei);
        }
        return def;
    }

    @Override
    public EnumOutline getEnum(CEnumLeafInfo eli) {
        return this.enums.get(eli);
    }

    @Override
    public Collection<EnumOutline> getEnums() {
        return this.enums.values();
    }

    @Override
    public Iterable<? extends PackageOutline> getAllPackageContexts() {
        return this.packageContexts.values();
    }

    @Override
    public FieldOutline getField(CPropertyInfo prop) {
        return this.fields.get(prop);
    }

    private void generateClassBody(ClassOutlineImpl cc) {
        CClassInfo target = cc.target;
        if (this.model.serializable) {
            cc.implClass._implements(Serializable.class);
            if (this.model.serialVersionUID != null) {
                cc.implClass.field(28, this.codeModel.LONG, "serialVersionUID", JExpr.lit(this.model.serialVersionUID));
            }
        }
        String mostUsedNamespaceURI = cc._package().getMostUsedNamespaceURI();
        XmlTypeWriter xtw = cc.implClass.annotate2(XmlTypeWriter.class);
        QName typeName = cc.target.getTypeName();
        if (typeName == null) {
            xtw.name("");
        } else {
            xtw.name(typeName.getLocalPart());
            String typeNameURI = typeName.getNamespaceURI();
            if (typeNameURI != null && !typeNameURI.equals("")) {
                xtw.namespace(typeNameURI);
            }
        }
        if (target.isElement()) {
            String namespaceURI = target.getElementName().getNamespaceURI();
            String localPart = target.getElementName().getLocalPart();
            XmlRootElementWriter xrew = cc.implClass.annotate2(XmlRootElementWriter.class);
            xrew.name(localPart);
            if (!namespaceURI.equals(mostUsedNamespaceURI)) {
                xrew.namespace(namespaceURI);
            }
        }
        if (target.isOrdered()) {
            for (CPropertyInfo p : target.getProperties()) {
                if (p instanceof CAttributePropertyInfo) continue;
                xtw.propOrder(p.getName(false));
            }
        } else {
            xtw.getAnnotationUse().paramArray("propOrder");
        }
        for (CPropertyInfo prop : target.getProperties()) {
            this.generateFieldDecl(cc, prop);
        }
        if (target.declaresAttributeWildcard()) {
            this.generateAttributeWildcard(cc);
        }
        cc.ref.javadoc().append(target.javadoc);
        cc._package().objectFactoryGenerator().populate(cc);
    }

    private void generateAttributeWildcard(ClassOutlineImpl cc) {
        String FIELD_NAME = "otherAttributes";
        String METHOD_SEED = this.model.getNameConverter().toClassName(FIELD_NAME);
        JClass mapType = this.codeModel.ref(Map.class).narrow(QName.class, String.class);
        JClass mapImpl = this.codeModel.ref(HashMap.class).narrow(QName.class, String.class);
        JFieldVar $ref = cc.implClass.field(4, mapType, FIELD_NAME, (JExpression)JExpr._new(mapImpl));
        $ref.annotate2(XmlAnyAttributeWriter.class);
        MethodWriter writer = cc.createMethodWriter();
        JMethod $get = writer.declareMethod(mapType, "get" + METHOD_SEED);
        $get.javadoc().append("Gets a map that contains attributes that aren't bound to any typed property on this class.\n\n<p>\nthe map is keyed by the name of the attribute and \nthe value is the string value of the attribute.\n\nthe map returned by this method is live, and you can add new attribute\nby updating the map directly. Because of this design, there's no setter.\n");
        $get.javadoc().addReturn().append("always non-null");
        $get.body()._return($ref);
    }

    private EnumOutline generateEnum(CEnumLeafInfo e) {
        JType baseExposedType = e.base.toType(this, Aspect.EXPOSED).unboxify();
        JType baseImplType = e.base.toType(this, Aspect.IMPLEMENTATION).unboxify();
        JDefinedClass type = this.getClassFactory().createClass(this.getContainer(e.parent, Aspect.EXPOSED), e.shortName, e.getLocator(), ClassType.ENUM);
        type.javadoc().append(e.javadoc);
        XmlEnumWriter xew = type.annotate2(XmlEnumWriter.class);
        xew.value(baseExposedType);
        JCodeModel codeModel = this.model.codeModel;
        EnumOutline enumOutline = new EnumOutline(e, type){};
        boolean needsValue = e.needsValueField();
        HashSet<String> enumFieldNames = new HashSet<String>();
        for (CEnumConstant mem : e.members) {
            String constName = mem.getName();
            if (!JJavaName.isJavaIdentifier(constName)) {
                this.getErrorReceiver().error(e.getLocator(), Messages.ERR_UNUSABLE_NAME.format(mem.getLexicalValue(), constName));
            }
            if (!enumFieldNames.add(constName)) {
                this.getErrorReceiver().error(e.getLocator(), Messages.ERR_NAME_COLLISION.format(constName));
            }
            JEnumConstant constRef = type.enumConstant(constName);
            if (needsValue) {
                constRef.arg(e.base.createConstant(this, new XmlString(mem.getLexicalValue())));
            }
            if (!mem.getLexicalValue().equals(constName)) {
                constRef.annotate2(XmlEnumValueWriter.class).value(mem.getLexicalValue());
            }
            if (mem.javadoc != null) {
                constRef.javadoc().append(mem.javadoc);
            }
            enumOutline.constants.add(new EnumConstantOutline(mem, constRef){});
        }
        XmlTypeWriter xtw = enumOutline.clazz.annotate2(XmlTypeWriter.class);
        QName typeName = enumOutline.target.getTypeName();
        if (typeName == null) {
            xtw.name("");
        } else {
            xtw.name(typeName.getLocalPart());
            String typeNameURI = typeName.getNamespaceURI();
            if (typeNameURI != null && !typeNameURI.equals("")) {
                xtw.namespace(typeNameURI);
            }
        }
        if (needsValue) {
            JFieldVar $value = type.field(12, baseExposedType, "value");
            type.method(1, baseExposedType, "value").body()._return($value);
            JMethod m = type.constructor(0);
            m.body().assign($value, m.param(baseImplType, "v"));
            m = type.method(17, type, "fromValue");
            JVar $v = m.param(baseExposedType, "v");
            JForEach fe = m.body().forEach(type, "c", type.staticInvoke("values"));
            JExpression eq = baseExposedType.isPrimitive() ? fe.var().ref($value).eq($v) : fe.var().ref($value).invoke("equals").arg($v);
            fe.body()._if(eq)._then()._return(fe.var());
            JInvocation ex = JExpr._new(codeModel.ref(IllegalArgumentException.class));
            if (baseExposedType.isPrimitive()) {
                m.body()._throw(ex.arg(codeModel.ref(String.class).staticInvoke("valueOf").arg($v)));
            } else {
                m.body()._throw(ex.arg($v.invoke("toString")));
            }
        } else {
            type.method(1, String.class, "value").body()._return(JExpr.invoke("name"));
            JMethod m = type.method(17, type, "fromValue");
            m.body()._return(JExpr.invoke("valueOf").arg(m.param(String.class, "v")));
        }
        return enumOutline;
    }

    private FieldOutline generateFieldDecl(ClassOutlineImpl cc, CPropertyInfo prop) {
        FieldRenderer fr = prop.realization;
        if (fr == null) {
            fr = this.model.options.getFieldRendererFactory().getDefault();
        }
        FieldOutline field = fr.generate(cc, prop);
        this.fields.put(prop, field);
        return field;
    }

    public final void generateAdapterIfNecessary(CPropertyInfo prop, JAnnotatable field) {
        CAdapter adapter = prop.getAdapter();
        if (adapter != null) {
            if (adapter.getAdapterIfKnown() == SwaRefAdapter.class) {
                field.annotate(XmlAttachmentRef.class);
            } else {
                XmlJavaTypeAdapterWriter xjtw = field.annotate2(XmlJavaTypeAdapterWriter.class);
                xjtw.value(((NClass)adapter.adapterType).toType(this, Aspect.EXPOSED));
            }
        }
        switch (prop.id()) {
            case ID: {
                field.annotate(XmlID.class);
                break;
            }
            case IDREF: {
                field.annotate(XmlIDREF.class);
            }
        }
        if (prop.getExpectedMimeType() != null) {
            field.annotate2(XmlMimeTypeWriter.class).value(prop.getExpectedMimeType().toString());
        }
    }

    @Override
    public final JClass addRuntime(Class clazz) {
        JClass g = this.generatedRuntime.get(clazz);
        if (g == null) {
            JPackage implPkg = this.getUsedPackages(Aspect.IMPLEMENTATION)[0].subPackage("runtime");
            g = this.generateStaticClass(clazz, implPkg);
            this.generatedRuntime.put(clazz, g);
        }
        return g;
    }

    public JClass generateStaticClass(Class src, JPackage out) {
        String shortName = this.getShortName(src.getName());
        URL res = src.getResource(shortName + ".java");
        if (res == null) {
            res = src.getResource(shortName + ".java_");
        }
        if (res == null) {
            throw new InternalError("Unable to load source code of " + src.getName() + " as a resource");
        }
        JStaticJavaFile sjf = new JStaticJavaFile(out, shortName, res, null);
        out.addResourceFile(sjf);
        return sjf.getJClass();
    }

    private String getShortName(String name) {
        return name.substring(name.lastIndexOf(46) + 1);
    }
}

