/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.writer.FileCodeWriter;
import com.sun.codemodel.writer.PrologCodeWriter;
import com.sun.org.apache.xml.internal.resolver.CatalogManager;
import com.sun.org.apache.xml.internal.resolver.tools.CatalogResolver;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Messages;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.api.ClassNameAllocator;
import com.sun.tools.xjc.generator.bean.field.FieldRendererFactory;
import com.sun.tools.xjc.util.Util;
import com.sun.xml.bind.api.impl.NameConverter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options {
    public boolean debugMode;
    public boolean verbose;
    public boolean quiet;
    public boolean readOnly;
    public boolean noFileHeader;
    public boolean strictCheck = true;
    public boolean runtime14 = false;
    public static final int STRICT = 1;
    public static final int EXTENSION = 2;
    public int compatibilityMode = 1;
    public File targetDir = new File(".");
    public EntityResolver entityResolver = null;
    private Language schemaLanguage = null;
    public String defaultPackage = null;
    public String defaultPackage2 = null;
    private final List<InputSource> grammars = new ArrayList<InputSource>();
    private final List<InputSource> bindFiles = new ArrayList<InputSource>();
    private String proxyHost = null;
    private String proxyPort = null;
    private String proxyUser = null;
    private String proxyPassword = null;
    public final List<Plugin> activePlugins = new ArrayList<Plugin>();
    private List<Plugin> allPlugins;
    public final Set<String> pluginURIs = new HashSet<String>();
    public ClassNameAllocator classNameAllocator;
    public boolean packageLevelAnnotations = true;
    private FieldRendererFactory fieldRendererFactory = new FieldRendererFactory();
    private Plugin fieldRendererFactoryOwner = null;
    private NameConverter nameConverter = null;
    private Plugin nameConverterOwner = null;
    public final List<URL> classpaths = new ArrayList<URL>();

    public FieldRendererFactory getFieldRendererFactory() {
        return this.fieldRendererFactory;
    }

    public void setFieldRendererFactory(FieldRendererFactory frf, Plugin owner) throws BadCommandLineException {
        if (frf == null) {
            throw new IllegalArgumentException();
        }
        if (this.fieldRendererFactoryOwner != null) {
            throw new BadCommandLineException(Messages.format("FIELD_RENDERER_CONFLICT", this.fieldRendererFactoryOwner.getOptionName(), owner.getOptionName()));
        }
        this.fieldRendererFactoryOwner = owner;
        this.fieldRendererFactory = frf;
    }

    public NameConverter getNameConverter() {
        return this.nameConverter;
    }

    public void setNameConverter(NameConverter nc, Plugin owner) throws BadCommandLineException {
        if (nc == null) {
            throw new IllegalArgumentException();
        }
        if (this.nameConverter != null) {
            throw new BadCommandLineException(Messages.format("NAME_CONVERTER_CONFLICT", this.nameConverterOwner.getOptionName(), owner.getOptionName()));
        }
        this.nameConverterOwner = owner;
        this.nameConverter = nc;
    }

    public List<Plugin> getAllPlugins() {
        if (this.allPlugins == null) {
            this.allPlugins = new ArrayList<Plugin>();
            URLClassLoader ucl = this.getUserClassLoader(this.getClass().getClassLoader());
            for (Plugin aug : Options.findServices(Plugin.class, ucl)) {
                this.allPlugins.add(aug);
            }
        }
        return this.allPlugins;
    }

    public Language getSchemaLanguage() {
        if (this.schemaLanguage == null) {
            this.schemaLanguage = this.guessSchemaLanguage();
        }
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(Language _schemaLanguage) {
        this.schemaLanguage = _schemaLanguage;
    }

    public InputSource[] getGrammars() {
        return this.grammars.toArray(new InputSource[this.grammars.size()]);
    }

    public void addGrammar(InputSource is) {
        this.grammars.add(this.absolutize(is));
    }

    private InputSource fileToInputSource(File source) {
        try {
            String url = source.toURL().toExternalForm();
            return new InputSource(com.sun.tools.xjc.reader.Util.escapeSpace(url));
        }
        catch (MalformedURLException e) {
            return new InputSource(source.getPath());
        }
    }

    public void addGrammar(File source) {
        this.addGrammar(this.fileToInputSource(source));
    }

    public void addGrammarRecursive(File dir) {
        this.addRecursive(dir, ".xsd", this.grammars);
    }

    private void addRecursive(File dir, String suffix, List<InputSource> result) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                this.addRecursive(f, suffix, result);
                continue;
            }
            if (!f.getPath().endsWith(suffix)) continue;
            result.add(this.absolutize(this.fileToInputSource(f)));
        }
    }

    private InputSource absolutize(InputSource is) {
        try {
            URL baseURL = new File(".").getCanonicalFile().toURL();
            is.setSystemId(new URL(baseURL, is.getSystemId()).toExternalForm());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return is;
    }

    public InputSource[] getBindFiles() {
        return this.bindFiles.toArray(new InputSource[this.bindFiles.size()]);
    }

    public void addBindFile(InputSource is) {
        this.bindFiles.add(this.absolutize(is));
    }

    public void addBindFileRecursive(File dir) {
        this.addRecursive(dir, ".xjb", this.bindFiles);
    }

    public URLClassLoader getUserClassLoader(ClassLoader parent) {
        return new URLClassLoader(this.classpaths.toArray(new URL[this.classpaths.size()]), parent);
    }

    protected int parseArgument(String[] args, int i) throws BadCommandLineException {
        if (args[i].equals("-classpath") || args[i].equals("-cp")) {
            if (i == args.length - 1) {
                throw new BadCommandLineException(Messages.format("Driver.MissingClassPath", new Object[0]));
            }
            File file = new File(args[++i]);
            try {
                this.classpaths.add(file.toURL());
            }
            catch (MalformedURLException e) {
                throw new BadCommandLineException(Messages.format("Driver.NotAValidFileName", file), e);
            }
            return 2;
        }
        if (args[i].equals("-d")) {
            if (i == args.length - 1) {
                throw new BadCommandLineException(Messages.format("Driver.MissingDir", new Object[0]));
            }
            this.targetDir = new File(args[++i]);
            if (!this.targetDir.exists()) {
                throw new BadCommandLineException(Messages.format("Driver.NonExistentDir", this.targetDir));
            }
            return 2;
        }
        if (args[i].equals("-readOnly")) {
            this.readOnly = true;
            return 1;
        }
        if (args[i].equals("-p")) {
            if (i == args.length - 1) {
                throw new BadCommandLineException(Messages.format("Driver.MissingPackageName", new Object[0]));
            }
            this.defaultPackage = args[++i];
            if (this.defaultPackage.length() == 0) {
                this.packageLevelAnnotations = false;
            }
            return 2;
        }
        if (args[i].equals("-debug")) {
            this.debugMode = true;
            this.verbose = true;
            return 1;
        }
        if (args[i].equals("-nv")) {
            this.strictCheck = false;
            return 1;
        }
        if (args[i].equals("-npa")) {
            this.packageLevelAnnotations = false;
            return 1;
        }
        if (args[i].equals("-no-header")) {
            this.noFileHeader = true;
            return 1;
        }
        if (args[i].equals("-verbose")) {
            this.verbose = true;
            return 1;
        }
        if (args[i].equals("-quiet")) {
            this.quiet = true;
            return 1;
        }
        if (args[i].equals("-XexplicitAnnotation")) {
            this.runtime14 = true;
            return 1;
        }
        if (args[i].equals("-b")) {
            if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                throw new BadCommandLineException(Messages.format("Driver.MissingFileName", new Object[0]));
            }
            this.addFile(args[i + 1], this.bindFiles, ".xjb");
            return 2;
        }
        if (args[i].equals("-dtd")) {
            this.schemaLanguage = Language.DTD;
            return 1;
        }
        if (args[i].equals("-relaxng")) {
            this.schemaLanguage = Language.RELAXNG;
            return 1;
        }
        if (args[i].equals("-relaxng-compact")) {
            this.schemaLanguage = Language.RELAXNG_COMPACT;
            return 1;
        }
        if (args[i].equals("-xmlschema")) {
            this.schemaLanguage = Language.XMLSCHEMA;
            return 1;
        }
        if (args[i].equals("-wsdl")) {
            this.schemaLanguage = Language.WSDL;
            return 1;
        }
        if (args[i].equals("-extension")) {
            this.compatibilityMode = 2;
            return 1;
        }
        if (args[i].equals("-httpproxyfile")) {
            File file;
            if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                throw new BadCommandLineException(Messages.format("Driver.MISSING_PROXYFILE", new Object[0]));
            }
            if (!(file = new File(args[++i])).exists()) {
                throw new BadCommandLineException(Messages.format("Driver.NO_SUCH_FILE", file));
            }
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                this.parseProxy(in.readLine());
                in.close();
            }
            catch (IOException e) {
                throw new BadCommandLineException(Messages.format("Driver.FailedToParse", file, e.getMessage()), e);
            }
            return 2;
        }
        if (args[i].equals("-httpproxy")) {
            if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                throw new BadCommandLineException(Messages.format("Driver.MISSING_PROXY", new Object[0]));
            }
            this.parseProxy(args[++i]);
            return 2;
        }
        if (args[i].equals("-host")) {
            if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                throw new BadCommandLineException(Messages.format("Driver.MissingProxyHost", new Object[0]));
            }
            this.proxyHost = args[++i];
            return 2;
        }
        if (args[i].equals("-port")) {
            if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                throw new BadCommandLineException(Messages.format("Driver.MissingProxyPort", new Object[0]));
            }
            this.proxyPort = args[++i];
            return 2;
        }
        if (args[i].equals("-catalog")) {
            if (i == args.length - 1) {
                throw new BadCommandLineException(Messages.format("Driver.MissingCatalog", new Object[0]));
            }
            File catalogFile = new File(args[++i]);
            try {
                this.addCatalog(catalogFile);
            }
            catch (IOException e) {
                throw new BadCommandLineException(Messages.format("Driver.FailedToParse", catalogFile, e.getMessage()), e);
            }
            return 2;
        }
        if (args[i].equals("-source")) {
            String version;
            if (i == args.length - 1) {
                throw new BadCommandLineException(Messages.format("Driver.MissingVersion", new Object[0]));
            }
            if (!(version = args[++i]).equals("2.0")) {
                throw new BadCommandLineException(Messages.format("Driver.DefaultVersion", new Object[0]));
            }
            return 2;
        }
        if (args[i].equals("-Xtest-class-name-allocator")) {
            this.classNameAllocator = new ClassNameAllocator(){

                public String assignClassName(String packageName, String className) {
                    System.out.printf("assignClassName(%s,%s)\n", packageName, className);
                    return className + "_Type";
                }
            };
            return 1;
        }
        for (Plugin plugin : this.getAllPlugins()) {
            if (('-' + plugin.getOptionName()).equals(args[i])) {
                this.activePlugins.add(plugin);
                plugin.onActivated(this);
                this.pluginURIs.addAll(plugin.getCustomizationURIs());
                return 1;
            }
            try {
                int r = plugin.parseArgument(this, args, i);
                if (r == 0) continue;
                return r;
            }
            catch (IOException e) {
                throw new BadCommandLineException(e.getMessage(), e);
            }
        }
        return 0;
    }

    private void parseProxy(String text) throws BadCommandLineException {
        String token = "([^@:]+)";
        Pattern p = Pattern.compile("(?:" + token + "(?:\\:" + token + ")?\\@)?" + token + "(?:\\:" + token + ")");
        Matcher matcher = p.matcher(text);
        if (!matcher.matches()) {
            throw new BadCommandLineException(Messages.format("Driver.ILLEGAL_PROXY", text));
        }
        this.proxyUser = matcher.group(1);
        this.proxyPassword = matcher.group(2);
        this.proxyHost = matcher.group(3);
        this.proxyPort = matcher.group(4);
        try {
            Integer.valueOf(this.proxyPort);
        }
        catch (NumberFormatException e) {
            throw new BadCommandLineException(Messages.format("Driver.ILLEGAL_PROXY", text));
        }
    }

    private void addFile(String name, List<InputSource> target, String suffix) throws BadCommandLineException {
        Object src;
        try {
            src = com.sun.tools.xjc.reader.Util.getFileOrURL(name);
        }
        catch (IOException e) {
            throw new BadCommandLineException(Messages.format("Driver.NotAFileNorURL", name));
        }
        if (src instanceof URL) {
            target.add(this.absolutize(new InputSource(com.sun.tools.xjc.reader.Util.escapeSpace(((URL)src).toExternalForm()))));
        } else {
            File fsrc = (File)src;
            if (fsrc.isDirectory()) {
                this.addRecursive(fsrc, suffix, target);
            } else {
                target.add(this.absolutize(this.fileToInputSource(fsrc)));
            }
        }
    }

    public void addCatalog(File catalogFile) throws IOException {
        if (this.entityResolver == null) {
            CatalogManager.getStaticManager().setIgnoreMissingProperties(true);
            this.entityResolver = new CatalogResolver(true);
        }
        ((CatalogResolver)this.entityResolver).getCatalog().parseCatalog(catalogFile.getPath());
    }

    public void parseArguments(String[] args) throws BadCommandLineException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].length() == 0) {
                throw new BadCommandLineException();
            }
            if (args[i].charAt(0) == '-') {
                int j = this.parseArgument(args, i);
                if (j == 0) {
                    throw new BadCommandLineException(Messages.format("Driver.UnrecognizedParameter", args[i]));
                }
                i += j - 1;
                continue;
            }
            this.addFile(args[i], this.grammars, ".xsd");
        }
        if (this.proxyHost != null || this.proxyPort != null) {
            if (this.proxyHost == null || this.proxyPort == null) {
                if (this.proxyHost == null) {
                    throw new BadCommandLineException(Messages.format("Driver.MissingProxyHost", new Object[0]));
                }
                throw new BadCommandLineException(Messages.format("Driver.MissingProxyPort", new Object[0]));
            }
            System.setProperty("http.proxyHost", this.proxyHost);
            System.setProperty("http.proxyPort", this.proxyPort);
            System.setProperty("https.proxyHost", this.proxyHost);
            System.setProperty("https.proxyPort", this.proxyPort);
            if (this.proxyUser != null) {
                System.setProperty("http.proxyUser", this.proxyUser);
            }
            if (this.proxyPassword != null) {
                System.setProperty("http.proxyPassword", this.proxyPassword);
            }
        }
        if (this.grammars.size() == 0) {
            throw new BadCommandLineException(Messages.format("Driver.MissingGrammar", new Object[0]));
        }
        if (this.schemaLanguage == null) {
            this.schemaLanguage = this.guessSchemaLanguage();
        }
    }

    public Language guessSchemaLanguage() {
        String name = this.grammars.get(0).getSystemId().toLowerCase();
        if (name.endsWith(".rng")) {
            return Language.RELAXNG;
        }
        if (name.endsWith(".rnc")) {
            return Language.RELAXNG_COMPACT;
        }
        if (name.endsWith(".dtd")) {
            return Language.DTD;
        }
        if (name.endsWith(".wsdl")) {
            return Language.WSDL;
        }
        return Language.XMLSCHEMA;
    }

    public CodeWriter createCodeWriter() throws IOException {
        return this.createCodeWriter(new FileCodeWriter(this.targetDir, this.readOnly));
    }

    public CodeWriter createCodeWriter(CodeWriter core) {
        if (this.noFileHeader) {
            return core;
        }
        String format = Messages.format("Driver.DateFormat", new Object[0]) + " '" + Messages.format("Driver.At", new Object[0]) + "' " + Messages.format("Driver.TimeFormat", new Object[0]);
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return new PrologCodeWriter(core, Messages.format("Driver.FilePrologComment", dateFormat.format(new Date())));
    }

    private static <T> T[] findServices(Class<T> clazz, ClassLoader classLoader) {
        boolean debug = Util.getSystemProperty(Options.class, "findServices") != null;
        String serviceId = "META-INF/services/" + clazz.getName();
        HashSet<String> classNames = new HashSet<String>();
        if (debug) {
            System.out.println("Looking for " + serviceId + " for add-ons");
        }
        try {
            Enumeration<URL> e = classLoader.getResources(serviceId);
            if (e == null) {
                return (Object[])Array.newInstance(clazz, 0);
            }
            ArrayList<T> a = new ArrayList<T>();
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                BufferedReader reader = null;
                if (debug) {
                    System.out.println("Checking " + url + " for an add-on");
                }
                try {
                    String impl;
                    reader = new BufferedReader(new InputStreamReader(url.openStream()));
                    while ((impl = reader.readLine()) != null) {
                        if (!classNames.add(impl = impl.trim())) continue;
                        Class<?> implClass = classLoader.loadClass(impl);
                        if (!clazz.isAssignableFrom(implClass)) {
                            if (!debug) continue;
                            System.out.println(impl + " is not a subclass of " + clazz + ". Skipping");
                            continue;
                        }
                        if (debug) {
                            System.out.println("Attempting to instanciate " + impl);
                        }
                        a.add(clazz.cast(implClass.newInstance()));
                    }
                    reader.close();
                }
                catch (Exception ex) {
                    if (debug) {
                        ex.printStackTrace(System.out);
                    }
                    if (reader == null) continue;
                    try {
                        reader.close();
                    }
                    catch (IOException ex2) {}
                }
            }
            return a.toArray((Object[])Array.newInstance(clazz, a.size()));
        }
        catch (Throwable e) {
            if (debug) {
                e.printStackTrace(System.out);
            }
            return (Object[])Array.newInstance(clazz, 0);
        }
    }

    public static String getBuildID() {
        return Messages.format("Driver.BuildID", new Object[0]);
    }
}

