/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.modeler.wsdl;

import com.sun.tools.ws.processor.util.ProcessorEnvironment;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.xml.ws.util.localization.LocalizableMessageFactory;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.xml.sax.SAXParseException;

public class ConsoleErrorReporter
implements ErrorListener {
    private LocalizableMessageFactory messageFactory;
    private ProcessorEnvironment env;
    private boolean printStackTrace;
    private boolean hasError;
    private Exception e;

    public ConsoleErrorReporter(ProcessorEnvironment env, boolean printStackTrace) {
        this.env = env;
        this.printStackTrace = printStackTrace;
        this.messageFactory = new LocalizableMessageFactory("com.sun.tools.ws.resources.model");
    }

    public boolean hasError() {
        return this.hasError;
    }

    Exception getException() {
        return this.e;
    }

    public void error(SAXParseException e) {
        this.hasError = true;
        this.e = e;
        if (this.printStackTrace) {
            e.printStackTrace();
        }
        this.env.error(this.messageFactory.getMessage("model.saxparser.exception", e.getMessage(), this.getLocationString(e)));
    }

    public void fatalError(SAXParseException e) {
        this.hasError = true;
        this.e = e;
        if (this.printStackTrace) {
            e.printStackTrace();
        }
        this.env.error(this.messageFactory.getMessage("model.saxparser.exception", e.getMessage(), this.getLocationString(e)));
    }

    public void warning(SAXParseException e) {
        this.env.warn(this.messageFactory.getMessage("model.saxparser.exception", e.getMessage(), this.getLocationString(e)));
    }

    public void info(SAXParseException e) {
        this.env.info(this.messageFactory.getMessage("model.saxparser.exception", e.getMessage(), this.getLocationString(e)));
    }

    protected final String getLocationString(SAXParseException e) {
        if (e.getLineNumber() != -1 || e.getSystemId() != null) {
            int line = e.getLineNumber();
            return this.format("ConsoleErrorReporter.LineXOfY", line == -1 ? "?" : Integer.toString(line), this.getShortName(e.getSystemId()));
        }
        return this.format("ConsoleErrorReporter.UnknownLocation", new Object[0]);
    }

    private String getShortName(String url) {
        if (url == null) {
            return this.format("ConsoleErrorReporter.UnknownLocation", new Object[0]);
        }
        return url;
    }

    private String format(String property, Object ... args) {
        String text = ResourceBundle.getBundle("com.sun.tools.ws.resources.model").getString(property);
        return MessageFormat.format(text, args);
    }
}

