/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.generator;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.codemodel.writer.ProgressCodeWriter;
import com.sun.codemodel.writer.PrologCodeWriter;
import com.sun.tools.ws.processor.ProcessorAction;
import com.sun.tools.ws.processor.config.Configuration;
import com.sun.tools.ws.processor.config.WSDLModelInfo;
import com.sun.tools.ws.processor.generator.GeneratorBase;
import com.sun.tools.ws.processor.generator.GeneratorException;
import com.sun.tools.ws.processor.generator.GeneratorUtil;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.model.Service;
import com.sun.tools.ws.processor.model.java.JavaInterface;
import com.sun.tools.ws.wscompile.WSCodeWriter;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.encoding.soap.SOAPVersion;
import com.sun.xml.ws.util.JAXWSUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;

public class ServiceGenerator
extends GeneratorBase
implements ProcessorAction {
    private String serviceNS;
    private WSDLModelInfo wsdlModelInfo;

    public ServiceGenerator() {
    }

    private ServiceGenerator(Model model, Configuration config2, Properties properties) {
        super(model, config2, properties);
        this.wsdlModelInfo = (WSDLModelInfo)config2.getModelInfo();
    }

    public GeneratorBase getGenerator(Model model, Configuration config2, Properties properties) {
        return new ServiceGenerator(model, config2, properties);
    }

    public GeneratorBase getGenerator(Model model, Configuration config2, Properties properties, SOAPVersion ver) {
        return new ServiceGenerator(model, config2, properties);
    }

    private JInvocation createQName(QName name) {
        return JExpr._new(this.cm.ref(QName.class)).arg(name.getNamespaceURI()).arg(name.getLocalPart());
    }

    private JInvocation createURL(URL url) {
        return JExpr._new(this.cm.ref(URL.class)).arg(url.toExternalForm());
    }

    protected void visitService(Service service) {
        try {
            JavaInterface intf = service.getJavaInterface();
            String className = this.env.getNames().customJavaTypeClassName(intf);
            if (this.donotOverride && GeneratorUtil.classExists(this.env, className)) {
                this.log("Class " + className + " exists. Not overriding.");
                return;
            }
            JDefinedClass cls = this.getClass(className, ClassType.CLASS);
            cls._extends(javax.xml.ws.Service.class);
            String serviceFieldName = JAXBRIContext.mangleNameToClassName(service.getName().getLocalPart()).toUpperCase();
            String wsdlLocationName = serviceFieldName + "_WSDL_LOCATION";
            JFieldVar urlField = cls.field(28, URL.class, wsdlLocationName);
            JClass qNameCls = this.cm.ref(QName.class);
            JInvocation inv = JExpr._new(qNameCls);
            inv.arg("namespace");
            inv.arg("localpart");
            JBlock staticBlock = cls.init();
            URL url = new URL(JAXWSUtils.absolutize(JAXWSUtils.getFileOrURLName(this.wsdlLocation)));
            JVar urlVar = staticBlock.decl(this.cm.ref(URL.class), "url", JExpr._null());
            JTryBlock tryBlock = staticBlock._try();
            tryBlock.body().assign(urlVar, this.createURL(url));
            JCatchBlock catchBlock = tryBlock._catch(this.cm.ref(MalformedURLException.class));
            catchBlock.param("e");
            catchBlock.body().directStatement("e.printStackTrace();");
            staticBlock.assign(urlField, urlVar);
            JMethod constructor = cls.constructor(1);
            constructor.param(URL.class, "wsdlLocation");
            constructor.param(QName.class, "serviceName");
            constructor.body().directStatement("super(wsdlLocation, serviceName);");
            constructor = cls.constructor(1);
            constructor.body().directStatement("super(" + wsdlLocationName + ", new QName(\"" + service.getName().getNamespaceURI() + "\", \"" + service.getName().getLocalPart() + "\"));");
            JAnnotationUse webServiceClientAnn = cls.annotate(this.cm.ref(WebServiceClient.class));
            this.writeWebServiceClientAnnotation(service, webServiceClientAnn);
            this.writeHandlerConfig(this.env.getNames().customJavaTypeClassName(service.getJavaInterface()), cls, this.wsdlModelInfo);
            for (Port port : service.getPorts()) {
                if (port.isProvider()) continue;
                JMethod m = null;
                JDocComment methodDoc = null;
                JDefinedClass retType = this.getClass(port.getJavaInterface().getName(), ClassType.INTERFACE);
                m = cls.method(1, retType, port.getPortGetter());
                methodDoc = m.javadoc();
                if (port.getJavaDoc() != null) {
                    methodDoc.add(port.getJavaDoc());
                }
                JCommentPart ret = methodDoc.addReturn();
                ret.add("returns " + ((JType)retType).name());
                JBlock body = m.body();
                StringBuffer statement = new StringBuffer("return (");
                statement.append(((JType)retType).name());
                statement.append(")super.getPort(new QName(\"" + port.getName().getNamespaceURI() + "\", \"" + port.getName().getLocalPart() + "\"), ");
                statement.append(((JType)retType).name());
                statement.append(".class);");
                body.directStatement(statement.toString());
                this.writeWebEndpoint(port, m);
            }
            CodeWriter cw = new WSCodeWriter(this.sourceDir, this.env);
            cw = new PrologCodeWriter(cw, ServiceGenerator.getJAXClassComment(this.targetVersion));
            if (this.env.verbose()) {
                cw = new ProgressCodeWriter(cw, System.out);
            }
            this.cm.build(cw);
        }
        catch (IOException e) {
            throw new GeneratorException("generator.nestedGeneratorError", new Object[]{e});
        }
    }

    protected JDefinedClass getClass(String className, ClassType type) {
        JDefinedClass cls = null;
        try {
            cls = this.cm._class(className, type);
        }
        catch (JClassAlreadyExistsException e) {
            cls = this.cm._getClass(className);
        }
        return cls;
    }

    private void writeWebServiceClientAnnotation(Service service, JAnnotationUse wsa) {
        String serviceName = service.getName().getLocalPart();
        this.serviceNS = service.getName().getNamespaceURI();
        wsa.param("name", serviceName);
        wsa.param("targetNamespace", this.serviceNS);
        wsa.param("wsdlLocation", this.wsdlLocation);
    }

    private void writeWebEndpoint(Port port, JMethod m) {
        JAnnotationUse webEndpointAnn = m.annotate(this.cm.ref(WebEndpoint.class));
        webEndpointAnn.param("name", port.getName().getLocalPart());
    }
}

