/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationWriter;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDeclaration;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JResourceFile;
import com.sun.codemodel.TypedAnnotationWriter;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JPackage
implements JDeclaration,
JGenerable,
JClassContainer,
JAnnotatable,
Comparable<JPackage> {
    private String name;
    private final JCodeModel owner;
    private final Map<String, JDefinedClass> classes = new TreeMap<String, JDefinedClass>();
    private final Set<JResourceFile> resources = new HashSet<JResourceFile>();
    private final Map<String, JDefinedClass> upperCaseClassMap;
    private List<JAnnotationUse> annotations = null;
    private JDocComment jdoc = null;

    JPackage(String name, JCodeModel cw) {
        this.owner = cw;
        if (name.equals(".")) {
            String msg = "JPackage name . is not allowed";
            throw new IllegalArgumentException(msg);
        }
        int dots = 1;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '.') {
                ++dots;
                continue;
            }
            if (dots > 1) {
                String msg = "JPackage name " + name + " missing identifier";
                throw new IllegalArgumentException(msg);
            }
            if (dots == 1 && !Character.isJavaIdentifierStart(c)) {
                String msg = "JPackage name " + name + " contains illegal " + "character for beginning of identifier: " + c;
                throw new IllegalArgumentException(msg);
            }
            if (!Character.isJavaIdentifierPart(c)) {
                String msg = "JPackage name " + name + "contains illegal " + "character: " + c;
                throw new IllegalArgumentException(msg);
            }
            dots = 0;
        }
        if (!name.trim().equals("") && dots != 0) {
            String msg = "JPackage name not allowed to end with .";
            throw new IllegalArgumentException(msg);
        }
        this.upperCaseClassMap = JCodeModel.isCaseSensitiveFileSystem ? null : new HashMap<String, JDefinedClass>();
        this.name = name;
    }

    @Override
    public JClassContainer parentContainer() {
        return this.parent();
    }

    public JPackage parent() {
        if (this.name.length() == 0) {
            return null;
        }
        int idx = this.name.lastIndexOf(46);
        return this.owner._package(this.name.substring(0, idx));
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public boolean isPackage() {
        return true;
    }

    @Override
    public JPackage getPackage() {
        return this;
    }

    @Override
    public JDefinedClass _class(int mods, String name) throws JClassAlreadyExistsException {
        return this._class(mods, name, ClassType.CLASS);
    }

    @Override
    public JDefinedClass _class(int mods, String name, boolean isInterface) throws JClassAlreadyExistsException {
        return this._class(mods, name, isInterface ? ClassType.INTERFACE : ClassType.CLASS);
    }

    @Override
    public JDefinedClass _class(int mods, String name, ClassType classTypeVal) throws JClassAlreadyExistsException {
        if (this.classes.containsKey(name)) {
            throw new JClassAlreadyExistsException(this.classes.get(name));
        }
        JDefinedClass c = new JDefinedClass(this, mods, name, classTypeVal);
        if (this.upperCaseClassMap != null) {
            JDefinedClass dc = this.upperCaseClassMap.get(name.toUpperCase());
            if (dc != null) {
                throw new JClassAlreadyExistsException(dc);
            }
            this.upperCaseClassMap.put(name.toUpperCase(), c);
        }
        this.classes.put(name, c);
        return c;
    }

    @Override
    public JDefinedClass _class(String name) throws JClassAlreadyExistsException {
        return this._class(1, name);
    }

    public JDefinedClass _getClass(String name) {
        if (this.classes.containsKey(name)) {
            return this.classes.get(name);
        }
        return null;
    }

    @Override
    public int compareTo(JPackage that) {
        return this.name.compareTo(that.name);
    }

    @Override
    public JDefinedClass _interface(int mods, String name) throws JClassAlreadyExistsException {
        return this._class(mods, name, ClassType.INTERFACE);
    }

    @Override
    public JDefinedClass _interface(String name) throws JClassAlreadyExistsException {
        return this._interface(1, name);
    }

    @Override
    public JDefinedClass _annotationTypeDeclaration(String name) throws JClassAlreadyExistsException {
        return this._class(1, name, ClassType.ANNOTATION_TYPE_DECL);
    }

    @Override
    public JDefinedClass _enum(String name) throws JClassAlreadyExistsException {
        return this._class(1, name, ClassType.ENUM);
    }

    public JResourceFile addResourceFile(JResourceFile rsrc) {
        this.resources.add(rsrc);
        return rsrc;
    }

    public boolean hasResourceFile(String name) {
        for (JResourceFile r : this.resources) {
            if (!r.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Iterator propertyFiles() {
        return this.resources.iterator();
    }

    public JDocComment javadoc() {
        if (this.jdoc == null) {
            this.jdoc = new JDocComment(this.owner());
        }
        return this.jdoc;
    }

    public void remove(JClass c) {
        if (c._package() != this) {
            throw new IllegalArgumentException("the specified class is not a member of this package, or it is a referenced class");
        }
        this.classes.remove(c.name());
        if (this.upperCaseClassMap != null) {
            this.upperCaseClassMap.remove(c.name().toUpperCase());
        }
    }

    public JClass ref(String name) throws ClassNotFoundException {
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("JClass name contains '.': " + name);
        }
        String n = "";
        if (!this.isUnnamed()) {
            n = this.name + '.';
        }
        n = n + name;
        return this.owner.ref(Class.forName(n));
    }

    public JPackage subPackage(String pkg) {
        if (this.isUnnamed()) {
            return this.owner()._package(pkg);
        }
        return this.owner()._package(this.name + '.' + pkg);
    }

    @Override
    public Iterator<JDefinedClass> classes() {
        return this.classes.values().iterator();
    }

    public boolean isDefined(String classLocalName) {
        Iterator<JDefinedClass> itr = this.classes();
        while (itr.hasNext()) {
            if (!((JClass)itr.next()).name().equals(classLocalName)) continue;
            return true;
        }
        return false;
    }

    public final boolean isUnnamed() {
        return this.name.length() == 0;
    }

    public String name() {
        return this.name;
    }

    @Override
    public final JCodeModel owner() {
        return this.owner;
    }

    @Override
    public JAnnotationUse annotate(JClass clazz) {
        if (this.isUnnamed()) {
            throw new IllegalArgumentException("the root package cannot be annotated");
        }
        if (this.annotations == null) {
            this.annotations = new ArrayList<JAnnotationUse>();
        }
        JAnnotationUse a = new JAnnotationUse(clazz);
        this.annotations.add(a);
        return a;
    }

    @Override
    public JAnnotationUse annotate(Class<? extends Annotation> clazz) {
        return this.annotate(this.owner.ref(clazz));
    }

    @Override
    public <W extends JAnnotationWriter> W annotate2(Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    File toPath(File dir) {
        if (this.name == null) {
            return dir;
        }
        return new File(dir, this.name.replace('.', File.separatorChar));
    }

    @Override
    public void declare(JFormatter f) {
        if (this.name.length() != 0) {
            f.p("package").p(this.name).p(';').nl();
        }
    }

    @Override
    public void generate(JFormatter f) {
        f.p(this.name);
    }

    void build(CodeWriter src, CodeWriter res) throws IOException {
        for (JDefinedClass c : this.classes.values()) {
            if (c.isHidden()) continue;
            JFormatter f = this.createJavaSourceFileWriter(src, c.name());
            f.write(c);
            f.close();
        }
        if (this.annotations != null || this.jdoc != null) {
            JFormatter f = this.createJavaSourceFileWriter(src, "package-info");
            if (this.jdoc != null) {
                f.g(this.jdoc);
            }
            if (this.annotations != null) {
                for (JAnnotationUse a : this.annotations) {
                    f.g(a).nl();
                }
            }
            f.d(this);
            f.close();
        }
        for (JResourceFile rsrc : this.resources) {
            CodeWriter cw = rsrc.isResource() ? res : src;
            BufferedOutputStream os = new BufferedOutputStream(cw.openBinary(this, rsrc.name()));
            rsrc.build(os);
            ((OutputStream)os).close();
        }
    }

    int countArtifacts() {
        int r = 0;
        for (JDefinedClass c : this.classes.values()) {
            if (c.isHidden()) continue;
            ++r;
        }
        if (this.annotations != null || this.jdoc != null) {
            ++r;
        }
        return r += this.resources.size();
    }

    private JFormatter createJavaSourceFileWriter(CodeWriter src, String className) throws IOException {
        BufferedWriter bw = new BufferedWriter(src.openSource(this, className + ".java"));
        return new JFormatter(new PrintWriter(bw));
    }
}

