/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.scan.util;

import com.ibm.xml.xlxp.scan.util.IntArrayStore;

public final class DataStore {
    private static final boolean DEBUG_ALLOCATE = false;
    private static final int INITIAL_LIST_COUNT = 4;
    private IntArrayStore fArrayStore;
    private int CHUNK_SHIFT = 8;
    private int CHUNK_SIZE = 1 << this.CHUNK_SHIFT;
    private int CHUNK_MASK = this.CHUNK_SIZE - 1;
    private int INITIAL_CHUNK_COUNT = 1 << 16 - this.CHUNK_SHIFT;
    private int fCurrentRecordChunk;
    private int[][] fRecordHeap = new int[this.INITIAL_CHUNK_COUNT][];
    private int fListCount;
    private int[][] fListMap = new int[this.INITIAL_CHUNK_COUNT][];
    private int fMutipleElementListCount;
    private int[][] fMutipleElementList = new int[this.INITIAL_CHUNK_COUNT][];

    public DataStore() {
        this.fArrayStore = new IntArrayStore();
        this.fRecordHeap[0] = this.fArrayStore.allocIntArray(this.CHUNK_SIZE);
        this.fRecordHeap[0][0] = 1;
    }

    public void reset(boolean bl) {
        if (!bl) {
            int n = this.fCurrentRecordChunk + 1;
            int n2 = 1;
            while (n2 < n) {
                if (this.fRecordHeap[n2] != null) {
                    this.fArrayStore.deallocIntArray(this.fRecordHeap[n2], this.CHUNK_SIZE);
                    this.fRecordHeap[n2] = null;
                }
                ++n2;
            }
            n = this.fListCount >>> this.CHUNK_SHIFT - 1;
            n2 = 0;
            while (n2 < n) {
                if (this.fListMap[n2] != null) {
                    this.fArrayStore.deallocIntArray(this.fListMap[n2], this.CHUNK_SIZE);
                    this.fListMap[n2] = null;
                }
                ++n2;
            }
            n = this.fMutipleElementListCount;
            n2 = 0;
            while (n2 < n) {
                if (this.fMutipleElementList[n2] == null) {
                    this.fArrayStore.deallocIntArray(this.fMutipleElementList[n2], this.fMutipleElementList[n2].length);
                    this.fMutipleElementList[n2] = null;
                }
                ++n2;
            }
        }
        this.fArrayStore.reset(bl);
        this.fRecordHeap[0][0] = 1;
        this.fCurrentRecordChunk = 0;
        this.fListCount = 0;
        this.fMutipleElementListCount = 0;
    }

    public int allocateRecord(int n) {
        int n2 = this.fCurrentRecordChunk;
        int[] nArray = this.fRecordHeap[n2];
        int n3 = nArray[0];
        if (n3 + n <= this.CHUNK_SIZE) {
            nArray[0] = n3 + n;
            return (n2 << this.CHUNK_SHIFT) + n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            n3 = this.fRecordHeap[n4][0];
            if (n3 + n <= this.CHUNK_SIZE) {
                this.fRecordHeap[n4][0] = n3 + n;
                return (n4 << this.CHUNK_SHIFT) + n3;
            }
            ++n4;
        }
        n2 = ++this.fCurrentRecordChunk;
        n3 = 1;
        if (n2 >= this.INITIAL_CHUNK_COUNT && (n2 & n2 - 1) == 0 && this.fRecordHeap.length <= n2) {
            this.fRecordHeap = this.reallocIntArray2(this.fRecordHeap, n2, n2 << 1);
        }
        if (this.fRecordHeap[n2] == null) {
            this.fRecordHeap[n2] = this.fArrayStore.allocIntArray(this.CHUNK_SIZE);
        }
        this.fRecordHeap[n2][0] = n3 + n;
        return (n2 << this.CHUNK_SHIFT) + n3;
    }

    public int[] getRecordArray(int n) {
        return this.fRecordHeap[n >>> this.CHUNK_SHIFT];
    }

    public int getRecordBase(int n) {
        return n & this.CHUNK_MASK;
    }

    public int addToList(int n, int n2) {
        int n3;
        int[] nArray;
        int n4;
        int n5;
        if (n == -1) {
            n = this.fListCount++;
            int n6 = n >>> this.CHUNK_SHIFT - 1;
            int n7 = n << 1 & this.CHUNK_MASK;
            if (n6 == this.fListMap.length) {
                int n8 = n6 << 1;
                this.fListMap = this.reallocIntArray2(this.fListMap, n6, n8);
            }
            if (this.fListMap[n6] == null) {
                this.fListMap[n6] = this.fArrayStore.allocIntArray(this.CHUNK_SIZE);
            }
            this.fListMap[n6][n7] = 0;
            this.fListMap[n6][n7 + 1] = n2;
            return n;
        }
        int n9 = n >>> this.CHUNK_SHIFT - 1;
        int n10 = n << 1 & this.CHUNK_MASK;
        if (this.fListMap[n9][n10] >= 0) {
            if ((n5 = this.fMutipleElementListCount++) == this.fMutipleElementList.length) {
                n4 = n5 << 1;
                this.fMutipleElementList = this.reallocIntArray2(this.fMutipleElementList, n5, n4);
            }
            if (this.fMutipleElementList[n5] == null) {
                nArray = this.fArrayStore.allocIntArray(5);
                this.fMutipleElementList[n5] = nArray;
            } else {
                nArray = this.fMutipleElementList[n5];
            }
            nArray[0] = 1;
            nArray[1] = this.fListMap[n9][n10 + 1];
            n3 = 1;
            this.fListMap[n9][n10] = -1;
            this.fListMap[n9][n10 + 1] = n5;
        } else {
            n5 = this.fListMap[n9][n10 + 1];
            nArray = this.fMutipleElementList[n5];
            n3 = nArray[0];
            if (n3 >= 4 && (n3 & n3 - 1) == 0 && nArray.length <= n3 + 1) {
                n4 = 4;
                while (n4 < n3) {
                    n4 <<= 2;
                }
                if (n4 == n3) {
                    nArray = this.fArrayStore.reallocIntArray(nArray, 1 + n3, 1 + (n3 << 2));
                    this.fMutipleElementList[n5] = nArray;
                }
            }
        }
        nArray[++n3] = n2;
        nArray[0] = nArray[0] + 1;
        return n;
    }

    public int[] getListArray(int n) {
        int n2 = n >>> this.CHUNK_SHIFT - 1;
        int n3 = n << 1 & this.CHUNK_MASK;
        if (this.fListMap[n2][n3] >= 0) {
            return this.fListMap[n2];
        }
        int n4 = this.fListMap[n2][n3 + 1];
        return this.fMutipleElementList[n4];
    }

    public int getListBase(int n) {
        int n2 = n >>> this.CHUNK_SHIFT - 1;
        int n3 = n << 1 & this.CHUNK_MASK;
        if (this.fListMap[n2][n3] >= 0) {
            return 1 + n3;
        }
        return 1;
    }

    public int getListCount(int n) {
        int n2 = n >>> this.CHUNK_SHIFT - 1;
        int n3 = n << 1 & this.CHUNK_MASK;
        if (this.fListMap[n2][n3] >= 0) {
            return 1;
        }
        int n4 = this.fListMap[n2][n3 + 1];
        return this.fMutipleElementList[n4][0];
    }

    private int[][] reallocIntArray2(int[][] nArray, int n, int n2) {
        int[][] nArrayArray = new int[n2][];
        System.arraycopy(nArray, 0, nArrayArray, 0, n);
        return nArrayArray;
    }
}

